//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <stdio.h>
#include <WScom.h>
#include <WSCstring.h>
#include <devfb/WSDdeviceFont.h>
#include <devfb/devfb.h>
#include <fbconfig.h>
#include <WSCindexData.h>

#ifndef DEVICE_FONT_OPTIMIZE
WSDdeviceFontGlyph::WSDdeviceFontGlyph(){
  _width = 0;
  _ascent = 0;
  _descent = -1;
  _left_bearing = -1;
  _right_bearing = -1;
  _data = NULL;
  _char_code =-1;
  _width = 0;
}
#endif

int WSDdeviceFontGlyph::destroy(){
//  if (_data != NULL){
//    delete _data;
//    _data = NULL;
//  }
  return WS_NO_ERR;
}
WSDdeviceFontGlyph::~WSDdeviceFontGlyph(){
  destroy();
}
WSDdeviceFont::WSDdeviceFont(){
  _type = 0;
  _height = -1;
  _width = -1;
  _ascent = -1;
  _descent = -1;
  _chars = 0;
  _default_char_code = 0;
  _font_encode = WS_FONT_NONE;
  _font_glyph = NULL;
#ifndef NO_FONT_GLYPH_TABLE
  _font_glyph_table = NULL;
#endif
}
WSDdeviceFont::~WSDdeviceFont(){
  destroy();
}
int WSDdeviceFont::destroy(){
  if (_font_glyph != NULL){
    delete[] _font_glyph;
    _font_glyph = NULL;
  }
  if (_glyph_buf != NULL){
    delete _glyph_buf;
    _glyph_buf = NULL;
  }
#ifndef NO_FONT_GLYPH_TABLE
  if (_font_glyph_table != NULL){
    delete _font_glyph_table;
    _font_glyph_table = NULL;
  }
#endif
  return WS_NO_ERR;
}





WSDdeviceFontList::WSDdeviceFontList(){
  int i;
  for(i=0; i<WS_FONT_COUNT;i++){
    _font_order[i] = 0;
  }
dbprintf("WSDdeviceFontList::WSDdeviceFontList this=0x%x\n",this);
}
WSDdeviceFontList::~WSDdeviceFontList(){
  destroy();
}
int WSDdeviceFontList::addFont(WSDdeviceFont* font){
  _list.add((void*)font);
  if (font == NULL){
    return WS_ERR;
  }
  int encode = font->_font_encode;
  int i;
  for(i=0; i<WS_FONT_COUNT;i++){
    if ( _font_order[i] == encode){
      break;
    }
    if ( _font_order[i] == 0){
      _font_order[i] = encode;
      break;
    }
  }
  return WS_NO_ERR;
}
WSDdeviceFont* WSDdeviceFontList::getFont(int fenc){
  int i;
  int num = _list._num;
  WSDdeviceFont** buf = (WSDdeviceFont**)_list._data;
  for(i=0; i<num;i++){
    WSDdeviceFont* f = buf[i];
    if ( f->_font_encode == fenc){
dbprintf("WSDdeviceFontList::getFont(%d) this=0x%x num=%d f=0x%x\n",fenc,this,num,f);
      return f;
    }
  }
  return NULL;
}
int WSDdeviceFontList::destroy(){
  int i;
  int num = _list.getNum();
  for(i=0; i<num; i++){
    WSDdeviceFont* font = (WSDdeviceFont*)_list[i];
    delete font;
  }
  _list.clear();
  return WS_NO_ERR;
}


WSCindexData _font_list;

WSDdeviceFont* WSGFdeviceReadBdfFont(char* file_name,char* fname,int fenc){
#ifndef NO_BDF_FONT
TIME_TRACE("WSGFdeviceReadBdfFont() start");
#if 0
  WSCstring* fstr = WSGFreadTextFile(file_name);
  if (fstr == NULL){
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
    return NULL;
  }
#endif
  WSDdeviceFont* cache = (WSDdeviceFont*)_font_list[file_name];
  if (cache != NULL){
    WSDdeviceFont* ret = new WSDdeviceFont;
    *ret = *cache;
    ret->_font_glyph = new WSDdeviceFontGlyph[ret->_chars];
    memcpy(ret->_font_glyph,cache->_font_glyph,sizeof(WSDdeviceFontGlyph)*ret->_chars);
    long size = ret->_height * ((ret->_height-1)/8 + 1)*ret->_chars;
    ret->_glyph_buf = new unsigned char[size];
    memcpy(ret->_glyph_buf,cache->_glyph_buf,size);
TIME_TRACE("WSGFdeviceReadBdfFont()0 done");
    return ret;
  }
  FILE* ffile = fopen(file_name,"r");
  if (ffile == NULL){
TIME_TRACE("WSGFdeviceReadBdfFont()1 done");
    return NULL;
  }

  WSDdeviceFont* font = new WSDdeviceFont();
  if (font == NULL){
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
TIME_TRACE("WSGFdeviceReadBdfFont()2 done");
    return NULL;
  }
  font->_font_name = fname;
  font->_font_encode = fenc;
  long cnt = 0;
  char line[128];
  while(!feof(ffile)){
//    WSCstring line = fstr->gets();
    fgets(line,128,ffile);
    if (!strcmp(line,"")){
      break;
    }
    char* ln = (char*)line;
    if (!strncmp(ln,"STARTCHAR",9)){
      if (cnt < font->_chars){
        WSDdeviceFontGlyph* fg = &(font->_font_glyph[cnt]);
        int data = 0;
        int y = 0;
        int row_w = 0;
        while(1){
//          line = fstr->gets();
          fgets(line,128,ffile);
          ln =(char*)line;
          if (data == 1){
            if (ln[0] == 'E' && !strncmp(ln,"ENDCHAR",7)){
              data = 0;
              break;
            }
            unsigned int val = 0;

            int ret = sscanf(ln,"%x",&val);
            if (ret < 1){
              val = 0;
            }
            unsigned char* ptr = (unsigned char*)fg->_data;
            if (row_w == 1){
              ptr[y] = val;
              y++;
            }else
            if (row_w == 2){
              ptr[y] = (val>>8)& 0xff;
              y++;
              ptr[y] = val & 0xff;
              y++;
            }else
            if (row_w == 3){
              ptr[y] = (val>>16) & 0xff;
              y++;
              ptr[y] = (val>>8) & 0xff;
              y++;
              ptr[y] = val & 0xff;
              y++;
            }else
            if (row_w == 4){
              ptr[y] = (val>>24) & 0xff;
              y++;
              ptr[y] = (val>>16) & 0xff;
              y++;
              ptr[y] = (val>>8) & 0xff;
              y++;
              ptr[y] = val & 0xff;
              y++;
            }
          }else
          if (ln[0] == 'E' && !strncmp(ln,"ENCODING",8)){
            int val = 0;
            int ret = sscanf((char*)line,"ENCODING %d",&val);
            if (ret < 1){
              val = 0;
            }
            fg->_char_code = val;
          }
          if (ln[0] == 'B' && !strncmp(ln,"BBX",3)){
            int w=0,h=0,l=0,b=0;
            int ret = sscanf((char*)line,"BBX %d %d %d %d",&w,&h,&l,&b);
            if (ret < 1){
              delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
              return NULL;
            }
            fg->_left_bearing = l;
            fg->_right_bearing = l+w;
            fg->_ascent = h+b;
            fg->_descent = -b;
          }else
          if (ln[0] == 'D' && !strncmp(ln,"DWIDTH",6)){
            int val,val2;
            int ret = sscanf((char*)line,"DWIDTH %d %d",&val,&val2);
            if (ret < 1){
              val = 0;
              val2 = 0;
            }
            fg->_width = val;
//            long size = font->_chars * font->_height * ((fg->_width-1)/8 + 1);
            long pos = font->_height * ((font->_height-1)/8 + 1) * cnt;
            fg->_data = &(font->_glyph_buf[pos]);
            row_w = (fg->_width-1) / 8 +1;
          }else
          if (ln[0] == 'B' && !strncmp(ln,"BITMAP",6)){
            data = 1;
          }
        }
        cnt++;

      }else{
dbprintf("Error. %s:%d font->_chars=%d cnt=%d\n",__FILE__,__LINE__,font->_chars,cnt);
        delete font;
        return NULL;
      }
    }else
    if (!strncmp(ln,"FONTBOUNDINGBOX",15)){
      int size1,size2,tmp,tmp2;
      int ret = sscanf((char*)line,"FONTBOUNDINGBOX %d %d %d %d",&size1,&size2,&tmp,&tmp2);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_width = size1;
      font->_height = size2;
//printf("size=%d %d\n",size1,size2);
    }else
    if (!strncmp(ln,"DEFAULT_CHAR",12)){
      int val;
      int ret = sscanf((char*)line,"DEFAULT_CHAR %d",&val);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_default_char_code = val;
    }else
    if (!strncmp(ln,"FONT_ASCENT",11)){
      int val;
      int ret = sscanf((char*)line,"FONT_ASCENT %d",&val);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_ascent = val;
    }else
    if (!strncmp(ln,"FONT_DESCENT",12)){
      int val;
      int ret = sscanf((char*)line,"FONT_DESCENT %d",&val);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_descent = val;
//      font->_height = font->_descent + font->_ascent;
    }else
    if (!strncmp(ln,"CHARSET_",8)){
      //do nothing
    }else
    if (!strncmp(ln,"CHARS",5)){
      int val;
      int ret = sscanf((char*)line,"CHARS %d",&val);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_chars = val;
      font->_font_glyph = new WSDdeviceFontGlyph[val];
      long size = font->_height * ((font->_height-1)/8 + 1)*val;
      font->_glyph_buf = new unsigned char[size];
    }
  }
#if 0
  delete fstr;
#endif
  fclose(ffile);
  _font_list[file_name] = (void*)font;
TIME_TRACE("WSGFdeviceReadBdfFont()3 done");
  return font;
#else
  return NULL;
#endif
}

WSDdeviceFont* WSGFdeviceReadFont(char* file_name,char* fontname,int type,int fenc){
  if (type == WS_FONT_TYPE_BDF){
    return WSGFdeviceReadBdfFont(file_name,fontname,fenc);
#ifndef NO_PCF_FONT
  }else
  if (type == WS_FONT_TYPE_PCF){
extern WSDdeviceFont* WSGFdeviceReadPcfFont(char* file_name,char* fname,int fenc);
    return WSGFdeviceReadPcfFont(file_name,fontname,fenc);
#endif
  }
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
  return NULL;
}
int* WSDdeviceFontList::getFontOrder(){
  return _font_order;
}

WSDdeviceFontList* WSGFdeviceOpenFont(char* fname,char* path){
TIME_TRACE("WSGFdeviceOpenFont() start");
  WSCstring* file = WSGFreadTextFile(path);
  if (file == NULL){
TIME_TRACE("WSGFdeviceOpenFont()1 done");
fprintf(stdout,"Err: Can not find font definition file. PATH=%s\n",path);
fprintf(stdout,"Err: Can not load fonts.\n");
    return NULL;
  }
  WSDdeviceFontList* fontl = new WSDdeviceFontList();
  if (fontl == NULL){
TIME_TRACE("WSGFdeviceOpenFont()2 done");
fprintf(stdout,"Err: Can not load fonts.\n");
    return NULL;
  }

  while(file->eof() == False){
    WSCstring line = file->gets();
    long words = line.getWords(",");
    if (words <4){
      continue;
    }
    WSCstring font_name = line.getWord(0,",");
    if (!strcmp(font_name,"default")){
    }else
    if (strcmp(font_name,fname)){
      continue;
    }
    long type = WS_FONT_TYPE_BDF;
    WSCstring typestr = line.getWord(1,",");
    if (!strcmp((char*)typestr,"BDF")){
      type = WS_FONT_TYPE_BDF;
    }else
    if (!strcmp((char*)typestr,"PCF")){
      type = WS_FONT_TYPE_PCF;
    }else
    if (!strcmp((char*)typestr,"TTF")){
      type = WS_FONT_TYPE_TTF;
    }
    long cnt = 2;
    while(1){
      WSCstring fpath = line.getWord(cnt,",");
      cnt++;
      WSCstring fencode = line.getWord(cnt,",");
      cnt++;
      long encode = WS_FONT_ISO8859(1);
      if (!strcmp((char*)fencode,"ISO8859_1")){
        encode = WS_FONT_ISO8859(1);
      }else
      if (!strcmp((char*)fencode,"ISO8859_2")){
        encode = WS_FONT_ISO8859(2);
      }else
      if (!strcmp((char*)fencode,"ISO8859_3")){
        encode = WS_FONT_ISO8859(3);
      }else
      if (!strcmp((char*)fencode,"ISO8859_4")){
        encode = WS_FONT_ISO8859(4);
      }else
      if (!strcmp((char*)fencode,"ISO8859_5")){
        encode = WS_FONT_ISO8859(5);
      }else
      if (!strcmp((char*)fencode,"ISO8859_6")){
        encode = WS_FONT_ISO8859(6);
      }else
      if (!strcmp((char*)fencode,"ISO8859_7")){
        encode = WS_FONT_ISO8859(7);
      }else
      if (!strcmp((char*)fencode,"ISO8859_8")){
        encode = WS_FONT_ISO8859(8);
      }else
      if (!strcmp((char*)fencode,"ISO8859_9")){
        encode = WS_FONT_ISO8859(9);
      }else
      if (!strcmp((char*)fencode,"ISO8859_10")){
        encode = WS_FONT_ISO8859(10);
      }else
      if (!strcmp((char*)fencode,"ISO8859_11")){
        encode = WS_FONT_ISO8859(11);
      }else
      if (!strcmp((char*)fencode,"ISO8859_12")){
        encode = WS_FONT_ISO8859(12);
      }else
      if (!strcmp((char*)fencode,"ISO8859_13")){
        encode = WS_FONT_ISO8859(13);
      }else
      if (!strcmp((char*)fencode,"ISO8859_14")){
        encode = WS_FONT_ISO8859(14);
      }else
      if (!strcmp((char*)fencode,"ISO8859_15")){
        encode = WS_FONT_ISO8859(15);
      }else
      if (!strcmp((char*)fencode,"UNICODE")){
        encode = WS_FONT_UNICODE;
      }else
      if (!strcmp((char*)fencode,"KOI8R")){
        encode = WS_FONT_KOI8R;
      }else
      if (!strcmp((char*)fencode,"CP1251")){
        encode = WS_FONT_CP1251;
      }else
      if (!strcmp((char*)fencode,"JIS0201")){
        encode = WS_FONT_JIS0201;
      }else
      if (!strcmp((char*)fencode,"JIS0208")){
        encode = WS_FONT_JIS0208;
      }else
      if (!strcmp((char*)fencode,"KSC5601")){
        encode = WS_FONT_KSC5601;
      }else
      if (!strcmp((char*)fencode,"GB2312")){
        encode = WS_FONT_GB2312;
      }else
      if (!strcmp((char*)fencode,"BIG5")){
        encode = WS_FONT_BIG5;
      }
      if (!strcmp((char*)fpath,"")){
        continue;
      }
      WSDdeviceFont* font = WSGFdeviceReadFont((char*)fpath,
                                   (char*)fpath,type,encode);
      if (font != NULL){
        fontl->addFont(font);
      }
      if (cnt >= words){
        break;
      }
    }
  }
  delete file;
TIME_TRACE("WSGFdeviceOpenFont()3 done");
  return fontl;
}
int WSDdeviceFontList::getFontHeight(){
  WSDdeviceFont* f = getFont(WS_FONT_ISO8859(1));
  if (f != NULL){
    return f->_height;
  }
//printf("WSDdeviceFont::getStringWidth w=%d nchars=%d\n",*w,nchars);
  return -1;
}
int WSDdeviceFontList::getFontAscent(){
  WSDdeviceFont* f = getFont(WS_FONT_ISO8859(1));
  if (f != NULL){
    return f->_ascent;
  }
  return -1;
}
int WSDdeviceFontList::getFontDescent(){
  WSDdeviceFont* f = getFont(WS_FONT_ISO8859(1));
  if (f != NULL){
    return f->_descent;
  }
  return -1;
}


int WSDdeviceFontList::getStringWidth(WSCushort* str,int nchars,int* w){
TIME_TRACE("WSDdeviceFontList::getStringWidth() start");
  int width =0;
//  int len = 0;
  WSCushort c;
  int code = 0;
  WSDdeviceFont* f = NULL;
  *w = 0;

  if(nchars < 0){
    nchars = WSGFstrlenUCS2(str);
  }

  int i;
  for(i = 0; i < nchars; i++) {
    if(i == nchars) {
      code = WS_FONT_NONE;
    } else {
      c = *str;
extern int WSGFdeviceQueryChar(unsigned short*,int*);
//printf("WSDdeviceFontList::getStringWidth() font_order=0x%x\n",_font_order);
      code = WSGFdeviceQueryChar(&c,_font_order);
    }
    if (f != NULL && f->_font_encode == code){
      //use same font..
    }else{
      f = getFont(code);
      if(!f){
        f = getFont(WS_FONT_ISO8859(1));
      }
    }
    if (f != NULL){
//        int slen = WSGIappCodeConvert()->decode(NULL,0,sptr,len,WS_EN_UTF8);
//        char* utf8 = new char[slen+1];
//        WSGIappCodeConvert()->decode(utf8,slen+1,sptr,-1,WS_EN_UTF8);
//
//      f->getStringWidth(str,1,&width);
//      long height = f->_height;
      WSDdeviceFontGlyph* fgr = f->getFontGlyph(c);
      if (fgr != NULL){
//printf("f=0x%x code=%d w=%d\n",f,code,fgr->_width);
        *w += fgr->_width+1;
      }else{
//printf("f=0x%x code=%d w=%d\n",f,code,f->_width);
        *w += f->_width+1;
      }
    }
    str++;
  }
//printf("WSDdeviceFont::getStringWidth w=%d nchars=%d\n",*w,nchars);
TIME_TRACE("WSDdeviceFontList::getStringWidth() done");
  return WS_NO_ERR;
}

WSDdeviceFontGlyph* WSDdeviceFont::getFontGlyph(WSCushort c){
  if (_font_glyph == NULL){
    return NULL;
  }
#ifdef NO_FONT_GLYPH_TABLE
  long center = _chars/2;
//  return _get_font_glyph(c & 0x7f7f,center,center -1,_chars - center);
  return _get_font_glyph(c,center,center -1,_chars - center);
#else
  if (_font_glyph_table == NULL){
    int i;
    WSDdeviceFontGlyph* fg;
    WSCushort cc;
    WSCushort max=0;
//    WSCushort min=0xffff;
    for(i=0; i<_chars; i++){
      cc = _font_glyph[i]._char_code;
      if (max < cc){
        max = cc;
      }
//      if (min > cc){
//        min = cc;
//      }
    }
    _font_glyph_table = new WSDdeviceFontGlyph*[max+1];
    memset(_font_glyph_table,0,sizeof(WSDdeviceFontGlyph*)*(max+1));
    for(i=0; i<_chars; i++){
      fg = &(_font_glyph[i]);
      cc = fg->_char_code;
      _font_glyph_table[cc] = fg;
    }
  }
  return _font_glyph_table[c];
#endif
}
#ifdef NO_FONT_GLYPH_TABLE
WSDdeviceFontGlyph* WSDdeviceFont::_get_font_glyph(WSCushort c,int pos,int snum,int lnum){
//dbprintf("_get_font_glyph c=%d pos=%d snum=%d lnum=%d\n",c,pos,snum,lnum);
  if (pos < _chars){
    WSDdeviceFontGlyph* fg = &(_font_glyph[pos]);
    WSCushort cc = fg->_char_code;
    if (cc > c){
      if (snum > 2){
        long center = snum/2;
        long lnum2 = snum - center;
        return _get_font_glyph(c,pos - lnum2,center,lnum2);
      }else if (snum == 2){
        pos--;
        if ( pos > -1){
          WSDdeviceFontGlyph* fg = &(_font_glyph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        pos--;
        if ( pos > -1){
          WSDdeviceFontGlyph* fg = &(_font_glyph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        return NULL;
      }else if (snum == 1){
        pos--;
        if ( pos > -1){
          WSDdeviceFontGlyph* fg = &(_font_glyph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        return NULL;
      }else{
        return NULL;
      }
    }else
    if (cc < c){
      if (lnum > 2){
        long center = lnum/2;
        long lnum2 = lnum - center;
        return _get_font_glyph(c,center + pos,center,lnum2);
      }else if (lnum == 2){
        pos++;
        if ( pos < _chars){
          WSDdeviceFontGlyph* fg = &(_font_glyph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        pos++;
        if ( pos < _chars){
          WSDdeviceFontGlyph* fg = &(_font_glyph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        return NULL;
      }else if (lnum == 1){
        pos++;
        if ( pos < _chars){
          WSDdeviceFontGlyph* fg = &(_font_glyph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        return NULL;
      }else{
        return NULL;
      }
    }else{
      return fg;
    }
  }
  return NULL;
}
#endif
#if 0
int WSDdeviceFont::getStringWidth(WSCushort* str,int len,int* w){
//printf("WSDdeviceFont::getStringWidth here!!\n");
  if (w == NULL){
    return WS_ERR_ADR;
  }
  if (str == NULL){
    return WS_ERR_ADR;
  }
  int i;
  *w = 0;
  for(i=0; i<len; i++){
    WSDdeviceFontGlyph* fg = getFontGlyph(str[i]);
//printf("str[%d] font glyph=0x%x\n",i,fg);
    if (fg != NULL){
//printf("str[%d] width=%d\n",i,fg->_width);
      *w += fg->_width;
    }else{
//printf("str[%d] none width=%d\n",i,_width);
      *w += _width;
    }
  }
//printf("WSDdeviceFont::getStringWidth=%d\n",*w);
  return WS_NO_ERR;
}
#endif
