//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <WScom.h>
#include <devfb/devfb.h>
#include <devfb/devfb_dep.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <sys/time.h>
#include <directfb.h>

#include <WSDkeyboard.h>
#include "fbconfig.h"

#define DFBCHECK(x...) \
     {                                                                \
          DFBResult err = x;                                          \
          if (err != DFB_OK) {                                        \
               fprintf( stderr, "%s <%d>:\n\t", __FILE__, __LINE__ ); \
               DirectFBErrorFatal( #x, err );                         \
          }                                                           \
     }
  

extern int _add_event(WSDdeviceEventList* evt);
extern int _device_check_event_available();
extern int _search_window(short x,short y);

extern int _init_for_event_function();
extern int _wake_up_event();
extern int _wait_event();

void* _dfb_input_thread(void*);
pthread_t _input_thr = 0;

IDirectFB*              _app_context;
IDirectFBDisplayLayer*  _layer;
DFBCardCapabilities     _caps;
DFBDisplayLayerConfig   _layer_config;
IDirectFBEventBuffer*   _ev_buffer;
IDirectFBWindow*        _window;
IDirectFBSurface*       _context;
IDirectFBInputDevice*   _keyboard = 0;
IDirectFBInputDevice*   _mouse = 0;

void _get_mouse_pos(short* x,short* y){
  int px = 0;
  int py = 0;
  _layer->GetCursorPosition( _layer, &px, &py );
  *x = px;
  *y = py;
}
 
int _init_frame_buffer(){
   int argc = 0;
   char** argv = NULL;
   DirectFBInit(&argc,&argv);

  //TODO: init frame buffer..
  DFBCHECK(DirectFBCreate(&_app_context));
  _app_context->GetCardCapabilities( _app_context, &_caps );
  _app_context->CreateEventBuffer(_app_context,&_ev_buffer);


  DFBCHECK(_app_context->GetDisplayLayer(_app_context,DLID_PRIMARY,&_layer));
  _layer->SetCooperativeLevel(_layer,DLSCL_ADMINISTRATIVE);
  
  if (!((_caps.blitting_flags & DSBLIT_BLEND_ALPHACHANNEL) &&
      (_caps.blitting_flags & DSBLIT_BLEND_COLORALPHA  ))){
    _layer_config.flags = DLCONF_BUFFERMODE;
//    _layer_config.buffermode = DLBM_BACKSYSTEM;
    _layer_config.buffermode = DLBM_WINDOWS;
    _layer->SetConfiguration(_layer, &_layer_config);
  }
  _layer->GetConfiguration(_layer, &_layer_config );
  _layer->EnableCursor (_layer, 1 );
#if 0
  IDirectFBSurface* suf;
  _layer->GetSurface(_layer,&suf);
#endif

#if 0
  DFBWindowDescription desc;

  desc.flags  = (DFBWindowDescriptionFlags)( DWDESC_POSX | DWDESC_POSY |
                        DWDESC_WIDTH | DWDESC_HEIGHT | DWDESC_CAPS );
  desc.posx   = 0;
  desc.posy   = 0;
  desc.width  = _device_width;
  desc.height = _device_height;
  desc.caps   = DWCAPS_NONE;
//  desc.caps   = DWCAPS_DOUBLEBUFFER;
//  desc.caps   = DWCAPS_DOUBLEBUFFER;

  DFBCHECK(_layer->CreateWindow( _layer, &desc, &_window ) );
  if (_window == 0){
    _window->SetOpacity(_window, 0xFF );
    _window->GetID(_window, &_window_id );
    _window->CreateEventBuffer(_window,&_ev_buffer);
    _window->GetSurface( _window, &_context );
  }

#endif
   DFBSurfaceDescription desc;
   desc.flags = (DFBSurfaceDescriptionFlags)
        (DSDESC_WIDTH | DSDESC_HEIGHT | DSDESC_PIXELFORMAT | DSDESC_CAPS);
   desc.width = _layer_config.width;
   desc.height = _layer_config.height;
   desc.pixelformat = DSPF_RGB32;
//   desc.caps = DSCAPS_VIDEOONLY;
   desc.caps = DSCAPS_PRIMARY;
   DFBCHECK( _app_context->CreateSurface( _app_context, &desc, &_context) );

  _context->GetSize(_context,&_device_width,&_device_height);

  _device_row_bytes = _device_width * _device_depth /8;

  _device_start_red =   16;
  _device_start_green = 8;
  _device_start_blue =  0;
  _device_red_bits =    8;
  _device_green_bits =  8;
  _device_blue_bits =   8;

  _app_context->GetInputDevice( _app_context, DIDID_KEYBOARD, &_keyboard );
  _app_context->GetInputDevice( _app_context, DIDID_MOUSE, &_mouse );
  if (_keyboard != NULL){
    _keyboard->AttachEventBuffer(_keyboard,_ev_buffer);
  }
  if (_mouse != NULL){
    _mouse->AttachEventBuffer(_mouse,_ev_buffer);
  }

  pthread_create(&_input_thr,NULL,_dfb_input_thread,NULL);

  int pitch;
  _buffer = 0;
  _context->Lock(_context,(DFBSurfaceLockFlags)(DSLF_WRITE | DSLF_READ),(void**)&_buffer,&pitch);

  return WS_NO_ERR;
}

int _update_frame_buffer(int x,int y,unsigned int w,unsigned int h){
  long x2,y2;
  unsigned long w2,h2;

  WSGFandArea(x,y,w,h,0,0,_device_width,_device_height,&x2,&y2,&w2,&h2);
  _context->Unlock(_context);
  _context->Flip(_context,NULL,(DFBSurfaceFlipFlags)0);
  int pitch;
  _context->Lock(_context,(DFBSurfaceLockFlags)(DSLF_WRITE | DSLF_READ),(void**)&_buffer,&pitch);
//printf("_buffer=0x%x pitch=%d wh=%d,%d\n",_buffer,pitch,_device_width,_device_height);
  return 0;
}

int _get_event(WSDdeviceEvent* evt,unsigned int mode){
//printf("_get_event start");
  if (_evt_list == NULL){
    if ( _device_check_event_available() != False ){
      evt->s.type = EV_MSG;
//printf("_get_event1\n");
      return WS_NO_ERR;
    }
    return WS_ERR;
  }
  WSDdeviceEventList* item = _evt_list;
  WSDdeviceEventList* item_bak = NULL;
  while(1){
    if (item == NULL){
      break;
    }
    if ((mode & 0xfff0 ) == DSPEVT){
      if (item->_event.r.type != EV_REQUEST){
        item_bak = item;
        item = item->_next;
        continue;
      }
      if (item->_event.r.cmd != W_REDISP){
        item_bak = item;
        item = item->_next;
        continue;
      }
    }
    if (item_bak == NULL){
      _evt_list = item->_next;
    }else{
      item_bak->_next = item->_next;
    }
    memcpy(evt,&(item->_event),sizeof(WSDdeviceEvent));
    free(item);
//printf("_get_event2\n");
    return WS_NO_ERR;
  }
  if ((mode & 0xfff0 ) == DSPEVT){
    return WS_ERR;
  }
  //TODO: get mouse event..
  //TODO: get key event..
  if ( _device_check_event_available() != False ){
    evt->s.type = EV_MSG;
//printf("_get_event3\n");
    return WS_NO_ERR;
  }
  return WS_ERR;
}
//---------------------------------------------- 
int _key_id_to_key_code(DFBInputDeviceKeyIdentifier kid){
  if (kid >=DIKI_A && kid <=DIKI_Z){
    return WSK_A + kid - DIKI_A;
  }
  if (kid >=DIKI_0 && kid <=DIKI_9){
    return WSK_0 + kid - DIKI_0;
  }
  if (kid >=DIKI_F1 && kid <=DIKI_F12){
    return WSK_F1 + kid - DIKI_F1;
  }
  switch(kid){
    case DIKI_SHIFT_L: return WSK_Shift_L;
    case DIKI_SHIFT_R: return WSK_Shift_R;
    case DIKI_CONTROL_L: return WSK_Control_L;
    case DIKI_CONTROL_R: return WSK_Control_R;
    case DIKI_ALT_L: return WSK_Alt_L;
    case DIKI_ALT_R: return WSK_Alt_R;
    case DIKI_META_L: return WSK_Meta_L;
    case DIKI_META_R: return WSK_Meta_R;
    case DIKI_SUPER_L: return WSK_Super_L;
    case DIKI_SUPER_R: return WSK_Super_R;
    case DIKI_HYPER_L: return WSK_Hyper_L;
    case DIKI_HYPER_R: return WSK_Hyper_R;
    case DIKI_ESCAPE: return WSK_Escape;
    case DIKI_LEFT: return WSK_Left;
    case DIKI_RIGHT: return WSK_Right;
    case DIKI_UP: return WSK_Up;
    case DIKI_DOWN: return WSK_Down;
    case DIKI_TAB: return WSK_Tab;
    case DIKI_ENTER: return WSK_Return;
    case DIKI_SPACE: return WSK_space;
    case DIKI_BACKSPACE: return WSK_BackSpace;
    case DIKI_INSERT: return WSK_Insert;
    case DIKI_DELETE: return WSK_Delete;
    case DIKI_HOME: return WSK_Home;
    case DIKI_END: return WSK_End;
    case DIKI_PAGE_UP: return WSK_Page_Up;
    case DIKI_PAGE_DOWN: return WSK_Page_Down;
    case DIKI_PRINT: return WSK_Print;
    case DIKI_PAUSE: return WSK_Pause;
    case DIKI_QUOTE_LEFT: return WSK_quoteleft;    /*  TLDE  */
    case DIKI_MINUS_SIGN: return WSK_minus;    /*  AE11  */
    case DIKI_EQUALS_SIGN: return WSK_equal;   /*  AE12  */
    case DIKI_BRACKET_LEFT: return WSK_bracketleft;  /*  AD11  */
    case DIKI_BRACKET_RIGHT: return WSK_bracketleft; /*  AD12  */
    case DIKI_BACKSLASH: return WSK_backslash;     /*  BKSL  */
    case DIKI_SEMICOLON: return WSK_semicolon;     /*  AC10  */
    case DIKI_QUOTE_RIGHT: return WSK_quoteright;   /*  AC11  */
    case DIKI_COMMA: return WSK_comma;         /*  AB08  */
    case DIKI_PERIOD: return WSK_period;        /*  AB09  */
    case DIKI_SLASH: return WSK_slash;         /*  AB10  */

    case DIKI_LESS_SIGN: return WSK_less;     /*  103rd  */

    case DIKI_KP_DIV: return WSK_KP_Divide;
    case DIKI_KP_MULT: return WSK_KP_Multiply;
    case DIKI_KP_MINUS: return WSK_KP_Subtract;
    case DIKI_KP_PLUS: return WSK_KP_Add;
    case DIKI_KP_ENTER: return WSK_KP_Enter;
    case DIKI_KP_SPACE: return WSK_KP_Space;
    case DIKI_KP_TAB: return WSK_KP_Tab;
    case DIKI_KP_F1: return WSK_KP_F1;
    case DIKI_KP_F2: return WSK_KP_F2;
    case DIKI_KP_F3: return WSK_KP_F3;
    case DIKI_KP_F4: return WSK_KP_F4;
    case DIKI_KP_EQUAL: return WSK_KP_Equal;
    case DIKI_KP_SEPARATOR: return WSK_KP_Separator;
    case DIKI_KP_DECIMAL: return WSK_KP_Decimal;
    case DIKI_KP_0: return WSK_KP_0;
    case DIKI_KP_1: return WSK_KP_1;
    case DIKI_KP_2: return WSK_KP_2;
    case DIKI_KP_3: return WSK_KP_3;
    case DIKI_KP_4: return WSK_KP_4;
    case DIKI_KP_5: return WSK_KP_5;
    case DIKI_KP_6: return WSK_KP_6;
    case DIKI_KP_7: return WSK_KP_7;
    case DIKI_KP_8: return WSK_KP_8;
    case DIKI_KP_9: return WSK_KP_9;
    default: return 0;
  }
  return 0;
}

void* _dfb_input_thread(void*){
  while(1){
    DFBInputEvent ev;
    int ret = _ev_buffer->WaitForEvent(_ev_buffer);
    ret = _ev_buffer->GetEvent(_ev_buffer,DFB_EVENT(&ev));
    if (ret != DFB_OK){
      continue;
    }
    switch(ev.type){
      case DIET_BUTTONPRESS:{
        WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
        WSDdeviceEvent* evt = &(evtl->_event);

        int px = 0;
        int py = 0;
        _layer->GetCursorPosition( _layer, &px, &py );

        int wid = _search_window(px,py);
        if (wid > 0){
          short wx = _window_list[wid -1]._x;
          short wy = _window_list[wid -1]._y;
          evt->s.stat = ES_BUT;
          evt->e.pos.x = px -wx;
          evt->e.pos.y = py -wy;
          evt->s.type = EV_BUTDWN;
          evt->s.cmd = W_WORK;
          evt->s.wid = wid;
#ifndef NO_THREAD
          WSGFdeviceSemLock(_event_sem_id);
#endif
          _add_event(evtl);

#ifndef NO_THREAD
          WSGFdeviceSemUnlock(_event_sem_id);
          _wake_up_event();
#endif
        }else{
          delete evtl;
        }
        break;
      }

      case DIET_BUTTONRELEASE:{
//printf("btn release\n");
        WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
        WSDdeviceEvent* evt = &(evtl->_event);
        int px = 0;
        int py = 0;
        _layer->GetCursorPosition( _layer, &px, &py );

        int wid = _search_window(px,py);
        if (wid > 0){
          short wx = _window_list[wid -1]._x;
          short wy = _window_list[wid -1]._y;
          evt->s.stat = 0;
          evt->s.stat |= ES_BUT;
  
          evt->e.pos.x = px -wx;
          evt->e.pos.y = py -wy;
          evt->s.type = EV_BUTUP;
          evt->s.cmd = W_WORK;
          evt->s.wid = wid;
#ifndef NO_THREAD
          WSGFdeviceSemLock(_event_sem_id);
#endif
          _add_event(evtl);

#ifndef NO_THREAD
          WSGFdeviceSemUnlock(_event_sem_id);
          _wake_up_event();
#endif
        }else{
          delete evtl;
        }
        break;
      }
      case DIET_AXISMOTION:{
        WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
        WSDdeviceEvent* evt = &(evtl->_event);

        int px = 0;
        int py = 0;
        _layer->GetCursorPosition( _layer, &px, &py );
        int wid = _search_window(px,py);
        if (wid > 0){
          short wx = _window_list[wid -1]._x;
          short wy = _window_list[wid -1]._y;
          evt->s.wid = wid;
          evt->e.pos.x = px -wx;
          evt->e.pos.y = py -wy;
        }else{
          evt->s.wid = 0;
          evt->e.pos.x = px;
          evt->e.pos.y = py;
        }
        evt->s.stat = 0;
        evt->s.stat |= ES_BUT;
        evt->e.type = EV_NULL;
#ifndef NO_THREAD
        WSGFdeviceSemLock(_event_sem_id);
#endif
        _add_event(evtl);

#ifndef NO_THREAD
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
#endif
      break;
    }
    case DIET_KEYPRESS:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int key = _key_id_to_key_code(ev.key_id);
      char buffer[1024];
      buffer[0] = 0;
      WSCushort key_str[2];
      key_str[0] = ev.key_symbol; //UCS2 string..
      key_str[1] = 0;

      if (key_str[0] & 0xff00){
        buffer[0] = 0;
      }else{
        buffer[0] = (char)(key_str[0] & 0xff);
        buffer[1] = 0;
      }
      WSGIappKeyboard()->setText(buffer,WS_EN_UTF8);

      evt->s.wid = (short)key;
      evt->e.type = EV_KEYDWN;
      evt->s.stat = 0;
      if (ev.modifiers & DIMM_SHIFT ){
        evt->s.stat |= 0x10;
      }
      if (ev.key_id == DIKI_CAPS_LOCK){
        evt->s.stat |= 0x08;
      }
      if (ev.modifiers & DIMM_CONTROL ){
        evt->s.stat |= 0x80;
      }
      if (ev.modifiers & DIMM_ALT ){
        evt->s.stat |= 0x40;
      }
      if (ev.modifiers & DIMM_META ){
        evt->s.stat |= 0x40;
      }

#ifndef NO_THREAD
      WSGFdeviceSemLock(_event_sem_id);
#endif
      _add_event(evtl);

#ifndef NO_THREAD
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
#endif
 
      break;
    }
    case DIET_KEYRELEASE:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int key = _key_id_to_key_code(ev.key_id);
      char buffer[1024];
      buffer[0] = 0;
      WSCushort key_str[2];
      key_str[0] = ev.key_symbol; //UCS2 string..
      key_str[1] = 0;

      if (key_str[0] & 0xff00){
        buffer[0] = 0;
      }else{
        buffer[0] = (char)(key_str[0] & 0xff);
        buffer[1] = 0;
      }
      WSGIappKeyboard()->setText(buffer,WS_EN_UTF8);

      evt->s.wid = key;
      evt->e.type = EV_KEYUP;
#ifndef NO_THREAD
      WSGFdeviceSemLock(_event_sem_id);
#endif
      _add_event(evtl);

#ifndef NO_THREAD
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
#endif
 
      break;
    }
    default:{
      break;
    }
  }
  }
  return NULL;
}

