//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <qpe/qpeapplication.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>

class WSCqtBase : public QWidget{
    Q_OBJECT
public:
    WSCqtBase( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 ){
      setName( "WSCqtBase" );
      resize( 320, 640 );
      setCaption( tr( "" ) );
    }
    ~WSCqtBase(){};
};
QTOPIA_ADD_APPLICATION("example", WSCqtBase)

#if !defined(Q_MOC_OUTPUT_REVISION)
#define Q_MOC_OUTPUT_REVISION 9
#elif Q_MOC_OUTPUT_REVISION != 9
#error "Moc format conflict - please regenerate all moc files"
#endif

#ifdef QWS
#include <qobjectdict.h>
#endif

const char *WSCqtBase::className() const {
    return "WSCqtBase";
}
QMetaObject *WSCqtBase::metaObj = 0;

#ifdef QWS
static class WSCqtBase_metaObj_Unloader {
public:
  ~WSCqtBase_metaObj_Unloader(){
    if ( objectDict ){
      objectDict->remove( "WSCqtBase" );
    }
  }
} WSCqtBase_metaObj_unloader;
#endif

void WSCqtBase::initMetaObject() {
  if (metaObj){
	return;
  }
  if ( qstrcmp(QWidget::className(), "QWidget") != 0 ){
	badSuperclassWarning("WSCqtBase","QWidget");
  }
  (void) staticMetaObject();
}

#ifndef QT_NO_TRANSLATION
QString WSCqtBase::tr(const char* s) {
  return qApp->translate( "WSCqtBase", s, 0 );
}

QString WSCqtBase::tr(const char* s, const char * c) {
  return qApp->translate( "WSCqtBase", s, c );
}

#endif // QT_NO_TRANSLATION
QMetaObject* WSCqtBase::staticMetaObject(){
  if (metaObj){
    return metaObj;
  }
  (void) QWidget::staticMetaObject();
#ifndef QT_NO_PROPERTIES
#endif // QT_NO_PROPERTIES
  QMetaData::Access *slot_tbl_access = 0;
  metaObj = QMetaObject::new_metaobject(
	"WSCqtBase", "QWidget",
	0, 0,
	0, 0,
#ifndef QT_NO_PROPERTIES
	0, 0,
	0, 0,
#endif // QT_NO_PROPERTIES
	0, 0 );
  metaObj->set_slot_access( slot_tbl_access );
#ifndef QT_NO_PROPERTIES
#endif // QT_NO_PROPERTIES
  return metaObj;
}

//QTOPIA_MAIN
QWidget *mw = 0;
void* _qt_loop_(void* ptr){
  QPEApplication* a = (QPEApplication*)ptr;
  int rv = a->exec();
  delete mw;
  exit(1);
}

QPEAppMap *qpeAppMap();
int main( int argc, char ** argv ){
  QPEApplication a( argc, argv );
  QString executableName(argv[0]);
    executableName = executableName.right(executableName.length()
        - executableName.findRev('/') - 1);

  if ( qpeAppMap()->contains(executableName) ){
    mw = (*qpeAppMap())[executableName](0,0,0); 
  }else if ( qpeAppMap()->count() ){
    mw = qpeAppMap()->begin().data()(0,0,0); 
  }
  if ( mw ) {
    if ( mw->metaObject()->slotNames().contains("setDocument(const QString&)") ){
      a.showMainDocumentWidget( mw );
    }else{
      a.showMainWidget( mw ); 
    }
    pthread_t _id;
    int ret = pthread_create(&_id,NULL,_qt_loop_,&a);
extern int WSGFwsMain(int,char**);
    return WSGFwsMain(argc,argv);

#if 0
        int rv = a.exec(); 
        delete mw; 
        return rv; 
#endif
  }else{ 
    return -1; 
  } 
}

QPEAppMap *qpeAppMap() { 
  static QPEAppMap *amap = 0; 
  if (!amap ){
    amap = new QPEAppMap(); 
  }
  return amap; 
} 


