//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <mac/WSDmacAppDev.h>
#include <mac/WSDmacTimer.h>

WSMFclassInit(WSDmacTimer,WSDtimer);

//250 ms 
#define _WS_INTERVAL_     250

WSDtimer* _macTimer_create_handler(){
  return new WSDmacTimer();
}

#ifndef NO_GLOBAL_CONSTRUCTORS
class _macTimer_init{
  public: _macTimer_init(){
    WSDtimer::setCreateInstanceHandler(_macTimer_create_handler);
  };
};

_macTimer_init _macTimer_init_run_constructor;
#endif

WSDmacTimer::WSDmacTimer(){
printf("WSDmacTimer::WSDmacTimer not supported..\n");
//  _interval_id =0;
  _timer_set();
}
WSDmacTimer::~WSDmacTimer(){
#if 0
  if (_interval_id != 0){
    XtRemoveTimeOut(_interval_id);
    _interval_id = 0;
  }
#endif
}


void WSDmacTimer::_timer_set(){
#if 0 //XXZZ
  _interval_id = XtAppAddTimeOut(WSGIxwinAppDev()->appContext(),_WS_INTERVAL_,
      (XtTimerCallbackProc)_timer_callback,this);
  if ( _interval_id ==  0 ) {
WSMFtrace("Error. WSDmacTimer is down.\n");
  }
#endif //XXZZ
}

#if 0 //XXZZ
void WSDmacTimer::_timer_callback(XtPointer ptr,XtIntervalId) {
    WSDmacTimer* obj = (WSDmacTimer*)ptr;
    obj->_clock++;
    long i;
    long num = obj->_cproc_list.getNum();

//WSMFtrace("WSDmacTimer::_timer_callback timer procs=%d\n",num);
    //execute the timer processes...
    for(i = 0; i < num; i++){
      timerProcRec* proc = (timerProcRec*)obj->_cproc_list.getData(i);
//WSMFtrace("WSDmacTimer::_timer_callback clock=%d  proc rate=%d  tm=%d\n",obj->_clock,proc->rate,proc->fclock);
      if ( ( obj->_clock % proc->rate) == proc->fclock ){
//WSMFtrace("WSDmacTimer::_timer_callback exec procs=0x%x\n",proc);
        proc->proc(obj->_clock,proc->data);
      }
    }

    num = obj->_proc_list.getNum();
    //execute the trigger processes...
    for(i = 0; i < num; i++){
      triggerProcRec* proc = (triggerProcRec*)obj->_proc_list.getData(i);
      if (( obj->_clock % proc->rate) == proc->fclock ){
        //delete this executed process from the process list
        obj->_proc_list.del(proc); 
        num = obj->_proc_list.getNum();
        i--;

        proc->proc(obj->_clock,proc->data);
        proc->executed = False;
        delete proc;
      }
    }
    obj->_timer_set();
    return;
}
#endif //XXZZ
