//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <stdio.h>
#include <WScom.h>
#include <WSCbase.h>
#include <WSCprocedure.h>
#include <WSCstring.h>
#include <WSCvariant.h>
#include <jni.h>
#include <WSCbaseList.h>
#include "wsjava.h"
#ifdef MacOS
#include <pthread.h>
#endif
static JavaVM *jvm[] = {NULL};
static JNIEnv *env = NULL;

void _procedure_handler(char* fname,WSCbase* ptr){
  static const unsigned char VM_NUM = 1;

  // variable
  jint r;
  WSCstring tmp, name, cname, user_pkg;
  jobject obj;
  jclass cls;
  jfieldID fid;
  jmethodID mid;

   // init
  int t =0;
  if (jvm[t] == NULL) {
//printf("_procedure_handler...init\n");
    jsize num = 0;
    r = JNI_GetCreatedJavaVMs(jvm, VM_NUM, &num);
    if (r != JNI_OK && num != VM_NUM) {
      fprintf(stderr, "Error: JNI_GetCreatedJavaVMs() in _procedure_handler()\n");
      return;
    }
  }
  // get env
  WSCbool attached = False;
  r = jvm[t]->GetEnv((void **)&env, JNI_VERSION_1_1);
  if (r == JNI_EDETACHED){
    attached = True;
    r = jvm[t]->AttachCurrentThread((void **)&env, NULL);
  }
  //r = jvm[t]->AttachCurrentThread((void **)&env, NULL);
  //r = jvm[0]->GetEnv((void **)&env, JNI_VERSION_1_4);
  //r = jvm[0]->AttachCurrentThreadAsDaemon((void **)&env, NULL);
  if (r != JNI_OK) {
     fprintf(stderr, "Error: JavaVM::GetEnv()");
     return;
  }

  if (env == NULL){
    fprintf(stderr,"Error: Cannot attach current thread of JavaVM in _procedure_handler()\n");
    return;
  }

   // ptr to java object
  user_pkg = ptr->getVariantData("package_name");
  if (!strcmp(user_pkg,"0")){
    user_pkg = "";
  }
  obj = (jobject)ptr->getUserData("java-object");

   // fname to java method ID
  tmp = fname;
  long wc = tmp.getWords(".");
  if (wc < 2) {
    fprintf(stderr,"procedure function name error. name:%s\n",(char*)fname);
    return;
  }

  name = tmp.getWord(wc - 1, ".");
  cname = user_pkg;
  tmp.cutString(tmp.getWordCharPos(wc - 1, ".") - 1);
  cname << tmp;
  jboolean excep = env->ExceptionCheck();
  if (excep == 1){
    env->ExceptionClear();
  }
  cls = env->FindClass(cname);
  if (cls == NULL){
    fprintf(stderr, "Error: Cannot get the event procedure in _procedure_handler() class_name=%s\n",(char*)cname);
    return;
  }

  mid = env->GetStaticMethodID(cls, name, METHOD_SIG);

  if (mid == NULL){
    fprintf(stderr, "Error: Cannot get the event procedure in _procedure_handler() method_id is missed.\n");
    return;
  }
   // call method
  env->CallStaticVoidMethod(cls, mid, obj);
  if (attached != False){
    jvm[t]->DetachCurrentThread();
  }
}

void _ev_proc_handler(char* fname,void* val){
  static const char *METHOD_SIG = "(J)V";
  static const unsigned char VM_NUM = 1;
//printf("_ev_proc_handler fname=%s\n",fname);
  // variable
  jint r;
  WSCstring name, cname;
  jobject obj;
  jclass cls;
  jfieldID fid;
  jmethodID mid;

   // init
  int t =0;
  if (jvm[t] == NULL) {
//printf("_procedure_handler...init\n");
    jsize num = 0;
    r = JNI_GetCreatedJavaVMs(jvm, VM_NUM, &num);
    if (r != JNI_OK && num != VM_NUM) {
      fprintf(stderr, "Error: JNI_GetCreatedJavaVMs() in _procedure_handler()\n");
      return;
    }
  }
  // get env

  WSCbool attached = False;
  r = jvm[t]->GetEnv((void **)&env, JNI_VERSION_1_1);
  if (r == JNI_EDETACHED){
    attached = True;
    r = jvm[t]->AttachCurrentThread((void **)&env, NULL);
  }
//  r = jvm[t]->AttachCurrentThread((void **)&env, NULL);
  if (r != JNI_OK) {
     fprintf(stderr, "Error: JavaVM::GetEnv()");
     return;
  }

  if (env == NULL){
    fprintf(stderr,"Error: Cannot attach current thread of JavaVM in _ev_procedure_handler()\n");
    return;
  }

   // fname to java method ID
  cname = fname;
  long wc = cname.getWords(".");
  if (wc < 2) {
    fprintf(stderr,"procedure function name error. name:%s\n",(char*)fname);
    return;
  }

  name = cname.getWord(wc - 1, ".");
  cname.cutString(cname.getWordCharPos(wc - 1, ".") - 1);
  cname.replaceString(".","/",0);

  jboolean excep = env->ExceptionCheck();
  if (excep == 1){
    env->ExceptionDescribe();
    env->ExceptionClear();
  }
  cls = env->FindClass(cname);
  if (cls == NULL){
    fprintf(stderr, "Error: Cannot get the event procedure in _ev_procedure_handler() class_name=%s\n",(char*)cname);
    return;
  }

  mid = env->GetStaticMethodID(cls, name, METHOD_SIG);
  if (mid == NULL){
    fprintf(stderr, "Error: Cannot get the event procedure in _ev_procedure_handler() method_id is missed.\n");
    return;
  }
   // call method
  env->CallStaticVoidMethod(cls, mid, val);
  excep = env->ExceptionCheck();
  if (attached != False){
    jvm[t]->DetachCurrentThread();
  }
}



class _java_proc_init{
  public: _java_proc_init(){
    WSGFsetProcedureHandler((void*)_procedure_handler);
    WSGIappObjectList()->setEventProcHandler(_ev_proc_handler);
  };
};
_java_proc_init _exec_java_init;
