open Swig
open Mwt

let mwt_inited = ref false
let mwt_app = ref C_void
let mwt_font_data = ref C_void
let init_application num fontdata=
   match !mwt_inited with
   | true -> ()
   | false ->
      ignore(Mwt._WSGFdeviceInitialize (C_list [C_void]));
      mwt_app := Mwt._WSGIappDev (C_list [C_void]);
      mwt_font_data := new_WSCstring (C_list [C_string fontdata]);
      ignore(Mwt._WSGFwsInitialize (C_list [C_void]));
      ignore(Mwt._WSGFsetFontData (C_list [!mwt_font_data]));
      ignore(Mwt._WSGFsetDefaultEncoding (C_list [C_int num]));
      mwt_inited := true;;

type c_enum_type = Mwt.c_enum_type
type c_enum_value = Mwt.c_enum_value
type c_obj = Mwt.c_obj
exception BadArgs of string
exception BadMethodName of c_obj * string * string
exception NotObject of c_obj
exception NotEnumType of c_obj
exception LabelNotFromThisEnum of c_obj
exception InvalidDirectorCall of c_obj
let _WS_DATA_SOURCE_NONE = Mwt._WS_DATA_SOURCE_NONE C_void
let _WS_DATA_SOURCE_INSTANCE = Mwt._WS_DATA_SOURCE_INSTANCE C_void
let _WS_DATA_SOURCE_FILE = Mwt._WS_DATA_SOURCE_FILE C_void
let _WS_TEXT = Mwt._WS_TEXT C_void
let _WS_BINARY = Mwt._WS_BINARY C_void
let _WS_NORMAL = Mwt._WS_NORMAL C_void
let _WS_TREE = Mwt._WS_TREE C_void
let _WS_VERBOSE = Mwt._WS_VERBOSE C_void
let _WS_HAVE_CHILD = Mwt._WS_HAVE_CHILD C_void
let _WS_HAVE_BROS = Mwt._WS_HAVE_BROS C_void
let _WS_OPEN = Mwt._WS_OPEN C_void
let _WS_INDENT_LEVEL = Mwt._WS_INDENT_LEVEL C_void
let _WS_ABSOLUTE_OPEN = Mwt._WS_ABSOLUTE_OPEN C_void
let _WS_ICON = Mwt._WS_ICON C_void
let _WS_SFORM_FIXED = Mwt._WS_SFORM_FIXED C_void
let _WS_SFORM_UNDER_RESIZING = Mwt._WS_SFORM_UNDER_RESIZING C_void
let _WS_EXEC_NONE = Mwt._WS_EXEC_NONE C_void
let _WS_EXEC_RD = Mwt._WS_EXEC_RD C_void
let _WS_EXEC_RDWR = Mwt._WS_EXEC_RDWR C_void
let _WS_EXEC_WR = Mwt._WS_EXEC_WR C_void
let _WS_DOUBLE_CLICK_TIME = Mwt._WS_DOUBLE_CLICK_TIME C_void
let _WS_POLICY_ORIGINAL = Mwt._WS_POLICY_ORIGINAL C_void
let _WS_POLICY_WINDOWS = Mwt._WS_POLICY_WINDOWS C_void
let _WS_POLICY_GRADATION = Mwt._WS_POLICY_GRADATION C_void
let _WS_POLICY_AQUA = Mwt._WS_POLICY_AQUA C_void
let _WS_TYPE_WINDOW = Mwt._WS_TYPE_WINDOW C_void
let _WS_TYPE_MANAGER = Mwt._WS_TYPE_MANAGER C_void
let _WS_TYPE_FORM = Mwt._WS_TYPE_FORM C_void
let _WS_TYPE_SCR_FORM = Mwt._WS_TYPE_SCR_FORM C_void
let _WS_TYPE_MENU_WINDOW = Mwt._WS_TYPE_MENU_WINDOW C_void
let _WS_EN_DEFAULT = Mwt._WS_EN_DEFAULT C_void
let _WS_EN_LOCALE = Mwt._WS_EN_LOCALE C_void
let _WS_EN_NONE = Mwt._WS_EN_NONE C_void
let _WS_EN_ISO8859_1 = Mwt._WS_EN_ISO8859_1 C_void
let _WS_EN_ISO8859_2 = Mwt._WS_EN_ISO8859_2 C_void
let _WS_EN_ISO8859_3 = Mwt._WS_EN_ISO8859_3 C_void
let _WS_EN_ISO8859_4 = Mwt._WS_EN_ISO8859_4 C_void
let _WS_EN_ISO8859_5 = Mwt._WS_EN_ISO8859_5 C_void
let _WS_EN_ISO8859_6 = Mwt._WS_EN_ISO8859_6 C_void
let _WS_EN_ISO8859_7 = Mwt._WS_EN_ISO8859_7 C_void
let _WS_EN_ISO8859_8 = Mwt._WS_EN_ISO8859_8 C_void
let _WS_EN_ISO8859_9 = Mwt._WS_EN_ISO8859_9 C_void
let _WS_EN_ISO8859_10 = Mwt._WS_EN_ISO8859_10 C_void
let _WS_EN_ISO8859_11 = Mwt._WS_EN_ISO8859_11 C_void
let _WS_EN_ISO8859_12 = Mwt._WS_EN_ISO8859_12 C_void
let _WS_EN_ISO8859_13 = Mwt._WS_EN_ISO8859_13 C_void
let _WS_EN_ISO8859_14 = Mwt._WS_EN_ISO8859_14 C_void
let _WS_EN_ISO8859_15 = Mwt._WS_EN_ISO8859_15 C_void
let _WS_EN_UTF8 = Mwt._WS_EN_UTF8 C_void
let _WS_EN_KOI8R = Mwt._WS_EN_KOI8R C_void
let _WS_EN_EUCJP = Mwt._WS_EN_EUCJP C_void
let _WS_EN_SJIS = Mwt._WS_EN_SJIS C_void
let _WS_EN_EUCKR = Mwt._WS_EN_EUCKR C_void
let _WS_EN_EUCCN = Mwt._WS_EN_EUCCN C_void
let _WS_EN_BIG5 = Mwt._WS_EN_BIG5 C_void
let _WS_DIALOG_CANCEL = Mwt._WS_DIALOG_CANCEL C_void
let _WS_DIALOG_OK = Mwt._WS_DIALOG_OK C_void
let _WS_DIALOG_NO = Mwt._WS_DIALOG_NO C_void
let _WS_DIALOG_DONE = Mwt._WS_DIALOG_DONE C_void

let _WSGIappDev arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappDev arg

let _WSGFwsInitialize arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFwsInitialize arg

let _WSGFwsInitialize2 arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFwsInitialize2 arg

let _WSGFdestroyWindow arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFdestroyWindow arg

let _WSGFdeviceInitialize arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFdeviceInitialize arg

let _WSGIappMouse arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappMouse arg

let _WSGIappKeyboard arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappKeyboard arg
let _WSCDB_SQL_CONCUR_READ_ONLY = Mwt._WSCDB_SQL_CONCUR_READ_ONLY C_void
let _WSCDB_SQL_CONCUR_LOCK = Mwt._WSCDB_SQL_CONCUR_LOCK C_void
let _WSCDB_SQL_CONCUR_ROWVER = Mwt._WSCDB_SQL_CONCUR_ROWVER C_void
let _WSCDB_SQL_CONCUR_VALUES = Mwt._WSCDB_SQL_CONCUR_VALUES C_void
let _WSCDB_SQL_CONCUR_DEFAULT = Mwt._WSCDB_SQL_CONCUR_DEFAULT C_void
let _WSCDB_SQL_CURSOR_FORWARD_ONLY = Mwt._WSCDB_SQL_CURSOR_FORWARD_ONLY C_void
let _WSCDB_SQL_CURSOR_KEYSET_DRIVEN = Mwt._WSCDB_SQL_CURSOR_KEYSET_DRIVEN C_void
let _WSCDB_SQL_CURSOR_DYNAMIC = Mwt._WSCDB_SQL_CURSOR_DYNAMIC C_void
let _WSCDB_SQL_CURSOR_STATIC = Mwt._WSCDB_SQL_CURSOR_STATIC C_void
let _WSCDB_SQL_CURSOR_TYPE_DEFAULT = Mwt._WSCDB_SQL_CURSOR_TYPE_DEFAULT C_void
let _WSCDB_FIELD_TYPE_CHAR = Mwt._WSCDB_FIELD_TYPE_CHAR C_void
let _WSCDB_FIELD_TYPE_NUMERIC = Mwt._WSCDB_FIELD_TYPE_NUMERIC C_void
let _WSCDB_FIELD_TYPE_DECIMAL = Mwt._WSCDB_FIELD_TYPE_DECIMAL C_void
let _WSCDB_FIELD_TYPE_INTEGER = Mwt._WSCDB_FIELD_TYPE_INTEGER C_void
let _WSCDB_FIELD_TYPE_SMALLINT = Mwt._WSCDB_FIELD_TYPE_SMALLINT C_void
let _WSCDB_FIELD_TYPE_FLOAT = Mwt._WSCDB_FIELD_TYPE_FLOAT C_void
let _WSCDB_FIELD_TYPE_REAL = Mwt._WSCDB_FIELD_TYPE_REAL C_void
let _WSCDB_FIELD_TYPE_DOUBLE = Mwt._WSCDB_FIELD_TYPE_DOUBLE C_void
let _WSCDB_FIELD_TYPE_DATE = Mwt._WSCDB_FIELD_TYPE_DATE C_void
let _WSCDB_FIELD_TYPE_TIME = Mwt._WSCDB_FIELD_TYPE_TIME C_void
let _WSCDB_FIELD_TYPE_TIMESTAMP = Mwt._WSCDB_FIELD_TYPE_TIMESTAMP C_void
let _WSCDB_FIELD_TYPE_NONE = Mwt._WSCDB_FIELD_TYPE_NONE C_void

let _WSGIappFileSelect arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappFileSelect arg

let _WSGFsetDefaultEncoding arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsetDefaultEncoding arg

let _WSGFgettext arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgettext arg

let _WSGFimage arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFimage arg

let _WSGIappColorSet arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappColorSet arg

let _WSGFindexColor arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFindexColor arg

let _WSGFcolorName arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFcolorName arg

let _WSGFcolor arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFcolor arg

let _WSGIappImageSet arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappImageSet arg

let _WSGFimageName arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFimageName arg

let _WSGIappFontSet arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappFontSet arg

let _WSGFdestroyPixmap arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFdestroyPixmap arg

let _WSGFdestroyPixmap arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFdestroyPixmap arg

let _WSGIappMessageDialog arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappMessageDialog arg

let _WSGIappObjectList arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGIappObjectList arg

let _WSGFreadWinFile arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFreadWinFile arg
let _WSCSHEET_DEFAULT = Mwt._WSCSHEET_DEFAULT C_void
let _WSCSHEET_NONE = Mwt._WSCSHEET_NONE C_void
let _WSCSHEET_HORZ = Mwt._WSCSHEET_HORZ C_void
let _WSCSHEET_VERT = Mwt._WSCSHEET_VERT C_void
let _WSCSHEET_BOTH = Mwt._WSCSHEET_BOTH C_void
let _WSCSHEET_DEF_ROW_HEIGHT = Mwt._WSCSHEET_DEF_ROW_HEIGHT C_void
let _WSCSHEET_DEF_COL_WIDTH = Mwt._WSCSHEET_DEF_COL_WIDTH C_void
let _WSCSHEET_DEFCOLOR = Mwt._WSCSHEET_DEFCOLOR C_void
let _WSCSHEET_DEFFONT = Mwt._WSCSHEET_DEFFONT C_void
let _WSCSHEET_DEF_ROWS = Mwt._WSCSHEET_DEF_ROWS C_void
let _WSCSHEET_DEF_COLS = Mwt._WSCSHEET_DEF_COLS C_void
let _WSCSHEET_DEF_FIXEDROWS = Mwt._WSCSHEET_DEF_FIXEDROWS C_void
let _WSCSHEET_DEF_FIXEDCOLS = Mwt._WSCSHEET_DEF_FIXEDCOLS C_void
let _WSCSHEET_DB_SORT_ASC = Mwt._WSCSHEET_DB_SORT_ASC C_void
let _WSCSHEET_DB_SORT_DESC = Mwt._WSCSHEET_DB_SORT_DESC C_void
let _WS_MOUSE_SHIFT = Mwt._WS_MOUSE_SHIFT C_void
let _WS_MOUSE_LOCK = Mwt._WS_MOUSE_LOCK C_void
let _WS_MOUSE_CONTROL = Mwt._WS_MOUSE_CONTROL C_void
let _WS_MOUSE_MOD = Mwt._WS_MOUSE_MOD C_void
let _WS_MOUSE_BTN1 = Mwt._WS_MOUSE_BTN1 C_void
let _WS_MOUSE_BTN2 = Mwt._WS_MOUSE_BTN2 C_void
let _WS_MOUSE_BTN3 = Mwt._WS_MOUSE_BTN3 C_void
let _WS_MOUSE_BTN4 = Mwt._WS_MOUSE_BTN4 C_void
let _WS_MOUSE_BTN5 = Mwt._WS_MOUSE_BTN5 C_void
let _WS_READ = Mwt._WS_READ C_void
let _WS_WRITE = Mwt._WS_WRITE C_void
let _WS_RW = Mwt._WS_RW C_void
let _WS_IN_OUT = Mwt._WS_IN_OUT C_void
let _WS_OUT = Mwt._WS_OUT C_void
let _WS_IN = Mwt._WS_IN C_void
let _WS_NONE = Mwt._WS_NONE C_void
let _WS_VERTICAL = Mwt._WS_VERTICAL C_void
let _WS_HORIZONTAL = Mwt._WS_HORIZONTAL C_void
let _WS_DIRECT_WINDOW = Mwt._WS_DIRECT_WINDOW C_void
let _WS_DYNAMIC_PIXMAP = Mwt._WS_DYNAMIC_PIXMAP C_void
let _WS_SHADOW_NONE = Mwt._WS_SHADOW_NONE C_void
let _WS_SHADOW_TRANS = Mwt._WS_SHADOW_TRANS C_void
let _WS_SHADOW_OUT = Mwt._WS_SHADOW_OUT C_void
let _WS_SHADOW_IN = Mwt._WS_SHADOW_IN C_void
let _WS_SHADOW_EOUT = Mwt._WS_SHADOW_EOUT C_void
let _WS_SHADOW_EIN = Mwt._WS_SHADOW_EIN C_void
let _WS_SHADOW_BORDER = Mwt._WS_SHADOW_BORDER C_void
let _WS_NO_TITLE = Mwt._WS_NO_TITLE C_void
let _WS_FULL_TITLE = Mwt._WS_FULL_TITLE C_void
let _WS_ONLY_TITLE = Mwt._WS_ONLY_TITLE C_void
let _WS_MINI_BTN = Mwt._WS_MINI_BTN C_void
let _WS_MAX_BTN = Mwt._WS_MAX_BTN C_void
let _WS_FRAME = Mwt._WS_FRAME C_void
let _WS_NO_MANAGE = Mwt._WS_NO_MANAGE C_void
let _WS_LEFT = Mwt._WS_LEFT C_void
let _WS_RIGHT = Mwt._WS_RIGHT C_void
let _WS_CENTER = Mwt._WS_CENTER C_void
let _WS_UP = Mwt._WS_UP C_void
let _WS_TOP = Mwt._WS_TOP C_void
let _WS_DOWN = Mwt._WS_DOWN C_void
let _WS_BOTTOM = Mwt._WS_BOTTOM C_void
let _WS_LEFT_TOP = Mwt._WS_LEFT_TOP C_void
let _WS_LEFT_BOTTOM = Mwt._WS_LEFT_BOTTOM C_void
let _WS_RIGHT_TOP = Mwt._WS_RIGHT_TOP C_void
let _WS_RIGHT_BOTTOM = Mwt._WS_RIGHT_BOTTOM C_void
let _WS_RET = Mwt._WS_RET C_void
let _WS_TAB = Mwt._WS_TAB C_void
let _WS_STAB = Mwt._WS_STAB C_void
let _WS_NO_ERR = Mwt._WS_NO_ERR C_void
let _WS_OK = Mwt._WS_OK C_void
let _WS_ERR = Mwt._WS_ERR C_void
let _WS_REMOTE_CALL_FAILED = Mwt._WS_REMOTE_CALL_FAILED C_void
let _False = Mwt._False C_void
let _True = Mwt._True C_void
let _WSTlong = Mwt._WSTlong C_void
let _WSTulong = Mwt._WSTulong C_void
let _WSTshort = Mwt._WSTshort C_void
let _WSTushort = Mwt._WSTushort C_void
let _WSTchar = Mwt._WSTchar C_void
let _WSTuchar = Mwt._WSTuchar C_void
let _WSTfloat = Mwt._WSTfloat C_void
let _WSTdouble = Mwt._WSTdouble C_void
let _WSTvoidptr = Mwt._WSTvoidptr C_void
let _WSTcharptr = Mwt._WSTcharptr C_void
let _WSTvoid = Mwt._WSTvoid C_void
let _WSTbool = Mwt._WSTbool C_void
let _WSTint = Mwt._WSTint C_void
let _WSTuint = Mwt._WSTuint C_void
let _WSEV_HASH_MAX_NUM = Mwt._WSEV_HASH_MAX_NUM C_void
let _WSEV_NONE = Mwt._WSEV_NONE C_void
let _WSEV_INITIALIZE = Mwt._WSEV_INITIALIZE C_void
let _WSEV_DELETE = Mwt._WSEV_DELETE C_void
let _WSEV_ACTIVATE = Mwt._WSEV_ACTIVATE C_void
let _WSEV_VALUE_CH = Mwt._WSEV_VALUE_CH C_void
let _WSEV_FOCUS_CH = Mwt._WSEV_FOCUS_CH C_void
let _WSEV_VISIBLE_CH = Mwt._WSEV_VISIBLE_CH C_void
let _WSEV_SENSITIVE_CH = Mwt._WSEV_SENSITIVE_CH C_void
let _WSEV_PARENT_VISIBLE_CH = Mwt._WSEV_PARENT_VISIBLE_CH C_void
let _WSEV_PARENT_SENSITIVE_CH = Mwt._WSEV_PARENT_SENSITIVE_CH C_void
let _WSEV_EXPOSE = Mwt._WSEV_EXPOSE C_void
let _WSEV_RESIZE = Mwt._WSEV_RESIZE C_void
let _WSEV_MOUSE_IN = Mwt._WSEV_MOUSE_IN C_void
let _WSEV_MOUSE_OUT = Mwt._WSEV_MOUSE_OUT C_void
let _WSEV_MOUSE_PRESS = Mwt._WSEV_MOUSE_PRESS C_void
let _WSEV_MOUSE_RELEASE = Mwt._WSEV_MOUSE_RELEASE C_void
let _WSEV_MOUSE_MOVE = Mwt._WSEV_MOUSE_MOVE C_void
let _WSEV_KEY_PRESS = Mwt._WSEV_KEY_PRESS C_void
let _WSEV_KEY_RELEASE = Mwt._WSEV_KEY_RELEASE C_void
let _WSEV_KEY_HOOK = Mwt._WSEV_KEY_HOOK C_void
let _WSEV_MOUSE_DOUBLE_CLICK = Mwt._WSEV_MOUSE_DOUBLE_CLICK C_void
let _WSEV_SORT = Mwt._WSEV_SORT C_void
let _WSEV_GUI_POLICY_CH = Mwt._WSEV_GUI_POLICY_CH C_void
let _WSEV_ITEM_SELECTED = Mwt._WSEV_ITEM_SELECTED C_void
let _WSEV_STATUS_CH = Mwt._WSEV_STATUS_CH C_void
let _WSEV_INPUT_FIXED = Mwt._WSEV_INPUT_FIXED C_void
let _WSEV_BEGIN = Mwt._WSEV_BEGIN C_void
let _WSEV_END = Mwt._WSEV_END C_void
let _WSEV_INCREMENT = Mwt._WSEV_INCREMENT C_void
let _WSEV_DECREMENT = Mwt._WSEV_DECREMENT C_void
let _WSEV_PAGE_INCREMENT = Mwt._WSEV_PAGE_INCREMENT C_void
let _WSEV_PAGE_DECREMENT = Mwt._WSEV_PAGE_DECREMENT C_void
let _WSEV_SCR_MOUSE_PRESS = Mwt._WSEV_SCR_MOUSE_PRESS C_void
let _WSEV_SCR_MOUSE_RELEASE = Mwt._WSEV_SCR_MOUSE_RELEASE C_void
let _WSEV_SCR_MOUSE_MOVE = Mwt._WSEV_SCR_MOUSE_MOVE C_void
let _WSEV_EDIT_MODE_CH = Mwt._WSEV_EDIT_MODE_CH C_void
let _WSEV_SPECIAL_FOCUS_CH = Mwt._WSEV_SPECIAL_FOCUS_CH C_void
let _WSEV_CHILD_ADDED = Mwt._WSEV_CHILD_ADDED C_void
let _WSEV_SELECTION_CH = Mwt._WSEV_SELECTION_CH C_void
let _WS_IMAGE_DEFAULT = Mwt._WS_IMAGE_DEFAULT C_void
let _WS_IMAGE_XPM = Mwt._WS_IMAGE_XPM C_void
let _WS_IMAGE_BMP = Mwt._WS_IMAGE_BMP C_void
let _WS_IMAGE_PNG = Mwt._WS_IMAGE_PNG C_void
let _WS_IMAGE_JPG = Mwt._WS_IMAGE_JPG C_void
let _WSK_BackSpace = Mwt._WSK_BackSpace C_void
let _WSK_Tab = Mwt._WSK_Tab C_void
let _WSK_Linefeed = Mwt._WSK_Linefeed C_void
let _WSK_Clear = Mwt._WSK_Clear C_void
let _WSK_Return = Mwt._WSK_Return C_void
let _WSK_Pause = Mwt._WSK_Pause C_void
let _WSK_Scroll_Lock = Mwt._WSK_Scroll_Lock C_void
let _WSK_Sys_Req = Mwt._WSK_Sys_Req C_void
let _WSK_Escape = Mwt._WSK_Escape C_void
let _WSK_Delete = Mwt._WSK_Delete C_void
let _WSK_Kanji = Mwt._WSK_Kanji C_void
let _WSK_Muhenkan = Mwt._WSK_Muhenkan C_void
let _WSK_Henkan_Mode = Mwt._WSK_Henkan_Mode C_void
let _WSK_Henkan = Mwt._WSK_Henkan C_void
let _WSK_Romaji = Mwt._WSK_Romaji C_void
let _WSK_Hiragana = Mwt._WSK_Hiragana C_void
let _WSK_Katakana = Mwt._WSK_Katakana C_void
let _WSK_Hiragana_Katakana = Mwt._WSK_Hiragana_Katakana C_void
let _WSK_Zenkaku = Mwt._WSK_Zenkaku C_void
let _WSK_Hankaku = Mwt._WSK_Hankaku C_void
let _WSK_Zenkaku_Hankaku = Mwt._WSK_Zenkaku_Hankaku C_void
let _WSK_Touroku = Mwt._WSK_Touroku C_void
let _WSK_Massyo = Mwt._WSK_Massyo C_void
let _WSK_Kana_Lock = Mwt._WSK_Kana_Lock C_void
let _WSK_Kana_Shift = Mwt._WSK_Kana_Shift C_void
let _WSK_Eisu_Shift = Mwt._WSK_Eisu_Shift C_void
let _WSK_Eisu_toggle = Mwt._WSK_Eisu_toggle C_void
let _WSK_Home = Mwt._WSK_Home C_void
let _WSK_Left = Mwt._WSK_Left C_void
let _WSK_Up = Mwt._WSK_Up C_void
let _WSK_Right = Mwt._WSK_Right C_void
let _WSK_Down = Mwt._WSK_Down C_void
let _WSK_Prior = Mwt._WSK_Prior C_void
let _WSK_Page_Up = Mwt._WSK_Page_Up C_void
let _WSK_Page_Down = Mwt._WSK_Page_Down C_void
let _WSK_End = Mwt._WSK_End C_void
let _WSK_Begin = Mwt._WSK_Begin C_void
let _WSK_Select = Mwt._WSK_Select C_void
let _WSK_Print = Mwt._WSK_Print C_void
let _WSK_Execute = Mwt._WSK_Execute C_void
let _WSK_Insert = Mwt._WSK_Insert C_void
let _WSK_Undo = Mwt._WSK_Undo C_void
let _WSK_Redo = Mwt._WSK_Redo C_void
let _WSK_Menu = Mwt._WSK_Menu C_void
let _WSK_Find = Mwt._WSK_Find C_void
let _WSK_Cancel = Mwt._WSK_Cancel C_void
let _WSK_Help = Mwt._WSK_Help C_void
let _WSK_Break = Mwt._WSK_Break C_void
let _WSK_Mode_switch = Mwt._WSK_Mode_switch C_void
let _WSK_script_switch = Mwt._WSK_script_switch C_void
let _WSK_Num_Lock = Mwt._WSK_Num_Lock C_void
let _WSK_KP_Space = Mwt._WSK_KP_Space C_void
let _WSK_KP_Tab = Mwt._WSK_KP_Tab C_void
let _WSK_KP_Enter = Mwt._WSK_KP_Enter C_void
let _WSK_KP_F1 = Mwt._WSK_KP_F1 C_void
let _WSK_KP_F2 = Mwt._WSK_KP_F2 C_void
let _WSK_KP_F3 = Mwt._WSK_KP_F3 C_void
let _WSK_KP_F4 = Mwt._WSK_KP_F4 C_void
let _WSK_KP_Home = Mwt._WSK_KP_Home C_void
let _WSK_KP_Left = Mwt._WSK_KP_Left C_void
let _WSK_KP_Up = Mwt._WSK_KP_Up C_void
let _WSK_KP_Right = Mwt._WSK_KP_Right C_void
let _WSK_KP_Down = Mwt._WSK_KP_Down C_void
let _WSK_KP_Prior = Mwt._WSK_KP_Prior C_void
let _WSK_KP_Page_Up = Mwt._WSK_KP_Page_Up C_void
let _WSK_KP_Next = Mwt._WSK_KP_Next C_void
let _WSK_KP_Page_Down = Mwt._WSK_KP_Page_Down C_void
let _WSK_KP_End = Mwt._WSK_KP_End C_void
let _WSK_KP_Begin = Mwt._WSK_KP_Begin C_void
let _WSK_KP_Insert = Mwt._WSK_KP_Insert C_void
let _WSK_KP_Delete = Mwt._WSK_KP_Delete C_void
let _WSK_KP_Equal = Mwt._WSK_KP_Equal C_void
let _WSK_KP_Multiply = Mwt._WSK_KP_Multiply C_void
let _WSK_KP_Add = Mwt._WSK_KP_Add C_void
let _WSK_KP_Separator = Mwt._WSK_KP_Separator C_void
let _WSK_KP_Subtract = Mwt._WSK_KP_Subtract C_void
let _WSK_KP_Decimal = Mwt._WSK_KP_Decimal C_void
let _WSK_KP_Divide = Mwt._WSK_KP_Divide C_void
let _WSK_KP_0 = Mwt._WSK_KP_0 C_void
let _WSK_KP_1 = Mwt._WSK_KP_1 C_void
let _WSK_KP_2 = Mwt._WSK_KP_2 C_void
let _WSK_KP_3 = Mwt._WSK_KP_3 C_void
let _WSK_KP_4 = Mwt._WSK_KP_4 C_void
let _WSK_KP_5 = Mwt._WSK_KP_5 C_void
let _WSK_KP_6 = Mwt._WSK_KP_6 C_void
let _WSK_KP_7 = Mwt._WSK_KP_7 C_void
let _WSK_KP_8 = Mwt._WSK_KP_8 C_void
let _WSK_KP_9 = Mwt._WSK_KP_9 C_void
let _WSK_F1 = Mwt._WSK_F1 C_void
let _WSK_F2 = Mwt._WSK_F2 C_void
let _WSK_F3 = Mwt._WSK_F3 C_void
let _WSK_F4 = Mwt._WSK_F4 C_void
let _WSK_F5 = Mwt._WSK_F5 C_void
let _WSK_F6 = Mwt._WSK_F6 C_void
let _WSK_F7 = Mwt._WSK_F7 C_void
let _WSK_F8 = Mwt._WSK_F8 C_void
let _WSK_F9 = Mwt._WSK_F9 C_void
let _WSK_F10 = Mwt._WSK_F10 C_void
let _WSK_F11 = Mwt._WSK_F11 C_void
let _WSK_L1 = Mwt._WSK_L1 C_void
let _WSK_F12 = Mwt._WSK_F12 C_void
let _WSK_L2 = Mwt._WSK_L2 C_void
let _WSK_F13 = Mwt._WSK_F13 C_void
let _WSK_L3 = Mwt._WSK_L3 C_void
let _WSK_F14 = Mwt._WSK_F14 C_void
let _WSK_L4 = Mwt._WSK_L4 C_void
let _WSK_F15 = Mwt._WSK_F15 C_void
let _WSK_L5 = Mwt._WSK_L5 C_void
let _WSK_F16 = Mwt._WSK_F16 C_void
let _WSK_L6 = Mwt._WSK_L6 C_void
let _WSK_F17 = Mwt._WSK_F17 C_void
let _WSK_L7 = Mwt._WSK_L7 C_void
let _WSK_F18 = Mwt._WSK_F18 C_void
let _WSK_L8 = Mwt._WSK_L8 C_void
let _WSK_F19 = Mwt._WSK_F19 C_void
let _WSK_L9 = Mwt._WSK_L9 C_void
let _WSK_F20 = Mwt._WSK_F20 C_void
let _WSK_L10 = Mwt._WSK_L10 C_void
let _WSK_F21 = Mwt._WSK_F21 C_void
let _WSK_R1 = Mwt._WSK_R1 C_void
let _WSK_F22 = Mwt._WSK_F22 C_void
let _WSK_R2 = Mwt._WSK_R2 C_void
let _WSK_F23 = Mwt._WSK_F23 C_void
let _WSK_R3 = Mwt._WSK_R3 C_void
let _WSK_F24 = Mwt._WSK_F24 C_void
let _WSK_R4 = Mwt._WSK_R4 C_void
let _WSK_F25 = Mwt._WSK_F25 C_void
let _WSK_R5 = Mwt._WSK_R5 C_void
let _WSK_F26 = Mwt._WSK_F26 C_void
let _WSK_R6 = Mwt._WSK_R6 C_void
let _WSK_F27 = Mwt._WSK_F27 C_void
let _WSK_R7 = Mwt._WSK_R7 C_void
let _WSK_F28 = Mwt._WSK_F28 C_void
let _WSK_R8 = Mwt._WSK_R8 C_void
let _WSK_F29 = Mwt._WSK_F29 C_void
let _WSK_R9 = Mwt._WSK_R9 C_void
let _WSK_F30 = Mwt._WSK_F30 C_void
let _WSK_R10 = Mwt._WSK_R10 C_void
let _WSK_F31 = Mwt._WSK_F31 C_void
let _WSK_R11 = Mwt._WSK_R11 C_void
let _WSK_F32 = Mwt._WSK_F32 C_void
let _WSK_R12 = Mwt._WSK_R12 C_void
let _WSK_F33 = Mwt._WSK_F33 C_void
let _WSK_R13 = Mwt._WSK_R13 C_void
let _WSK_F34 = Mwt._WSK_F34 C_void
let _WSK_R14 = Mwt._WSK_R14 C_void
let _WSK_F35 = Mwt._WSK_F35 C_void
let _WSK_R15 = Mwt._WSK_R15 C_void
let _WSK_Shift_L = Mwt._WSK_Shift_L C_void
let _WSK_Shift_R = Mwt._WSK_Shift_R C_void
let _WSK_Control_L = Mwt._WSK_Control_L C_void
let _WSK_Control_R = Mwt._WSK_Control_R C_void
let _WSK_Caps_Lock = Mwt._WSK_Caps_Lock C_void
let _WSK_Shift_Lock = Mwt._WSK_Shift_Lock C_void
let _WSK_Meta_L = Mwt._WSK_Meta_L C_void
let _WSK_Meta_R = Mwt._WSK_Meta_R C_void
let _WSK_Alt_L = Mwt._WSK_Alt_L C_void
let _WSK_Alt_R = Mwt._WSK_Alt_R C_void
let _WSK_Super_L = Mwt._WSK_Super_L C_void
let _WSK_Super_R = Mwt._WSK_Super_R C_void
let _WSK_Hyper_L = Mwt._WSK_Hyper_L C_void
let _WSK_Hyper_R = Mwt._WSK_Hyper_R C_void
let _WSK_space = Mwt._WSK_space C_void
let _WSK_exclam = Mwt._WSK_exclam C_void
let _WSK_quotedbl = Mwt._WSK_quotedbl C_void
let _WSK_numbersign = Mwt._WSK_numbersign C_void
let _WSK_dollar = Mwt._WSK_dollar C_void
let _WSK_percent = Mwt._WSK_percent C_void
let _WSK_ampersand = Mwt._WSK_ampersand C_void
let _WSK_apostrophe = Mwt._WSK_apostrophe C_void
let _WSK_quoteright = Mwt._WSK_quoteright C_void
let _WSK_parenleft = Mwt._WSK_parenleft C_void
let _WSK_parenright = Mwt._WSK_parenright C_void
let _WSK_asterisk = Mwt._WSK_asterisk C_void
let _WSK_plus = Mwt._WSK_plus C_void
let _WSK_comma = Mwt._WSK_comma C_void
let _WSK_minus = Mwt._WSK_minus C_void
let _WSK_period = Mwt._WSK_period C_void
let _WSK_slash = Mwt._WSK_slash C_void
let _WSK_0 = Mwt._WSK_0 C_void
let _WSK_1 = Mwt._WSK_1 C_void
let _WSK_2 = Mwt._WSK_2 C_void
let _WSK_3 = Mwt._WSK_3 C_void
let _WSK_4 = Mwt._WSK_4 C_void
let _WSK_5 = Mwt._WSK_5 C_void
let _WSK_6 = Mwt._WSK_6 C_void
let _WSK_7 = Mwt._WSK_7 C_void
let _WSK_8 = Mwt._WSK_8 C_void
let _WSK_9 = Mwt._WSK_9 C_void
let _WSK_colon = Mwt._WSK_colon C_void
let _WSK_semicolon = Mwt._WSK_semicolon C_void
let _WSK_less = Mwt._WSK_less C_void
let _WSK_equal = Mwt._WSK_equal C_void
let _WSK_greater = Mwt._WSK_greater C_void
let _WSK_question = Mwt._WSK_question C_void
let _WSK_at = Mwt._WSK_at C_void
let _WSK_A = Mwt._WSK_A C_void
let _WSK_B = Mwt._WSK_B C_void
let _WSK_C = Mwt._WSK_C C_void
let _WSK_D = Mwt._WSK_D C_void
let _WSK_E = Mwt._WSK_E C_void
let _WSK_F = Mwt._WSK_F C_void
let _WSK_G = Mwt._WSK_G C_void
let _WSK_H = Mwt._WSK_H C_void
let _WSK_I = Mwt._WSK_I C_void
let _WSK_J = Mwt._WSK_J C_void
let _WSK_K = Mwt._WSK_K C_void
let _WSK_L = Mwt._WSK_L C_void
let _WSK_M = Mwt._WSK_M C_void
let _WSK_N = Mwt._WSK_N C_void
let _WSK_O = Mwt._WSK_O C_void
let _WSK_P = Mwt._WSK_P C_void
let _WSK_Q = Mwt._WSK_Q C_void
let _WSK_R = Mwt._WSK_R C_void
let _WSK_S = Mwt._WSK_S C_void
let _WSK_T = Mwt._WSK_T C_void
let _WSK_U = Mwt._WSK_U C_void
let _WSK_V = Mwt._WSK_V C_void
let _WSK_W = Mwt._WSK_W C_void
let _WSK_X = Mwt._WSK_X C_void
let _WSK_Y = Mwt._WSK_Y C_void
let _WSK_Z = Mwt._WSK_Z C_void
let _WSK_bracketleft = Mwt._WSK_bracketleft C_void
let _WSK_backslash = Mwt._WSK_backslash C_void
let _WSK_bracketright = Mwt._WSK_bracketright C_void
let _WSK_asciicircum = Mwt._WSK_asciicircum C_void
let _WSK_underscore = Mwt._WSK_underscore C_void
let _WSK_grave = Mwt._WSK_grave C_void
let _WSK_quoteleft = Mwt._WSK_quoteleft C_void
let _WSK_a = Mwt._WSK_a C_void
let _WSK_b = Mwt._WSK_b C_void
let _WSK_c = Mwt._WSK_c C_void
let _WSK_d = Mwt._WSK_d C_void
let _WSK_e = Mwt._WSK_e C_void
let _WSK_f = Mwt._WSK_f C_void
let _WSK_g = Mwt._WSK_g C_void
let _WSK_h = Mwt._WSK_h C_void
let _WSK_i = Mwt._WSK_i C_void
let _WSK_j = Mwt._WSK_j C_void
let _WSK_k = Mwt._WSK_k C_void
let _WSK_l = Mwt._WSK_l C_void
let _WSK_m = Mwt._WSK_m C_void
let _WSK_n = Mwt._WSK_n C_void
let _WSK_o = Mwt._WSK_o C_void
let _WSK_p = Mwt._WSK_p C_void
let _WSK_q = Mwt._WSK_q C_void
let _WSK_r = Mwt._WSK_r C_void
let _WSK_s = Mwt._WSK_s C_void
let _WSK_t = Mwt._WSK_t C_void
let _WSK_u = Mwt._WSK_u C_void
let _WSK_v = Mwt._WSK_v C_void
let _WSK_w = Mwt._WSK_w C_void
let _WSK_x = Mwt._WSK_x C_void
let _WSK_y = Mwt._WSK_y C_void
let _WSK_z = Mwt._WSK_z C_void
let _WSK_braceleft = Mwt._WSK_braceleft C_void
let _WSK_bar = Mwt._WSK_bar C_void
let _WSK_braceright = Mwt._WSK_braceright C_void
let _WSK_asciitilde = Mwt._WSK_asciitilde C_void
let _WS_LIST_TREE_OPEN = Mwt._WS_LIST_TREE_OPEN C_void
let _WS_LIST_TREE_OPEN_CH = Mwt._WS_LIST_TREE_OPEN_CH C_void
let _WS_LIST_INDENT_LEVEL = Mwt._WS_LIST_INDENT_LEVEL C_void
let _WS_LIST_INDENT_STATUS = Mwt._WS_LIST_INDENT_STATUS C_void
let _WS_LIST_LABEL_LIST = Mwt._WS_LIST_LABEL_LIST C_void
let _WS_LIST_TOP = Mwt._WS_LIST_TOP C_void
let _WS_ROOT_INSTANCE_ID = Mwt._WS_ROOT_INSTANCE_ID C_void
let _WS_ROOT_PROPERTY_ID = Mwt._WS_ROOT_PROPERTY_ID C_void
let _WS_ROOT_PROCEDURE_ID = Mwt._WS_ROOT_PROCEDURE_ID C_void
let _WS_NEXT_CHILD_INSTANCE_ID = Mwt._WS_NEXT_CHILD_INSTANCE_ID C_void
let _WS_PARENT_INSTANCE_ID = Mwt._WS_PARENT_INSTANCE_ID C_void
let _WS_SET_ROOT_INSTANCE = Mwt._WS_SET_ROOT_INSTANCE C_void
let _WS_REMOVE_ROOT_INSTANCE = Mwt._WS_REMOVE_ROOT_INSTANCE C_void
let _WS_SET_SELECTED_INSTANCE = Mwt._WS_SET_SELECTED_INSTANCE C_void
let _WS_REMOVE_SELECTED_INSTANCE = Mwt._WS_REMOVE_SELECTED_INSTANCE C_void
let _WS_NEXT_SELECTED_INSTANCE_ID = Mwt._WS_NEXT_SELECTED_INSTANCE_ID C_void
let _WS_INSTANCE_NAME = Mwt._WS_INSTANCE_NAME C_void
let _WS_PROPERTY_NAME = Mwt._WS_PROPERTY_NAME C_void
let _WS_PROPERTY_VALUE = Mwt._WS_PROPERTY_VALUE C_void
let _WS_PROPERTY_TYPE = Mwt._WS_PROPERTY_TYPE C_void
let _WS_PROPERTY_ATTRIBUTE = Mwt._WS_PROPERTY_ATTRIBUTE C_void
let _WS_PROCEDURE_FUNCTION_NAME = Mwt._WS_PROCEDURE_FUNCTION_NAME C_void
let _WS_PROCEDURE_NAME = Mwt._WS_PROCEDURE_NAME C_void
let _WS_OBJECT_NAME = Mwt._WS_OBJECT_NAME C_void
let _WS_OBJECT_ARRAY_NAME = Mwt._WS_OBJECT_ARRAY_NAME C_void
let _WS_OBJECT_ARRAY_NAME_INVALID = Mwt._WS_OBJECT_ARRAY_NAME_INVALID C_void
let _WS_OTHER_NAME = Mwt._WS_OTHER_NAME C_void
let _WS_PROPERTY_SELECT_VALUE_NAME = Mwt._WS_PROPERTY_SELECT_VALUE_NAME C_void
let _WS_PROPERTY_SELECT_VALUE = Mwt._WS_PROPERTY_SELECT_VALUE C_void
let _WS_PROPERTY_TITLE = Mwt._WS_PROPERTY_TITLE C_void
let _WS_PROPERTY_TYPE_COLOR = Mwt._WS_PROPERTY_TYPE_COLOR C_void
let _WS_PROPERTY_TYPE_PIXMAP = Mwt._WS_PROPERTY_TYPE_PIXMAP C_void
let _WS_PROPERTY_TYPE_FILE_SELECT = Mwt._WS_PROPERTY_TYPE_FILE_SELECT C_void
let _WS_NEXT_PROPERTY_ID = Mwt._WS_NEXT_PROPERTY_ID C_void
let _WS_NEXT_PROCEDURE_ID = Mwt._WS_NEXT_PROCEDURE_ID C_void
let _WS_NEXT_PROPERTY_SELECT_ITEM_ID = Mwt._WS_NEXT_PROPERTY_SELECT_ITEM_ID C_void
let _WS_NEXT_TARGET_ID = Mwt._WS_NEXT_TARGET_ID C_void
let _WS_TARGET_NATIVE = Mwt._WS_TARGET_NATIVE C_void
let _WS_TARGET_NAME = Mwt._WS_TARGET_NAME C_void
let _WS_TARGET_SUFFIX = Mwt._WS_TARGET_SUFFIX C_void
let _WS_ITEM_ROOT = Mwt._WS_ITEM_ROOT C_void
let _WS_NEXT_LANG_ID = Mwt._WS_NEXT_LANG_ID C_void
let _WS_LANG_STR = Mwt._WS_LANG_STR C_void
let _WS_NEXT_ENCODING_ID = Mwt._WS_NEXT_ENCODING_ID C_void
let _WS_ENCODING_NAME = Mwt._WS_ENCODING_NAME C_void
let _WS_DEFAULT_PROJECT_FILE_NAME = Mwt._WS_DEFAULT_PROJECT_FILE_NAME C_void
let _WS_LINK_OPT_DEF_FILE_NAME = Mwt._WS_LINK_OPT_DEF_FILE_NAME C_void
let _WS_LINK_OPTIONS = Mwt._WS_LINK_OPTIONS C_void
let _WS_STLINK_OPTIONS = Mwt._WS_STLINK_OPTIONS C_void
let _WS_NEXT_LINK_OPT_ID = Mwt._WS_NEXT_LINK_OPT_ID C_void
let _WS_LINK_OPT_NAME = Mwt._WS_LINK_OPT_NAME C_void
let _WS_TARGET_INSTANCE_ID = Mwt._WS_TARGET_INSTANCE_ID C_void
let _WS_LINK_LIB_DEF_FILE_NAME = Mwt._WS_LINK_LIB_DEF_FILE_NAME C_void
let _WS_LINK_LIB_NAME = Mwt._WS_LINK_LIB_NAME C_void
let _WS_LINK_CLASS_DEF_FILE_NAME = Mwt._WS_LINK_CLASS_DEF_FILE_NAME C_void
let _WS_TARGET_DEF_FILE_NAME = Mwt._WS_TARGET_DEF_FILE_NAME C_void
let _WS_ENV_DEF_FILE_NAME = Mwt._WS_ENV_DEF_FILE_NAME C_void
let _WS_LIBNAME_DEF_FILE_NAME = Mwt._WS_LIBNAME_DEF_FILE_NAME C_void
let _WS_TARGET_ENV_DEF_FILE_NAME = Mwt._WS_TARGET_ENV_DEF_FILE_NAME C_void
let _WS_TARGET_ENV_TITLE = Mwt._WS_TARGET_ENV_TITLE C_void
let _WS_TARGET_ENV_NAME = Mwt._WS_TARGET_ENV_NAME C_void

let _WSGFloadProject arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFloadProject arg

let _WSGFloadProject arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFloadProject arg

let _WSGFreloadProject arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFreloadProject arg

let _WSGFreloadProject arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFreloadProject arg

let _WSGFdestroyProject arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFdestroyProject arg

let _WSGFdumpProject arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFdumpProject arg

let _WSGFsaveProject arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsaveProject arg

let _WSGFsetProjectData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsetProjectData arg

let _WSGFgetProjectData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetProjectData arg

let _WSGFgetProjectDefaultData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetProjectDefaultData arg

let _WSGFgetProjectEnvironmentData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetProjectEnvironmentData arg

let _WSGFsetProjectEnvironmentData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsetProjectEnvironmentData arg

let _WSGFsaveProjectEnvironment arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsaveProjectEnvironment arg

let _WSGFloadLinkOptions arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFloadLinkOptions arg

let _WSGFloadWinFiles arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFloadWinFiles arg

let _WSGFloadProjectAndWinFiles arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFloadProjectAndWinFiles arg

let _WSGFsaveWinFile arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsaveWinFile arg

let _WSGFloadTargets arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFloadTargets arg

let _WSGFgetMgrData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetMgrData arg

let _WSGFgetMgrStrData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetMgrStrData arg

let _WSGFgetMgrStrStrData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetMgrStrStrData arg

let _WSGFsetMgrStrData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsetMgrStrData arg

let _WSGFidToProcedure arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFidToProcedure arg

let _WSGFprocedureToId arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFprocedureToId arg

let _WSGFcreateProjectSrcFile arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFcreateProjectSrcFile arg

let _WSGFcreateMakefiles arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFcreateMakefiles arg

let _WSGFcreateWindowSrcFiles arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFcreateWindowSrcFiles arg

let _WSGFsetDefaultVePopupMenus arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsetDefaultVePopupMenus arg

let _WSGFsetDefaultVePropertyEditProcedures arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsetDefaultVePropertyEditProcedures arg

let _WSGFcheckNameString arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFcheckNameString arg

let _WSGFisArrayName arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFisArrayName arg

let _WSGFgetArrayNo arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetArrayNo arg

let _WSGFgetArrayName arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetArrayName arg

let _WSGFexistName arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFexistName arg

let _WSGFcheckExistFile arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFcheckExistFile arg

let _WSGFsetupInstance arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsetupInstance arg

let _WSGFloadLibrary arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFloadLibrary arg

let _WSGFsetFontData arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFsetFontData arg

let _WSGFgetEncodingValue arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFgetEncodingValue arg
let _WS_LANG_CPP = Mwt._WS_LANG_CPP C_void
let _WS_LANG_RUBY = Mwt._WS_LANG_RUBY C_void
let _WS_LANG_PYTHON = Mwt._WS_LANG_PYTHON C_void
let _WS_LANG_PERL = Mwt._WS_LANG_PERL C_void
let _WS_LANG_JAVA = Mwt._WS_LANG_JAVA C_void
let _WS_LANG_OCAML = Mwt._WS_LANG_OCAML C_void

let _WSGFcreateProcedure arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFcreateProcedure arg

let _WSGFpasteInstance arg =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt._WSGFpasteInstance arg
let _WS_ERR_NOT_MANAGER = Mwt._WS_ERR_NOT_MANAGER C_void
let _WS_ERR_OVERWRAPED = Mwt._WS_ERR_OVERWRAPED C_void

let new_WSCpoint clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCpoint clst

let new_WSCrect clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCrect clst

let new_WSCstring clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCstring clst

let new_WSCstring clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCstring clst

let new_WSCstring clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCstring clst

let new_WSCvariant clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvariant clst

let new_WSCvariant clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvariant clst

let new_WSCvariant clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvariant clst

let new_WSCvariant clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvariant clst

let new_WSCvariant clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvariant clst

let new_WSCprocedure clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCprocedure clst

let new_WSCbase clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCbase clst

let new_WSCform clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCform clst

let new_WSCnwbase clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCnwbase clst

let new_WSCngbase clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCngbase clst

let new_WSCvlabel clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvlabel clst

let new_WSCvbtn clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvbtn clst

let new_WSCvfbtn clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvfbtn clst

let new_WSCvendbtn clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvendbtn clst

let new_WSCvklabel clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvklabel clst

let new_WSCvkflabel clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvkflabel clst

let new_WSCvifield clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvifield clst

let new_WSCvkslabel clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvkslabel clst

let new_WSCvmifield clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvmifield clst

let new_WSCvpifield clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvpifield clst

let new_WSCtextField clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCtextField clst

let new_WSCvarrow clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvarrow clst

let new_WSCvscrBar clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvscrBar clst

let new_WSCvpolyAttr clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvpolyAttr clst

let new_WSCvmeter clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvmeter clst

let new_WSCvclock clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvclock clst

let new_WSCvslider clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvslider clst

let new_WSCpulldownMenu clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCpulldownMenu clst

let new_WSCcomboBox clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCcomboBox clst

let new_WSCoption clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCoption clst

let new_WSCgrid clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCgrid clst

let new_WSCvimage clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvimage clst

let new_WSCvrect clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvrect clst

let new_WSCvarc clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvarc clst

let new_WSCvpoly clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvpoly clst

let new_WSCvline clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvline clst

let new_WSDimage clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSDimage clst

let new_WSCvdrawingArea clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvdrawingArea clst

let new_WSCvbarGraph clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvbarGraph clst

let new_WSCvlineGraph clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvlineGraph clst

let new_WSCvgraphScale clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvgraphScale clst

let new_WSCvgraphMatrix clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvgraphMatrix clst

let new_WSCvtimer clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvtimer clst

let new_WSCvspace clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvspace clst

let new_WSCvballoonHelp clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvballoonHelp clst

let new_WSCvcsocket clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvcsocket clst

let new_WSCvssocket clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvssocket clst

let new_WSCvudpsocket clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvudpsocket clst

let new_WSCvremoteClient clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvremoteClient clst

let new_WSCvremoteServer clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvremoteServer clst

let new_WSCvdb clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvdb clst

let new_WSCdbRecord clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCdbRecord clst

let new_WSCwindow clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCwindow clst

let new_WSCmainWindow clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCmainWindow clst

let new_WSCbaseDialog clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCbaseDialog clst

let new_WSCdialog clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCdialog clst

let new_WSCmessageDialog clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCmessageDialog clst

let new_WSCinputDialog clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCinputDialog clst

let new_WSCwizardDialog clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCwizardDialog clst

let new_WSCfileSelect clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCfileSelect clst

let new_WSCworkingDialog clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCworkingDialog clst

let new_WSCindexForm clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCindexForm clst

let new_WSCsform clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCsform clst

let new_WSCvtoggle clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvtoggle clst

let new_WSCvradio clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvradio clst

let new_WSCradioGroup clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCradioGroup clst

let new_WSCcheckGroup clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCcheckGroup clst

let new_WSCvertForm clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCvertForm clst

let new_WSChorzForm clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSChorzForm clst

let new_WSCmenuArea clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCmenuArea clst

let new_WSCtform clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCtform clst

let new_WSCfform clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCfform clst

let new_WSCprform clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCprform clst

let new_WSCj3wform clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCj3wform clst

let new_WSCscrForm clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCscrForm clst

let new_WSClist clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSClist clst

let new_WSCverbList clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCverbList clst

let new_WSCtreeList clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCtreeList clst

let new_WSCdirTree clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCdirTree clst

let new_WSDcolor clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSDcolor clst

let new_WSCcolorSet clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCcolorSet clst

let new_WSCimageSet clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCimageSet clst

let new_WSDfont clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSDfont clst

let new_WSCfontSet clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCfontSet clst

let new_WSCbaseList clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCbaseList clst

let new_WSCsheet clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCsheet clst

let new_WSCindexData clst =
   match !mwt_inited with
   | false -> C_void
   | true  -> Mwt.new_WSCindexData clst

let invoke obj =
   match !mwt_inited with
   | true -> Swig.invoke obj
   | false -> (fun mth arg -> C_void)

let get_int x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_int (o "getInt" C_void)
         with _ -> Swig.get_int x
      end
   | _ -> Swig.get_int x

let get_float x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_float (o "getDouble" C_void)
         with _ ->
         try
            Swig.get_float (o "getFloat" C_void)
         with _ -> Swig.get_float x
      end
   | _ -> Swig.get_float x

let get_char x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_char (o "getChar" C_void)
         with _ -> Swig.get_char x
      end
   | _ -> Swig.get_char x

let get_string x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_string (o "getCharPtr" C_void)
         with _ ->
         try
            Swig.get_string (o "getString" C_void)
         with _ -> Swig.get_string x
      end
   | _ -> Swig.get_string x

let get_bool x =
   match x with
   | C_obj o ->
      begin
         try
            Swig.get_bool (o "getUnsignedChar" C_void)
         with _ -> Swig.get_bool x
      end
   | _ -> Swig.get_bool x
