//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCRscrForm.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCscrForm.h>

WSMFclassInit(WSCRscrForm,WSCRform);
WSMFremoteClassInit(WSCRscrForm,WSCscrForm);

WSCRscrForm::WSCRscrForm(){
}

WSCRscrForm::~WSCRscrForm(){
}

long WSCRscrForm::getVisibleWidth(){
  if (_local != NULL){
    WSCscrForm* target = (WSCscrForm*)_local->cast("WSCscrForm");
    if (target != NULL){
      return target->getVisibleWidth();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCscrForm");
  rc.setOperationName("getVisibleWidth");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  }
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

long WSCRscrForm::getVisibleHeight(){
  if (_local != NULL){
    WSCscrForm* target = (WSCscrForm*)_local->cast("WSCscrForm");
    if (target != NULL){
      return target->getVisibleHeight();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCscrForm");
  rc.setOperationName("getVisibleHeight");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  }
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
void WSCRscrForm::onActivate(){
  if (_local != NULL){
    WSCscrForm* target = (WSCscrForm*)_local->cast("WSCscrForm");
    if (target != NULL){
      target->onActivate();
      return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCscrForm");
  rc.setOperationName("onActivate");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  endRemoteCall();
}
void WSCRscrForm::onValueChange(){
  if (_local != NULL){
    WSCscrForm* target = (WSCscrForm*)_local->cast("WSCscrForm");
    if (target != NULL){
      target->onValueChange();
      return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCscrForm");
  rc.setOperationName("onValueChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  endRemoteCall();
}


void _WSCscrForm_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getVisibleWidth")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCscrForm* target = (WSCscrForm*)inst->cast("WSCscrForm");
        long ret = 0;
        if (target != NULL){
          ret = target->getVisibleWidth();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getVisibleHeight")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCscrForm* target = (WSCscrForm*)inst->cast("WSCscrForm");
        long ret = 0;
        if (target != NULL){
          ret = target->getVisibleHeight();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }
  }else
  if ( rc->_op[0] == 'o'){
    if (!strcmp(rc->_op,"onActivate")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCscrForm* target = (WSCscrForm*)inst->cast("WSCscrForm");
        if (target != NULL){
          target->onActivate();
        }
      }
      return;
    }else
    if (!strcmp(rc->_op,"onValueChange")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCscrForm* target = (WSCscrForm*)inst->cast("WSCscrForm");
        if (target != NULL){
          target->onValueChange();
        }
      }
      return;
    }
  }

extern void _WSCform_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCform_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSCscrForm,_WSCscrForm_remote_call);

