//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCRvlabel.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCvlabel.h>

WSMFclassInit(WSCRvlabel,WSCRnwbase);
WSMFremoteClassInit(WSCRvlabel,WSCvlabel);

WSCRvlabel::WSCRvlabel(){
}

WSCRvlabel::~WSCRvlabel(){
}

char WSCRvlabel::getAlignment(){
  if (_local != NULL){
    WSCvlabel* item = (WSCvlabel*)_local->cast("WSCvlabel");
    if (item != NULL){
      return item->getAlignment();
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCvlabel");
  rc.setOperationName("getAlignment");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  char ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

void _WSCvlabel_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getAlignment")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCvlabel* item = (WSCvlabel*)inst->cast("WSCvlabel");
        WSCbool ret = 0;
        if (item != NULL){
          ret = item->getAlignment();
        }
        db->save(WS_DcRChar,"ret",(void*)&ret);
        return;
      }else{
        WSCbool ret = 0;
        db->save(WS_DcRChar,"ret",(void*)&ret);
        return;
      }
    }
  }
extern void _WSCnwbase_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCnwbase_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSCvlabel,_WSCvlabel_remote_call);

