//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCvremoteServer.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSCconductor.h>
#include <WSCRbaseList.h>
#include <WSCmessageDialog.h>

WSMFguiClassInitialize(WSCvremoteServer, WSCngbase);
WSMFversion(WSCvremoteServer, WSCngbase);

WSCvremoteServer::WSCvremoteServer(WSCbase* base, char* objname):
			WSCngbase(base, objname){
  _title_string.setString("RemoteServer");
  _addr = WSGFstrdup("");
  _port = WS_DEFAULT_SERVER_PORT;
  _running = False;
  _running_bk = False;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvremoteServer);

    WSMFpropertyCreate(WSNip,  char*,   _addr,WSSip);
    WSMFpropertyCreate(WSNport,  WSCushort, _port,WSSport);
    WSMFpropertyCreate(WSNrunning,  WSCbool, _running,WSSrunning);
      WSMFpropertySetSelection(WSRbool3, WSRbool3D);
 
    WSMFpropertyVisibleOff(WSNexport);


  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvremoteServer, WSNip, char*, _addr ,WSGFstrdup(""));
WSMFproperty( WSCvremoteServer, WSNport, WSCushort, _port ,WS_DEFAULT_SERVER_PORT);
WSMFproperty( WSCvremoteServer, WSNrunning, WSCbool, _running ,False);

void WSCvremoteServer::setWorkWSNip(char*){ };
void WSCvremoteServer::getWorkWSNip(char**){ };
void WSCvremoteServer::setWorkWSNport(WSCushort){ };
void WSCvremoteServer::getWorkWSNport(WSCushort*){ };

WSCvremoteServer* WSCvremoteServer::_master_instance = NULL;

void WSCvremoteServer::setWorkWSNrunning(WSCbool){
#ifndef WS_EMBED
  if (getPropertyEditMode() != False){
    return;
  }
#endif
  if (_running != False){
    if (_running_bk == False){
      if (strcmp("",_addr)){
        WSGIconductor()->setAddr(_addr);
      }
      if (_port == 0){
        WSCRbaseList* orb = new WSCRbaseList();
        orb->setPort(WS_DEFAULT_AGENT_PORT);
        orb->setAddr(_addr);
        _port = orb->getBindPort();
//printf("_port = %d\n",_port);
        if (_port == 0){
          WSGIappMessageDialog()->setProperty(WSNlabelString,
            "WSCvremoteServer: Error.\nwsagent does not exists...");
          WSGIappMessageDialog()->setProperty(WSNdefaultPosition,True);
          WSGIappMessageDialog()->popup();
        }
      }
      WSGIconductor()->setPort(_port);
      WSGIconductor()->setTimeout(1);
      WSGIconductor()->startDispatch();
      _running_bk = True;
    }
  }else{
    if (_running_bk != False){
      WSGIconductor()->stopDispatch();
      _running_bk = False;
    }
  }
}

void WSCvremoteServer::getWorkWSNrunning(WSCbool*){ };

WSCvremoteServer::~WSCvremoteServer(){
  if (_addr != NULL){
    delete _addr;
    _addr = NULL;
  }
  if (_running_bk != False){
    WSGIconductor()->stopDispatch();
    _running_bk = False;
  }
}

