//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <xunicode.h>
#include <WSDappDev.h>
#include <WScom.h>
#include <nx/WSDnxCodeConvert.h>
#include <WSDenv.h>

WSDcodeConvert* _code_convert_create_handler_(){
dbprintf("WSDcodeConvert* _code_convert_create_handler_.. \n");
  return new WSDnxCodeConvert;
}

int WSDnxCodeConvert::codeConvert(char* str,int max,int codeto,const char* src,int len,int codefrom){
  return XUCodeConv(str,max,codeto,src,len,codefrom);
}
int WSDnxCodeConvert::getSystemEncoding(){
extern int XUGetLocale();
  return XUGetLocale();
}

static char lc_all_buf[32];
static char lang_buf[32];

void WSDnxCodeConvert::initialize(){
  XUInit();
//extern char* XUGetLang();
//  setSystemLocaleName(XUGetLang(),getSystemEncoding());
  char* lang = getenv("LANG");
  if (lang == NULL){
    lang = "C";
  }
  char buffer[32];
  strncpy(buffer,lang,32);
  buffer[31] = 0;
  char* ptr = strstr(buffer, "@euro");
  if (ptr != NULL){
    ptr[0] = 0x2E; // '.'
    ptr[1] = 0x75; // 'u'
    ptr[2] = 0x74; // 't'
    ptr[3] = 0x66; // 'f'
    ptr[4] = 0x38; // '8'

    strcpy(lc_all_buf,"LC_ALL=");
    strncat(lc_all_buf,buffer,24);
    putenv(lc_all_buf);
    strcpy(lang_buf,"LANG=");
    strncat(lang_buf,buffer,24);
    putenv(lang_buf);
  }

  setSystemLocaleName(buffer,getSystemEncoding());
}
int WSDnxCodeConvert::utf8CharLen(const char* str,int max){
  return XUutf8CharLen(str,max); 
}
int WSDnxCodeConvert::encode(WSCushort* str,int max,const char* src,int len,int code){
  return XUEncode((XUChar*)str,max,src,len,code);
}
int WSDnxCodeConvert::decode(char* str,int max,const WSCushort* src,int len,int code){
  return XUDecode(str,max,(XUChar*)src,len,code);
}

