//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <btron/WSDunixEnv.h>
#include <WSCstring.h>

#ifndef WS_DEFAULT_DIR
#define WS_DEFAULT_DIR "/usr/local/ws"
#endif

WSDenv* _unix_env_chandler(){
  return new WSDunixEnv();
}
void WSGFunixEnvInit(){
  WSDenv::setCreateInstanceHandler(_unix_env_chandler);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _unix_env_init{
  public: _unix_env_init(){
    WSGFunixEnvInit();
  };
};
static _unix_env_init _unix_env_init_execute;
#endif

WSDunixEnv::WSDunixEnv(){}
WSDunixEnv::~WSDunixEnv(){}

char* WSDunixEnv::getEnv(char* src){
  WSCstring str(src);
  str.delString("(",0);
  str.delString(")",0);
  WSCstring new_str = str.getWord(0);

  char* ret = getenv( new_str.getString() );
  if (ret == NULL){
    WSCbool wsdir = !strcmp("WSDIR",new_str.getString());
    if (wsdir != 0){
       return WS_DEFAULT_DIR;
    }else{
#if defined (BTRON)  || defined (TE)
      if (!strcmp("HOME",new_str.getString())){
        if (getenv("SHELL") == NULL){
          return "/SYS";
        }else{
          return "/";
        }
      }
#endif 
       return "";
    }
  }

  return ret;
}

