//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WStcpcom.h>
#include <x11/WSDunixMutex.h>
#include <stdio.h>
#include <fcntl.h>
#include <WSClocaleSet.h>
#include <pthread.h>

WSMFclassInit(WSDunixMutex,WSDmutex);

WSDmutex* _unix_mutex_chandler(){
  return new WSDunixMutex;
}

void WSGFinitializeUnixMutex(){
    WSDmutex::setCreateInstanceHandler((void*)_unix_mutex_chandler);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _unix_mutex_init {
  public: _unix_mutex_init(){
    WSGFinitializeUnixMutex();
  };
};
_unix_mutex_init  _unix_mutex_init_execute;
#endif

WSDunixMutex::WSDunixMutex(){
}

WSDunixMutex::~WSDunixMutex(){
}

long WSDunixMutex::initialize(){
  pthread_mutex_init(&_mutex,NULL);
  return WS_NO_ERR;
}
long WSDunixMutex::lock(){
  int ret = pthread_mutex_lock(&_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDunixMutex::trylock(){
  int ret = pthread_mutex_trylock(&_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDunixMutex::unlock(){
  int ret = pthread_mutex_unlock(&_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDunixMutex::destroy(){
  int ret = pthread_mutex_destroy(&_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}




