//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WStcpcom.h>
#include <x11/WSxcom.h>
#include <x11/WSDunixSemaphore.h>
#include <stdio.h>
#include <fcntl.h>
#include <WSClocaleSet.h>
#include <pthread.h>

WSMFclassInit(WSDunixSemaphore,WSDsemaphore);

WSDsemaphore* _unix_sem_chandler(){
  return new WSDunixSemaphore;
}

void WSGFinitializeUnixSemaphore(){
    WSDsemaphore::setCreateInstanceHandler((void*)_unix_sem_chandler);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _unix_sem_init {
  public: _unix_sem_init(){
    WSGFinitializeUnixSemaphore();
  };
};
_unix_sem_init  _unix_sem_init_execute;
#endif

WSDunixSemaphore::WSDunixSemaphore(){
}

WSDunixSemaphore::~WSDunixSemaphore(){
}

long WSDunixSemaphore::initialize(){
  pthread_sem_init_np(&_sem);
  return WS_NO_ERR;
}
long WSDunixSemaphore::lock(){
  int ret = pthread_sem_lock_np(&_sem);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDunixSemaphore::unlock(){
  int ret = pthread_sem_unlock_np(&_sem);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDunixSemaphore::destroy(){
  int ret = pthread_sem_destroy_np(&_sem);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}




