//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WSCdb.h>
#include <WSCdbDrv.h>
#include <WSCdbOdbc.h>
#include <WSCodbcDatabase.h>
#include "udebug.h"
#include <WSDthread.h>
#include <WSDsemaphore.h>

#ifdef FACTORY_METHOD /* factory method handler..*/
WSCdbDrvDatabase* _WSCdbOdbcDatabase_create_(){
//printf("WSCdbOdbcDatabase_create...\n");
  WSCdbOdbcDatabase* inst = new WSCdbOdbcDatabase();
  inst->setThisPtr(inst);
  return inst;
}
WSCdbDrvRecord* _WSCdbOdbcRecord_create_(WSCdbDrvDatabase* db){
  return new WSCdbOdbcRecord((WSCdbOdbcDatabase*)db->getThisPtr());
}

class _WSCdbOdbcDatabase_init_ {
  public:
    _WSCdbOdbcDatabase_init_ (){
//printf("_WSCdbOdbcDatabase_init_... hd=0x%x\n\n",_WSCdbOdbcDatabase_create_);
       WSCdbDatabase::setCreateHandler((void*)_WSCdbOdbcDatabase_create_,"ODBC");
       WSCdbRecord::setCreateHandler((void*)_WSCdbOdbcRecord_create_,"ODBC");
    };
};
static _WSCdbOdbcDatabase_init_ _execute_initialize_;
#endif /* factory method handler..*/

WSCdbOdbcDatabase::WSCdbOdbcDatabase() : WSCdbDrvDatabase()
{
	_db = NULL;
}
WSCdbOdbcDatabase::~WSCdbOdbcDatabase()
{
	close();
	
	if(_db) {
		delete _db;
	}
}
long WSCdbOdbcDatabase::open(char* host, char* uid, char* pwd, char* dbname, char* port)
{
	close();
	long ret = WS_ERR;
	_db = new WSCodbcDatabase();
	if(_db) {
		ret = _db->open(host, uid, pwd);
	}
	return ret;
}
long WSCdbOdbcDatabase::close()
{
	long ret = WS_ERR;
	if(_db) {
		ret = _db->close();
		delete _db;
		_db = NULL;
	}
	return ret;
}
long WSCdbOdbcDatabase::beginTran()
{
	long ret = WS_ERR;
	if(_db) {
		ret = _db->beginTran();
	}
	return ret;
}
long WSCdbOdbcDatabase::commitTran()
{
	long ret = WS_ERR;
	if(_db) {
		ret = _db->commitTran();
	}
	return ret;
}
long WSCdbOdbcDatabase::abortTran()
{
	long ret = WS_ERR;
	if(_db) {
		ret = _db->abortTran();
	}
	return ret;
}
long WSCdbOdbcDatabase::sqlExecute(const char* stmt)
{
	long ret = WS_ERR;
	if(_db) {
		ret = _db->sqlExecute(stmt);
	}
	return ret;
}
WSCbool WSCdbOdbcDatabase::isOpen()
{
	if(_db) {
		return _db->isOpen();
	}
	return False;
}
void WSCdbOdbcDatabase::getErrorMsg(char* szState, char* szMsg)
{
	if(_db) {
		_db->getErrorMsg(szState, szMsg);
	}
}

void WSCdbOdbcDatabase::getErrorMsg(char* szMsg,long size)
{
	if(_db) {
		_db->getErrorMsg(szMsg, size);
	}
}
void WSCdbOdbcDatabase::setEncode(long code)
{
	if(_db) {
		_db->setEncode(code);
	}
}
long WSCdbOdbcDatabase::getEncode()
{
	if(_db) {
		return _db->getEncode();
	}
	return -1;
}



/////
WSCdbOdbcRecord::WSCdbOdbcRecord(WSCdbOdbcDatabase* pDatabase) : WSCdbDrvRecord(pDatabase)
{
	_pDB = pDatabase;
	_rs = NULL;
    _async_thread = NULL;
    _wait_sem = NULL;
    _is_busy = False;
    _ret_query = WS_ERR;
}
WSCdbOdbcRecord::~WSCdbOdbcRecord()
{
	close();
	_pDB = NULL;
    if (_async_thread != NULL){
      delete _async_thread;
    }
    if (_wait_sem != NULL){
      delete _wait_sem;
    }
}
long WSCdbOdbcRecord::open(const char* stmt)
{
	return open(stmt, SQL_CURSOR_STATIC, SQL_CONCUR_LOCK);
}
long WSCdbOdbcRecord::sendQuery(const char* stmt)
{
	return open(stmt, SQL_CURSOR_STATIC, SQL_CONCUR_LOCK);
}
long WSCdbOdbcRecord::open(const char* stmt, short eCousor, short eAccess)
{
	close();
	long ret = WS_ERR;
	_rs = new WSCodbcRecord(_pDB->_db);
	if(_rs) {
		ret = _rs->open(stmt, eCousor, eAccess);
	}
	return ret;
}
void* _async_thread_func(WSDthread* thr,void* ptr){
  WSCdbOdbcRecord* _this = (WSCdbOdbcRecord*)ptr;
  _this->_wait_sem->lock();
  _this->_is_busy = True;
  _this->_ret_query = _this->_rs->open(_this->_tmp_stmt, _this->_tmp_ecursor, _this->_tmp_eaccess);
  _this->_is_busy = False;
  _this->_wait_sem->unlock();
  return NULL;
}
WSCbool WSCdbOdbcRecord::isBusy(){
  return _is_busy;
}
long WSCdbOdbcRecord::sendQuery(const char* stmt, short eCursor, short eAccess)
{
  if (_is_busy != False){
    return WS_DB_BUSY;
  }
  close();
  long ret = WS_ERR;
  if (_async_thread == NULL){
    _async_thread = WSDthread::getNewInstance();
    if (_async_thread == NULL){
      return WS_ERR;
    }
    _async_thread->setFunction(_async_thread_func);
    _wait_sem = WSDsemaphore::getNewInstance();
    if (_wait_sem == NULL){
      return WS_ERR;
    }
    _wait_sem->initialize();
  }
  _rs = new WSCodbcRecord(_pDB->_db);
  if(_rs){
    _is_busy = True;
    _tmp_stmt = stmt;
    _tmp_ecursor = eCursor;
    _tmp_eaccess = eAccess;
    ret = _async_thread->createThread((void*)this);
    if (ret == WS_NO_ERR){
      return WS_NO_ERR;
    }
    _is_busy = False;
    return WS_ERR;
  }
  return WS_ERR;
}
long WSCdbOdbcRecord::getResult(WSCbool wait){
  if (_is_busy != False){
    if (_rs != NULL){
      if (wait == False){
        return WS_DB_BUSY;
      }
      _wait_sem->lock();
      _wait_sem->unlock();
      return _ret_query;
    }else{
      return WS_ERR;
    }
  }else{
    return _ret_query;
  }
}
long WSCdbOdbcRecord::cancelQuery(){
  if (_is_busy != False){
    _rs->cancel();
    _wait_sem->lock();
    _wait_sem->unlock();
  }
  return WS_NO_ERR;
}
long WSCdbOdbcRecord::close()
{
    if (_is_busy){
      cancelQuery();
    }
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->close();
		delete _rs;
		_rs = NULL;
	}
	return ret;
}
WSCbool WSCdbOdbcRecord::isEOF()
{
	if(_rs) {
		return _rs->isEOF();
	}
	return True;
}
WSCbool WSCdbOdbcRecord::isOpen()
{
	if(_rs) {
		return _rs->isOpen();
	}
	return False;
}
long WSCdbOdbcRecord::getColValue(long index, WSCvariant* var)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->getColValue(index, var);
	}
	return ret;
}
long WSCdbOdbcRecord::getColValue(const char* name, WSCvariant* var)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->getColValue(name, var);
	}
	return ret;
}
long WSCdbOdbcRecord::getColStringValue(long index, char* var)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->getColStringValue(index, var);
	}
	return ret;
}
long WSCdbOdbcRecord::getColStringValue(const char* name, char* var)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->getColStringValue(name, var);
	}
	return ret;
}
long WSCdbOdbcRecord::setColValue(long index, WSCvariant var)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->setColValue(index, var);
	}
	return ret;
}
long WSCdbOdbcRecord::setColValue(const char* name, WSCvariant var)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->setColValue(name, var);
	}
	return ret;
}
long WSCdbOdbcRecord::edit()
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->edit();
	}
	return ret;
}
long WSCdbOdbcRecord::addnew()
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->addnew();
	}
	return ret;
}
long WSCdbOdbcRecord::update()
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->update();
	}
	return ret;
}
long WSCdbOdbcRecord::deleterow()
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->deleterow();
	}
	return ret;
}
long WSCdbOdbcRecord::moveNext()
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->moveNext();
	}
	return ret;
}
long WSCdbOdbcRecord::movePrevious()
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->movePrevious();
	}
	return ret;
}
long WSCdbOdbcRecord::moveFirst()
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->moveFirst();
	}
	return ret;
}
long WSCdbOdbcRecord::moveLast()
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->moveLast();
	}
	return ret;
}
long WSCdbOdbcRecord::getColName(long index, char* name)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->getColName(index, name);
	}
	return ret;
}
long WSCdbOdbcRecord::getColIndex(const char* name)
{
	if(_rs) {
		return _rs->getColIndex(name);
	}
	return -1;
}
long WSCdbOdbcRecord::getColType(long index)
{
	if(_rs) {
		return _rs->getColType(index);
	}
	return -1;
}
long WSCdbOdbcRecord::getColType(const char* name)
{
	if(_rs) {
		return _rs->getColIndex(name);
	}
	return -1;
}
long WSCdbOdbcRecord::getColLength(long index)
{
	if(_rs) {
		return _rs->getColLength(index);
	}
	return 0;
}
long WSCdbOdbcRecord::getColLength(const char* name)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->getColLength(name);
	}
	return ret;
}

long WSCdbOdbcRecord::getRowCount()
{
	if(_rs) {
		return _rs->getRowCount();
	}
	return 0;
}
long WSCdbOdbcRecord::getColCount()
{
	if(_rs) {
		return _rs->getColCount();
	}
	return 0;
}
void WSCdbOdbcRecord::getErrorMsg(char* szState, char* szMsg)
{
	if(_rs) {
		_rs->getErrorMsg(szState, szMsg);
	}
}
WSCstring WSCdbOdbcRecord::getErrorMessage(){
  WSCstring ret;
  if (_rs != NULL){
    char stat[10];
    char buf[SQL_MAX_MESSAGE_LENGTH+1];
    _rs->getErrorMsg(stat,buf);
    char buf2[SQL_MAX_MESSAGE_LENGTH+1+32];
    sprintf(buf2,"state: %s ,message: %s",stat,buf);
    ret.setString(buf2);
    return ret;
  }
  return ret;
}
long WSCdbOdbcRecord::isNull(long index)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->isNull(index);
	}
	return ret;
}
long WSCdbOdbcRecord::isNull(const char* name)
{
	long ret = WS_ERR;
	if(_rs) {
		ret = _rs->isNull(name);
	}
	return ret;
}
