//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCvodbc.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCodbcDatabase.h>

extern "C" {
WSDLEX32 void libwsodbc_func();
};
void libwsodbc_func(){
}

WSMFguiClassInitialize(WSCvodbc, WSCngbase);
WSMFversion(WSCvodbc, WSCngbase);

WSCvodbc::WSCvodbc(WSCbase* base, char* objname):
			WSCngbase(base, objname){
  _db = NULL;
  _title_string.setString("ODBC Client");

  _dsn = WSGFstrdup("dsn");
  _user = WSGFstrdup("username");
  _passwd = WSGFstrdup("password");


  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvodbc);
    WSMFpropertyCreate(WSNdsn,    char*,   _dsn,WSSdsn);
    WSMFpropertyCreate(WSNusername,    char*,   _user,WSSusername);
    WSMFpropertyCreate(WSNpassword,    char*,   _passwd,WSSpassword);


  WSMFpropertyCreateEnd

}

WSMFproperty(WSCvodbc, WSNdsn,    char*,   _dsn, WSGFstrdup("dsn"));
WSMFproperty(WSCvodbc, WSNusername, char*, _user, WSGFstrdup("username"));
WSMFproperty(WSCvodbc, WSNpassword, char*, _passwd, WSGFstrdup("password"));

void WSCvodbc::setWorkWSNdsn(char*) {}
void WSCvodbc::getWorkWSNdsn(char**) {}
void WSCvodbc::setWorkWSNusername(char*) {}
void WSCvodbc::getWorkWSNusername(char**) {}
void WSCvodbc::setWorkWSNpassword(char*) {}
void WSCvodbc::getWorkWSNpassword(char**) {}


WSCvodbc::~WSCvodbc(){
  if (_db != NULL){
    delete _db;
    _db = NULL;
  }
}
WSCodbcDatabase* WSCvodbc::getODBCDatabase(){
  _init();
  return _db;
}
void WSCvodbc::_init(){
  if (_db == NULL){
    _db = new WSCodbcDatabase();
  }
}

long WSCvodbc::open(char* dsn,char* uid,char* passwd){
  _init();
  if (_db != NULL){
    return _db->open(dsn,uid,passwd);
  }
  return WS_ERR;
}
long WSCvodbc::open(){
  _init();
  if (_db != NULL){
    return _db->open(_dsn,_user,_passwd);
  }
  return WS_ERR;
}



long WSCvodbc::close(){
  _init();
  if (_db != NULL){
    return _db->close();
  }
  return WS_ERR;
}
long WSCvodbc::beginTran(){
  _init();
  if (_db != NULL){
    return _db->beginTran();
  }
  return WS_ERR;
}
long WSCvodbc::commitTran(){
  _init();
  if (_db != NULL){
    return _db->commitTran();
  }
  return WS_ERR;
}

long WSCvodbc::abortTran(){
  _init();
  if (_db != NULL){
    return _db->abortTran();
  }
  return WS_ERR;
}

long WSCvodbc::sqlExecute(const char* sql){
  _init();
  if (_db != NULL){
    return _db->sqlExecute(sql);
  }
  return WS_ERR;
}

WSCbool WSCvodbc::isOpen(){
  _init();
  if (_db != NULL){
    return _db->isOpen();
  }
  return False;
}
void WSCvodbc::getErrorMsg(char* msg,long size){
  _init();
  if (_db != NULL){
    char stat[6];
    char buf[SQL_MAX_MESSAGE_LENGTH+1];
    _db->getErrorMsg(stat,buf);
    char buf2[SQL_MAX_MESSAGE_LENGTH+1+32];
    sprintf(buf2,"state: %s ,message: %s",stat,buf);
    if (size > 0){
      strncpy(msg,buf2,size);
// update 2002/06/05
      msg[size-1] = '\0';
    }
    return;
  }
  if (size > 0){
    strncpy(msg,"Not initialized..",size);
// update 2002/06/05
    msg[size-1] = '\0';
  }
  return;
}
WSCstring WSCvodbc::getErrorMessage()
{
  WSCstring ret;
  _init();
  if (_db != NULL){
    char stat[10];
    char buf[SQL_MAX_MESSAGE_LENGTH+1];
    _db->getErrorMsg(stat,buf);
    char buf2[SQL_MAX_MESSAGE_LENGTH+1+32];
    sprintf(buf2,"state: %s ,message: %s",stat,buf);
    ret.setString(buf2);
  }
  return ret;
}

