//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <WSCdb.h>
#include <WSCdbDrv.h>
#include "WSCdbSQLite.h"
#include <WSClocaleSet.h>

#include "udebug.h"

extern "C" {
void libwssqlite_func();
};
void libwssqlite_func(){
}

#ifdef FACTORY_METHOD /* factory method handler..*/
WSCdbDrvDatabase* _WSCdbSQLiteDatabase_create_(){
  WSCdbSQLiteDatabase* inst = new WSCdbSQLiteDatabase();
  inst->setThisPtr(inst);
  return inst;
}
WSCdbDrvRecord* _WSCdbSQLiteRecord_create_(WSCdbDrvDatabase* db){
  return new WSCdbSQLiteRecord((WSCdbSQLiteDatabase*)db->getThisPtr());
}

class _WSCdbSQLiteDatabase_init_ {
  public:
    _WSCdbSQLiteDatabase_init_ (){
       WSCdbDatabase::setCreateHandler((void*)_WSCdbSQLiteDatabase_create_,"SQLITE");
       WSCdbRecord::setCreateHandler((void*)_WSCdbSQLiteRecord_create_,"SQLITE");
    };
};
static _WSCdbSQLiteDatabase_init_ _execute_initialize_;
#endif /* factory method handler..*/

WSCdbSQLiteDatabase::WSCdbSQLiteDatabase() : WSCdbDrvDatabase()
{
	TRACE_U(("WSCdbSQLiteDatabase::WSCdbSQLiteDatabase start"));
	
	_hconn = NULL;
	_open = False;
	_begin = 0;
	_errno = 0;
	_errmsg = NULL;
	memset(_dbName, '\0', sizeof(_dbName));
	_encoding = -1;
	TRACE_U(("WSCdbSQLiteDatabase::WSCdbSQLiteDatabase end"));
}
WSCdbSQLiteDatabase::~WSCdbSQLiteDatabase()
{
	TRACE_U(("WSCdbSQLiteDatabase::~WSCdbSQLiteDatabase"));

	close();
	
	TRACE_U(("WSCdbSQLiteDatabase::~WSCdbSQLiteDatabase end"));
}

long WSCdbSQLiteDatabase::open(char* host, char* uid, char* pwd, char* dbname, char* port)
{
	TRACE_U(("WSCdbSQLiteDatabase::open start"));

	if(isOpen()) {
		close();
	}
	_open = False;

	if((sqlite3_open(dbname, &_hconn)) != SQLITE_OK) {
		getError();
		return WS_ERR;
	}
	_open = True;
	if(dbname) {
		strcpy(_dbName, dbname);
	}
	sqlite3_exec(_hconn, "PRAGMA show_datatypes = on;", NULL, NULL, NULL);

	getServerEncoding();

	TRACE_U(("WSCdbSQLiteDatabase::open end"));
	return WS_NO_ERR;
}
long WSCdbSQLiteDatabase::close()
{
	TRACE_U(("WSCdbSQLiteDatabase::close start"));
	if(_hconn == NULL) {
		return WS_NO_ERR;
	}
	if(_begin) {
		abortTran();
	}
	sqlite3_close(_hconn);
	_hconn = NULL;
	_open = False;
	memset(_dbName, '\0', sizeof(_dbName));
	_encoding = -1;
	TRACE_U(("WSCdbSQLiteDatabase::close end"));
	return WS_NO_ERR;
}
long WSCdbSQLiteDatabase::beginTran()
{
	TRACE_U(("WSCdbSQLiteDatabase::beginTran start"));
	if(!isOpen()) {
		return WS_ERR;
	}
	long ret = WS_NO_ERR;
	if((_errno = sqlite3_exec(_hconn, "BEGIN;", NULL, NULL, &_errmsg))) {
		getError();
		ret = WS_ERR;
	} else {
		_begin = True;
	}
	TRACE_U(("WSCdbSQLiteDatabase::beginTran end"));
	return ret;
}
long WSCdbSQLiteDatabase::commitTran()
{
	TRACE_U(("WSCdbSQLiteDatabase::commitTran start"));
	if(!isOpen()) {
		return WS_ERR;
	}
	long ret = WS_NO_ERR;
	if((_errno = sqlite3_exec(_hconn, "COMMIT;", NULL, NULL, &_errmsg))) {
		getError();
		ret = WS_ERR;
	} else {
		_begin = False;
	}
	TRACE_U(("WSCdbSQLiteDatabase::commitTran end"));
	return ret;
}
long WSCdbSQLiteDatabase::abortTran()
{
	TRACE_U(("WSCdbSQLiteDatabase::abortTran start"));
	if(!isOpen()) {
		return WS_ERR;
	}
	long ret = WS_NO_ERR;
	if((_errno = sqlite3_exec(_hconn, "ROLLBACK;", NULL, NULL, &_errmsg))) {
		getError();
		ret = WS_ERR;
	} else {
		_begin = False;
	}
	TRACE_U(("WSCdbSQLiteDatabase::abortTran end"));
	return ret;
}
long WSCdbSQLiteDatabase::sqlExecute(const char* stmt)
{
	TRACE_U(("WSCdbSQLiteDatabase::sqlExecute start"));
	if(!isOpen()) {
		return WS_ERR;
	}
	long ret = WS_NO_ERR;
	if((_errno = sqlite3_exec(_hconn, decode(stmt), NULL, NULL, &_errmsg))) {
		getError();
		ret = WS_ERR;
	}
	TRACE_U(("WSCdbSQLiteDatabase::sqlExecute end"));
	return ret;
}
WSCbool WSCdbSQLiteDatabase::isOpen()
{
	return _open;
}
void WSCdbSQLiteDatabase::getError()
{
	TRACE_U(("WSCdbSQLiteDatabase::getError start"));

	sprintf((char*)_szSqlState, "%05d", sqlite3_errcode(_hconn));
	memset(_szErrorMsg, '\0', sizeof(_szErrorMsg));
	strncpy((char*)_szErrorMsg, sqlite3_errmsg(_hconn), sizeof(_szErrorMsg)-1);
	TRACE_U(("WSCdbSQLiteDatabase::getError State:%s messgae:%s", _szSqlState, _szErrorMsg));
	TRACE_U(("WSCdbSQLiteDatabase::getError end"));
}

void WSCdbSQLiteDatabase::getErrorMsg(char* szState, char* szMsg)
{
	TRACE_U(("WSCdbSQLiteDatabase::getErrorMsg start"));
	
	strcpy(szState, (char*)_szSqlState);
	strcpy(szMsg, (char*)_szErrorMsg);
	
	TRACE_U(("WSCdbSQLiteDatabase::getErrorMsg end"));
}

void WSCdbSQLiteDatabase::getErrorMsg(char* szMsg,long size)
{
	TRACE_U(("WSCdbSQLiteDatabase::getErrorMsg start"));
	
	char szStat[6];
	char szErrorMsg[SQLITE_MAX_MESSAGE_LENGTH + 1];
	char buf[SQLITE_MAX_MESSAGE_LENGTH + 1+32];
	getErrorMsg(szStat,szErrorMsg);
	sprintf(buf,"status:%s message:%s",szStat,szErrorMsg);
	strncpy(szMsg,buf,size);
	szMsg[size] = '\0';

	TRACE_U(("WSCdbSQLiteDatabase::getErrorMsg end"));
}
int WSCdbSQLiteDatabase::getProcessId()
{
	return 0;
}
WSCulong WSCdbSQLiteDatabase::getCursor()
{
	return 0;
}
short WSCdbSQLiteDatabase::getbeginTranmode()
{
	return _begin;
}
void WSCdbSQLiteDatabase::setbeginTranmode(short begin)
{
	_begin = begin;
}
char* WSCdbSQLiteDatabase::getDbName()
{
	return _dbName;
}
void WSCdbSQLiteDatabase::setEncode(long code)
{
	_encoding = code;
}
long WSCdbSQLiteDatabase::getEncode()
{
	return _encoding;
}
void WSCdbSQLiteDatabase::getServerEncoding()
{
	_encoding = -1;
	TRACE_U(("getServerEncoding code:%s, _encoding:%d\n", code, _encoding));
}
char* WSCdbSQLiteDatabase::decode(const char* buf)
{
	long decode = WSGIappLocaleSet()->getDefaultEncoding();
	static WSCstring s;
	s = buf;
	if(_encoding != decode && _encoding != -1) {
	TRACE_U(("decode buf:%s\n", buf));
	TRACE_U(("decode str:%s\n", s.getString(_encoding)));
		return s.getString(_encoding);
	}
	return s.getString();
}

/////
WSCdbSQLiteRecord::WSCdbSQLiteRecord(WSCdbSQLiteDatabase* pDatabase) : WSCdbDrvRecord(pDatabase)
{
	TRACE_U(("WSCdbSQLiteRecord::WSCdbSQLiteRecord start"));

	Cleanup(pDatabase);

	TRACE_U(("WSCdbSQLiteRecord::WSCdbSQLiteRecord end"));
}
void WSCdbSQLiteRecord::Cleanup(WSCdbSQLiteDatabase* pDatabase)
{
	_pDB = pDatabase;
	_open = False;
	_Cols = 0;
	_fd = NULL;
	_access_mode = SQLITE_ACCESS_MODE_READ;
	_Cursor = WSCDB_SQL_CURSOR_STATIC;
	_access = WSCDB_SQL_CONCUR_LOCK;
	memset(_szSqlState, '\0', sizeof(_szSqlState));
	memset(_szErrorMsg, '\0', sizeof(_szErrorMsg));
	_RowCount = 0;
	_FetchRowPos = 0;
	_encoding = -1;
	_rowiduse = 0;
}

WSCdbSQLiteRecord::~WSCdbSQLiteRecord()
{
	TRACE_U(("WSCdbSQLiteRecord::~WSCdbSQLiteRecord start"));

	close();

	_pDB = NULL;

	TRACE_U(("WSCdbSQLiteRecord::~WSCdbSQLiteRecord end"));
}
long WSCdbSQLiteRecord::open(const char* stmt)
{
	return open(stmt, WSCDB_SQL_CURSOR_STATIC, WSCDB_SQL_CONCUR_LOCK);
}
long WSCdbSQLiteRecord::open(const char* stmt, short eCousor, short eAccess)
{
	TRACE_U(("WSCdbSQLiteRecord::open start"));

	if(_pDB == NULL) {
		return WS_ERR;
	}
	if(_pDB->_hconn == NULL) {
		return WS_ERR;
	}
	if(isOpen()) {
		close();
	}
	_open = False;
	_Cursor = eCousor;
	_access = eAccess;
	_RowCount = 0;
	_FetchRowPos = 0xffffffff;
	_encoding = _pDB->getEncode();;
	_rowiduse = 0;
	_stmt = stmt;

	WSCstring buf;
	char	buf1[256];
	strncpy(buf1, stmt, 6);
	buf1[6] = '\0';

	if(_access != WSCDB_SQL_CONCUR_READ_ONLY 
		&& WSGFstricmp(buf1, "select") == 0) {
		getTableName((char*)stmt, _tableName, sizeof(_tableName));
		sprintf(buf1, "select rowid from %s", _tableName);
		if(sqlite3_exec(_pDB->_hconn, buf1, NULL, NULL, NULL)) {
			_rowiduse = 0;
			TRACE_U(("WSCdbSQLiteRecord::open rowid not use"));
		} else {
			_rowiduse = 1;
			TRACE_U(("WSCdbSQLiteRecord::open rowid use"));
		}
	} else {
		_rowiduse = 0;
	}
	buf = getSelectSQL(stmt, _rowiduse);

	// Prepare query
	if (sqlite3_prepare(_pDB->_hconn, buf.getString(), strlen(buf.getString()), &_res_stmt, NULL) != SQLITE_OK) {
		getError();
		return WS_ERR;
	}

	// Retrieve cols and rows count
	while (sqlite3_step(_res_stmt) != SQLITE_DONE) {
		_RowCount++;
	}
	sqlite3_reset(_res_stmt);
	_Cols = sqlite3_column_count(_res_stmt);

	_open = True;
	_eof = False;
	
	if (_RowCount < 1) {
        _eof = True;
        BindCols();
    }

	// Go to first row. It's necessary to get cols names and types
	// and to initialize cursor
	moveFirst();

	TRACE_U(("WSCdbSQLiteRecord::open end"));
	return WS_NO_ERR;
}
long WSCdbSQLiteRecord::close()
{
	TRACE_U(("WSCdbSQLiteRecord::close start"));
	
	if(_res_stmt) {
		sqlite3_finalize(_res_stmt);
	}
	_res_stmt = NULL;
	ReleaseCols();
	_open = False;
	_RowCount = 0;
	_FetchRowPos = 0;
	_encoding = -1;
	_rowiduse = 0;
	
	TRACE_U(("WSCdbSQLiteRecord::close end"));
	return WS_NO_ERR;
}
WSCbool WSCdbSQLiteRecord::isEOF()
{
	return _eof;
}
WSCbool WSCdbSQLiteRecord::isOpen()
{
	return _open;
}
long WSCdbSQLiteRecord::getColValue(long index, WSCvariant* var)
{
	if(index < 0 || index >= (_Cols-_rowiduse)) {
		return WS_ERR;
	}
	if(_RowCount < 1) {
        return WS_ERR;
    }
	getValue(index, var);
	return WS_NO_ERR;
}
long WSCdbSQLiteRecord::getColValue(const char* name, WSCvariant* var)
{
	if(_RowCount < 1) {
        return WS_ERR;
    }
	return getColValue(getColIndex(name), var);
}
long WSCdbSQLiteRecord::getColStringValue(long index, char* var)
{
	if(index < 0 || index >= (_Cols-_rowiduse)) {
		return WS_ERR;
	}
	if(_RowCount < 1) {
        return WS_ERR;
    }
	strcpy(var, (char*)_fd[index].buff);
	return WS_NO_ERR;
}
long WSCdbSQLiteRecord::getColStringValue(const char* name, char* var)
{
	if(_RowCount < 1) {
        return WS_ERR;
    }
	return getColStringValue(getColIndex(name), var);
}
long WSCdbSQLiteRecord::setColValue(long index, WSCvariant var)
{
	if(index < 0 || index >= (_Cols-_rowiduse)) {
		return WS_ERR;
	}
	if(_access_mode == SQLITE_ACCESS_MODE_READ || _rowiduse == 0) {
		return WS_ERR;
	}
	setValue(index, &var);
	return WS_NO_ERR;
}
long WSCdbSQLiteRecord::setColValue(const char* name, WSCvariant var)
{
	return setColValue(getColIndex(name), var);
}
long WSCdbSQLiteRecord::edit()
{
	if(isEOF() || _access == WSCDB_SQL_CONCUR_READ_ONLY || _rowiduse == 0) {
		return WS_ERR;
	}
	if(_RowCount < 1) {
        return WS_ERR;
    }
	_access_mode = SQLITE_ACCESS_MODE_EDIT;
	return WS_NO_ERR;
}
long WSCdbSQLiteRecord::addnew()
{
	if(!isOpen() || _access == WSCDB_SQL_CONCUR_READ_ONLY || _rowiduse == 0) {
		return WS_ERR;
	}
	for(int i = 0; i < _Cols; i++) {
		memset(_fd[i].buff, '\0', _fd[i].buffLen);
	}
	_access_mode = SQLITE_ACCESS_MODE_ADDNEW;
	return WS_NO_ERR;
}
long WSCdbSQLiteRecord::update()
{
	WSCulong _temp_FetchRowPos;
	long ret = WS_ERR;
	if(_access_mode == SQLITE_ACCESS_MODE_ADDNEW) {
		sqlite3_finalize(_res_stmt);
		ret = _pDB->sqlExecute(makeINSERT());
		close();
		open(_stmt);
		moveFirst();
	} else
	if(_access_mode == SQLITE_ACCESS_MODE_EDIT) {
		sqlite3_finalize(_res_stmt);
		ret = _pDB->sqlExecute(makeUPDATE());
		_temp_FetchRowPos = _FetchRowPos;
		close();
		open(_stmt);
		setRowPos(_temp_FetchRowPos);
	}
	_access_mode = SQLITE_ACCESS_MODE_READ;
	return ret;
}
long WSCdbSQLiteRecord::deleterow()
{
    WSCulong _temp_FetchRowPos;
	long ret = WS_ERR;
	if(isEOF() || _access == WSCDB_SQL_CONCUR_READ_ONLY || _rowiduse == 0) {
		return WS_ERR;
	}
	sqlite3_finalize(_res_stmt);
	_access_mode = SQLITE_ACCESS_MODE_READ;
	ret = _pDB->sqlExecute(makeDELETE());
	_temp_FetchRowPos = _FetchRowPos;
	close();
	open(_stmt);
    if (_temp_FetchRowPos > _RowCount){
       _temp_FetchRowPos = _RowCount;
    }
	setRowPos(_temp_FetchRowPos);
	return ret;
}
long WSCdbSQLiteRecord::moveNext()
{
	if(isEOF()) {
		return WS_ERR;
	}
	if (_RowCount < 1) {
        return WS_ERR;
    }
	_access_mode = SQLITE_ACCESS_MODE_READ;
	if ((_FetchRowPos+1) == _RowCount)
	{
		_eof = True;
	} else {
		_eof = False;
	}
	return setRowPos(_FetchRowPos+1);
}
long WSCdbSQLiteRecord::movePrevious()
{
	if(!isOpen()) {
		return WS_ERR;
	}
	if (_RowCount < 1) {
        return WS_ERR;
    }
	_access_mode = SQLITE_ACCESS_MODE_READ;
	return setRowPos(_FetchRowPos-1);
	_eof = False;
}
long WSCdbSQLiteRecord::moveFirst()
{
	if(!isOpen()) {
		return WS_ERR;
	}
	if (_RowCount < 1) {
        return WS_ERR;
    }
	_access_mode = SQLITE_ACCESS_MODE_READ;
	return setRowPos(0);
	_eof = False;
}
long WSCdbSQLiteRecord::moveLast()
{
	if(isEOF()) {
		return WS_ERR;
	}
	if (_RowCount < 1) {
        return WS_ERR;
    }
	_access_mode = SQLITE_ACCESS_MODE_READ;
	_eof = True;
	return setRowPos(_RowCount-1);
}
long WSCdbSQLiteRecord::setRowPos(WSCulong pos)
{
	if (pos > _RowCount-1) {
		getError();
		return WS_ERR;
	}
	_FetchRowPos = pos;
	sqlite3_reset(_res_stmt);
	for(WSCulong i = 0; i < pos; i++) {
		if(sqlite3_step(_res_stmt) == SQLITE_DONE)
		{
			_eof = True;
		} else {
			_eof = False;
		}
	}
	BindCols();
	return WS_NO_ERR;
}
long WSCdbSQLiteRecord::getColName(long index, char* name)
{
	if(!isOpen()) {
		return -1;
	}
	if(index < 0 || index >= (_Cols-_rowiduse)) {
		return WS_ERR;
	}
	strcpy(name, (char*)_fd[index].colName);
	return WS_NO_ERR;
}
long WSCdbSQLiteRecord::getColIndex(const char* name)
{
	if(!isOpen()) {
		return -1;
	}
	for(int i = 0; i < (_Cols-_rowiduse); i++) {
		if(WSGFstricmp((char*)_fd[i].colName, (char*)name) == 0) {
			return (i);
		}
	}
	return -1;
}
long WSCdbSQLiteRecord::getColType(long index)
{
	if(!isOpen()) {
		return -1;
	}
	if(index < 0 || index >= (_Cols-_rowiduse)) {
		return -1;
	}
	return _fd[index].colType;
}
long WSCdbSQLiteRecord::getColType(const char* name)
{
	return getColType(getColIndex(name));
}
long WSCdbSQLiteRecord::getColLength(long index)
{
	if(!isOpen()) {
		return -1;
	}
	if(index < 0 || index >= (_Cols-_rowiduse)) {
		return -1;
	}
	return _fd[index].buffLen-1;
}
long WSCdbSQLiteRecord::getColLength(const char* name)
{
	return _fd[(getColIndex(name))].buffLen-1;
}

long WSCdbSQLiteRecord::getRowCount()
{
	return (isOpen() ? _RowCount : 0);
}
long WSCdbSQLiteRecord::getColCount()
{
	return _Cols-_rowiduse;
}
long WSCdbSQLiteRecord::BindCols()
{
	TRACE_U(("WSCdbSQLiteRecord::BindCols start"));
	if(_Cols < 1) {
		getError();
		return WS_ERR;
	}
	delete _fd;
	_fd = new _SqLiteCol[_Cols];
	memset(_fd, '\0', sizeof(_SqLiteCol) * _Cols);

    if(_RowCount < 1) {
	    for(int i = 0; i < _Cols; i++ ) {
            strncpy((char*)_fd[i].colName, sqlite3_column_name(_res_stmt, i), sizeof(_fd[i].colName)-1);
            getColTypeLength(sqlite3_column_decltype(_res_stmt, i), &_fd[i].colType, &_fd[i].buffLen);
        }
    } else {
  	    sqlite3_step(_res_stmt);
	    for(int i = 0; i < _Cols; i++ ) {
		    strncpy((char*)_fd[i].colName, sqlite3_column_name(_res_stmt, i), sizeof(_fd[i].colName)-1);
		    getColTypeLength(sqlite3_column_decltype(_res_stmt, i), &_fd[i].colType, &_fd[i].buffLen);
		    _fd[i].buff = new char[_fd[i].buffLen];
		    memset(_fd[i].buff, '\0', _fd[i].buffLen);
		    strncpy((char*)_fd[i].buff, (const char*)sqlite3_column_text(_res_stmt, i), _fd[i].buffLen);
	    }
     }

	TRACE_U(("WSCdbSQLiteRecord::BindCols end"));
	return WS_NO_ERR;
}
void WSCdbSQLiteRecord::getColTypeLength(const char*colname, short* type, int* length)
{
	WSCstring s;
	s = colname;
	s.to_upper();

	if(s.isExist("INT") != -1) {
		*type = WSCDB_FIELD_TYPE_INTEGER;
	} else if(s.isExist("FLOAT") != -1) {
		*type = WSCDB_FIELD_TYPE_REAL;
	} else {
		*type = WSCDB_FIELD_TYPE_CHAR;
	}

	*length = getBufflen(*type);
}
void WSCdbSQLiteRecord::ReleaseCols()
{
	TRACE_U(("WSCdbSQLiteRecord::ReleaseCols start"));
	
	if(_fd == NULL) {
		return;
	}
    	for(int i = 0; i < _Cols; i++ ) {
    	    delete[] (char*)(_fd[i].buff);
    	}
    	delete[] _fd;

	_fd = NULL;

	TRACE_U(("WSCdbSQLiteRecord::ReleaseCols end"));
}

void WSCdbSQLiteRecord::getValue(int index, WSCvariant* var)
{
	TRACE_U(("WSCdbSQLiteRecord::getValue start"));
	TRACE_U(("WSCdbSQLiteRecord::getValue _fd[index].colType:%d", _fd[index].colType));

	if(_fd[index].colType == WSCDB_FIELD_TYPE_INTEGER) {
		// SQL_INTEGER long int
		*var = (long)atol((char*)_fd[index].buff);
	} else
	if(_fd[index].colType == WSCDB_FIELD_TYPE_REAL) {
		// SQL_FLOAT, SQL_DOUBLE float
		*var = (double)atof((char*)_fd[index].buff);
	} else {
		*var = (char*)_fd[index].buff;
	}

	TRACE_U(("WSCdbSQLiteRecord::getValue end"));
}
void WSCdbSQLiteRecord::setValue(int index, WSCvariant* var)
{
	TRACE_U(("WSCdbSQLiteRecord::setValue start"));
	TRACE_U(("WSCdbSQLiteRecord::setValue _fd[index].colType:%d", _fd[index].colType));

	int len = (int)strlen(var->getCharPtr());

	if(_fd[index].colType == WSCDB_FIELD_TYPE_CHAR) {
		// SQL_CHAR unsigned char
		strncpy((char*)_fd[index].buff, var->getCharPtr(), _fd[index].buffLen-1);
		((char*)_fd[index].buff)[(len < _fd[index].buffLen ? len : _fd[index].buffLen-1)] = '\0';
	} else
	if(_fd[index].colType == WSCDB_FIELD_TYPE_INTEGER) {
		// SQL_INTEGER long int
		sprintf((char*)_fd[index].buff, "%d", var->getLong());
	} else
	if(_fd[index].colType == WSCDB_FIELD_TYPE_REAL) {
		// SQL_REAL REAL
		sprintf((char*)_fd[index].buff, "%f", var->getFloat());
	} else {
		strncpy((char*)_fd[index].buff, var->getCharPtr(), _fd[index].buffLen-1);
		((char*)_fd[index].buff)[(len < _fd[index].buffLen ? len : _fd[index].buffLen-1)] = '\0';
	}

	TRACE_U(("WSCdbSQLiteRecord::setValue end"));
}

void WSCdbSQLiteRecord::getError()
{
	TRACE_U(("WSCdbSQLiteRecord::getError start"));

	sprintf((char*)_szSqlState, "%05d", sqlite3_errcode(_pDB->_hconn));
	memset(_szErrorMsg, '\0', sizeof(_szErrorMsg));
	strncpy((char*)_szErrorMsg, sqlite3_errmsg(_pDB->_hconn), sizeof(_szErrorMsg)-1);

	TRACE_U(("WSCdbSQLiteRecord::getError State:%s messgae:%s", _szSqlState, _szErrorMsg));
	TRACE_U(("WSCdbSQLiteRecord::getError end"));
}

void WSCdbSQLiteRecord::getErrorMsg(char* szState, char* szMsg)
{
	TRACE_U(("WSCdbSQLiteRecord::getErrorMsg start"));

	strcpy(szState, (char*)_szSqlState);
	strcpy(szMsg, (char*)_szErrorMsg);

	TRACE_U(("WSCdbSQLiteRecord::getErrorMsg start"));
}
char* WSCdbSQLiteRecord::makeINSERT()
{
	static WSCstring str;
	str = "insert into ";
	str << _tableName;
	str << "(";
	int i;
	for(i = 0; i < _Cols-1; i++) {
		str << (char*)_fd[i].colName;
		if(i < _Cols-2) {
			str << ",";
		}
	}
	str << ") values(";
	for(i = 0; i < _Cols-1; i++) {
		str << getSqlString(i);
		if(i < _Cols-2) {
			str << ",";
		}
	}
	str << ")";
	TRACE_U(("makeINSERT:%s", str.getString()));
	return str.getString();
}
char* WSCdbSQLiteRecord::makeUPDATE()
{
	static WSCstring str;

	str = "update ";
	str << _tableName;
	str << " set ";
	for(int i = 0; i < _Cols-1; i++) {
		str << (char*)_fd[i].colName;
		str << "=";
		str << getSqlString(i);
		if(i < _Cols-2) {
			str << ",";
		}
	}
	str << " where rowid = ";
	str << (char*)_fd[0].buff;
	TRACE_U(("makeUPDATE:%s", str.getString()));
	return str.getString();
}
char*  WSCdbSQLiteRecord::makeDELETE()
{
	static WSCstring str;

	str = "delete from ";
	str << _tableName;
	str << " where rowid = ";
	str << (char*)_fd[_Cols-1].buff;
	TRACE_U(("makeDELETE:%s", str.getString()));
	return str.getString();
}
void WSCdbSQLiteRecord::getTableName(char* p, char* tbl, int size)
{
	char buf[7];
	buf[6] = '\0';
	*tbl = '\0';
	for(; *p != '\0'; p++) {
		if(*p != ' ') {
			continue;
		}
		strncpy(buf, p, 6);
		if(WSGFstricmp(buf, " FROM ") == 0) {
			int j = 0;
			char* s1 = p + 6;
			for(j = 0; (*s1 != '\0') &&  j < size; s1++) {
				if(*s1 == ' ') {
					if(tbl[0] != '\0') {
						tbl[j] = '\0';
						break;
					}
				} else if(*s1 != '(' && *s1 != ')') {
					tbl[j++] = *s1;
				}
			}
			break;
		}
	}
}
int WSCdbSQLiteRecord::getBufflen(int type)
{
	if(type == WSCDB_FIELD_TYPE_CHAR) {
		return 32767;
	} else
	if(type == WSCDB_FIELD_TYPE_INTEGER) {
		// SQL_INTEGER long int
		return 11 + 1;
	} else

	if(type == WSCDB_FIELD_TYPE_REAL) {
		// SQL_FLOAT, SQL_DOUBLE float
		return 22 + 1;
	}

	return 32767;
}
char* WSCdbSQLiteRecord::getSqlString(int i)
{
	static WSCstring str;
	str = "";

	if(_fd[i].colType == WSCDB_FIELD_TYPE_INTEGER) {
		str << (char*)_fd[i].buff;
	} else
	if(_fd[i].colType == WSCDB_FIELD_TYPE_REAL) {
		str << (char*)_fd[i].buff;
	} else {
		str << "'" << decode((char*)_fd[i].buff) << "'";
	}

	return str.getString();
}
void WSCdbSQLiteRecord::encode(char* buf, char* str)
{
	long encodeing = WSGIappLocaleSet()->getDefaultEncoding();
	if(_encoding != encodeing && _encoding != -1) {
		WSCstring s(buf,  _encoding);
		strcpy(str, s.getString(encodeing));
	TRACE_U(("encode buf:%s\n", buf));
	TRACE_U(("encode str:%s\n", str));
	} else if(buf) {
		strcpy(str, buf);
	} else {
		*str = '\0';
	}
}
char* WSCdbSQLiteRecord::decode(char* buf)
{
	long decode = WSGIappLocaleSet()->getDefaultEncoding();
	static WSCstring s;
	s = buf;
	if(_encoding != decode && _encoding != -1) {
	TRACE_U(("decode buf:%s\n", buf));
	TRACE_U(("decode str:%s\n", s.getString(_encoding)));
		return s.getString(_encoding);
	}
	return s.getString();
}
char* WSCdbSQLiteRecord::getSelectSQL(const char* p, long rowiduse)
{
	char* buf = new char[strlen(p) + 256];
	char  buf1[7];
	char  buf2[256];
	buf1[6] = '\0';
	if(rowiduse == 1) {
		for(int i = 0; *p != '\0'; p++, i++) {
			if(*p == ' ') {
				strncpy(buf1, p, 6);
				if(WSGFstricmp(buf1, " FROM ") == 0) {
					sprintf(buf2, ",%s.rowid as _rowid_rowuse_", _tableName);
					strcpy(&buf[i], buf2);
					strcat(buf, p);
					break;
				}
			}
			buf[i] = *p;
		}
	} else {
		strcpy(buf, p);
	}
	return buf;
}

WSCstring WSCdbSQLiteRecord::getErrorMessage()
{
  WSCstring ret;
  char stat[10];
  char buf[SQLITE_MAX_MESSAGE_LENGTH+1];
  getErrorMsg(stat,buf);
  char buf2[SQLITE_MAX_MESSAGE_LENGTH+1+32];
  sprintf(buf2,"state: %s ,message: %s",stat,buf);
  ret.setString(buf2);
  return ret;
}
long WSCdbSQLiteRecord::isNull(long index)
{
	if(index < 0 || index >= (_Cols-_rowiduse)) {
		return -1;
	}
	return (*((char*)_fd[index].buff) == '\0' ? True : False);
}
long WSCdbSQLiteRecord::isNull(const char* name)
{
	return isNull(getColIndex(name));
}

