//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSDappDev.h>
#include <WSCwindow.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSDprivateTimer.h>
#include <unistd.h>
#include <WSCvbtn.h>
#include <WSCvmeter.h>
WSCwindow* newpic000;
WSCvmeter* meter1;

#define WS_WIDTH  400
#define WS_HEIGHT 128

void timerp(void*){
static long no = 0;
  meter1->setProperty(WSNvalue1,no*4);
  meter1->redraw();
  no++;
  if (no > 25){
#ifdef MSW
    _sleep(1000);
#else
    sleep(1);
#endif
    WSGFexit(0);
  }
}

void _create_pic_newpic000(){
  newpic000 = new  WSCwindow(NULL,"newpic000");
  newpic000->initialize();
  long w = WSGIappDev()->getWidth();
  long h = WSGIappDev()->getHeight();
  newpic000->setPropertyV(WSNx,(short)((w -WS_WIDTH)/2));
  newpic000->setPropertyV(WSNy,(short)((h -WS_HEIGHT)/2));
  newpic000->setPropertyV(WSNwidth,(unsigned short)WS_WIDTH);
  newpic000->setPropertyV(WSNheight,(unsigned short)WS_HEIGHT);
  newpic000->setPropertyV(WSNtitleBar,WS_NO_MANAGE);
//  newpic000->setPropertyV(WSNbackPixmap,"t1.jpg");
//  newpic000->setPropertyV(WSNbackColor,"#000000");
  newpic000->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  newpic000->setProperty(WSNindicatorOn,False);

  WSCvariant num;
  long t = 1;
  char buf[1024];
  sprintf(buf,"$(WSDIR)/sys/pixmaps/wtitle/files.dat");
  WSCstring* str = WSGFreadTextFile(buf);
  if (str != NULL){
    num = str->getString();
    delete str;
    long v = num.getLong();
    if (v < 1){
      v = 1;
    }else{
      long val = WSGFclocktime();
      t = (val/1000) % v;
    }
  }

  sprintf(buf,"$(WSDIR)/sys/pixmaps/wtitle/t%d.jpg",t);
  newpic000->setPropertyV(WSNbackPixmap,buf);
  newpic000->setVisible(True);

  meter1 = new WSCvmeter(newpic000,"meter1");
  meter1->initialize();
  meter1->setProperty(WSNx,20);
  meter1->setProperty(WSNy,WS_HEIGHT - 30);
  meter1->setProperty(WSNwidth,150);
  meter1->setProperty(WSNheight,20);
  meter1->setProperty(WSNvalue2,0);
  meter1->setProperty(WSNvalue1,0);
  meter1->setProperty(WSNforeColor,"#000000");
  meter1->setProperty(WSNstippled,True);
  meter1->setProperty(WSNhatchColor,"#606060");
  meter1->setVisible(True);

  WSCvlabel* vl = new WSCvlabel(newpic000,"vl");
  vl->initialize();
  vl->setProperty(WSNx,20);
  vl->setProperty(WSNy,WS_HEIGHT -50);
  vl->setProperty(WSNwidth,100);
  vl->setProperty(WSNheight,20);
  vl->setProperty(WSNalignmentH,WS_LEFT);
  vl->setProperty(WSNforeColor,"#000000");
  vl->setProperty(WSNlabelString,"Processing...");
  vl->setProperty(WSNshadowType,WS_SHADOW_TRANS);
  vl->setVisible(True);

  WSDprivateTimer* timer = WSDprivateTimer::getNewInstance();
  timer->setWorkProc(timerp,NULL);
  timer->setCont(True);
  timer->setRate(50);
  timer->startTimer();
}
