//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#ifndef _WSWINCE

#include <WScom.h>
#include <WSDappDev.h>
#include <WSCbaseDialog.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSCvlabel.h>
#include <WSCoption.h>
#include <WSCfontSet.h>
#include <WSDfont.h>
#include <WSCclassInformation.h>
#include <win/WSDwinFontSelect.h>
#include <win/WSDwinAppDev.h>
#include <WSClocaleSet.h>

WSMFguiClassInitialize(WSDwinFontSelect,WSCbaseDialog);

WSMFpropertyValueChange(WSDwinFontSelect,WSNtitleBar,char,WS_ONLY_TITLE);

static void _winfonts_init_(){
WSMFtrace("WSDwinFontSelect.c: _winfonts_init() start..\n");
  WSCbase* fonteditor = new WSDwinFontSelect(NULL,"font-editor");
  fonteditor->initialize();
//  fonteditor->setPropertyV(WSNx,(short)400);
//  fonteditor->setPropertyV(WSNy,(short)300);
  WSGFsetFontEditor(fonteditor);
WSMFtrace("WSDwinFontSelect.c: _winfonts_init() done..\n");
}

class _winfontselect_init_ {
  public:
    _winfontselect_init_(){
       WSGIappDev()->setInitHandler(_winfonts_init_);
    };
};
static _winfontselect_init_ _xfs_execute_;

#ifdef WS_EE
#define DEFAULT_FONT_SET  "13,0,0,0,400,0,0,0,128,3,2,1,1,Courier New"
#else
//#define DEFAULT_FONT_SET  "13,0,0,0,400,0,0,0,128,3,2,1,1,~Bl~Br ~CS~CV~Cb~CN"
#define DEFAULT_FONT_SET  "13,0,0,0,400,0,0,0,X,3,2,1,1,NULL"
#endif


WSDwinFontSelect::WSDwinFontSelect(WSCbase* base,char* objName):
WSCbaseDialog(base,objName){
WSMFtrace("WSDwinFontSelect::WSDwinFontSelect() start..\n");
  _font_name = WSGFstrdup(DEFAULT_FONT_SET);
  _target_name = WSGFstrdup("");
  _rep = NULL;
  _font_no = 0;

  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNfontName,char*,_font_name,WSSfontName);
    WSMFpropertyCreate(WSNtype,char*,_target_name,WSStype);
    WSMFpropertyCreate(WSNfont,WSCuchar,_font_no,WSSfont);

    WSMFpropertyValueChangeDef(WSDwinFontSelect,WSNtitleBar,char);
    WSMFpropertyDelete(WSNpixmapStyle);
    WSMFpropertyVisibleOff(WSNwidth);
    WSMFpropertyVisibleOff(WSNheight);
    WSMFaddTrigger(3);
  WSMFpropertyCreateEnd
WSMFtrace("WSDwinFontSelect::WSDwinFontSelect() done..\n");
}
WSMFproperty(WSDwinFontSelect,WSNfontName,char*,_font_name,WSGFstrdup(DEFAULT_FONT_SET));

void WSDwinFontSelect::setWorkWSNfontName(char* data){
  WSCstring str(data);
  long e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12,e13;
  char fname1[LF_FACESIZE+1024];
  if (_target_name != NULL && _target_name[0] != 0){
    WSDfont* defaultf = WSGIappFontSet()->getFont(8);
    if (defaultf != NULL){
      char* fname2 = defaultf->getSrc();
      sscanf(fname2,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%s",
      &e1, &e2, &e3, &e4, &e5, &e6, &e7, &e8, &e9, &e10, &e11,
      &e12, &e13, fname1);

      char dust[1024]; 
      sscanf(data,"%d,%s",&e1,dust);

      _lgfont.lfHeight = e1;
      _lgfont.lfWidth = e2;
      _lgfont.lfEscapement = e3;
      _lgfont.lfOrientation = e4;
      _lgfont.lfWeight = e5;
      _lgfont.lfItalic = e6;
      _lgfont.lfUnderline = e7;
      _lgfont.lfStrikeOut = e8;
      _lgfont.lfCharSet = e9;
      _lgfont.lfOutPrecision = e10;
      _lgfont.lfClipPrecision = e11;
      _lgfont.lfQuality = e12;
      _lgfont.lfPitchAndFamily = e13;
    }
  }else{

    sscanf(data,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%s",
       &e1, &e2, &e3, &e4, &e5, &e6, &e7, &e8, &e9, &e10, &e11,
       &e12, &e13, fname1);

    _lgfont.lfHeight = e1;
    _lgfont.lfWidth = e2;
    _lgfont.lfEscapement = e3;
    _lgfont.lfOrientation = e4;
    _lgfont.lfWeight = e5;
    _lgfont.lfItalic = e6;
    _lgfont.lfUnderline = e7;
    _lgfont.lfStrikeOut = e8;
    _lgfont.lfCharSet = e9;
    _lgfont.lfOutPrecision = e10;
    _lgfont.lfClipPrecision = e11;
    _lgfont.lfQuality = e12;
    _lgfont.lfPitchAndFamily = e13;
    strcpy(_lgfont.lfFaceName,fname1);
  }
}

void WSDwinFontSelect::getWorkWSNfontName(char** fn){
}

WSMFproperty(WSDwinFontSelect,WSNtype,char*,_target_name,WSGFstrdup(""));
void WSDwinFontSelect::setWorkWSNtype(char* data){}
void WSDwinFontSelect::getWorkWSNtype(char** fn){}

WSMFproperty(WSDwinFontSelect,WSNfont,WSCuchar,_font_no,0);
void WSDwinFontSelect::setWorkWSNfont(WSCuchar data){
  WSDfont* font = WSGIappFontSet()->getFont((short)data);
  if (font != NULL){
    setWorkWSNfontName(font->getFontName());
  }
}
void WSDwinFontSelect::getWorkWSNfont(WSCuchar* data){}


WSDwinFontSelect::~WSDwinFontSelect(){
  delete _target_name;
  delete _font_name;
}

long WSDwinFontSelect::initialize(){
WSMFtrace("WSDwinFontSelect::initialize() start..\n");
  WSCbaseDialog::initialize();
WSMFtrace("WSDwinFontSelect::initialize() done..\n");
  return WS_NO_ERR;
}

void WSDwinFontSelect::onVisibleChange(WSCbool fl){
}

long WSDwinFontSelect::popup(){
  CHOOSEFONT cf;
  cf.lStructSize = sizeof(CHOOSEFONT);
  cf.hwndOwner = NULL;
  cf.hDC = NULL;
  cf.lpLogFont = &_lgfont;
  cf.iPointSize = 0;
  cf.Flags = CF_INITTOLOGFONTSTRUCT | CF_SCREENFONTS | CF_EFFECTS;
  cf.rgbColors = 0L;
  cf.lCustData = 0L;
  cf.lpfnHook = NULL;
  cf.lpTemplateName = NULL;
  cf.hInstance = NULL;
  cf.lpszStyle = NULL;
  cf.nFontType = 0;
  cf.nSizeMin = 0;
  cf.nSizeMax = 0;
  long ret = ChooseFont(&cf);
  if (ret != 0){
    HDC dc = GetDC(WSGIwinAppDev()->getHWND());
    long h = -MulDiv(_lgfont.lfHeight,72,GetDeviceCaps(dc,LOGPIXELSY));
    ReleaseDC(WSGIwinAppDev()->getHWND(),dc);

    WSCstring fn;
    fn.setString(_lgfont.lfFaceName,WSGIappLocaleSet()->getSystemLocaleEncoding());
    WSCstring data;
    data << h << ","
         << (long)_lgfont.lfWidth  << ","
         << _lgfont.lfEscapement << ","
         << _lgfont.lfOrientation << ","
         << _lgfont.lfWeight << ","
         << _lgfont.lfItalic << ","
         << _lgfont.lfUnderline << ","
         << _lgfont.lfStrikeOut << ","
         << _lgfont.lfCharSet << ","
         << _lgfont.lfOutPrecision << ","
         << _lgfont.lfClipPrecision << ","
         << _lgfont.lfQuality << ","
         << _lgfont.lfPitchAndFamily << ","
         << fn.getString(WS_EN_DEFAULT);
    if (_target_name != NULL && _target_name[0] != 0){
      data << h << " 60c6";
    }
    delete _font_name;
    _font_name = WSGFstrdup((char*)data);
    WSDfont* font = WSGIappFontSet()->getFont(_font_no);
    if (font != NULL){
      font->setFontName(_font_name);
    }
    return WS_DIALOG_OK;
  }
  return WS_DIALOG_CANCEL;
}
#endif
