//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <win/WSDwinSemaphore.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDwinSemaphore,WSDsemaphore);

WSDsemaphore* _win_sem_chandler(){
  return new WSDwinSemaphore;
}

void WSGFinitializeWinSemaphore(){
    WSDsemaphore::setCreateInstanceHandler((void*)_win_sem_chandler);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _win_sem_init {
  public: _win_sem_init(){
    WSGFinitializeWinSemaphore();
  };
};
_win_sem_init  _win_sem_init_execute;
#endif

WSDwinSemaphore::WSDwinSemaphore(){
  _sem = NULL;
}

WSDwinSemaphore::~WSDwinSemaphore(){
  destroy();
}

long WSDwinSemaphore::initialize(){
  destroy();
  _sem = CreateSemaphore(NULL,1,1024,NULL);
  return WS_NO_ERR;
}
long WSDwinSemaphore::lock(){
  WaitForSingleObject(_sem,INFINITE);
  return WS_NO_ERR;
}

long WSDwinSemaphore::unlock(){
  DWORD cnt;
  ReleaseSemaphore(_sem,1,(long int*)&cnt);
  return WS_NO_ERR;
}

long WSDwinSemaphore::destroy(){
  if (_sem != NULL){
    CloseHandle(_sem);
    _sem = NULL;
  }
  return WS_NO_ERR;
}




