//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <win/WSwincom.h>
#include <win/WSDwinAppDev.h>
#include <WSCstring.h>
#include <WSClocaleSet.h>
#ifdef _WSWINCE
#define strdup _strdup
#endif

#ifndef WS_NWIN
extern "C" {
void libwswin_func();
};
void libwswin_func(){
}
#else
extern "C" {
void libwsnwin_func();
};
void libwsnwin_func(){
}
#endif

WSDLEX32 int _system(char* cmdname){
  int len = strlen(cmdname);
  char* str = strdup(cmdname);
  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  ZeroMemory(&si,sizeof(STARTUPINFO));
  ZeroMemory(&pi,sizeof(PROCESS_INFORMATION));
  si.cb = sizeof(STARTUPINFO);
#ifndef _WSWINCE
  si.dwFlags = STARTF_USESHOWWINDOW;
#else
  si.dwFlags = 0;
#endif
  si.wShowWindow = SW_SHOWNORMAL;
  if (str[len-1] == '&'){
    str[len-1] = ' ';
    WSCstring tmp(str);
    tmp.delHeadSpace();
    tmp.delTailSpace();
WSMFtrace("_system #%s#\n",(char*)tmp);
//    CreateProcess(NULL,(char*)tmp,NULL,NULL,FALSE,DETACHED_PROCESS,NULL,NULL,&si,&pi);
#ifndef _WSWINCE
    CreateProcess(NULL,
       tmp.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
       NULL,NULL,FALSE,0,NULL,NULL,&si,&pi);
#else
    WSCushort* tmpstr = WSGFgetUCS2(tmp,WS_EN_DEFAULT);
    CreateProcess(NULL,tmpstr,
       NULL,NULL,FALSE,0,NULL,NULL,&si,&pi);
    delete tmpstr;
#endif
    free(str);
    if (pi.hProcess == 0){
      return -1;
    }
    return 0;
  }else{
WSMFtrace("_system #%s#\n",(char*)str);
//    CreateProcess(NULL,str,NULL,NULL,FALSE,DETACHED_PROCESS,NULL,NULL,&si,&pi);
    WSCstring tmp(str);
    tmp.delHeadSpace();
    tmp.delTailSpace();
#ifndef _WSWINCE
    CreateProcess(NULL,
       tmp.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
       NULL,NULL,FALSE,0,NULL,NULL,&si,&pi);
#else
    WSCushort* tmpstr = WSGFgetUCS2(tmp,WS_EN_DEFAULT);
    CreateProcess(NULL,tmpstr,
       NULL,NULL,FALSE,0,NULL,NULL,&si,&pi);
#endif
    free(str);
    if (pi.hProcess == 0){
WSMFtrace("_system error\n");
      return -1;
    }
#ifndef _WSWINCE
    WaitForInputIdle(pi.hProcess,INFINITE);
#endif
//    WaitForInputIdle(GetCurrentProcess(),5000);
    DWORD ret = STILL_ACTIVE;
    while(ret == STILL_ACTIVE){
      WaitForSingleObject(pi.hProcess,1000);
      GetExitCodeProcess(pi.hProcess,&ret);
    } 
    return ret;
  }
}
WSDLEX32 int _system_console(char* cmdname){
  int len = strlen(cmdname);
  char* str = strdup(cmdname);
  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  ZeroMemory(&si,sizeof(STARTUPINFO));
  ZeroMemory(&pi,sizeof(PROCESS_INFORMATION));
  si.cb = sizeof(STARTUPINFO);
#ifndef _WSWINCE
  si.dwFlags = STARTF_USESHOWWINDOW;
#else
  si.dwFlags = 0;
#endif
  si.wShowWindow = SW_SHOWNORMAL;
  if (str[len-1] == '&'){
    str[len-1] = ' ';
    WSCstring tmp(str);
    tmp.delHeadSpace();
    tmp.delTailSpace();
WSMFtrace("_system #%s#\n",(char*)tmp);
#ifndef _WSWINCE
    CreateProcess(NULL,(char*)tmp,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi);
#else
    WSCushort* tmpstr = WSGFgetUCS2(tmp,WS_EN_DEFAULT);
    CreateProcess(NULL,tmpstr,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi);
    delete tmpstr;
#endif
    free(str);
    if (pi.hProcess == 0){
      return -1;
    }
    return 0;
  }else{
#ifndef _WSWINCE
    CreateProcess(NULL,str,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi);
#else
    WSCushort* tmpstr = WSGFgetUCS2(str,WS_EN_DEFAULT);
    CreateProcess(NULL,tmpstr,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi);
    delete tmpstr;
#endif
    free(str);
    if (pi.hProcess == 0){
      return -1;
    }
#ifndef _WSWINCE
    WaitForInputIdle(pi.hProcess,INFINITE);
#endif
//    WaitForInputIdle(GetCurrentProcess(),5000);
    DWORD ret = STILL_ACTIVE;
    while(ret == STILL_ACTIVE){
      WaitForSingleObject(pi.hProcess,1000);
      GetExitCodeProcess(pi.hProcess,&ret);
    } 
    return ret;
  }
}
struct _create_window{
  DWORD style_ex;
  char* app;
  char* title;
  DWORD style;
  int x;
  int y;
  WSCushort w;
  WSCushort h;
  HWND parent;
  HMENU ptr1;
  HINSTANCE inst;
  void* ptr2;
};

#ifndef _WSWINCE
HWND WSGFcreateWindow(char* app,char* title,DWORD style,
                        int x, int y, int w, int h,HWND parent,
                        HMENU ptr1,
                        HINSTANCE inst,void* ptr2){
  if (WSGIwinAppDev()->getAppThreadId() == GetCurrentThreadId()){
    return CreateWindow( app,title,style,x,y,w,h,parent,
                           ptr1,inst,ptr2);
  }
  _create_window val;
  val.style_ex = 0;
  val.app = app;
  val.title = title;
  val.style = style;
  val.x = x;
  val.y = y;
  val.w = w;
  val.h = h;
  val.parent = parent;
  val.ptr1 = ptr1;
  val.inst = inst;
  val.ptr2 = ptr2;
  HWND ret = (HWND)SendMessage(WSGIwinAppDev()->getHWND(),WM_CREATE_NEW_WINDOW,
                     (WPARAM)&val,(LPARAM)NULL);
//printf("WSGFcreateWindow wnd=0x%x\n",ret);
//fflush(stdout);
  return ret;
}

HWND WSGFcreateWindowEx(DWORD style_ex,char* app,char* title,DWORD style,
                        int x, int y, int w, int h,HWND parent,
                        HMENU ptr1,
                        HINSTANCE inst,void* ptr2){
  if (WSGIwinAppDev()->getAppThreadId() == GetCurrentThreadId()){
    return CreateWindowEx( style_ex,app,title,style,x,y,w,h,parent,
                           ptr1,inst,ptr2);
  }
  _create_window val;
  val.style_ex = style_ex;
  val.app = app;
  val.title = title;
  val.style = style;
  val.x = x;
  val.y = y;
  val.w = w;
  val.h = h;
  val.parent = parent;
  val.ptr1 = ptr1;
  val.inst = inst;
  val.ptr2 = ptr2;
  HWND ret = (HWND)SendMessage(WSGIwinAppDev()->getHWND(),WM_CREATE_NEW_WINDOW_EX,
                     (WPARAM)&val,(LPARAM)NULL);
//printf("WSGFcreateWindowEx wnd=0x%x\n",ret);fflush(stdout);
  return ret;
}
void WSGFreplyCreateWindowRequestEx(void* pt){
  _create_window* ptr = (_create_window*)pt;
  HWND ret = CreateWindowEx( ptr->style_ex,ptr->app,ptr->title,ptr->style,
                              ptr->x,ptr->y,ptr->w,ptr->h,ptr->parent,
                              ptr->ptr1,ptr->inst,ptr->ptr2);
//printf("WSGFreplyCreateWindowRequest win=0x%x tid=0x%x\n",GetCurrentThreadId());fflush(stdout);
  ReplyMessage((DWORD)ret);
}
void WSGFreplyCreateWindowRequest(void* pt){
  _create_window* ptr = (_create_window*)pt;
  HWND ret = CreateWindow (ptr->app,ptr->title,ptr->style,
                           ptr->x,ptr->y,ptr->w,ptr->h,ptr->parent,
                           ptr->ptr1,ptr->inst,ptr->ptr2);
//printf("WSGFreplyCreateWindowRequest win=0x%x tid=0x%x\n",GetCurrentThreadId());fflush(stdout);
  ReplyMessage((DWORD)ret);
}
BOOL WSGFdestroyWindow(HWND target){
  if (WSGIwinAppDev()->getAppThreadId() == GetCurrentThreadId()){
//printf("WSGFdestroyWindow destroyed.. target=0x%x\n",target);
    return DestroyWindow( target);
  }
  BOOL ret = (BOOL)SendMessage(WSGIwinAppDev()->getHWND(),WM_DESTROY_WINDOW,
                     (WPARAM)target,(LPARAM)NULL);
//printf("WSGFdestroyWindow reply=%d.. target=0x%x\n",ret,target);
  return ret;
}
void WSGFreplyDestroyWindowRequest(HWND target){
  BOOL ret =DestroyWindow(target);
//printf("WSGFreplyDestroyWindowRequest destroyed.. target=0x%x ret=%d\n",target,ret);
  ReplyMessage((DWORD)ret);
}
#else //_WSWINCE
BOOL WSGFdestroyWindow(HWND target){
  return DestroyWindow( target);
}
#endif
