//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <win/WSDwinAppDev.h>
#include <win/WSDwinColor.h>
#include <win/WSDwinMouse.h>
#include <WSCcolorSet.h>
#include <win/WSDwindraw.h>
#include <WSDdev.h>
#include <WSCbaseList.h>

HINSTANCE hInst;
char szAppName[] = "Wide Studio Application";
char szTitle[]= "Wide Studio Application";

extern LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM uParam,LPARAM lParam);
//extern "C" {
//int WINAPI _cygwin_dll_entry(HANDLE h,DWORD reason,void* foo){
//  return 1;
//};
//};
BOOL InitApplication(HINSTANCE hInstance){
  WNDCLASS wc;
#ifndef _WSWINCE
  wc.style = CS_HREDRAW | CS_VREDRAW | CS_SAVEBITS;
#else
  wc.style = CS_HREDRAW | CS_VREDRAW;
#endif
  wc.lpfnWndProc = (WNDPROC)WndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInstance;
WSMFtrace("XXZZim1 WinMan1 icon=0x%x  hinst=0x%x\n",wc.hIcon,hInstance);
#ifndef _WSWINCE
  wc.hIcon = LoadIcon(hInstance,(char*)101);
#else
  wc.hIcon = LoadIcon(hInstance,(WSCushort*)101);
#endif
  if (wc.hIcon == NULL){
#ifndef _WSWINCE
    wc.hIcon = (HICON)::LoadImage(NULL,"main.ico",IMAGE_ICON,0,0,LR_LOADFROMFILE);
#else
    WSCushort* tmps = WSGFgetUCS2("main.ico",WS_EN_DEFAULT);
    wc.hIcon = (HICON)::LoadImage(NULL,tmps,IMAGE_ICON,0,0,0);
    delete tmps;
#endif
WSMFtrace("XXZZim1 WinMan2 icon=0x%x\n",wc.hIcon);
//    wc.hIcon = LoadIcon(hInstance,szAppName);
//    wc.hIcon = (HICON)::LoadImage(hInstance,(char*)101,IMAGE_ICON,0,0,LR_DEFAULTCOLOR);
  }
#ifndef _WSWINCE
  wc.hCursor = LoadCursor(NULL,IDC_ARROW);
#else
  wc.hCursor = 0;
#endif
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW +1);
#ifndef _WSWINCE
  wc.lpszMenuName = szAppName;
  wc.lpszClassName = szAppName;
#else
dbprintf("InitApp %s:%d szAppName=%s\n",__FILE__,__LINE__,szAppName);
  WSCushort* tmpstr = WSGFgetUCS2(szAppName,WS_EN_DEFAULT);
  wc.lpszMenuName = 0;
  wc.lpszClassName = tmpstr;
#endif
  int ret = RegisterClass(&wc);
dbprintf("InitApp %s:%d ret=%d\n",__FILE__,__LINE__,ret);
  return ret;
}

HWND hWnd;
BOOL InitInstance(HINSTANCE hInstance,int nCmdShow){
  hInst = hInstance;
#ifndef _WSWINCE
  hWnd = CreateWindow(szAppName,szTitle,WS_OVERLAPPEDWINDOW,
                 CW_USEDEFAULT,0,
                 CW_USEDEFAULT,0,
                 NULL,NULL,
                 hInstance,NULL);
#else
  WSCushort* tmps = WSGFgetUCS2(szAppName,WS_EN_DEFAULT);
  WSCushort* tmps2 = WSGFgetUCS2(szTitle,WS_EN_DEFAULT);
  hWnd = CreateWindow(tmps,tmps2,WS_CLIPCHILDREN,
                 CW_USEDEFAULT,CW_USEDEFAULT,
                 CW_USEDEFAULT,CW_USEDEFAULT,
                 NULL,NULL,
                 hInstance,NULL);
  delete tmps;
  delete tmps2;
dbprintf("InitInstance %s:%d hWnd=0x%x\n",__FILE__,__LINE__,hWnd);
  UpdateWindow(hWnd);
#endif
  if (!hWnd) return FALSE;
//  ShowWindow(hWnd,nCmdShow);
//  UpdateWindow(hWnd);
  return TRUE;
}

int app_type = WS_APP_TYPE_GENERIC;
int _win_main2(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow){

  WSDdev::setDraw(new WSDwindraw());

WSMFtrace("main start:\n");
dbprintf("_win_main2 %s:%d start hPrevInstance=0x%x\n",__FILE__,__LINE__,hPrevInstance);
#ifndef _WSWINCE
  if (!hPrevInstance){
#endif
    if (!InitApplication(hInstance)){
      if (WSGIappDev()->getMode() == WS_MODE_NORMAL){
dbprintf("_win_main2 %s:%d done1 appdev=0x%x\n",__FILE__,__LINE__,WSGIappDev());
//TEST
//        return (FALSE);
      }
    }
#ifndef _WSWINCE
  }
#endif
  if (!InitInstance(hInstance,nCmdShow)){
dbprintf("_win_main2 %s:%d done2 hInsntace=0x%x\n",__FILE__,__LINE__,hInstance);
    return FALSE;
  }

  WSDwinAppDev* winApp = WSGIwinAppDev();
dbprintf("_win_main2 %s:%d winapp=0x%x\n",__FILE__,__LINE__,winApp);
  winApp->setInitPrm(lpCmdLine);
  winApp->setWnd(hWnd);
  winApp->setInstanceHandle(hInstance);
  winApp->initialize();


   WSGIwinAppMouse()->initialize();
WSMFtrace("main 1:\n");


//printf("cmd=#%s#",GetCommandLine());
#ifndef _WSWINCE
   char* cmd = WSGFstrdup(GetCommandLine());
#else
   char* cmd = WSGFgetString(GetCommandLine(),WS_EN_DEFAULT);
#endif
   long len = strlen(cmd)+1;
   long i;
   WSClistData plist;
   long qfl = 0;
   long ptr = 0;
   long word = 0;
   for(i=0; i<len; i++){
     if (qfl == 0 && cmd[i] == '\"'){
       qfl =1;
       word = 1;
       ptr = i+1;
     }else
     if (qfl == 1 && cmd[i] == '\"'){
       qfl =0;
       cmd[i] = 0;
       char* pr = WSGFstrdup(&cmd[ptr]);
       plist.add((void*)pr);
       word = 0;
     }else
     if (qfl == 0 && (cmd[i] == ' ' || cmd[i] == 0 || cmd[i] == '\t' || i == len -1) && word != 0){
       cmd[i] = 0;
       char* pr = WSGFstrdup(&cmd[ptr]);
       plist.add((void*)pr);
       word = 0;
     }else
     if (word == 0 && cmd[i] != ' ' && cmd[i] != 0 && cmd[i] != '\t'){
       ptr = i;
       word = 1;
     }
   }
   long lines = plist.getNum();
   char** cprm = new char*[lines+1];
   for(i=0; i<lines; i++){
     cprm[i] = (char*)plist[i];
//printf("#%s#\n",cprm[i]);
   } 
   cprm[lines] = NULL;
   winApp->setInitPrm(lines,cprm);
   delete cmd;
 
WSMFtrace("main 2:\n");

dbprintf("_win_main2 %s:%d done\n",__FILE__,__LINE__);
   return 0;
}
extern WSDLEX int WSGFwsInitialize();
extern WSDLEX int WSGFwsInitialize2(int type);
int WSGFwsInitialize2(int type){
  app_type = type;
  return WSGFwsInitialize();
}
int WSGFwsInitialize(){
static long cnt = 0;
  HINSTANCE hInst = GetModuleHandle(NULL);
dbprintf("WSGFwsInitialize() %s:%d start hInst=0x%x cnt=%d\n",__FILE__,__LINE__,hInst,cnt);
cnt++;
#ifndef _WSWINCE
  LPSTR cmd = GetCommandLine();
  _win_main2(hInst,NULL,cmd,TRUE);
#else
  LPSTR cmd = WSGFgetString(GetCommandLine(),WS_EN_DEFAULT);
  _win_main2(hInst,NULL,cmd,TRUE);
  delete cmd;
#endif
  
  return 0;
}

extern "C" {
WSDLEX32 int WSGFwsMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow){
  _dbprintf_init();
  _win_main2(hInstance,hPrevInstance,lpCmdLine,nCmdShow);


  WSDwinAppDev* winApp = WSGIwinAppDev();
  winApp->execInitHandler();
  WSGIappObjectList()->execInitialize();
  winApp->handleEvents();
  return 0;
}
#ifndef NO_MAIN_FUNCTION
WSDLEX32 int _win_main(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow){
  return WSGFwsMain(hInstance,hPrevInstance,lpCmdLine,nCmdShow);
}
#endif
};
