//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#ifndef _XUNICODE_H_
#define _XUNICODE_H_

#ifdef WIN32
#include <windows.h>
extern BOOL xunicode_enable;
typedef wchar_t XUChar;
#else
#include <X11/Xlib.h>
#include <X11/Xutil.h>
extern Bool xunicode_enable;
typedef unsigned short XUChar;
#endif

#define XU_FONT_COUNT      24
#define XU_FONT_NONE        0
#define XU_FONT_ISO8859(n) (n) /* 1-15 */
#define XU_FONT_UNICODE    16
#define XU_FONT_KOI8R      17
#define XU_FONT_JIS0201    18
#define XU_FONT_JIS0208    19
#define XU_FONT_KSC5601    20
#define XU_FONT_GB2312     21
#define XU_FONT_BIG5       22
#define XU_FONT_CP1251     23

#define XU_CONV_LOCALE     -1
#define XU_CONV_NONE        0
#define XU_CONV_ISO8859(n) (n) /* 1-15 */
#define XU_CONV_UTF8       16
#define XU_CONV_KOI8R      17
#define XU_CONV_EUCJP      20
#define XU_CONV_SJIS       21
#define XU_CONV_EUCKR      30
#define XU_CONV_EUCCN      40
#define XU_CONV_BIG5       50
#define XU_CONV_CP1251     60

void XUInit();

XUChar XUCharEncode(const char* text, int max, int code,int* rlen);
int XUCharDecode(char* dest, int max, XUChar ch, int code);
int XUCharLen(const char* text, int max, int code);
XUChar XUutf8CharEncode(const char* text, int max,int* rlen);
int XUutf8CharDecode(char* dest, int max, XUChar ch);
int XUutf8CharLen(const char* text, int max);
int XUutf8CharRLen(const char* text, int max);
int XUStrLen(const XUChar* text);
int XUEncode(XUChar* dest, int max, const char* text, int length, int code);
int XUDecode(char* dest, int max, const XUChar* text, int length, int code);
int XULen(const char* text, int max, int code);
int XUutf8Encode(XUChar* dest, int max, const char* text, int length);
int XUutf8Decode(char* dest, int max, const XUChar* text, int length);
int XUutf8Len(const char* text, int max);
int XUCodeConv(char* dest, int max, int codeTo, const char* text, int length, int codeFrom);
//---
bool lcid2locale(long lcid, char **localeid);
//---

#endif
