//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCbaseDialog.h>
#include <WSCvifield.h>
#include <WSCform.h>
#include <WSCvtoggle.h>
#include <WSCcomboBox.h>
#include <WSCvbtn.h>
#include <WSCfileSelect.h>
#include <WSCmessageDialog.h>
#include <WSCindexForm.h>
#include <WSCoption.h>
#include <advance/WSCinspector.h>

extern WSCmessageDialog* message;

extern WSCbaseDialog* objsearchwz;
WSCvifield* objschif1;
WSCvifield* objschif2;
WSCvifield* objschif3;
WSCvifield* objschif4;
WSCvifield* objschif5;
WSCoption*  objschif6;
WSCform*    osform1;
WSCindexForm*    osform2;
WSCvtoggle* objsrhtg00;
WSCvtoggle* objsrhtg01;
WSCvtoggle* objsrhtg02;
extern WSClistData      winlist;
extern WSClistData      selected_clients;

static void visop(WSCbase*){
  if (objsearchwz->getVisible() != False){
    osform2->setProperty(WSNvalue,0);
    objschif1->setPropertyV(WSNlabelString,"");
    objschif2->setPropertyV(WSNlabelString,"");
    objschif3->setPropertyV(WSNlabelString,"");
    objschif4->setPropertyV(WSNlabelString,"");
    objschif5->setPropertyV(WSNlabelString,"");
    objsrhtg00->setStatus(False);
    objsrhtg01->setStatus(True);
    objschif6->setPropertyV(WSNvalue,(long)-2);
  }else{
    if (objsearchwz->getStatus() == WS_DIALOG_DONE){
//    do something...
    }
  }
}
static void sizeop(WSCbase*){
  long val = objsearchwz->getProperty(WSNwidth);
  if (val > 3){
    val -= 2;
  }else{
    val = 1;
  }
  osform1->setProperty(WSNwidth,val);

  val = objsearchwz->getProperty(WSNheight);
  if (val > 45){
    val -= 45;
  }else{
    val = 1;
  }
  osform1->setProperty(WSNheight,val);
}

void create_object_list(WSClistData* list,WSCbase* obj){
  list->add((void*)obj);
  long i;
  WSClistData children = obj->getChildren();
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      create_object_list(list,child);
    }
  }

}

static void searchop(WSCbase*){
  if (objsearchwz->getStatus() == WS_DIALOG_OK){
    WSClistData objects;
    long i;
    long num = winlist.getNum();
    for(i=0; i<num; i++){
      WSCbase* win = (WSCbase*)winlist[i];
      create_object_list(&objects,win);
    }
    extern WSCinspector* inspector;
    WSCbase* starget = inspector->getSelectedClient();
    num =  objects.getNum();
    long start = -1;
    if (starget != NULL){
      for(i=0; i<num; i++){
        WSCbase* obj = (WSCbase*)objects[i];
        if (starget == obj){
          start = i;
        }
      }
    }
    WSCvariant index = osform2->getProperty(WSNvalue);
    WSCbool found = False;
    if ((long)index == 0){ // search by instance name 
      WSCvariant iname = objschif1->getProperty(WSNlabelString);
      WSCbool to_bottom = objsrhtg01->getStatus();
      WSCbool equal = objsrhtg00->getStatus();
      if (!strcmp((char*)iname,"")){
        message->setPropertyV(WSNlabelString,
          WSGFgettext("e4:WSSTR Please specify a instance name to search."));
        message->popup();
        return;
      }
      if (to_bottom != False){
        for(i=start+1; i<num; i++){
          WSCbase* obj = (WSCbase*)objects[i];
          WSCstring iname2(obj->getInstanceName());
          if ( (equal != False && !strcmp((char*)iname,obj->getInstanceName())) ||
               (equal == False && iname2.isExist((char*)iname) != -1)){
            obj->setPropertyEditExecute(True);
            found = True;
            break;
          }
        }
      }else{ //search backward
        if (start == -1){
          start = num;
        }
        for(i=start-1;i > -1; i--){
          WSCbase* obj = (WSCbase*)objects[i];
          WSCstring iname2(obj->getInstanceName());
          if ( (equal != False && !strcmp((char*)iname,obj->getInstanceName())) ||
               (equal == False && iname2.isExist((char*)iname) != -1)){
            obj->setPropertyEditExecute(True);
            found = True;
            break;
          }
        }
      }
    }else if ((long)index == 1){ //search by properties 
      WSCvariant pname = objschif2->getProperty(WSNlabelString);
      WSCvariant valuestr = objschif3->getProperty(WSNlabelString);
      WSCbool to_bottom = objsrhtg01->getStatus();
      if (!strcmp((char*)valuestr,"")){
        message->setProperty(WSNwidth,640);
        message->setPropertyV(WSNlabelString,
          WSGFgettext("f4:WSSTR Please specify a value of the property to search instance."));
        message->popup();
        return;
      }
      if (strcmp((char*)pname,"") && strncmp((char*)pname,"WSN",3)){
        message->setProperty(WSNwidth,640);
        message->setPropertyV(WSNlabelString,
          WSGFgettext("f4:WSSTR Please specify a property name likes [WSN...] to search instance."));
        message->popup();
        return;
      }

      if (to_bottom != False){
        for(i=start+1; i<num; i++){
          WSCbase* obj = (WSCbase*)objects[i];
          if (!strcmp((char*)pname,"")){
            WSClistData proparray;
            obj->getPropertyArray(&proparray,True);
            long n = proparray.getNum();
            long j;
            for(j=0; j<n; j++){
              WSCvariant val = obj->getProperty((char*)proparray[j]);
//printf("%s:%d pname=%s v=%s v=%s\n",__FILE__,__LINE__,(char*)proparray[j],(char*)val,(char*)valuestr);
              if(!strcmp((char*)val,(char*)valuestr)){
                obj->setPropertyEditExecute(True);
                found = True;
                break;
              }
            }
            if (found == True){
              obj->setPropertyEditExecute(True);
              inspector->setSelectIndexTab(2);
//              inspector->setPropertyV(WSNvalue,(WSCuchar)2);
              found = True;
              break;
            }
          }else{
            WSCstring pname2((char*)pname);
            pname2.replaceString("WSN","",0);
            if (obj->existProperty((char*)pname2)){
              WSCvariant val = obj->getProperty((char*)pname2);
//printf("%s:%d pname=%s v=%s v=%s\n",__FILE__,__LINE__,(char*)pname2,(char*)val,(char*)valuestr);
              if(!strcmp((char*)val,(char*)valuestr)){
                obj->setPropertyEditExecute(True);
                inspector->setSelectIndexTab(2);
//                inspector->setPropertyV(WSNvalue,(WSCuchar)2);
                found = True;
                break;
              }
            }
          }
        }
      }else{ //search backward
        if (start == -1){
          start = num;
        }
        for(i=start-1;i > -1; i--){
          WSCbase* obj = (WSCbase*)objects[i];
          if (!strcmp((char*)pname,"")){
            WSClistData proparray;
            obj->getPropertyArray(&proparray,True);
            long n = proparray.getNum();
            long j;
            for(j=0; j<n; j++){
              WSCvariant val = obj->getProperty((char*)proparray[i]);
              if(!strcmp((char*)val,(char*)valuestr)){
                obj->setPropertyEditExecute(True);
                inspector->setSelectIndexTab(2);
//                inspector->setPropertyV(WSNvalue,(WSCuchar)2);
                found = True;
                break;
              }
            }
            if (found == True){
              obj->setPropertyEditExecute(True);
              break;
            }

          }else{
            WSCstring pname2((char*)pname);
            pname2.replaceString("WSN","",0);
            if (obj->existProperty((char*)pname2)){
              WSCvariant val = obj->getProperty((char*)pname2);
              if(!strcmp((char*)val,(char*)valuestr)){
                obj->setPropertyEditExecute(True);
                inspector->setSelectIndexTab(2);
//                inspector->setPropertyV(WSNvalue,(WSCuchar)2);
                found = True;
                break;
              }
            }
          }
        }
      }
    }else if ((long)index == 2){ //search by procedures 
      WSCvariant epname = objschif4->getProperty(WSNlabelString);
      WSCvariant fname = objschif5->getProperty(WSNlabelString);
      WSCvariant trigger = objschif6->getProperty(WSNvalue);
      WSCbool to_bottom = objsrhtg01->getStatus();
      if (!strcmp((char*)epname,"") && !strcmp((char*)fname,"") && (long)trigger == -2){
        message->setPropertyV(WSNlabelString,
          WSGFgettext("g4:WSSTR Please specify search condition."));
        message->popup();
        return;
      }
      if (to_bottom != False){
        for(i=start+1; i<num; i++){
          WSCbase* obj = (WSCbase*)objects[i];
          WSClistData* procedures = obj->getProcedureList();
          long n = procedures->getNum();
          long j;
          for(j=0; j<n; j++){
            WSCprocedure* proc = (WSCprocedure*)(*procedures)[j];
            if (proc->getInternal() != False){
              continue;
            }
            if (strcmp((char*)epname,"") && strcmp((char*)epname,proc->getProcName())){
              continue;
            }
            if (strcmp((char*)fname,"") && strcmp((char*)fname,proc->getFunctionName())){
              continue;
            }
            if ((long)trigger != -2 && (long)trigger != proc->getTrigger()){
              continue;
            }
            found = True;
            break;
          }
          if (found == True){
            obj->setPropertyEditExecute(True);
            inspector->setSelectIndexTab(3);
//            inspector->setPropertyV(WSNvalue,(WSCuchar)3);
            break;
          }
        }
      }else{ //search backward
        if (start == -1){
          start = num;
        }
        for(i=start-1;i > -1; i--){
          WSCbase* obj = (WSCbase*)objects[i];
          WSClistData* procedures = obj->getProcedureList();
          long n = procedures->getNum();
          long j;
          for(j=0; j<n; j++){
            WSCprocedure* proc = (WSCprocedure*)(*procedures)[j];
            if (proc->getInternal() != False){
              continue;
            }
            if (strcmp((char*)epname,"") && strcmp((char*)epname,proc->getProcName())){
              continue;
            }
            if (strcmp((char*)fname,"") && strcmp((char*)fname,proc->getFunctionName())){
              continue;
            }
            if ((long)trigger != -2 && (long)trigger != proc->getTrigger()){
              continue;
            }
            found = True;
            break;
          }
          if (found == True){
            obj->setPropertyEditExecute(True);
            inspector->setSelectIndexTab(3);
//            inspector->setPropertyV(WSNvalue,(WSCuchar)3);
            break;
          }
        }
      }
    }
    if (found == False){
      message->setPropertyV(WSNlabelString,WSGFgettext("h4:WSSTR No instance."));
      message->popup();
    }
  }
}
//////////////////////////////////////////////////////////
#define WS_OLLD_TGRMENU    \
":-2:,NONE:-1:,INITALIZE:0:,DELETE:1:,ACTIVATE:2:,VALUE-CH:3:\
FOCUS-CH:4:,VISIBLE-CH:5:,SENSITIVE-CH:6:,\
PARENT-VISIBLE-CH:7:,PARENT-SENSITIVE-CH :8:,EXPOSE:9:,\
RESIZE:10:,MOUSE-IN:11:,MOUSE-OUT:12:,MOUSE-PRESS:13:,MOUSE-RELEASE:14:,\
MOUSE-MOVE:15:,KEY-PRESS:16:,KEY-RELEASE:17:,KEY-HOOK:18:"
//////////////////////////////////////////////////////////

void create_objsearchwz_dialog(){

  objsearchwz = new WSCbaseDialog(NULL,"objsearchwz");
  objsearchwz->initialize();
  WSGFsetGeometry(objsearchwz,300,330,430,165);
  objsearchwz->setPropertyV(WSNtitleString,WSGFgettext("i4:WSSTR Find instances"));
  objsearchwz->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/search4.xpm");
  objsearchwz->setPropertyV(WSNokString,WSGFgettext("j4:WSSTR Find"));
  objsearchwz->setProperty(WSNno,False);
  WSCprocedure* op1 = new WSCprocedure("visop",WSEV_VISIBLE_CH);
  op1->setFunction(visop,"visop");
  objsearchwz->addProcedure(op1);
  WSCprocedure* op2 = new WSCprocedure("sizeop",WSEV_RESIZE);
  op2->setFunction(sizeop,"sizeop");
  objsearchwz->addProcedure(op2);
  WSCprocedure* op3 = new WSCprocedure("searchop",WSEV_ACTIVATE);
  op3->setFunction(searchop,"searchop");
  objsearchwz->addProcedure(op3);

  osform1 = new WSCform(objsearchwz,"osform1");
  osform1->initialize();
  WSGFsetGeometry(osform1,1,5,428,120);
  osform1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  osform1->setProperty(WSNshadowThickness,1); 
  osform1->setVisible(True);

  osform2 = new WSCindexForm(osform1,"osform1");
  osform2->initialize();
  WSGFsetGeometry(osform2,5,5,420,110);
  osform2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  osform2->setProperty(WSNshadowThickness,1); 
  osform2->setProperty(WSNmenuItems,WSGFgettext("k4:WSSTR Instance name,Properties,Procedures")); 
  osform2->setVisible(True);

  WSCvlabel* sp1 = new WSCvlabel(osform2,"sp1");
  sp1->initialize();
  WSGFsetGeometry(sp1,0,5,1280,2);
  sp1->setPropertyV(WSNuserValue,(long)1);
  sp1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp1->setVisible(True);

  WSCvlabel* lb11 = new WSCvlabel(osform2,"lb11");
  lb11->initialize();
  WSGFsetGeometry(lb11,5,32,120,20);
  lb11->setPropertyV(WSNlabelString,WSGFgettext("l4:WSSTR InstanceName"));
  lb11->setPropertyV(WSNuserValue,(long)1);
  WSGFsetMargin(lb11,0);
  lb11->setVisible(True); 

  objschif1 = new  WSCvifield(osform2,"nmif1");
  objschif1->initialize();
  objschif1->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  objschif1->setPropertyV(WSNshadowType,(char)1);
  objschif1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  objschif1->setPropertyV(WSNmaxLength,(WSCushort)0);
  objschif1->setPropertyV(WSNuserValue,(long)1);
  WSGFsetGeometry(objschif1,130,32,260,20);

  WSCvlabel* lb12 = new WSCvlabel(osform2,"lb11");
  lb12->initialize();
  WSGFsetGeometry(lb12,5,57,120,20);
  lb12->setPropertyV(WSNlabelString,WSGFgettext("m4:WSSTR Comparison"));
  lb12->setPropertyV(WSNuserValue,(long)1);
  WSGFsetMargin(lb12,0);
  lb12->setVisible(True); 

  objsrhtg00 = new  WSCvtoggle(osform2,"objsrhtg00");
  objsrhtg00->initialize();
  objsrhtg00->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  objsrhtg00->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
  objsrhtg00->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
  objsrhtg00->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
  objsrhtg00->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  objsrhtg00->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  objsrhtg00->setPropertyV(WSNlabelString,WSGFgettext("n4:WSSTR  Complete equal"));
  objsrhtg00->setPropertyV(WSNalignmentH,(WSCuchar)0);
  objsrhtg00->setPropertyV(WSNuserValue,(long)1);
  WSGFsetGeometry(objsrhtg00,130,55,100,26);
  objsrhtg00->setStatus(True);
  objsrhtg00->setVisible(True);



  WSCvlabel* lb21 = new WSCvlabel(osform2,"lb12");
  lb21->initialize();
  WSGFsetGeometry(lb21,5,32,120,20);
  lb21->setPropertyV(WSNlabelString,WSGFgettext("o4:WSSTR PropertyName"));
  lb21->setPropertyV(WSNuserValue,(long)2);
  WSGFsetMargin(lb21,0);
  lb21->setVisible(True); 

  objschif2 = new  WSCvifield(osform2,"nmif2");
  objschif2->initialize();
  objschif2->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  objschif2->setPropertyV(WSNshadowType,(char)1);
  objschif2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  objschif2->setPropertyV(WSNmaxLength,(WSCushort)0);
  objschif2->setPropertyV(WSNuserValue,(long)2);
  WSGFsetGeometry(objschif2,130,32,260,20);

  WSCvlabel* lb22 = new WSCvlabel(osform2,"lb22");
  lb22->initialize();
  WSGFsetGeometry(lb22,5,57,120,20);
  lb22->setPropertyV(WSNlabelString,WSGFgettext("p4:WSSTR Value"));
  lb22->setPropertyV(WSNuserValue,(long)2);
  WSGFsetMargin(lb22,0);
  lb22->setVisible(True);

  objschif3 = new  WSCvifield(osform2,"nmif2");
  objschif3->initialize();
  objschif3->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  objschif3->setPropertyV(WSNshadowType,(char)1);
  objschif3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  objschif3->setPropertyV(WSNmaxLength,(WSCushort)0);
  objschif3->setPropertyV(WSNuserValue,(long)2);
  WSGFsetGeometry(objschif3,130,57,260,20);

  WSCvlabel* lb31 = new WSCvlabel(osform2,"lb31");
  lb31->initialize();
  WSGFsetGeometry(lb31,5,32,120,20);
  lb31->setPropertyV(WSNlabelString,WSGFgettext("q4:WSSTR ProcedureName"));
  lb31->setPropertyV(WSNuserValue,(long)3);
  WSGFsetMargin(lb31,0);
  lb31->setVisible(True); 

  objschif4 = new  WSCvifield(osform2,"nmif4");
  objschif4->initialize();
  objschif4->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  objschif4->setPropertyV(WSNshadowType,(char)1);
  objschif4->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  objschif4->setPropertyV(WSNmaxLength,(WSCushort)0);
  objschif4->setPropertyV(WSNuserValue,(long)3);
  WSGFsetGeometry(objschif4,130,32,100,20);

  objschif6 = new  WSCoption(osform2,"nmif4");
  objschif6->initialize();
  objschif6->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  objschif6->setPropertyV(WSNmenuItems,WS_OLLD_TGRMENU);
  objschif6->setPropertyV(WSNvalue,(long)-2);
  objschif6->setPropertyV(WSNuserValue,(long)3);
  WSGFsetGeometry(objschif6,235,32,165,20);

  WSCvlabel* lb32 = new WSCvlabel(osform2,"lb32");
  lb32->initialize();
  WSGFsetGeometry(lb32,5,57,120,20);
  lb32->setPropertyV(WSNlabelString,WSGFgettext("r4:WSSTR FunctionName"));
  lb32->setPropertyV(WSNuserValue,(long)3);
  WSGFsetMargin(lb32,0);
  lb32->setVisible(True);

  objschif5 = new  WSCvifield(osform2,"nmif5");
  objschif5->initialize();
  objschif5->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  objschif5->setPropertyV(WSNshadowType,(char)1);
  objschif5->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  objschif5->setPropertyV(WSNmaxLength,(WSCushort)0);
  objschif5->setPropertyV(WSNuserValue,(long)3);
  WSGFsetGeometry(objschif5,130,57,270,20);

  WSCvlabel* lb23 = new WSCvlabel(osform2,"lb23");
  lb23->initialize();
  WSGFsetGeometry(lb23,5,83,120,20);
  lb23->setPropertyV(WSNlabelString,WSGFgettext("s4:WSSTR Direction"));
  lb23->setPropertyV(WSNuserValue,(long)-1);
  WSGFsetMargin(lb23,0);
  lb23->setVisible(True);

  objsrhtg01 = new  WSCvtoggle(osform2,"objsrhtg01");
  objsrhtg01->initialize();
  objsrhtg01->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  objsrhtg01->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
  objsrhtg01->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
  objsrhtg01->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
  objsrhtg01->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  objsrhtg01->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  objsrhtg01->setPropertyV(WSNlabelString,WSGFgettext("t4:WSSTR  Downward"));
  objsrhtg01->setPropertyV(WSNalignmentH,(WSCuchar)0);
  objsrhtg01->setPropertyV(WSNunique,(WSCbool)True);
  objsrhtg01->setPropertyV(WSNgroup,"objnptgl");
  objsrhtg01->setPropertyV(WSNuserValue,(long)-1);
  WSGFsetGeometry(objsrhtg01,130,80,100,26);
  objsrhtg01->setStatus(True);
  objsrhtg01->setVisible(True);

  objsrhtg02 = new  WSCvtoggle(osform2,"objsrhtg02");
  objsrhtg02->initialize();
  objsrhtg02->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  objsrhtg02->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
  objsrhtg02->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
  objsrhtg02->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
  objsrhtg02->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  objsrhtg02->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  objsrhtg02->setPropertyV(WSNlabelString,WSGFgettext("u4:WSSTR  Upward"));
  objsrhtg02->setPropertyV(WSNalignmentH,(WSCuchar)0);
  objsrhtg02->setPropertyV(WSNunique,(WSCbool)True);
  objsrhtg02->setPropertyV(WSNgroup,"objnptgl");
  objsrhtg02->setPropertyV(WSNuserValue,(long)-1);
  WSGFsetGeometry(objsrhtg02,235,80,100,26);
  objsrhtg02->setVisible(True);

}

