//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <X11/Intrinsic.h>
#include <WScom.h>
#ifndef NO_DRAG_DROP
#include <WSCbase.h>
#include <x11/WSDxdragDrop.h>
#include <x11/WSDxappDev.h>
#include <x11/WSDxformDev.h>
#include <x11/WSDxmouse.h>

#define MAX_ARGS 10

WSMFclassInit(WSDxdragDrop,WSDdragDrop);

WSDdragDrop* _xdrag_drop_create_handler_(){
  return new WSDxdragDrop;
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _wsd_xdragdrop_init{
  public:
    _wsd_xdragdrop_init(){
        WSDdragDrop::setCreateHandler(_xdrag_drop_create_handler_);
    };
};
static _wsd_xdragdrop_init  execute_init;
#endif

WSDxdragDrop* WSGIxappDragDrop(){
  WSDdragDrop* dd = WSGIappDragDrop();
  if (dd != NULL){
    WSDxdragDrop* xdd = (WSDxdragDrop*)dd->cast("WSDxdragDrop");
	return xdd;
  }else{
    return NULL;
  }
}

WSCbase* WSDxdragDrop::_drag_client = NULL;

WSDxdragDrop::WSDxdragDrop(){
  _under_dragging = 0;
}

WSDxdragDrop::~WSDxdragDrop(){
}

void WSDxdragDrop::executeDrop(){
  if (_under_dragging == 0){
    _drag_client = NULL;
    return;
  }
  _under_dragging = 0;

  WSCbase* drop_site = NULL;
  long num = _drop_site_list.getNum();
  long i;
  for(i=num -1; i>-1; i--){
     WSCbase* site = (WSCbase*)_drop_site_list.getData(i);
     WSDdev* dev = site->getdev();
     if (dev == NULL){
       continue;
     }
     WSDxformDev* xdev = (WSDxformDev*)dev->cast("WSDxformDev");
     if (xdev == NULL){
       continue;
     }
     Widget w = xdev->getWidget();
	 if (w != NULL && XtWindow(w) == WSGIxappMouse()->getCurrentMouseWindow()){
       drop_site = site;
	   break;
	 }
  }
  if (drop_site != NULL){
    void (*hd)(WSCbase*,WSCbase*) =
       (void(*)(WSCbase*,WSCbase*))drop_site->getUserData("DROP-PROC");
    if (hd != NULL){
      hd(drop_site,_drag_client);
    }
  }
  WSDdev* dev = _drag_client->getowndev();
  WSDxformDev* xdev = (WSDxformDev*)dev->cast("WSDxformDev");
  if (xdev == NULL){
    xdev = (WSDxformDev*)dev->getParentDev()->cast("WSDxformDev");
  }
  if (xdev != NULL){
    WSCushort mno =  xdev->getMouseNo();
    long val = WSGIappMouse()->getMouseCursor(mno);
    if (val != 0){
      XDefineCursor(XtDisplay(xdev->getWidget()),
                    XtWindow(xdev->getWidget()),val);
    }
  }
}


WSCbool WSDxdragDrop::getDragState(){
  return _under_dragging;
}

void WSDxdragDrop::_btn_press_drag_start(WSCbase* client){
   WSDxdragDrop* obj = (WSDxdragDrop*)client->getUserData("WSDRAG-SERV");
   if (obj->_under_dragging == True){
     return;
   }
   obj->_under_dragging = True;
   _drag_client = client;

  WSDdev* dev = client->getowndev();
  WSDxformDev* xdev = (WSDxformDev*)dev->cast("WSDxformDev");
  if (xdev == NULL){
    xdev = (WSDxformDev*)dev->getParentDev()->cast("WSDxformDev");
  }
  if (xdev != NULL){
    WSCushort mno =  154; //mouse no
    long val = WSGIappMouse()->getMouseCursor(mno);
    if (val != 0){
      XDefineCursor(XtDisplay(xdev->getWidget()),
                    XtWindow(xdev->getWidget()),val);
    }
  }
}

long WSDxdragDrop::registerDragSite(WSCbase* client,char* msg){
  WSCprocedure* ac = new WSCprocedure("WSDRAG-START",WSEV_MOUSE_PRESS);
  ac->setFunction(_btn_press_drag_start,"_btn_press_drag_start");
  client->addProcedure(ac);
  client->setUserData("WSDRAG-AC",(void*)ac);
  client->setUserData("WSDRAG-MSG",(void*)WSGFstrdup(msg));
  client->setUserData("WSDRAG-SERV",(void*)this);
  return WS_NO_ERR;
}

long WSDxdragDrop::unregisterDragSite(WSCbase* client){
  WSCprocedure* ac = (WSCprocedure*)client->getUserData("WSDRAG-AC");
  char* msg = (char*)client->getUserData("WSDRAG-MSG");
  if (msg != NULL){
    delete[] msg;
  }
  client->delProcedure(ac);
  delete ac;
  client->setUserData("WSDRAG-AC",(void*)NULL);
  client->setUserData("WSDRAG-MSG",(void*)NULL);
  return WS_NO_ERR;
}

long WSDxdragDrop::registerDropSite(WSCbase* dropc,char* msg,void(*hd)(WSCbase*,WSCbase*)){
#ifdef PDBG
  printf("WSDxdragDrop::registerDropSite #%s# num=%d 0x%x\n",
  dropc->getInstanceName(),_drop_site_list.getNum(),dropc);
#endif

  dropc->setUserData("WSDRAG-MSG",(void*)WSGFstrdup(msg));
  dropc->setUserData("DROP-PROC",(void*)hd);
  _drop_site_list.add((void*)dropc);

  return WS_NO_ERR;
}

long WSDxdragDrop::unregisterDropSite(WSCbase* client){
#ifdef PDBG
  printf("WSDxdragDrop::unregisterDropSite #%s# num=%d 0x%x\n",
  client->getInstanceName(),_drop_site_list.getNum(),client);
#endif
  char* msg = (char*)client->getUserData("WSDRAG-MSG");
  if (msg != NULL){
    delete[] msg;
  }
  client->setUserData("WSDRAG-MSG",(void*)NULL);
  _drop_site_list.del(client);
#ifdef PDBG
  printf("WSDxdragDrop::unregisterDropSite done. num=%d\n",
  _drop_site_list.getNum());
#endif

  return WS_NO_ERR;
}

#endif //NO_DRAG_DROP
