//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <WSCdevice.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSCbase.h>
#include <WSDmouse.h>
#include <WSCbaseList.h>
#include <x11/WSDxmwinDev.h>
#include <x11/WSDxappDev.h>
#include <x11/WSDxdraw.h>
#include <x11/WSxcom.h>
#include <x11/WSDxdragDrop.h>
#include <x11/WSDxformDev.h>
#include <x11/WSDxnwDev.h>
#include <form.h>

#include <WSDprDev.h>
#include <WSDpsdraw.h>

#ifndef MacOS
#include <dlfcn.h>
#else //MacOS
//#include <mach-o/dyld.h>
#define RTLD_LAZY 0
extern void* dlopen(char* fname,long);
extern void* dlsym(void*,char* procn);
#include <WSDenv.h>
#endif //MacOS

WSMFclassInit(WSDxmwinDev,WSDmwindowDev);

WSDdev* _wsdxmwindev_init_(){
  return new WSDxmwinDev();
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _WSDxmwinDev_init_ {
  public:_WSDxmwinDev_init_(){
     WSGIappDevice()->setCreateHandler("mwindowDev",_wsdxmwindev_init_);
  };
};
static _WSDxmwinDev_init_ _init_to_run_WSDxmwinDev_;
#endif
//static WSDxdraw* draw_of_xmwin = NULL;

int red_mask, green_mask, blue_mask;
int red_shift, green_shift, blue_shift;
int start_shift;
unsigned int start_mask;
char mask_initialized = 0;
long msb_flag = 0;

class eightBitAccelData {
public:
    XImage *_image;
    // speed up data
    unsigned char *_data;
    XColor    *_cols;
    WSCushort _ncols;
public:
    eightBitAccelData(XImage *image){
	_image=image;
	_data=NULL;
	_cols=NULL;
	_ncols=0;
    }
    ~eightBitAccelData(void){
	if( _data )delete [] _data;
	if( _cols )delete [] _cols;
    }
};

class eightBitAccelList {
    WSClistData list;
public:
    void destroy(){
	unsigned int n;
	eightBitAccelData *ap;
	while( (n=list.getNum())>0 ){
	    --n;
	    ap=(eightBitAccelData *)list.getData(n);
	    list.delPos( n );
	    delete ap;
	}
    }
    ~eightBitAccelList(void){
	void destroy();
    }
    void del( XImage *image ){
	unsigned int i, n;
	eightBitAccelData *ap=NULL;

	n=list.getNum();
	for( i=0 ; i<n ; i++ ){ 
	    ap=(eightBitAccelData *)list.getData(i);
	    if( ap->_image==image )break;
	}
	list.delPos( i );

	delete ap;
    }

    eightBitAccelData *get( XImage *image, WSCbool alloc=False ){
	unsigned int i, n;
	eightBitAccelData *ap=NULL;
	n=list.getNum();
	for( i=0 ; i<n ; i++ ){ 
	    ap=(eightBitAccelData *)list.getData(i);
	    if( ap->_image==image )break;
	}
	if( i>=n ){
	    ap=NULL;
	    if( alloc==True ){
		ap=new eightBitAccelData( image );
		list.add( (void *)ap );
	    }
	}
	return ap;
    }
};

eightBitAccelList eightBitAccelCache;

WSDxmwinDev::WSDxmwinDev(){
  _pixmap  = 0;
  _pixmap_for_img  = 0;
  _gc      = 0;
  _image   = NULL;
  _display = NULL;
  _bit = 0; 
//  if (draw_of_xmwin == NULL){
//      draw_of_xmwin = new WSDxdraw();
//  }
//  setDraw(draw_of_xmwin);
}

WSDxmwinDev::~WSDxmwinDev(){
  if(_image)eightBitAccelCache.del(_image);
  destroyContext();
  destroyPixmap();
}

// for forward reference
extern long
_pscopypixmap( WSDmwindowDev *mdev, short x,  short y, WSCushort w,  WSCushort h,
	      WSDdev *dev, short dx,  short dy, WSDmwindowDev *maskmdev=NULL );
extern long
_pscopypixmap( WSDmwindowDev *mdev, short x,  short y, WSCushort w,  WSCushort h,
	  WSDdev *dev, short dx,  short dy, WSDimage *maskimage );

long WSDxmwinDev::copyToWindow(WSDdev* dest,short x,short y,WSCushort w,WSCushort h,short dx,short dy){
  if (_pixmap == 0 || _gc == 0){
    return WS_ERR;
  }

  WSDdev *pdev=dest->getParentDev();
  WSDprDev *prdev2;
  if( pdev ){
      prdev2=(WSDprDev *)pdev->cast("WSDprDev");
  }else{
      prdev2=(WSDprDev *)dest->cast("WSDprDev");
  }

  if( prdev2!=NULL ){
      return _pscopypixmap( this, x, y, w, h, dest, dx, dy );
  }

  if (_operation == WS_OPERATION_SRC_COPY){
    XSetFunction( WSGIxwinAppDev()->display(),_gc,GXcopy);
  }else
  if (_operation == WS_OPERATION_XOR){
    XSetFunction( WSGIxwinAppDev()->display(),_gc,GXxor);
  }

  if (dest->cast("WSDnwDev") != NULL){
    int vx = 0;
    int vy = 0;
    if (dest->getAttachedClient() != NULL){
      vx = dest->getAttachedClient()->getProperty(WSNx);
      vy = dest->getAttachedClient()->getProperty(WSNy);
    }
    WSDdev* pdev = dest->getParentDev();
    WSDxformDev* xdev = NULL;
    if (pdev != NULL){
      xdev = (WSDxformDev*)dest->getParentDev()->cast("WSDxformDev");
    }

    if ( (Window)dest->getWindowResource() != (Window)-1){
      XCopyArea( WSGIxwinAppDev()->display(),_pixmap,
             (Window)dest->getWindowResource(),_gc,
            (int)x, (int)y, (WSCuint)w, (WSCuint)h, vx+(int)dx, vy+(int)dy);
    }
    if (xdev != NULL && xdev->getPixmapStyle() != WS_DIRECT_WINDOW &&
             (Widget)xdev->getSpecialResource() != NULL ){
      XCopyArea( WSGIxwinAppDev()->display(),_pixmap,
             XtWindow((Widget)xdev->getSpecialResource()),_gc,
            (int)x, (int)y, (WSCuint)w, (WSCuint)h, vx+(int)dx, vy+(int)dy);
    }
  }else{
    if ( (Window)dest->getWindowResource() != (Window)-1){
      XCopyArea( WSGIxwinAppDev()->display(),_pixmap,
             (Window)dest->getWindowResource(),_gc,
            (int)x, (int)y, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
    }
    WSDxformDev* xdev = (WSDxformDev*)dest->cast("WSDxformDev");
    if (xdev != NULL && xdev->getPixmapStyle() != WS_DIRECT_WINDOW &&
             (Widget)xdev->getSpecialResource() != NULL ){
      XCopyArea( WSGIxwinAppDev()->display(),_pixmap,
             XtWindow((Widget)xdev->getSpecialResource()),_gc,
            (int)x, (int)y, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
    }
  }
  return WS_NO_ERR;
}
long WSDxmwinDev::copyToWindowWithMask(WSDdev* dest,short x,short y,
                                       WSCushort w,WSCushort h,short dx,short dy,
                                       WSDimage* image){
  if (image == NULL){
    return WS_ERR;
  }

  WSDdev *pdev=dest->getParentDev();
  WSDprDev *prdev2;
  if( pdev ){
      prdev2=(WSDprDev *)pdev->cast("WSDprDev");
  }else{
      prdev2=(WSDprDev *)dest->cast("WSDprDev");
  }

  if( prdev2!=NULL ){
      return _pscopypixmap( (WSDmwindowDev*)this, x, y, w, h, dest, dx, dy, image );
  }

  Pixmap mask = (Pixmap)image->getValue1();
  return _copyToWindowWithMask(dest,x,y,w,h,dx,dy,mask);
}
long WSDxmwinDev::_copyToWindowWithMask(WSDdev* dest,short x,short y,
                                       WSCushort w,WSCushort h,short dx,short dy,
                                       Pixmap mask){
  if (_pixmap == 0 || _gc == 0){
    return WS_ERR;
  }
  GC gc2 = WSGIxwinAppDev()->appGC2();
  if (gc2 == 0){
    return WS_ERR;
  }
  Pixmap mp;
  if( _bit==8 ){
      mp=WSGFxGetPixmap(w,h);
  }else{
      mp=mask;
  }

  XSetFunction( WSGIxwinAppDev()->display(),_gc,GXcopy);
  XSetFunction( WSGIxwinAppDev()->display(),gc2,GXcopy);

  Pixmap src = WSGFxGetPixmap(w,h);
  XCopyArea( WSGIxwinAppDev()->display(),_pixmap,
           src,gc2, (int)x, (int)y, (WSCuint)w, (WSCuint)h, 0,0);

  WSDxnwDev* nwdev = (WSDxnwDev*)dest->cast("WSDxnwDev");
  int vx = 0;
  int vy = 0;
  WSDdev* pdev = dest->getParentDev();
  WSDxformDev* xdev = NULL;
  if (nwdev != NULL){
    if (dest->getAttachedClient() != NULL){
      vx = dest->getAttachedClient()->getProperty(WSNx);
      vy = dest->getAttachedClient()->getProperty(WSNy);
    }
    if (pdev != NULL){
      xdev = (WSDxformDev*)dest->getParentDev()->cast("WSDxformDev");
    }
  }else{
    xdev = (WSDxformDev*)dest->cast("WSDxformDev");
  }

  Pixmap tdest = WSGFxGetPixmap(w,h);
  if (xdev != NULL){
    XSetFunction( WSGIxwinAppDev()->display(),gc2,GXcopy);
    XCopyArea( WSGIxwinAppDev()->display(),
       xdev->getWindowResource(),
       tdest,gc2,
       vx+(int)dx, vy+(int)dy, (WSCuint)w, (WSCuint)h,0,0);
  }

  if (mask != (Pixmap)-1 && mask != 0){
    if ( _bit==8 ){
	Display *dpy=WSGIxwinAppDev()->display();
	unsigned long black=BlackPixel(dpy,DefaultScreen(dpy));
	unsigned long white=WhitePixel(dpy,DefaultScreen(dpy));
	unsigned long wb;
	wb=white^black;	    // bit difference in white and black pixel values
	wb=wb&~(wb^(~wb+1));// extract only 1 bit

	// black area = 0, other area =0xFF
	XSetForeground( dpy, gc2, (wb&black)?0:0xFF );
	XSetBackground( dpy, gc2, (wb&black)?0xFF:0 );

	XSetFunction( dpy, gc2,GXcopy);
	XCopyPlane( dpy, mask, mp, gc2, (int)x, (int)y,
		   (WSCuint)w, (WSCuint)h, 0, 0, wb );
    }

    XSetFunction( WSGIxwinAppDev()->display(),gc2,GXand);
    XCopyArea( WSGIxwinAppDev()->display(),mp,src,gc2,
           (int)x, (int)y, (WSCuint)w, (WSCuint)h, 0,0);
    if (_operation != WS_OPERATION_XOR){
      XSetGraphicsExposures(WSGIxwinAppDev()->display(),_gc,0);
      XSetFunction( WSGIxwinAppDev()->display(),_gc,GXandInverted);
      XSetFunction( WSGIxwinAppDev()->display(),gc2,GXandInverted);
      if (nwdev != NULL){
        if (nwdev->getUsePixmap() != False){
          XCopyArea( WSGIxwinAppDev()->display(),mp,
                 nwdev->getWindowResource(),_gc,
                (int)x, (int)y, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
        }else
        if ( (Window)dest->getWindowResource() != (Window)-1){
          XCopyArea( WSGIxwinAppDev()->display(),mp,
                 (Window)tdest,gc2,
                (int)x, (int)y, (WSCuint)w, (WSCuint)h, (int)0,(int)0);
        }
      }else{
        if ( (Window)dest->getWindowResource() != (Window)-1){
          XCopyArea( WSGIxwinAppDev()->display(),mp,
                 (Window)dest->getWindowResource(),_gc,
                (int)x, (int)y, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
        }
        if (xdev != NULL && xdev->getPixmapStyle() != WS_DIRECT_WINDOW &&
               (Widget)xdev->getSpecialResource() != NULL ){
          XCopyArea( WSGIxwinAppDev()->display(),mp,
               XtWindow((Widget)xdev->getSpecialResource()),_gc,
              (int)0, (int)0, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
        }
      }
    }
  }
  if (_operation == WS_OPERATION_SRC_COPY){
    XSetFunction( WSGIxwinAppDev()->display(),_gc,GXor);
    XSetFunction( WSGIxwinAppDev()->display(),gc2,GXor);
  }else
  if (_operation == WS_OPERATION_XOR){
    XSetFunction( WSGIxwinAppDev()->display(),_gc,GXxor);
    XSetFunction( WSGIxwinAppDev()->display(),gc2,GXxor);
  }
  if (nwdev != NULL){
    if (nwdev->getUsePixmap() != False){
      XCopyArea( WSGIxwinAppDev()->display(),src,
             nwdev->getWindowResource(),_gc,
            (int)0, (int)0, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
    }else
    if ( (Window)dest->getWindowResource() != (Window)-1){
      XCopyArea( WSGIxwinAppDev()->display(),src,
             (Window)tdest,gc2,
            (int)0, (int)0, (WSCuint)w, (WSCuint)h, (int)0,(int)0);
    }
    XSetFunction( WSGIxwinAppDev()->display(),_gc,GXcopy);
    if (nwdev->getUsePixmap() != False){
    }else
    if ( (Window)dest->getWindowResource() != (Window)-1){
      XCopyArea( WSGIxwinAppDev()->display(),tdest,
             (Window)dest->getWindowResource(),_gc,
            (int)0, (int)0, (WSCuint)w, (WSCuint)h, vx+(int)dx, vy+(int)dy);
    }
    if (xdev != NULL && xdev->getPixmapStyle() != WS_DIRECT_WINDOW &&
             (Widget)xdev->getSpecialResource() != NULL ){
      XCopyArea( WSGIxwinAppDev()->display(),tdest,
             XtWindow((Widget)xdev->getSpecialResource()),_gc,
            (int)0, (int)0, (WSCuint)w, (WSCuint)h, vx+(int)dx, vy+(int)dy);
    }
  }else{
    if ( (Window)dest->getWindowResource() != (Window)-1){
      XCopyArea( WSGIxwinAppDev()->display(),src,
             (Window)dest->getWindowResource(),_gc,
            (int)0, (int)0, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
    }
    if (xdev != NULL && xdev->getPixmapStyle() != WS_DIRECT_WINDOW &&
             (Widget)xdev->getSpecialResource() != NULL ){
      XCopyArea( WSGIxwinAppDev()->display(),src,
             XtWindow((Widget)xdev->getSpecialResource()),_gc,
            (int)0, (int)0, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
    }
  }
  if( _bit==8 )WSGFxReleasePixmap(mp);
  WSGFxReleasePixmap(src);
  WSGFxReleasePixmap(tdest);
  XSetGraphicsExposures(WSGIxwinAppDev()->display(),_gc,1);
  XSetFunction( WSGIxwinAppDev()->display(),_gc,GXcopy);
  XSetFunction( WSGIxwinAppDev()->display(),gc2,GXcopy);

  return WS_NO_ERR;
}
long WSDxmwinDev::copyToWindowWithMask(WSDdev* dest,short x,short y,
                                       WSCushort w,WSCushort h,short dx,short dy,
                                       WSDmwindowDev* image){
  if (image == NULL){
    return WS_ERR;
  }
  WSDxmwinDev* mimage = (WSDxmwinDev*)image->cast("WSDxmwinDev");
  if (mimage == NULL){
    return WS_ERR;
  }

  WSDdev *pdev=dest->getParentDev();
  WSDprDev *prdev2;
  if( pdev ){
      prdev2=(WSDprDev *)pdev->cast("WSDprDev");
  }else{
      prdev2=(WSDprDev *)dest->cast("WSDprDev");
  }

  if( prdev2!=NULL ){
      return _pscopypixmap( this, x, y, w, h, dest, dx, dy, image );
  }

  Pixmap mask = (Pixmap)mimage->_pixmap;
  return _copyToWindowWithMask(dest,x,y,w,h,dx,dy,mask);
}

long WSDxmwinDev::copyFromWindow(WSDdev* dest,short x,short y,WSCushort w,WSCushort h,short dx,short dy){
  if (_pixmap == 0 || _gc == 0){
    return WS_ERR;
  }
  if (dest->cast("WSDnwDev") != NULL){
    int vx = 0;
    int vy = 0;
    if (dest->getAttachedClient() != NULL){
      vx = dest->getAttachedClient()->getProperty(WSNx);
      vy = dest->getAttachedClient()->getProperty(WSNy);
    }
    XCopyArea( WSGIxwinAppDev()->display(),
             (Window)dest->getWindowResource(),_pixmap,_gc,
          vx+(int)x, vy+(int)y, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
  }else{
    XCopyArea( WSGIxwinAppDev()->display(),
             (Window)dest->getWindowResource(),_pixmap,_gc,
          (int)x, (int)y, (WSCuint)w, (WSCuint)h, (int)dx, (int)dy);
  }
  return WS_NO_ERR;
}

long WSDxmwinDev::createPixmap(WSCushort w,WSCushort h){
  _w = w;
  _h = h;
  if (_w == 0 || _h == 0){
    return WS_ERR;
  }

  if (_pixmap != 0){
    destroyPixmap();
  }
  _pixmap = WSGFxGetPixmap(w,h);
  createContext();
  return WS_NO_ERR;
}
long WSDxmwinDev::destroyPixmap(){
  if (_pixmap != 0){
    WSGFxReleasePixmap(_pixmap);
    _pixmap = 0;
  }
  destroyContext();
  return WS_NO_ERR;
}

long WSDxmwinDev::getDeviceResource(){
  return (long)WSGIxwinAppDev()->display();
}


long WSDxmwinDev::getContextResource(){
  if (_gc == 0){
    return -1;
  }
  return (long)_gc;
}

long WSDxmwinDev::getSpecialResource(){
   return (long)0;
}

long WSDxmwinDev::createContext(){
  destroyContext();  
  WSDxappDev* app   = WSGIxwinAppDev();
  _gc = app->appGC();
  return WS_NO_ERR;
}

long WSDxmwinDev::getWindowResource(){
  return (long)_pixmap;
}

long WSDxmwinDev::destroyContext(){
 _gc = 0;
 return WS_NO_ERR;
}

long WSDxmwinDev::initBuffer(){
  if (_image != NULL){
    if (_image->data != NULL){
      delete _image->data;
      _image->data = NULL;
    }
    XDestroyImage(_image);

    eightBitAccelCache.del( _image );

    _image = NULL;
  }
  Display* display = WSGIxwinAppDev()->display();
  _image = XGetImage(display,_pixmap,0,0,_w,_h,
                    0xffffffff,ZPixmap);

  _bit = XDefaultDepth(display,XDefaultScreen(display));
  if( _image && _bit<=8 ){
      eightBitAccelData * ap=eightBitAccelCache.get(_image,True);
      if( ap!=NULL ){
	  if( ap->_cols!=NULL ){
	      delete [] ap->_cols;
	      ap->_cols=NULL;
	  }
	  if( ap->_data!=NULL ){
	      delete [] ap->_data;
	      ap->_data=NULL;
	  }
	  ap->_ncols=1<<_bit;
	  ap->_cols=new XColor[ap->_ncols];

	  if( ap->_cols ){
	      Colormap cm = DefaultColormap(display,DefaultScreen(display));
	      WSCushort i, j;
	      for( i=0 ; i<ap->_ncols ; i++ )ap->_cols[i].pixel=i;
	      XQueryColors( display, cm, ap->_cols, ap->_ncols );

	      ap->_data = new unsigned char [(long)_w*_h*3];

	      if( ap->_data ){
		  unsigned short pixel;
		  for( i=0 ; i<_h ; i++ )for( j=0 ; j<_w ; j++ ){
		      pixel = ((unsigned char *)_image->data)[j+i*_image->bytes_per_line];
		      if( pixel<ap->_ncols ){ 
			  ap->_data[(j+i*_w)*3]=ap->_cols[pixel].red>>8;
			  ap->_data[(j+i*_w)*3+1]=ap->_cols[pixel].green>>8;
			  ap->_data[(j+i*_w)*3+2]=ap->_cols[pixel].blue>>8;
		      }
		  }
	      }
	  }
      }
  }

  if (_image != NULL){
    _pixmap_for_img = _pixmap;
    return WS_NO_ERR;
  }
  return WS_NO_ERR;
}
void mask_init(){
  XWindowAttributes win_attr;

  Display* display = WSGIxwinAppDev()->display();
  msb_flag = (ImageByteOrder(display) == MSBFirst)?1:0;

  if (XGetWindowAttributes(display,
            RootWindow(display, DefaultScreen(display)), &win_attr) == 0){
    return;
  }
  if ((win_attr.depth == 24) || (win_attr.depth == 16)) {
    if (win_attr.depth == 24) {
      start_shift = 24;
      start_mask = 0x80000000;
    }else{
      start_shift = 8;
      start_mask = 0x8000;
    }
    red_mask = win_attr.visual->red_mask;
    red_shift = start_shift;
    unsigned int n = start_mask;
    while (!(n & red_mask)) {
      n >>= 1;
      red_shift--;
    }
    green_mask = win_attr.visual->green_mask;
    green_shift = start_shift;
    n = start_mask;
    while (!(n & green_mask)) {
      n >>= 1;
      green_shift--;
    }
    blue_mask = win_attr.visual->blue_mask;
    blue_shift = start_shift;
    n = start_mask;
    while (!(n & blue_mask)) {
      n >>= 1;
      blue_shift--;
    }
  }

  mask_initialized = 1;
}

long WSDxmwinDev::setBufferRGB(WSCushort x,WSCushort y,WSCuchar r,WSCuchar g,WSCuchar b){
  if (mask_initialized == 0){
    mask_init();
  }
  if (_image == NULL){
    return WS_ERR;
  }
  if (x < _w && y < _h){
    WSCulong udat;
    if (_bit > 16){
      udat = 0;
      if (red_shift >= 0){
        udat |= (((int)r << red_shift) & red_mask);
      }else{
        udat |= (((int)r >> (-red_shift)) & red_mask);
      }
      if (green_shift >= 0){
        udat |= (((int)g << green_shift) & green_mask);
      }else{
        udat |= (((int)g >> (-green_shift)) & green_mask);
      }
      if (blue_shift >= 0){
        udat |= (((int)b << blue_shift) & blue_mask);
      }else{
        udat |= (((int)b >> (-blue_shift)) & blue_mask);
      }
      if (_image != NULL){
        if (_image->bits_per_pixel == 32){
          long ptr = (x+y*_w)*4;
          if (msb_flag){
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff000000)>>24;
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff0000)>>16;
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff00)>>8;
            ((unsigned char*)_image->data)[ptr] = (udat & 0xff);
          }else{
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff);
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff00)>>8;
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff0000)>>16;
            ((unsigned char*)_image->data)[ptr] = (udat & 0xff000000)>>24;
          }
        }else{
          long ptr = (x+y*_w)*3;
          if (msb_flag){
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff0000)>>16;
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff00)>>8;
            ((unsigned char*)_image->data)[ptr] = (udat & 0xff);
          }else{
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff);
            ((unsigned char*)_image->data)[ptr++] = (udat & 0xff00)>>8;
            ((unsigned char*)_image->data)[ptr] = (udat & 0xff0000)>>16;
          }
        }
      }
    }else
    if (_bit > 8){
      udat = 0;
      if (red_shift >= 0){
        udat |= (((int)r << red_shift) & red_mask);
      }else{
        udat |= (((int)r >> (-red_shift)) & red_mask);
      }
      if (green_shift >= 0){
        udat |= (((int)g << green_shift) & green_mask);
      }else{
        udat |= (((int)g >> (-green_shift)) & green_mask);
      }
      if (blue_shift >= 0){
        udat |= (((int)b << blue_shift) & blue_mask);
      }else{
        udat |= (((int)b >> (-blue_shift)) & blue_mask);
      }
      long ptr = x*2 +y*_image->bytes_per_line;
      if (msb_flag) {
        ((unsigned char*)_image->data)[ptr++] = (udat >> 8) & 0xff;
        ((unsigned char*)_image->data)[ptr] = (udat & 0xff);
      }else{
        ((unsigned char*)_image->data)[ptr++] = (udat & 0xff);
        ((unsigned char*)_image->data)[ptr] = (udat & 0xff00)>>8;
      }
    }else{
      eightBitAccelData *ap;
      ap=eightBitAccelCache.get( _image, True );
      if( ap ){
	  if( ap->_data == NULL ){
	      ap->_data = new unsigned char [(long)_w*_h*3];
	  }
      }
      if( ap && ap->_data ){
	  ap->_data[(x+y*_w)*3+0]=r;
	  ap->_data[(x+y*_w)*3+1]=g;
	  ap->_data[(x+y*_w)*3+2]=b;
      }else{
	  XColor col;
	  if (_display == NULL){
	      _display = WSGIxwinAppDev()->display();
	  }
	  Colormap cm = DefaultColormap(_display,DefaultScreen(_display));
	  if (r == 0xff){
	      col.red = 0xffff;
	  }else{
	      col.red = r << 8;
	  }
	  if (g == 0xff){
	      col.green = 0xffff;
	  }else{
	      col.green = g << 8;
	  }
	  if (b == 0xff){
	      col.blue = 0xffff;
	  }else{
	      col.blue = b << 8;
	  }
	  XAllocColor(_display,cm,&col);
	  //	  _image->data[x+y*_w] =  col.pixel;
	  _image->data[x+y*_image->bytes_per_line] =  col.pixel;
      }
    }
    return WS_NO_ERR;
  }
  return WS_ERR;
}
long WSDxmwinDev::getBufferRGB(WSCushort x,WSCushort y, WSCuchar* r, WSCuchar* g,WSCuchar* b){
  if (mask_initialized == 0){
    mask_init();
  }
  if (_image == NULL){
    return WS_ERR;
  }
  if (x < _w && y < _h){
    WSCulong udat = 0;
    if (_bit > 16){
      if (_image->bits_per_pixel == 32){
        long ptr = (x+y*_w)*4;
        if (msb_flag){
          udat |= ((unsigned char*)_image->data)[ptr++]<<24;
          udat |= ((unsigned char*)_image->data)[ptr++]<<16;
          udat |= ((unsigned char*)_image->data)[ptr++]<<8;
          udat |= ((unsigned char*)_image->data)[ptr++];
        }else{
          udat |= ((unsigned char*)_image->data)[ptr++];
          udat |= ((unsigned char*)_image->data)[ptr++]<<8;
          udat |= ((unsigned char*)_image->data)[ptr++]<<16;
          udat |= ((unsigned char*)_image->data)[ptr++]<<24;
        }
        if (red_shift >= 0){
          *r = (udat & red_mask)>>red_shift;
        }else{
          *r = (udat & red_mask)<<(-red_shift);
        }
        if (green_shift >= 0){
          *g = (udat & green_mask)>>green_shift;
        }else{
          *g = (udat & green_mask)<<(-green_shift);
        }
        if (blue_shift >= 0){
          *b = (udat & blue_mask)>>blue_shift;
        }else{
          *b = (udat & blue_mask)<<(-blue_shift);
        }
      }else{
        long ptr = (x+y*_w)*3;
        if (msb_flag){
          udat |= ((unsigned char*)_image->data)[ptr++]<<16;
          udat |= ((unsigned char*)_image->data)[ptr++]<<8;
          udat |= ((unsigned char*)_image->data)[ptr++];
        }else{
          udat |= ((unsigned char*)_image->data)[ptr++];
          udat |= ((unsigned char*)_image->data)[ptr++]<<8;
          udat |= ((unsigned char*)_image->data)[ptr++]<<16;
        }
        if (red_shift >= 0){
          *r = (udat & red_mask)>>red_shift;
        }else{
          *r = (udat & red_mask)<<(-red_shift);
        }
        if (green_shift >= 0){
          *g = (udat & green_mask)>>green_shift;
        }else{
          *g = (udat & green_mask)<<(-green_shift);
        }
        if (blue_shift >= 0){
          *b = (udat & blue_mask)>>blue_shift;
        }else{
          *b = (udat & blue_mask)<<(-blue_shift);
        }
      }
    }else
    if (_bit > 8){
      long ptr = x*2 + y*_image->bytes_per_line;
      if (msb_flag){
        udat |= ((unsigned char*)_image->data)[ptr++]<<8;
        udat |= ((unsigned char*)_image->data)[ptr++];
      }else{
        udat |= ((unsigned char*)_image->data)[ptr++];
        udat |= ((unsigned char*)_image->data)[ptr++]<<8;
      }
      if (red_shift >= 0){
        *r = (udat & red_mask)>>red_shift;
      }else{
        *r = (udat & red_mask)<<(-red_shift);
      }
      if (green_shift >= 0){
        *g = (udat & green_mask)>>green_shift;
      }else{
        *g = (udat & green_mask)<<(-green_shift);
      }
      if (blue_shift >= 0){
        *b = (udat & blue_mask)>>blue_shift;
      }else{
        *b = (udat & blue_mask)<<(-blue_shift);
      }
    }else{
      eightBitAccelData *ap;
      ap=eightBitAccelCache.get( _image, False );
      if( ap && ap->_data ){
	  *r = ap->_data[(x+y*_w)*3];
	  *g = ap->_data[(x+y*_w)*3+1];
	  *b = ap->_data[(x+y*_w)*3+2];
      }else{
	  XColor col;
	  XColor *colp;

	  col.pixel = ((unsigned char *)_image->data)[x+y*_image->bytes_per_line];
	  if( ap && ap->_cols!=NULL && col.pixel<ap->_ncols ){
	      colp=&ap->_cols[col.pixel];
	  }else{
	      colp=&col;
	      if (_display == NULL){
		  _display = WSGIxwinAppDev()->display();
	      }
	      Colormap cm = DefaultColormap(_display,DefaultScreen(_display));
	      XQueryColor(_display,cm,&col);
	  }
	  *r = colp->red >>8;
	  *g = colp->green >>8;
	  *b = colp->blue >>8;
      }
    }
  }
  return WS_NO_ERR;
}
long WSDxmwinDev::putBufferToPixmap(){
  if (_image == NULL){
    return WS_ERR;
  }
  if (_pixmap == 0){
    return WS_ERR;
  }
  if (_pixmap_for_img != _pixmap){
    return WS_ERR;
  }
  Display* display = WSGIxwinAppDev()->display();
  if( _bit<=8 ){
      eightBitAccelData *ap;
      ap=eightBitAccelCache.get( _image, True );
      if( ap && ap->_data ){
	  unsigned long i, j, k, c, cnt;
	  const int nr=5, ng=5, nb=5;
	  const unsigned int maxcols=nr*ng*nb;
	  unsigned int collist[maxcols*3];
	  XColor xcols[maxcols];
	  cnt=0;
	  for( i=0 ; i<_h ; i++ ){
	      for( j=0 ; j<_w ; j++ ){
		  c=ap->_data[(i*_w+j)*3]&0xFF;
		  c=(c<<8)|(ap->_data[(i*_w+j)*3+1]&0xFF);
		  c=(c<<8)|(ap->_data[(i*_w+j)*3+2]&0xFF);
		  for( k=0 ; k<cnt ; k++ ){
		      if( collist[k]==c ){
			  break;
		      }
		  }
		  if( k>=cnt ){
		      if( cnt<maxcols ){
			  collist[cnt++]=c;
		      }else{
			  break;
		      }
		  }
	      }
	      if( j<_w )break;
	  }
	  if( i<_h ){
	      for( i=0 ; i<(unsigned int)nr ; i++ )
	      for( j=0 ; j<(unsigned int)ng ; j++ )
	      for( k=0 ; k<(unsigned int)nb ; k++ ){
		  c=(i*ng+j)*nb+k;
		  xcols[c].red=((i*255)/(nr-1))*0x101;
		  xcols[c].green=((j*255)/(ng-1))*0x101;
		  xcols[c].blue=((k*255)/(nb-1))*0x101;
	      }
	      cnt=maxcols;
	      if (_display == NULL){
		  _display = WSGIxwinAppDev()->display();
	      }
	      Colormap cm = DefaultColormap(_display,DefaultScreen(_display));
	      for( i=0 ; i<cnt ; i++ ){
		  XAllocColor( _display, cm, &xcols[i] );
	      }
	      long colptr = 0;
	      long rr = 0,gg = 0,bb = 0;
	      long tr1,tg1,tb1;
	      signed char dr1,dg1,db1;

	      for( i=0 ; i<_h ; i++ ){
		  dr1 = 0;
		  dg1 = 0;
		  db1 = 0;
		  for( j=0 ; j<_w ; j++ ){
		      tr1=ap->_data[(i*_w+j)*3];
		      tg1=ap->_data[(i*_w+j)*3+1];
		      tb1=ap->_data[(i*_w+j)*3+2];

		      if ((0 < tr1 + dr1) && (tr1 + dr1) < 256){
			  if ( -128/(nr-1) < dr1 && dr1 < 128/(nr-1) ){
			      rr = tr1 + dr1 + 128/(nr-1)-1 ;
			  }else if (dr1 > 128/(nr-1)-1){
			      rr = tr1 + 256/(nr-1)-1 ;
			  }else{
			      rr = tr1;
			  }
			  rr -= rr% (256/(nr-1));
		      }else if (tr1 + dr1 > 255){
			  rr = 256;
		      }else{
			  rr = 0;
		      }
		      dr1 += (tr1 - rr);

		      if (0 < tg1 + dg1  &&tg1 + dg1 < 256){
			  if ( -128/(ng-1) < dg1 && dg1 < 128/(ng-1) ){
			      gg = tg1 + dg1 + 128/(ng-1)-1 ;
			  }else if (dg1 > 128/(ng-1)-1 ){
			      gg = tg1 + 256/(ng-1)-1 ;
			  }else{
			      gg = tg1;
			  }
			  gg -= gg % (256/(ng-1));
		      }else if (tg1 + dg1 > 255){
			  gg = 256;
		      }else{
			  gg = 0;
		      }
		      dg1 += (tg1 - gg);

		      if (0 < tb1 + db1 && tb1 + db1 < 256){
			  if (-256/(nb-1) < db1 && db1 < 256/(nb-1)){
			      bb = tb1 + db1 + 256/(nb-1)-1 ;
			  }else if (db1 > 128/(nb-1)-1){
			      bb = tb1 + 256/(nb-1)-1 ;
			  }else{
			      bb = tb1 ;
			  }
			  bb -= bb% (256/(nb-1));
		      }else if (tb1 + db1 > 255){
			  bb = 256;
		      }else{
			  bb = 0;
		      }
		      db1 += (tb1 - bb);

		      k=rr/(256/(nr-1)); if( k>=nr )k=nr;
		      colptr=k;
		      k=gg/(256/(ng-1)); if( k>=ng )k=ng;
		      colptr=colptr*ng+k;
		      k=bb/(256/(nb-1)); if( k>=nb )k=nb;
		      colptr=colptr*nb+k;
		      _image->data[j+i*_image->bytes_per_line]=
			xcols[colptr].pixel;
		  }
	      }
	  }else{
	      for(i=0;i<cnt;i++){
		  c=collist[i];
		  xcols[i].red=0x101*((c>>16)&0xFF);
		  xcols[i].green=0x101*((c>>8)&0xFF);
		  xcols[i].blue=0x101*(c&0xFF);
	      }
	      if (_display == NULL){
		  _display = WSGIxwinAppDev()->display();
	      }
	      Colormap cm = DefaultColormap(_display,DefaultScreen(_display));
	      for( i=0 ; i<cnt ; i++ ){
		  XAllocColor( _display, cm, &xcols[i] );
	      }
	      for( i=0 ; i<_h ; i++ ){
		  for( j=0 ; j<_w ; j++ ){
		      c=ap->_data[(i*_w+j)*3];
		      c=(c<<8)+ap->_data[(i*_w+j)*3+1];
		      c=(c<<8)+ap->_data[(i*_w+j)*3+2];
		      for( k=0 ; k<cnt-1 ; k++ ){
			  if( collist[k]==c ){
			      break;
			  }
		      }
		      _image->data[j+i*_image->bytes_per_line]=xcols[k].pixel;
		  }
	      }
	  }
      }
  }
  XPutImage(display,_pixmap,_gc,_image,0,0,0,0,_w,_h);
                    
  return WS_NO_ERR;
}

long WSDxmwinDev::saveFile(char* fname,long type){
  if (_w == 0 || _h == 0){
    return WS_ERR;
  }
  
  static void* dl = NULL;
  static long dl_init = 0;
  static long (*fn)(FILE*,char*,long,long) = NULL;

  static void* dl_jpg = NULL;
  static long dl_init_jpg = 0;
  static long (*fn_jpg)(FILE*,char*,long,long) = NULL;

  if (type != WS_IMAGE_PNG && type != WS_IMAGE_JPG){
    return WSDmwindowDev::saveFile(fname,type);
  }

  if (dl_init == 0 && type == WS_IMAGE_PNG){
#ifndef MacOS
    dl = dlopen("libwspng.so",RTLD_LAZY);
    if (dl == NULL){
      dl = dlopen("./libwspng.so",RTLD_LAZY);
    }
#else //MacOS
    dl = dlopen(
        WSGIappEnvironment()->getPlaneString("$(WSDIR)/lib/png.bundle"),
        RTLD_LAZY);
    if (dl == NULL){
      dl = dlopen("/usr/lib/png.bundle",RTLD_LAZY);
    }
    if (dl == NULL){
      dl = dlopen("./png.bundle",RTLD_LAZY);
    }
#endif //MacOS
    if (dl == NULL){
#ifndef MacOS
WSMFtrace("ERROR. in WSDximage::initialize(). Library png.so open error. \nso, png image can not support...\n");
#else //MacOS
WSMFtrace("ERROR. in WSDximage::initialize(). Library png.bundle open error. \nso, png image can not support...\n");
#endif //MacOS
    }else{
      fn = (long (*)(FILE*,char*,long,long))dlsym(dl,"PngWriteBufToFp");
      if (fn == NULL){
WSMFtrace("ERROR. in WSDximage::initialize(). Library png.so is invalid. \nso, png image can not support...\n");
      }
    }
  }

//printf("fn=0x%x\n",fn);
  if (fn != NULL && type == WS_IMAGE_PNG){
#ifndef NO_FILE_SYSTEM
    long ret = initBuffer();
    if (ret != WS_NO_ERR){
      return WS_ERR;
    }
    WSCuchar* buf = getBuffer();

    FILE* fp = fopen(fname,"w");
    if (fp != NULL){
      long ret = fn(fp,(char*)buf,_w,_h);
      if (ret != WS_NO_ERR){
        fclose(fp);
        return WS_ERR;
      }
      fclose(fp);
      return WS_NO_ERR;
    }
#endif //NO_FILE_SYSTEM
  }

  if (dl_init_jpg == 0 && type == WS_IMAGE_JPG){
#ifndef MacOS
    dl_jpg = dlopen("libwsjpg.so",RTLD_LAZY);
    if (dl_jpg == NULL){
      dl_jpg = dlopen("./libwsjpg.so",RTLD_LAZY);
    }
#else //MacOS
    dl = dlopen(
        WSGIappEnvironment()->getPlaneString("$(WSDIR)/lib/jpg.bundle"),
        RTLD_LAZY);
    if (dl == NULL){
      dl = dlopen("/usr/lib/jpg.bundle",RTLD_LAZY);
    }
    if (dl_jpg == NULL){
      dl_jpg = dlopen("./jpg.bundle",RTLD_LAZY);
    }
#endif //MacOS
    if (dl_jpg == NULL){
#ifndef MacOS
WSMFtrace("ERROR. in WSDximage::initialize(). Library jpg.so open error. \nso, jpeg image can not support...\n");
#else //MacOS
WSMFtrace("ERROR. in WSDximage::initialize(). Library jpg.bundle open error. \nso, jpeg image can not support...\n");
#endif //MacOS
    }else{
      fn_jpg = (long (*)(FILE*,char*,long,long))dlsym(dl_jpg,"JpegWriteBufToFp");
      if (fn_jpg == NULL){
WSMFtrace("ERROR. in WSDximage::initialize(). Library jpg.so is invalid. \nso, jpeg image can not support...\n");
      }
    }
  }
//printf("fn_jpg=0x%x\n",fn_jpg);
  if (fn_jpg != NULL && type == WS_IMAGE_JPG){
#ifndef NO_FILE_SYSTEM
    long ret = initBuffer();
    if (ret != WS_NO_ERR){
      return WS_ERR;
    }
    WSCuchar* buf = getBuffer();

    FILE* fp = fopen(fname,"w");
    if (fp != NULL){
      long ret = fn_jpg(fp,(char*)buf,_w,_h);
      if (ret != WS_NO_ERR){
        fclose(fp);
        return WS_ERR;
      }
      fclose(fp);
      return WS_NO_ERR;
    }
#endif //NO_FILE_SYSTEM
  }

  return WS_ERR;
}

long
_pscopypixmap( WSDmwindowDev *mdev, short x,  short y, WSCushort w,  WSCushort h,
	  WSDdev *dev, short dx,  short dy, WSDimage *maskimage ){
    long ret;
    WSCushort pw=maskimage->getImageWidth();
    WSCushort ph=maskimage->getImageHeight();

    WSDmwindowDev* maskmdev = WSDmwindowDev::getNewInstance();
    if (maskmdev != NULL){
	WSDdraw* bk = WSDdev::getDraw();
	WSDdev::setDraw(WSDdev::getNativeDraw());

	maskmdev->createPixmap(pw,ph);
	maskmdev->beginDraw(0,0,pw,ph);
	maskmdev->drawImage(0,0,x+w,y+h,maskimage,WS_LEFT_TOP);
	maskmdev->endDraw();
	maskmdev->initBuffer();
	WSDdev::setDraw(bk);
    }
    ret=_pscopypixmap( mdev, x, y, w, h, dev, dx, dy, maskmdev );
    if (maskmdev != NULL){
	delete maskmdev;
    }
    return ret;
}

long
_pscopypixmap( WSDmwindowDev *mdev, short x,  short y, WSCushort w,  WSCushort h,
	  WSDdev *dev, short dx,  short dy, WSDmwindowDev *maskmdev ){
    WSDdev *pdev=dev->getParentDev();
    WSDprDev *prdev;

    if( pdev ){
	prdev=(WSDprDev *)pdev->cast("WSDprDev");
    }else{
	prdev=(WSDprDev *)dev->cast("WSDprDev");
    }
    WSDdraw *prdraw=prdev->getDraw();

    WSDpsdraw *psdraw=(WSDpsdraw *)prdraw->cast("WSDpsdraw");

    if( psdraw==NULL ){
	return WS_ERR;
    }

    WSCbool scaled = prdev->getScaled();
    if (scaled != False){
	double scale = prdev->getScale();
	psdraw->copyPixmap( mdev, x, y,
			    (WSCushort)(w*scale),
			    (WSCushort)(h*scale),
			    (short)(dx*scale)+prdev->_x,
			    (short)(dy*scale)+prdev->_y, maskmdev );
    }else{
	psdraw->copyPixmap( mdev, x, y, w, h, dx+prdev->_x, dy+prdev->_y, maskmdev );
    }
    return WS_NO_ERR;
}
