//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef _XUNICODE_H_
#define _XUNICODE_H_

#ifdef WIN32
#include <windows.h>
extern BOOL xunicode_enable;
typedef wchar_t XUChar;
#else
#include <X11/Xlib.h>
#include <X11/Xutil.h>
extern Bool xunicode_enable;
typedef unsigned short XUChar;
#endif

#define XU_FONT_COUNT      24
#define XU_FONT_NONE        0
#define XU_FONT_ISO8859(n) (n) /* 1-15 */
#define XU_FONT_UNICODE    16
#define XU_FONT_KOI8R      17
#define XU_FONT_JIS0201    18
#define XU_FONT_JIS0208    19
#define XU_FONT_KSC5601    20
#define XU_FONT_GB2312     21
#define XU_FONT_BIG5       22
#define XU_FONT_CP1251     23

#define XU_CONV_LOCALE     -1
#define XU_CONV_NONE        0
#define XU_CONV_ISO8859(n) (n) /* 1-15 */
#define XU_CONV_UTF8       16
#define XU_CONV_KOI8R      17
#define XU_CONV_EUCJP      20
#define XU_CONV_SJIS       21
#define XU_CONV_EUCKR      30
#define XU_CONV_EUCCN      40
#define XU_CONV_BIG5       50
#define XU_CONV_CP1251     60

void XUInit();

#ifndef WIN32
struct _XUInfoFontSetting {
  struct _XUInfoFontSetting* previous;
  struct _XUInfoFontSetting* next;
  char* name;
  int count;
  int order[XU_FONT_COUNT];
  char* font[XU_FONT_COUNT];
};
typedef struct _XUInfoFontSetting XUInfoFontSetting;

struct _XUInfoFont {
  struct _XUInfoFont* previous;
  struct _XUInfoFont* next;
  char* name;
  int count;
  int order[XU_FONT_COUNT];
  Bool none[XU_FONT_COUNT];
  char* fontName[XU_FONT_COUNT];
  XFontStruct* font[XU_FONT_COUNT];
  char* fontSetName;
  XFontSet fontSet;
  int fheight;
};
typedef struct _XUInfoFont XUInfoFont;
#if 0 //deleted 2005/01/05
struct _XUInfoWindow {
  struct _XUInfoWindow* previous;
  struct _XUInfoWindow* next;
  Window window;
  int top, left, width, height;
  XFontStruct* font;
  XFontSet fontSet;
  XIC xic;
  int xicX, xicY;
  Bool xicFocus;
};
typedef struct _XUInfoWindow XUInfoWindow;
#endif
struct _XUInfoDisplay {
  struct _XUInfoDisplay* previous;
  struct _XUInfoDisplay* next;
  Display* display;
#if 0 //deleted 2005/01/05
  XIM xim;
  Window uinput;
  XUInfoWindow* window;
#endif
  XUInfoFont* font[256];
#if 0 //deleted 2005/01/05
  Atom isSrv, setSrv, input, cancel;
  Atom atmFont;
#endif
};
typedef struct _XUInfoDisplay XUInfoDisplay;

void XUDebug(const char* fmt,  ...);
int XUCloseDisplay(Display* display);
//int XUDestroyWindow(Display* display, Window window);
//int XUErrorHandler(Display* display, XErrorEvent* error);
//void XUGetWindowPos(XPoint* point, Display* display, Window window);
//void XUDrawString(Display* display, Drawable d, XFontStruct* font, GC gc, int x, int y, const XUChar* string, int length, Bool erase);
void XUDrawString(Display* display, Drawable d, char* fname, int fheight,GC gc, int x, int y, const XUChar* string, int length, Bool erase);
//void XUutf8DrawString(Display* display, Drawable d, XFontStruct* font, GC gc, int x, int y, const char* string, int length, Bool erase);
int XUQueryChar(XUChar* c, Display* display, XUInfoFont* fi);
//void XUTextExtents(Display* display, XFontStruct* font_struct, const XUChar* string, int nchars, int* direction_return, int* font_ascent_return, int* font_descent_return, XCharStruct* overall_return);
void XUFontExtents(Display* display, char* fname, int fheight,int* direction_return, int* font_ascent_return, int* font_descent_return);

void XUTextExtents(Display* display, char* fname, int fheight,const XUChar* string, int nchars, int* direction_return, int* font_ascent_return, int* font_descent_return, XCharStruct* overall_return);
//int XUCharWidth(Display* display, XFontStruct* font, XUChar ch);
//int XUTextWidth(Display* display, XFontStruct* font, const XUChar* text, int length);
int XUTextWidth(Display* display, char* fname, int fheight,const XUChar* text, int length);
void XUutf8TextExtents(Display* display, char* fname, int fheight,const char* string, int nchars, int* direction_return, int* font_ascent_return, int* font_descent_return, XCharStruct* overall_return);
//int XUutf8CharWidth(Display* display, XFontStruct* font, const char* text, int length);
//int XUutf8TextWidth(Display* display, XFontStruct* font, const char* text, int length);
int XUutf8TextWidth(Display* display, char* fname, int fheight,const char* text, int length);
//char* XUQueryFont(char* dest, int max, Display* display, const char* family, int pixel, Bool bold, Bool italic);
//XFontStruct* XULoadQueryFont(Display* display, const char* family, int pixel, Bool bold, Bool italic);
//char* XUSearchFont(char* dest, int max, Display* display, const char* font, int charset);
XFontStruct* XULoadSearchFont(Display* display, const char* font, int fheight,int charset);
char* XUCompareFonts(char* dest, int max, const char* font, char* fonts[], int count);
Bool XUSplitFontName(char* font, char* sep[]);
//char* XUGetFontName(Display* display, XFontStruct* font);
//char* XUGetFontSet(char* dest, int max, const char* separator, Display* display, const char* font);
//XFontSet XUCreateFontSet(Display* display, XFontStruct* font);
//Bool XUIMOpen(Display* display);
//Bool XUIMSet(Display* display, Window window, XFontStruct* font, int left, int top, int width, int height, int x, int y);
//Bool XUIMCreateIC(Display* display, Window window, XUInfoWindow* w);
//void XUIMUnset(Display* display, Window window);
//int XULookupString(Display* display, Window window, XEvent* event_struct, XUChar* buffer_return, int bytes_buffer, KeySym* keysym_return, XComposeStatus* status_in_out);
//int XUutf8LookupString(Display* display, Window window, XEvent* event_struct, char* buffer_return, int bytes_buffer, KeySym* keysym_return, XComposeStatus* status_in_out);
//void XUUISearch(Display* display, Window window);
//void XUUISet(Display* display, const XEvent* event);
//Bool XUUISend(Display* display, Window window, const XEvent* event);
//Bool XUUICancel(Display* display);
XUInfoDisplay* XUGetInfoDisplay(Display* display);
//XUInfoWindow* XUGetInfoWindow(Display* display, Window window);
XUInfoFontSetting* XUGetInfoFontSetting(const char* family);
XUInfoFont* XUGetInfoFont(Display* display, const char* font,int fheight);
void XUSearchOrder(Display* display, XUInfoFont* f);
Bool XUApplySetting(Display* display, XUInfoFont* f, const char* family);
void XUAddFonts(Display* display, XUInfoFont* f, const char* query);
Bool XUFontExists(Display* display, const char* font, int charset);
void XUAddCharset(XUInfoFont* f, int charset);
void XUInsertCharset(XUInfoFont* f, int charset);
void XUFreeInfoDisplay(Display* display);
//void XUFreeInfoWindow(Display* display, Window window);
void XUFreeInfoFont(Display* display, XUInfoFont* font);
int XUctEncode(XUChar* dest, int max, const char* text, int length);
int XUctDecode(char* dest, int max, const XUChar* text, int length);
#endif

XUChar XUCharEncode(const char* text, int max, int code,int* rlen);
int XUCharDecode(char* dest, int max, XUChar ch, int code);
int XUCharLen(const char* text, int max, int code);
XUChar XUutf8CharEncode(const char* text, int max,int* rlen);
int XUutf8CharDecode(char* dest, int max, XUChar ch);
int XUutf8CharLen(const char* text, int max);
int XUutf8CharRLen(const char* text, int max);
int XUStrLen(const XUChar* text);
int XUEncode(XUChar* dest, int max, const char* text, int length, int code);
int XUDecode(char* dest, int max, const XUChar* text, int length, int code);
int XULen(const char* text, int max, int code);
int XUutf8Encode(XUChar* dest, int max, const char* text, int length);
int XUutf8Decode(char* dest, int max, const XUChar* text, int length);
int XUutf8Len(const char* text, int max);
int XUCodeConv(char* dest, int max, int codeTo, const char* text, int length, int codeFrom);

#endif
