//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <X11/Xlib.h>
#include <stdio.h>

#ifdef SUN
#include <X11/xpm.h>
//#include <Xm/XpmP.h> //needs SOLARIS 8 with libXm.so...
#else
#include <X11/xpm.h>
#endif

extern "C" {
extern long ReadXpm(Display* ,Window,Colormap,char*,Pixmap*,Pixmap*,long*,long*);
extern long CreateXpmFromData(Display* ,Window,Colormap,char**,Pixmap*,Pixmap*,long*,long*);
};

long ReadXpm(Display* d,Window w,Colormap cm,char* fname, Pixmap* p1,Pixmap* p2,long* width,long* height){
     XpmAttributes att;
     att.closeness = 128;
     att.colormap = cm;
     att.valuemask = XpmSize | XpmCloseness | XpmReturnPixels | XpmColormap;
     long ret = XpmReadFileToPixmap( d,w, fname,p1, p2, &att);
     *width = att.width;
     *height = att.height;
     return ret;
}
long CreateXpmFromData(Display* d,Window w,Colormap cm,char** data, Pixmap* p1,Pixmap* p2,long* width,long* height){
     XpmAttributes att;
     att.closeness = 128;
     att.colormap = cm;
     att.valuemask = XpmSize | XpmCloseness | XpmReturnPixels | XpmColormap;

     long ret = XpmCreatePixmapFromData( d,w, data,p1, p2, &att);
     *width = att.width;
     *height = att.height;
     return ret;
}
