//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCOPENGLFORM_H
#define WSCOPENGLFORM_H

//#define GL_GLEXT_LEGACY

#include <WScom.h>
#include <WSCform.h>

#define WSCopenglForm_VER  1000

#ifdef MSW
#ifndef _WINGDI_
#define _WINGDI_
#endif  //_WINGDI_
#endif

class WSCopenglForm   :public WSCform{

  protected:
    void*  _opengl_context;
    WSCbool _double_buffer;
    unsigned  _begin_draw_fl:1;
    unsigned  _context_created_fl:1;

//    virtual long _device_initialize();
    void _delete_context();
    long (*_create_context_handler)();
    long _default_create_context();
    long _create_context();

    long (*_update_context_handler)();
    long _default_update_context();
    long _update_context();
  public:

    WSCopenglForm(WSCbase* base, char* name);

    virtual ~WSCopenglForm();
    virtual long draw();
    virtual void update();
    virtual long execEventProc(long,void*);

    virtual void onVisibleChange(WSCbool);
    virtual void onResize(WSCrect*);
    void* getOpenGLContext();

    virtual long beginDraw();
    virtual long endDraw();

    void setCreateContextHandler(long(*hd)());
    void setUpdateContextHandler(long(*hd)());
    void makeCurrent();
    void noMakeCurrent();

    WSMFguiClassDef(WSCopenglForm,WSCform);
    WSMFversionDef(WSCopenglForm);
};

#endif //WSCOPENGLFORM_H
