//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCINSPECTOR_H
#define WSCINSPECTOR_H

#include <WScom.h>
#include <WSCsform.h>
#include <WSClistData.h>

#define WSCinspector_VER 1000
class WSCindexForm;
class WSCpropertyEditor;
class WSClist;
class WSCprocedureEditor;
class WSCwindowEditor;
class WSCpopupMenu;
class WSCfform;

class WSCinspector :public WSCsform{

  protected:
    WSClist*           _list;
    WSCindexForm*      _area2;
    WSCpropertyEditor* _prope;
    WSClistData*       _target_list;
    WSCprocedureEditor* _ope;
    WSCwindowEditor*    _we;
    WSCpopupMenu*       _pmenu;
    WSCpopupMenu*       _pmenu2;
    WSClist*           _list2;
    WSClistData        _pname;
    WSClistData        _procs;
    WSClistData*       _selected;
    WSCbase*           _pmenu_client;
    WSClist*           _file_list;
    WSCfform*          _fform;

    void (*_search_proc)(WSCbase*);
    void (*_copy_proc)(WSCbase*);
    void (*_paste_proc)(WSCbase*);
    void (*_editor_proc)(WSCprocedureEditor*,char*);

    void _adjust_work();

    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);
    virtual void setWorkWSNshadowThickness(WSCuchar);
  
    virtual void onResize(WSCrect* rect);

    WSCbase* _search_inst_work(char* name,WSCbase*);
    static void _area2_work(WSCbase*);
    static void _pe_select_work(WSCbase*);
    static void _prope_activate_work(WSCbase*);
    static void _lb_press_work(WSCbase*);
    static void _lb_activate_work(WSCbase*);
    static void _flb_activate_work(WSCbase*);
    static void _lb_activate2_work(WSCbase*);
    static void _popup_ch_work(WSCbase*);
    static void _file_list_vis_work(WSCbase*);
    static void _flb_press_work(WSCbase*);
    static void _float_work(WSCbase*);

    static void _prj_work(WSCbase*);
    static void _cmpl_work(WSCbase*);
    static void _save_work(WSCbase*);
    static void _disp_work(WSCbase*);
    static void _search_work(WSCbase*);
    static void _copy_work(WSCbase*);
    static void _paste_work(WSCbase*);
    static void _del_work(WSCbase*);

    void _set_list_work(WSCbase*,long);
    void _set_file_list_work(WSCbase*);
    void _update_lb();
    void (*_getproc(char*))(WSCbase*);
    virtual WSCbase* getPropertyInheritChild();

  public:
    WSCinspector(WSCbase*,char*);
    virtual ~WSCinspector();
    virtual  long initialize();

    WSCbase* getPropertyEditor();
    WSCbase* getProcedureEditor();

    void setClients(WSClistData*);
    void setSelectedClientList(WSClistData*);
    void updateList();
    WSCbase* getSelectedClient();
    void setGetDirHandler(void*);
    char* getSrcPath();
    void setEditorExecuteHandler(void*);
    WSCbase* getPopupMenuSelectedClient();

    virtual long draw();

    WSMFguiClassDef(WSCinspector,WSCsform);
    WSMFversionDef(WSCinspector);
};
#endif
