//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDMACWINDEV_H
#define WSDMACWINDEV_H

#include <mac/WSDmacFormDev.h>
#include <Carbon/Carbon.h>

class WSDmacWinDev   :public WSDmacFormDev{
 protected:
  WindowRef _win;
  WindowRef _win2;
  DialogRef _dialog;
//  short _diff_x;
//  short _diff_y;
  short _diff_x2;
  short _diff_y2;
  char   _title_bar;
  char   _title_bar_style;
  WSCpoint _top_left;
  unsigned long _setv;
  unsigned long _clv;
  unsigned long _win_type;
//  WSDmacFormDev* _mouse_press_target;
//  WSDmacFormDev* _mouse_move_target;

  unsigned _no_frame:1;
  unsigned _requested_top:1;
  unsigned _no_frame_first_time:1;
  unsigned _transient:1;
  unsigned _top_float:1;
  unsigned _modal:1;
  unsigned _already_exposed:1;

  virtual long createWindow();
  virtual long destroyWindow();
  static pascal OSStatus _evh_mouse_pressed(EventHandlerCallRef nh,
                                         EventRef ev,void* d);
  static pascal OSStatus _evh_mouse_released(EventHandlerCallRef nh,
                                         EventRef ev,void* d);
  static pascal OSStatus _evh_mouse_entered(EventHandlerCallRef nh,
                                         EventRef ev,void* d);
  static pascal OSStatus _evh_mouse_leaved(EventHandlerCallRef nh,
                                         EventRef ev,void* d);
  static pascal OSStatus _evh_mouse_moved(EventHandlerCallRef nh,
                                         EventRef ev,void* d);
  static pascal OSStatus _evh_exposed(EventHandlerCallRef nh,
                                         EventRef ev,void* d);
  static pascal OSStatus _evh_mouse_dragged(EventHandlerCallRef nh,
                                         EventRef ev,void* d);
  static pascal OSStatus _evh_mouse_wheel_moved(EventHandlerCallRef nh,
                                         EventRef ev,void* d);
//  static pascal OSStatus _evh_resized(EventHandlerCallRef nh,
//                                         EventRef ev,void* d);

#if 0 //XXZZ
  static  void _evh_client_message(Widget,void*,XEvent*,WSCbool* );
  static  void _evh_delete2(Widget,void*,void*);
  static  void _evh_resize(Widget,void*,XEvent*,WSCbool* );
  static  void _evh_expose(Widget,void*,XEvent*,WSCbool* );
  static  void _evh_focus_ch(Widget,void*,XEvent*,WSCbool* );
  static  void _evh_mouse_in(Widget,void*,XEvent*,WSCbool* );
  static  void _float_top_timer_proc(WSCuchar,void*);
  static WSClistData  _no_frame_list;
  static void _add_list(WSDmacWinDev*);
  static void _del_list(WSDmacWinDev*);
  static void _popup_window(WSDmacWinDev*);
  static WSCbool _chk_popup(WSDmacWinDev*);
#endif //XXZ
 public:
  WSDmacWinDev();
  virtual ~WSDmacWinDev();
  virtual long setVisible(WSCbool fl);
  virtual long setValue(long kind,void*);
  virtual long getValue(long kind,void*);

  virtual WSDdev* getParentDev();
  virtual WSDdev* getVisibleParentDev();
  virtual long getWindowResource();
  virtual long getContextResource();
  virtual WindowRef getBaseWindow();

  virtual long resize_execute(long,long);
  virtual long move_execute(long,long);

//  Widget getShell();
  WindowRef getShellWindow();
  virtual void getVaridArea(long*,long*,long*,long*);
  virtual void getAbsoluteVaridArea(long*,long*,long*,long*);
  virtual void getGeometry(long*,long*,long*,long*);
  virtual void getAbsoluteGeometry(long*,long*,long*,long*);

  WSMFclassDef(WSDmacWinDev,WSDmacFormDev);
};
#endif
