//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCRbase.h>
#include <WSCbase.h>
#include <WSCbaseList.h>

WSMFclassInit(WSCRbase,WSCRroot);

WSCindexData* WSCRbase::_create_handlers=NULL;
WSCRbase::WSCRbase(){
  _local = NULL;
}

WSCRbase::~WSCRbase(){
}
void WSCRbase::setCreateHandler(char* cn,WSCRbase* (*hd)()){
  if (_create_handlers == NULL){
    _create_handlers = new WSCindexData();
  }
  _create_handlers->setData(cn,(void*)hd);
}
WSCRbase* WSCRbase::getNewInstance(char* cn){
  WSCRbase* (*hd)() = (WSCRbase*(*)())(*_create_handlers)[cn];
  if (hd != NULL){
    return hd();
  }
  return new WSCRbase;
}

void WSCRbase::setLocalInstance(WSCbase* inst){
  _local = inst;
}
WSCbool WSCRbase::setProperty(char* pname,const WSCvariant& val){
  if (_local != NULL){
    return _local->setProperty(pname,val);
  }
  WSCvariant tmp = val;
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("setProperty");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  _db->save(WS_DcRString,"prop",(void*)pname);
  _db->save(WS_DcRString,"val",(void*)tmp.getCharPtr());
  WSCbool ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
WSCvariant WSCRbase::getProperty(char* pname){
  if (_local != NULL){
    return _local->getProperty(pname);
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("getProperty");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  _db->save(WS_DcRString,"prop",(void*)pname);
  char* ret = NULL;
  _db->loadAlloc(WS_DcRString,"ret",(void**)&ret,NULL);
  endRemoteCall();
  WSCvariant ret2;
  if (ret != NULL){
    ret2 = ret;
    delete ret;
  }
  return ret2;
}

void WSCRbase::setVisible(WSCbool fl){
  if (_local != NULL){
    _local->setVisible(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("setVisible");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  _db->save(WS_DcRChar,"vis",(void*)&fl);
  endRemoteCall();
}
long WSCRbase::setFocus(WSCbool fl){
  if (_local != NULL){
    return _local->setFocus(fl);
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("setFocus");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return WS_ERR;
  } 
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
long WSCRbase::setSpecialFocus(WSCbool fl){
  if (_local != NULL){
    return _local->setSpecialFocus(fl);
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("setSpecialFocus");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return WS_ERR;
  } 
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

WSCbool WSCRbase::getVisible(){
  if (_local != NULL){
    return _local->getVisible();
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("getVisible");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  WSCbool ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
WSCbool WSCRbase::getFocus(){
  if (_local != NULL){
    return _local->getFocus();
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("getFocus");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  WSCbool ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
WSCbool WSCRbase::getSpecialFocus(){
  if (_local != NULL){
    return _local->getSpecialFocus();
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("getSpecialFocus");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  WSCbool ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

void WSCRbase::setSensitive(WSCbool fl){
  if (_local != NULL){
    _local->setSensitive(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("setSensitive");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  _db->save(WS_DcRChar,"det",(void*)&fl);
  endRemoteCall();
}
WSCbool WSCRbase::getSensitive(){
  if (_local != NULL){
    return _local->getSensitive();
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("setSensitive");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  WSCbool ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

void WSCRbase::execProcedure(char* pname){
  if (_local != NULL){
    _local->execProcedure(pname);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("execProcedureS");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  _db->save(WS_DcRString,"pn",(void*)pname);
  endRemoteCall();
}
void WSCRbase::execProcedure(long ev){
  if (_local != NULL){
    _local->execProcedure(ev);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("execProcedureL");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  _db->save(WS_DcRLong,"ev",(void*)&ev);
  endRemoteCall();
}
void WSCRbase::onMouseIn(WSCpoint* pt){
  if (_local != NULL){
    _local->onMouseIn(pt);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onMouseIn");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  long x = pt->x;
  _db->save(WS_DcRLong,"x",(void*)&x);
  long y = pt->y;
  _db->save(WS_DcRLong,"y",(void*)&y);
  endRemoteCall();
}

void WSCRbase::onMouseOut(){
  if (_local != NULL){
    _local->onMouseOut();
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onMouseOut");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  endRemoteCall();
}
void WSCRbase::onMouseMove(WSCpoint* pt){
  if (_local != NULL){
    _local->onMouseMove(pt);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onMouseMove");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  long x = pt->x;
  _db->save(WS_DcRLong,"x",(void*)&x);
  long y = pt->y;
  _db->save(WS_DcRLong,"y",(void*)&y);
  endRemoteCall();
}
void WSCRbase::onMousePress(WSCpoint* pt){
  if (_local != NULL){
    _local->onMousePress(pt);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onMousePress");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  long x = pt->x;
  _db->save(WS_DcRLong,"x",(void*)&x);
  long y = pt->y;
  _db->save(WS_DcRLong,"y",(void*)&y);
  endRemoteCall();
}
void WSCRbase::onMouseRelease(WSCpoint* pt){
  if (_local != NULL){
    _local->onMouseRelease(pt);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onMouseRelease");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  long x = pt->x;
  _db->save(WS_DcRLong,"x",(void*)&x);
  long y = pt->y;
  _db->save(WS_DcRLong,"y",(void*)&y);
  endRemoteCall();
}
void WSCRbase::onExpose(WSCrect* rect){
  if (_local != NULL){
    _local->onExpose(rect);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onExpose");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  long x = rect->x;
  _db->save(WS_DcRLong,"x",(void*)&x);
  long y = rect->y;
  _db->save(WS_DcRLong,"y",(void*)&y);
  WSCulong w = rect->width;
  _db->save(WS_DcRULong,"w",(void*)&w);
  WSCulong h = rect->height;
  _db->save(WS_DcRULong,"y",(void*)&h);
  endRemoteCall();
}
void WSCRbase::onResize(WSCrect* rect){
  if (_local != NULL){
    _local->onResize(rect);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onResize");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  long x = rect->x;
  _db->save(WS_DcRLong,"x",(void*)&x);
  long y = rect->y;
  _db->save(WS_DcRLong,"y",(void*)&y);
  WSCulong w = rect->width;
  _db->save(WS_DcRULong,"w",(void*)&w);
  WSCulong h = rect->height;
  _db->save(WS_DcRULong,"h",(void*)&h);
  endRemoteCall();
}
void WSCRbase::onVisibleChange(WSCbool fl){
  if (_local != NULL){
    _local->onVisibleChange(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onVisibleChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRbase::onSensitiveChange(WSCbool fl){
  if (_local != NULL){
    _local->onSensitiveChange(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onSensitiveChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRbase::onParentVisibleChange(WSCbool fl){
  if (_local != NULL){
    _local->onParentVisibleChange(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onParentVisibleChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRbase::onParentSensitiveChange(WSCbool fl){
  if (_local != NULL){
    _local->onParentSensitiveChange(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onParentSensitiveChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRbase::onEditModeChange(WSCbool fl){
  if (_local != NULL){
    _local->onEditModeChange(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onEditModeChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRbase::onFocusChange(WSCbool fl){
  if (_local != NULL){
    _local->onFocusChange(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onFocusChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRbase::onSpecialFocusChange(WSCbool fl){
  if (_local != NULL){
    _local->onSpecialFocusChange(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onSpecialFocusChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRbase::onSelectionChange(WSCbool fl){
  if (_local != NULL){
    _local->onSelectionChange(fl);
    return;
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("onSelectionChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}






long WSCRbase::draw(){
  if (_local != NULL){
    return _local->draw();
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("draw");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
long WSCRbase::clear(){
  if (_local != NULL){
    return _local->clear();
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("clear");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
long WSCRbase::redraw(){
  if (_local != NULL){
    return _local->redraw();
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("redraw");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
long WSCRbase::cdraw(){
  if (_local != NULL){
    return _local->cdraw();
  }
  WSCremoteCall rc;
  rc.setClassName("WSCbase");
  rc.setOperationName("cdraw");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return False;
  } 
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}


void _WSCbase_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 's'){
    if (!strcmp(rc->_op,"setVisible")){
      WSCbool val;
      db->load(WS_DcRChar,"vis",(void*)&val);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->setVisible(val);
      }
    }else
    if (!strcmp(rc->_op,"setFocus")){
      WSCbool val;
      db->load(WS_DcRChar,"fl",(void*)&val);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = 0;
      if (inst != NULL){
        ret = inst->setFocus(val);
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
    }else
    if (!strcmp(rc->_op,"setSpecialFocus")){
      WSCbool val;
      db->load(WS_DcRChar,"fl",(void*)&val);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = 0;
      if (inst != NULL){
        ret = inst->setSpecialFocus(val);
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
    }else


    if (!strcmp(rc->_op,"setProperty")){
      char* prop;
      char* val;
      db->loadAlloc(WS_DcRString,"prop",(void**)&prop,NULL);
      db->loadAlloc(WS_DcRString,"val",(void**)&val,NULL);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = 0;
      if (inst != NULL && prop != NULL && val != NULL){
        ret = inst->setProperty(prop,val);
      }
      if (prop != NULL){
        delete prop;
      }
      if (val != NULL){
        delete val;
      }
      db->save(WS_DcRChar,"ret",(void*)&ret);
    }else

    if (!strcmp(rc->_op,"setSensitive")){
      WSCbool val;
      db->load(WS_DcRChar,"det",(void*)&val);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->setSensitive(val);
      }
    }
  }else
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getVisible")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCbool ret = inst->getVisible();
        db->save(WS_DcRChar,"ret",(void*)&ret);
      }else{
        WSCbool ret = 0;
        db->save(WS_DcRChar,"ret",(void*)&ret);
      }
    }else
    if (!strcmp(rc->_op,"getFocus")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCbool ret = inst->getFocus();
        db->save(WS_DcRChar,"ret",(void*)&ret);
      }else{
        WSCbool ret = 0;
        db->save(WS_DcRChar,"ret",(void*)&ret);
      }
    }else
    if (!strcmp(rc->_op,"getSpecialFocus")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCbool ret = inst->getSpecialFocus();
        db->save(WS_DcRChar,"ret",(void*)&ret);
      }else{
        WSCbool ret = 0;
        db->save(WS_DcRChar,"ret",(void*)&ret);
      }
    }else



    if (!strcmp(rc->_op,"getProperty")){
      char* prop;
      db->loadAlloc(WS_DcRString,"prop",(void**)&prop,NULL);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      WSCvariant ret;
      if (inst != NULL && prop != NULL){
        ret = inst->getProperty(prop);
      }
      if (prop != NULL){
        delete prop;
      }
      db->save(WS_DcRString,"ret",(void*)ret.getCharPtr());
    }else
    if (!strcmp(rc->_op,"getSensitive")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCbool ret = inst->getSensitive();
        db->save(WS_DcRChar,"ret",(void*)&ret);
      }else{
        WSCbool ret = 0;
        db->save(WS_DcRChar,"ret",(void*)&ret);
      }
    }
  }else
  if ( rc->_op[0] == 'e'){
    if (!strcmp(rc->_op,"execProcedureS")){
      char* val = NULL;
      db->loadAlloc(WS_DcRString,"pn",(void**)&val,NULL);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL && val != NULL){
        inst->execProcedure(val);
      }
      if (val != NULL){
        delete val;
      }
    }else
    if (!strcmp(rc->_op,"execProcedureL")){
      long val;
      db->load(WS_DcRLong,"pn",(void*)&val);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->execProcedure(val);
      }
    }
  }else
  if ( rc->_op[0] == 'd'){
    if (!strcmp(rc->_op,"draw")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        long ret = inst->draw();
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
    }
  }else
  if ( rc->_op[0] == 'r'){
    if (!strcmp(rc->_op,"redraw")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        long ret = inst->redraw();
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
    }
  }else
  if ( rc->_op[0] == 'c'){
    if (!strcmp(rc->_op,"cdraw")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        long ret = inst->cdraw();
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
    }else
    if (!strcmp(rc->_op,"clear")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        long ret = inst->clear();
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
    }
  }else
  if ( rc->_op[0] == 'o'){
    if (!strcmp(rc->_op,"onMouseIn")){
      WSCpoint* pt = new WSCpoint();
      db->load(WS_DcRLong,"x",(void*)&pt->x);
      db->load(WS_DcRLong,"y",(void*)&pt->y);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onMouseIn(pt);
      }
      if (pt != NULL){
        delete pt;
      }
    }else
    if (!strcmp(rc->_op,"onMouseOut")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onMouseOut();
      }
    }else
    if (!strcmp(rc->_op,"onMouseMove")){
      WSCpoint* pt = new WSCpoint();
      db->load(WS_DcRLong,"x",(void*)&pt->x);
      db->load(WS_DcRLong,"y",(void*)&pt->y);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onMouseMove(pt);
      }
      if (pt != NULL){
        delete pt;
      }
    }else
    if (!strcmp(rc->_op,"onMousePress")){
      WSCpoint* pt = new WSCpoint();
      db->load(WS_DcRLong,"x",(void*)&pt->x);
      db->load(WS_DcRLong,"y",(void*)&pt->y);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onMousePress(pt);
      }
      if (pt != NULL){
        delete pt;
      }
    }else
    if (!strcmp(rc->_op,"onMouseRelease")){
      WSCpoint* pt = new WSCpoint();
      db->load(WS_DcRLong,"x",(void*)&pt->x);
      db->load(WS_DcRLong,"y",(void*)&pt->y);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onMouseRelease(pt);
      }
      if (pt != NULL){
        delete pt;
      }
    }else
    if (!strcmp(rc->_op,"onExpose")){
      WSCrect* rect = new WSCrect();
      db->load(WS_DcRLong,"x",(void*)&rect->x);
      db->load(WS_DcRLong,"y",(void*)&rect->y);
      db->load(WS_DcRULong,"w",(void*)&rect->width);
      db->load(WS_DcRULong,"h",(void*)&rect->height);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onExpose(rect);
      }
      if (rect != NULL){
        delete rect;
      }
    }else
    if (!strcmp(rc->_op,"onResize")){
      WSCrect* rect = new WSCrect();
      db->load(WS_DcRLong,"x",(void*)&rect->x);
      db->load(WS_DcRLong,"y",(void*)&rect->y);
      db->load(WS_DcRULong,"w",(void*)&rect->width);
      db->load(WS_DcRULong,"h",(void*)&rect->height);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onResize(rect);
      }
      if (rect != NULL){
        delete rect;
      }
    }else
    if (!strcmp(rc->_op,"onVisibleChange")){
      WSCbool fl;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onVisibleChange(fl);
      }
    }else
    if (!strcmp(rc->_op,"onSensitiveChange")){
      WSCbool fl;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onSensitiveChange(fl);
      }
    }else
    if (!strcmp(rc->_op,"onParentVisibleChange")){
      WSCbool fl;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onParentVisibleChange(fl);
      }
    }else
    if (!strcmp(rc->_op,"onParentSensitiveChange")){
      WSCbool fl;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onParentSensitiveChange(fl);
      }
    }else
    if (!strcmp(rc->_op,"onEditModeChange")){
      WSCbool fl;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onEditModeChange(fl);
      }
    }else
    if (!strcmp(rc->_op,"onFocusChange")){
      WSCbool fl;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onFocusChange(fl);
      }
    }else
    if (!strcmp(rc->_op,"onSpecialFocusChange")){
      WSCbool fl;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onSpecialFocusChange(fl);
      }
    }else
    if (!strcmp(rc->_op,"onSelectionChange")){
      WSCbool fl;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        inst->onSelectionChange(fl);
      }

    }
  }

}
WSMFdefineDrNetServer(WSCbase,_WSCbase_remote_call);

