//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvdb.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCdb.h>

#define SQL_MAX_MESSAGE_LENGTH           255

WSMFguiClassInitialize(WSCvdb, WSCngbase);
WSMFversion(WSCvdb, WSCngbase);

WSCvdb::WSCvdb(WSCbase* base, char* objname):
			WSCngbase(base, objname){
  _db = NULL;
  _title_string.setString("DB SQL Client");

  _hostname = WSGFstrdup("localhost");
  _user = WSGFstrdup("username");
  _passwd = WSGFstrdup("password");
  _dbname = WSGFstrdup("dbname");
  _port = 0;
  _type = 0;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvdb);
    WSMFpropertyCreate(WSNhostname,    char*,   _hostname,WSShostname);
    WSMFpropertyCreate(WSNusername,    char*,   _user,WSSusername);
    WSMFpropertyCreate(WSNpassword,    char*,   _passwd,WSSpassword);
    WSMFpropertyCreate(WSNdbname,    char*,   _dbname,WSSdbname);
    WSMFpropertyCreate(WSNport,    WSCushort,   _port,WSSport);
    WSMFpropertyCreate(WSNtype,    WSCuchar,   _type,WSStype);
      WSMFpropertySetSelection(WSRtypedb, WSRtypedbD);


  WSMFpropertyCreateEnd

}

WSMFproperty(WSCvdb, WSNhostname,    char*,   _hostname, WSGFstrdup("hostname"));
WSMFproperty(WSCvdb, WSNusername, char*, _user, WSGFstrdup("username"));
WSMFproperty(WSCvdb, WSNpassword, char*, _passwd, WSGFstrdup("password"));
WSMFproperty(WSCvdb, WSNdbname, char*, _dbname, WSGFstrdup("dbname"));
WSMFproperty(WSCvdb, WSNport, WSCushort, _port, 0);
WSMFproperty(WSCvdb, WSNtype, WSCuchar, _type, 0);

void WSCvdb::setWorkWSNhostname(char*) {}
void WSCvdb::getWorkWSNhostname(char**) {}
void WSCvdb::setWorkWSNusername(char*) {}
void WSCvdb::getWorkWSNusername(char**) {}
void WSCvdb::setWorkWSNpassword(char*) {}
void WSCvdb::getWorkWSNpassword(char**) {}
void WSCvdb::setWorkWSNdbname(char*) {}
void WSCvdb::getWorkWSNdbname(char**) {}
void WSCvdb::setWorkWSNport(WSCushort) {}
void WSCvdb::getWorkWSNport(WSCushort*) {}
void WSCvdb::setWorkWSNtype(WSCuchar) {}
void WSCvdb::getWorkWSNtype(WSCuchar*) {}


WSCvdb::~WSCvdb(){
  if (_db != NULL){
    delete _db;
    _db = NULL;
  }
}
WSCdbDatabase* WSCvdb::getDBDatabase(){
  _init();
  return _db;
}
void WSCvdb::_init(){
  if (_db == NULL){
    _db = new WSCdbDatabase();
    if (_type == 1){
      _db->setDatabase("PGSQL");
    }else
    if (_type == 2){
      _db->setDatabase("MYSQL");
    }else{
      _db->setDatabase("ODBC");
    }
  }
}

long WSCvdb::open(char* hostname,char* uid,char* passwd,char* dbname,char* port){
  _init();
  if (_db != NULL){
    return _db->open(hostname,uid,passwd,dbname,port);
  }
  return WS_ERR;
}
long WSCvdb::open(){
  _init();
  if (_db != NULL){
    // update 2002/07/12
    if(_db->isOpen()) {
        return WS_NO_ERR;
    }
    char port[256];
    sprintf(port,"%d",_port);
    return _db->open(_hostname,_user,_passwd,_dbname,port);
  }
  return WS_ERR;
}



long WSCvdb::close(){
  _init();
  if (_db != NULL){
    return _db->close();
  }
  return WS_ERR;
}
long WSCvdb::beginTran(){
  _init();
  if (_db != NULL){
    return _db->beginTran();
  }
  return WS_ERR;
}
long WSCvdb::commitTran(){
  _init();
  if (_db != NULL){
    return _db->commitTran();
  }
  return WS_ERR;
}

long WSCvdb::abortTran(){
  _init();
  if (_db != NULL){
    return _db->abortTran();
  }
  return WS_ERR;
}

long WSCvdb::sqlExecute(const char* sql){
  _init();
  if (_db != NULL){
    return _db->sqlExecute(sql);
  }
  return WS_ERR;
}

WSCbool WSCvdb::isOpen(){
  _init();
  if (_db != NULL){
    return _db->isOpen();
  }
  return False;
}
void WSCvdb::getErrorMsg(char* msg,long size){
  _init();
  if (_db != NULL){
    char stat[6];
    char buf[SQL_MAX_MESSAGE_LENGTH+1];
    _db->getErrorMsg(stat,buf);
    char buf2[SQL_MAX_MESSAGE_LENGTH+1+32];
    sprintf(buf2,"state: %s ,message: %s",stat,buf);
    if (size > 0){
      strncpy(msg,buf2,size);
// update 2002/06/05
      msg[size-1] = '\0';
    }
    return;
  }
  if (size > 0){
    strncpy(msg,"Not initialized..",size);
// update 2002/06/05
    msg[size-1] = '\0';
  }
  return;
}

WSCstring WSCvdb::getErrorMessage(){
  WSCstring ret;
  _init();
  if (_db != NULL){
    char stat[6];
    char buf[SQL_MAX_MESSAGE_LENGTH+1];
    _db->getErrorMsg(stat,buf);
    char buf2[SQL_MAX_MESSAGE_LENGTH+1+32];
    sprintf(buf2,"state: %s ,message: %s",stat,buf);
    ret.setString(buf2);
    return ret;
  }
  ret.setString("Not initialized..");
  return ret;
}


