//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCpulldownMenuPopup.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSDmouse.h>
#include <WSCfontSet.h>
#include <WSCcolorSet.h>
#include <WSDappDev.h>
#include <WSDkeyboard.h>
#include <string.h>

#define WS_ERR2 -2
#define WS_NO_SELECTED -2

WSMFguiClassInitialize(WSCpulldownMenuPopup, WSCwindow);

struct WSCpulldownData {
  WSCstring  _label;
  WSCstring  _op;
  WSCstring  _sc;
  WSCpulldownData*  _next;
  WSCpulldownData*  _cascade_data;
  short _id;
  WSCbool    _separator;
  WSCbool    _cascaded;
  WSCbool    _sensitive;
public:
  WSCpulldownData();
  ~WSCpulldownData();
  WSCbool   getSensitive(long no);
  WSCbool   getSensitiveWithId(long id);
  WSCpulldownData* getItem(long no);
  WSCpulldownData* getItemWithId(long no);
  long   setSensitive(long no,WSCbool fl );
  long   setSensitiveWithId(long id,WSCbool fl );
  void   setCascaded(WSCbool fl);
  void   add(WSCpulldownData* data);
  long   getItems();

  static  WSCpulldownData* parse(char* menu_string);

};

WSCpulldownData::WSCpulldownData(){
  _id = -1;
  _separator = 0;
  _cascaded = 0;
  _sensitive = 1;
  _next = NULL;
  _cascade_data = NULL;
}

WSCpulldownData::~WSCpulldownData(){
  if (_next != NULL){
    delete _next;
  }
  if (_cascade_data != NULL){
    delete _cascade_data;
  }
}

WSCbool WSCpulldownData::getSensitive(long no){
  WSCpulldownData* data = getItem(no);
  if (data != NULL){
    return data->_sensitive;
  }
  return False;
}

WSCbool WSCpulldownData::getSensitiveWithId(long id){
    WSCpulldownData* data = getItemWithId(id);
    if (data != NULL){
      return data->_sensitive;
    }
    return False;
};

WSCpulldownData* WSCpulldownData::getItem(long no){
     if (no < 0){
       return NULL;
     }
     if (no == 0){
       return this;
     }else if (_separator != False){
       if (_next != NULL){
         return _next->getItem(no);
       }
       return NULL;
     }else{
       if (_next != NULL){
         return _next->getItem(no-1);
       }
       return NULL;
     }
}
WSCpulldownData* WSCpulldownData::getItemWithId(long no){
  if (_id == no){
    return this;
  }else if ( _cascade_data != NULL){
    WSCpulldownData* ret =  _cascade_data->getItemWithId(no);
    if (ret != NULL){
      return ret;
    }
  }
  if (_next != NULL){
    return _next->getItemWithId(no);
  }
  return NULL;
}
long WSCpulldownData::setSensitive(long no,WSCbool fl ){
  if (no < 0){
    return WS_ERR;
  }
  WSCpulldownData* data = getItem(no);
  if (data != NULL){
    data->_sensitive = fl;
    return WS_NO_ERR;
  }
  return WS_ERR2;
}
long WSCpulldownData::setSensitiveWithId(long id,WSCbool fl ){
  WSCpulldownData* data = getItemWithId(id);
  if (data != NULL){
    data->_sensitive = fl;
    return WS_NO_ERR;
  }
  return WS_ERR2;
}
void WSCpulldownData::setCascaded(WSCbool fl){
  _cascaded = fl;
  if (fl != False){
    _cascade_data = parse(_op.getString());
  }else{
    delete _cascade_data;
    _cascade_data = NULL;
  }
}
void WSCpulldownData::add(WSCpulldownData* data){
  if (_next == NULL){
    _next = data;
  }else{
    _next->add(data);
  }
}
long WSCpulldownData::getItems(){
  long cnt = 0;
  if (_separator == False){
    cnt++;
  }
  if (_next != NULL){
    cnt += _next->getItems();
  }
  return cnt;
}

WSCpulldownData* WSCpulldownData::parse(char* menu_string){
    WSCpulldownData* ptr = NULL;
    WSCstring str(menu_string);
    long i;
    long num = str.getWords(",");
    WSCpulldownData* data;
    for(i=0; i<num; i++){
      WSCstring item = str.getWord(i,",");
      if (strcmp(item.getString(),"")){
        data = new WSCpulldownData;
        if ( ptr == NULL ){
          ptr = data;
        }else{
          ptr->add(data);
        }

        WSCstring item_str = item.getWord(0, ":");

        if (!strcmp(item_str.getString(),"SP") ||
            !strcmp(item_str.getString(),"SEPARATOR")){
          data->_separator = True;
        }else{
          data->_label.setString(item_str.getString());
         
          WSCstring opstr = item.getWord(1,":");
          if (!strncmp(opstr.getString(),"{",1)){
            long wpos = str.getWordCharPos(i, ",");
//printf("WSCpulldownMenuPopup::parse ,getwordcharpos=%d\n",wpos);
            WSCstring tmp(menu_string);
            tmp.deleteChars(0,wpos);
            wpos = tmp.getWordCharPos(1,"{");
            tmp.deleteChars(0,wpos);
            char* tstr = tmp.getString();
            long len = strlen(tstr);
            long num_of_conma = 0;
            long j;
            long layers = 0;

            for(j=0; j< len; j++){
              if (tstr[j] == '}'){
                if (layers == 0){
                  tstr[j] = 0;
                  break;
                }else{
                  layers--;
                }
              }
              if (tstr[j] == '{'){
                 layers++;
              }
              if (tstr[j] == ','){
                num_of_conma++;
              }
            }

            tstr[j] = 0;
            data->_op.setString(tstr);
            data->setCascaded(True);
          }else{
            data->_op.setString(opstr.getString());

            WSCstring scstr = item.getWord(2,":");
            data->_sc.setString(scstr.getString());
            WSCstring idstr = item.getWord(3,":");
            data->_id = atoi(idstr.getString());
          }
        }
      }
    }
    return ptr;
};

WSMFpropertyValueChange( WSCpulldownMenuPopup, WSNpixmapStyle, WSCuchar, WS_DYNAMIC_PIXMAP ) ;
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNforeColor,short,WS_DF_MENUFORECOLOR);
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNbackColor,short,WS_DF_MENUBACKCOLOR);
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNtopShadowColor,short,WS_DF_MENUTOPSHADOWCOLOR);
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNbottomShadowColor,short,WS_DF_MENUBOTTOMSHADOWCOLOR);



WSCpulldownMenuPopup::WSCpulldownMenuPopup(WSCbase* base, char* objname):
                  WSCwindow(base, objname){

  _next_popup = False;
  _id_value = 0;
  _parent_pld_menu = NULL;
  _selected = False;
  _pld_data = NULL;
  _menu_string = WSGFstrdup(""); 
  _item_height = 30;
  _font = (char)WSGIappFontSet()->getDefaultFontNo();
  _selected_item = WS_NO_SELECTED;
  _items = 0;
  _wait_child_popup = 0;

  _fg_no = WS_DF_MENUFORECOLOR;
  _bg_no = WS_DF_MENUBACKCOLOR;
  _ts_no = WS_DF_MENUTOPSHADOWCOLOR;
  _bs_no = WS_DF_MENUBOTTOMSHADOWCOLOR;


  WSMFpropertyCreateStart
  
    WSMFpropertyCreate(WSNmenuItems,   char*,    _menu_string,WSSmenuItems );
    WSMFpropertyCreate(WSNmenuItemHeight,WSCushort,_item_height,WSSmenuItemHeight);
    WSMFpropertyCreate(WSNfont, WSCuchar, _font,WSSfont );
    WSMFpropertyValueChangeDef( WSCpulldownMenuPopup, WSNpixmapStyle, WSCuchar ) ;
    WSMFpropertyDelete(WSNtitleBar);

    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNforeColor,short);
    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNbackColor,short);
    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNtopShadowColor,short);
    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNbottomShadowColor,short);
    WSMFpropertyVisibleOff( WSNindicatorOn );
    WSMFpropertyVisibleOff( WSNmargin );
    WSMFpropertyVisibleOff( WSNmarginLeft );
    WSMFpropertyVisibleOff( WSNbarThickness );
//   WSMFpropertyVisibleOff( WSNemboss );

  WSMFpropertyCreateEnd
}

WSMFproperty( WSCpulldownMenuPopup, WSNmenuItems,      char*,          _menu_string,WSGFstrdup("")); 
WSMFproperty( WSCpulldownMenuPopup, WSNmenuItemHeight, WSCushort, _item_height,30); 
WSMFproperty( WSCpulldownMenuPopup, WSNfont,           WSCuchar,           _font,       (char)WSGIappFontSet()->getDefaultFontNo()); 

void WSCpulldownMenuPopup::setWorkWSNemboss(WSCbool fl){
  setEmboss(fl);
}
void WSCpulldownMenuPopup::setWorkWSNwidth(WSCushort data){
  WSCwindow::setWorkWSNwidth(data);
  if (getVisible() != False){
    setAbsoluteDraw(True);
    redraw();
  }
}
void WSCpulldownMenuPopup::setWorkWSNheight(WSCushort data){
  WSCwindow::setWorkWSNheight(data);
  if (getVisible() != False){
    setAbsoluteDraw(True);
    redraw();
  }
}
void WSCpulldownMenuPopup::setWorkWSNmenuItems(char* data){
  if (_pld_data != NULL){
    WSCpulldownData* old = (WSCpulldownData*)_pld_data;
    delete old;
  }
  _pld_data = WSCpulldownData::parse(data);
}

void WSCpulldownMenuPopup::getWorkWSNmenuItems(char** ){}
void WSCpulldownMenuPopup::setWorkWSNmenuItemHeight(WSCushort ){}
void WSCpulldownMenuPopup::getWorkWSNmenuItemHeight(WSCushort* ){}
void WSCpulldownMenuPopup::setWorkWSNfont(WSCuchar){}
void WSCpulldownMenuPopup::getWorkWSNfont(WSCuchar* ){}

long WSCpulldownMenuPopup::initialize(){
  WSCwindow::initialize();
  setPropertyV(WSNpixmapStyle, (WSCuchar)WS_DYNAMIC_PIXMAP);

  return WS_NO_ERR;
}

WSCpulldownMenuPopup::~WSCpulldownMenuPopup(){
  long num = _child_pld_list.getNum();
  long i;
  for(i=0; i <num; i++){
    WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
    delete child_popup;
  }
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    delete data;
  }
  delete _menu_string;
}

void WSCpulldownMenuPopup::onResize(WSCrect* rect){
printf("WSCpulldownMenuPopup::onResize %d,%d,%d,%d XXZZy16\n",rect->x,rect->y,rect->width,rect->height);
}
long WSCpulldownMenuPopup::_device_initialize(){
  WSCwindow::_device_initialize();
  WSCbool val = True;
  if (_dev != NULL){
    _dev->setValue(WSDEV_NO_FRAME,(void*)&val);
    _dev->setValue(WSDEV_FLOAT_ON_TOP,(void*)&val);
  }
  return WS_NO_ERR;
}

long WSCpulldownMenuPopup::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  short x = _x;
  short y = _y;
  short px, py;
  WSCushort w = _w;
  WSCushort h = _h;
  WSGIappMouse()->getMousePosition(&px, &py);
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  if (_pld_data == NULL){
    return WS_NO_ERR;
  }
  WSCbool absolute = getAbsoluteDraw(); 
  if (absolute == False && dev->isExposed(0, 0, w, h) == False){
    return WS_NO_ERR;
  }
  WSCushort st = _shadow_thick;

  if (st > 0){
    long err = dev->beginDraw(0, 0, w, h, absolute);
    if (err != WS_NO_ERR){
      return WS_NO_ERR;
    }

    WSCbase::update();
    setAbsoluteDraw(False);

    dev->setForeColor(_bg_no);
    dev->drawFillRect(0, 0, w, h);
    WSGFdrawShadow(dev,_shadow_type,st,_fg_no, _ts_no, _bs_no,_bg_no,0,0,w,h);

    WSCstring str(_menu_string);  
    long num = str.getWords(",");    
    long i;
    short posy = st;
    long child_cnt = 0;

    WSCpulldownMenuPopup* target = this;
    while(target->getParentMenu() != NULL){
      target = target->getParentMenu();
    }
    target->_prc_name.setString("");
    target->_selected = False;

    WSCpulldownData* own_pld = (WSCpulldownData*)_pld_data;
    WSCpulldownData* pld = (WSCpulldownData*)target->_pld_data;

    if (pld == NULL || own_pld == NULL){
WSMFtrace("WSCpulldownMenuPopup::draw ERROR.target->_pld_data is NULL!    %s\n",getInstanceName());
    }
    _child_popup_waited = False;
    long cnt = 0;
    for(i=0; i < num; i++){
      WSCpulldownData* targetitem = own_pld->getItem(cnt);
      long itemid = -1;
      if (targetitem != NULL){
        itemid = targetitem->_id;
      }

      WSCstring item = str.getWord(i, ",");
      WSCstring item_str = item.getWord(0, ":");

      WSCstring space(" ");
      WSCushort smargin = WSGIappFontSet()->getStringWidth(_font,&space);

      if (!strcmp(item_str.getString(),"SP") ||
          !strcmp(item_str.getString(),"SEPARATOR")){

        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          posy += 2;
        }
        dev->setForeColor(_bs_no);
        dev->setLineDashType(0);
        dev->setLineWidth(1);
        dev->setHatchPattern(0);

        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          dev->drawLine(st,posy,w-st,posy);
          dev->setForeColor(_ts_no);
          dev->drawLine(st,posy+1,w-st,posy+1);
        }else if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->drawLine(st+1,posy,w-st-2,posy);
          dev->setForeColor(_ts_no);
          dev->drawLine(st+1,posy+1,w-st*2-2,posy+1);
        }
        posy += st*2;
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          posy += 2;
        }
      }else{
        if ( _selected_item == -1){
          _selected_item = _items -1;
        }else
        if ( _selected_item > _items -1){
          _selected_item = 0;
        }
        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + _item_height && _mouse_no_check == 0) ||
             (_mouse_no_check != 0 && cnt == _selected_item) ){

//          if (pld->getSensitiveWithId(itemid) != False){ 
          if (own_pld->getSensitive(cnt) != False){ 
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
              dev->setHatchPattern(0);
              dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTCOLOR));
              dev->drawFillRect( st+1,posy+1,w-st*2 -2, _item_height-2);
              dev->setForeColor(_fg_no);
            }
          }
        }

        dev->setForeColor(_fg_no);
//        if ( pld->getSensitiveWithId(itemid) == False) {
        if ( own_pld->getSensitive(cnt) == False) {
          if (getEmboss() != False){
            dev->setForeColor(_ts_no);
            dev->drawString(st*2 + smargin/2+1, posy +st+1, w -st*4 - smargin , _item_height -st*2, &item_str, _font, WS_LEFT, -1, False);
          }else{
            dev->setHatchPattern(8);
          }
        } else {
          dev->setHatchPattern(0);
        }

//        if (getEmboss() != False && pld->getSensitiveWithId(itemid) == False){
        if (getEmboss() != False && own_pld->getSensitive(cnt) == False){
          dev->setForeColor(_bs_no);
        }else{
          dev->setForeColor(_fg_no);
        }
        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + _item_height && _mouse_no_check == 0) ||
             (_mouse_no_check != 0 && cnt == _selected_item) ){

//          if (pld->getSensitiveWithId(itemid) != False){ 
          if (own_pld->getSensitive(cnt) != False){ 
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
              dev->setForeColor(WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTFORECOLOR));
            }
          }
        }


        dev->drawString(st*2 + smargin/2, posy +st, w -st*4 - smargin , _item_height -st*2, &item_str, _font, WS_LEFT, -1, False);

        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + _item_height && _mouse_no_check == 0) ||
             (_mouse_no_check != 0 && cnt == _selected_item) ){

//          if (pld->getSensitiveWithId(itemid) != False){
          if (own_pld->getSensitive(cnt) != False){
            _selected_item = cnt;
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              WSGFdrawBtnShadow(dev, _shadow_type, st, _fg_no, _ts_no, _bs_no,_bg_no,
                         st, posy, w-st*2, _item_height);
            }
          }
          WSCstring item_prc_name = item.getWord(1, ":");
          if (!strncmp(item_prc_name.getString(),"{",1)){
            
            WSCpoint pt[3];
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              pt[0].x = w - 15;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 15;
              pt[1].y = _item_height /2 -5 + posy;
              pt[2].x = w - 15 +10;
              pt[2].y = _item_height /2 + posy;
              dev->setForeColor(_fg_no);
              dev->drawFillPoly(pt,3);
              dev->setLineWidth(1);
              dev->setForeColor(_bs_no);
              dev->drawPoly(pt,3);
            }else if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
              pt[0].x = w - 10;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 10;
              pt[1].y = _item_height /2 -5 + posy;
              pt[2].x = w - 10 +5;
              pt[2].y = _item_height /2 + posy;
              dev->setForeColor(_fg_no);
              dev->drawFillPoly(pt,3);
            }

            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              pt[0].x = w - 15;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 15 +10;
              pt[1].y = _item_height /2 + posy;
              dev->setForeColor(_ts_no);
              dev->drawPoly(pt,2);
            }
            long wpos = str.getWordCharPos(i, ",");
            WSCstring tmp(_menu_string);
            tmp.deleteChars(0,wpos);
            wpos = tmp.getWordCharPos(1,"{");
            tmp.deleteChars(0,wpos);
            char* tstr = tmp.getString();
            long len = strlen(tstr);
            long num_of_conma = 0;
            long j;
            long layers = 0;
            for(j=0; j< len; j++){
              if (tstr[j] == '}'){
                if (layers == 0){
                  tstr[j] = 0;
                  break;
                }else{
                  layers--;
                }
              }
              if (tstr[j] == '{'){
                layers++;
              }
              if (tstr[j] == ','){
                num_of_conma++;
              }
            }

            i += num_of_conma;
            if (_wait_child_popup == 0){
              if (own_pld->getSensitive(cnt) != False){
                popupChildPld(child_cnt,tstr,x+w,y+posy);
              }
            }else{
              _child_popup_waited = True;
            }
            child_cnt++;

          }else{
//            if ( checkChildStatus() == False  && pld->getSensitiveWithId(itemid) != False) {
            if ( checkChildStatus() == False  && own_pld->getSensitive(cnt) != False) {
              target->_prc_name.setString( item_prc_name.getString() );
              target->_selected = True;
            }
          }

          WSCstring id_str = item.getWord(3, ":");
          target->_id_value = atoi(id_str.getString());
        }else{
          WSCstring item_prc_name = item.getWord(1, ":");
          if (!strncmp(item_prc_name.getString(),"{",1)){

            WSCpoint pt[3];
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              pt[0].x = w - 15;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 15;
              pt[1].y = _item_height /2 -5 + posy;
              pt[2].x = w - 15 +10;
              pt[2].y = _item_height /2 + posy;
              dev->setForeColor(_fg_no);
              dev->drawFillPoly(pt,3);
              dev->setLineWidth(1);
              dev->setForeColor(_bs_no);
              dev->drawPoly(pt,3);
            }else if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
              pt[0].x = w - 10;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 10;
              pt[1].y = _item_height /2 -5 + posy;
              pt[2].x = w - 10 +5;
              pt[2].y = _item_height /2 + posy;
              dev->setForeColor(_fg_no);
              dev->drawFillPoly(pt,3);
            }

            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              pt[0].x = w - 15;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 15 +10;
              pt[1].y = _item_height /2 + posy;
              dev->setForeColor(_ts_no);
              dev->drawPoly(pt,2);
            }
            long wpos = str.getWordCharPos(i, ",");
            WSCstring tmp(_menu_string);
            tmp.deleteChars(0,wpos);
            wpos = tmp.getWordCharPos(1,"{");
            tmp.deleteChars(0,wpos);
            char* tstr = tmp.getString();
            long len = strlen(tstr);
            long num_of_conma = 0;
            long j;
            long layers = 0;
            for(j=0; j< len; j++){
              if (tstr[j] == '}'){
                if (layers == 0){
                  tstr[j] = 0;
                  break;
                }else{
                  layers--;
                }
              }
              if (tstr[j] == '{'){
                 layers++;
              }
              if (tstr[j] == ','){
                num_of_conma++;
              }
            }

            i += num_of_conma; // { }  , Ф
            long num1 = _child_pld_list.getNum();
            WSCpulldownMenuPopup* child_popup = NULL;
            if (child_cnt < num1){
              child_popup = (WSCpulldownMenuPopup*)_child_pld_list[child_cnt];
            }
            if ( x < px  && px < x+w  &&
                 y < py  && py < y+h &&
                 child_popup != NULL && child_popup->getVisible() != False){
              popdownChildPld(child_cnt);
            }
            child_cnt++;
          }
          if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
            WSGFdrawShadow(dev, _shadow_type, st, _bg_no, _bg_no, _bg_no,_bg_no,
                         st, posy, w-st*2, _item_height,True);
          }
        }
        posy += _item_height;
        cnt++;
      }
    }
    _items = cnt;
    dev->endDraw();
  }

  updateChild();

  _mouse_no_check = 0;

  return WS_NO_ERR;

}

void WSCpulldownMenuPopup::popdownChildPld(short childnum){
  WSCpulldownMenuPopup* child = (WSCpulldownMenuPopup*)_child_pld_list.getData(childnum);
  if (child != NULL && child->getVisible() == True){
     child->setVisible(False);
  }
}

void WSCpulldownMenuPopup::popupChildPld(short childnum,char* menustr,short x,short y){
  WSCushort ww = 0;
  WSCushort len = 0;
  WSCushort st = _shadow_thick;
  WSCushort hh = st*2;
  WSCbool cascaded = False;

  WSCstring str(menustr);  
  WSDfont* fn = WSGIappFontSet()->getFont(_font);
  
  long num = str.getWords(",");
  long i;
  for(i=0; i<num; i++){
    WSCstring item = str.getWord(i, ",");
    WSCstring itemName = item.getWord(0, ":");
    WSCstring itemPrc = item.getWord(1, ":");

    if (!strcmp(itemName.getString(),"SP") ||
        !strcmp(itemName.getString(),"SEPARATOR")){
      hh += st*2;
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        hh += 4;
      }
    }else{
      if ( !strncmp(itemPrc.getString(),"{",1) ){
        cascaded = True;
        long wpos = itemPrc.getWordCharPos(i, ",");
        WSCstring tmp(str.getString());
        tmp.deleteChars(0,wpos);
        wpos = tmp.getWordCharPos(1,"{");
        tmp.deleteChars(0,wpos);
        char* tstr = tmp.getString();
        long len = strlen(tstr);
        long num_of_conma = 0;
        long j;
        long layers = 0;
        for(j=0; j< len; j++){
          if (tstr[j] == '}'){
            if (layers == 0){
              tstr[j] = 0;
              break;
            }else{
              layers--;
            }
          }
          if (tstr[j] == '{'){
             layers++;
          }
          if (tstr[j] == ','){
            num_of_conma++;
          }
        }
        i += num_of_conma;
        hh += _item_height;
      }else{
        hh += _item_height;
      }
    }

    if (len < (short)strlen(itemName.getString())) {
      len = (short)strlen(itemName.getString());
      WSCstring space(" ");
      WSCushort smargin = WSGIappFontSet()->getStringWidth(_font,&space);
      ww = (short)fn->getStringWidth(&itemName) + st * 2 + st * 2 + smargin;
    }
  }

  if (cascaded != False){
    ww += 30;
  }

  if ( x + ww > WSGIappDev()->getWidth()){
    WSCushort width;
    getPropertyV(WSNwidth,&width);
    x -= (ww + width);
  }
  if ( y + hh > WSGIappDev()->getHeight()){
    WSCushort width;
    getPropertyV(WSNwidth,&width);
    y -= (y + hh - WSGIappDev()->getHeight());
  }

  WSCpulldownMenuPopup* child_popup;
  if ( !(childnum < _child_pld_list.getNum()) ){
    child_popup = new WSCpulldownMenuPopup(NULL,"pld-menu-child");
    child_popup->initialize();
    child_popup->setInternalObject(True);
    _child_pld_list.add((void*)child_popup);
  }else{
    child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(childnum);
  }
  if (child_popup->getVisible() == False){
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      child_popup->setPropertyV(WSNx,                x);
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      child_popup->setProperty(WSNx,                x-5);
    }
    child_popup->setPropertyV(WSNy,                y);
    child_popup->setPropertyV(WSNwidth,            ww);
    child_popup->setPropertyV(WSNheight,           hh);
    child_popup->setPropertyV(WSNmenuItemHeight,   _item_height);
    child_popup->setPropertyV(WSNmenuItems,        str.getString());
    child_popup->setPropertyV(WSNfont,             (WSCuchar)_font);
    child_popup->setPropertyV(WSNforeColor,        _fg_no);
    child_popup->setPropertyV(WSNbackColor,        _bg_no);
    child_popup->setPropertyV(WSNtopShadowColor,   _ts_no);
    child_popup->setPropertyV(WSNbottomShadowColor,_bs_no);
    child_popup->setPropertyV(WSNshadowType,       (char)_shadow_type);
    child_popup->setPropertyV(WSNshadowThickness,  (WSCuchar)_shadow_thick);
    child_popup->setPropertyV(WSNpixmapStyle,      (WSCuchar)WS_DYNAMIC_PIXMAP);
    child_popup->setEmboss(getEmboss());
    child_popup->setParentMenu(this);
    child_popup->setVisible(True);
  }
}

WSCbool WSCpulldownMenuPopup::checkChildStatus(){
  short px, py;
  WSGIappMouse()->getMousePosition(&px, &py);

  long num = _child_pld_list.getNum();
  long i;
  for(i=0; i <num; i++){
    WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
    if (child_popup->getVisible() != False){
      short x = _w;
	  short y = _y;
      WSCushort w = _w;
	  WSCushort h = _h;
      if (x < px && px < x+w &&
          y < py && py < y+h ){
        return True;
      }
      WSCbool ret = child_popup->checkChildStatus();
      if (ret == True){
        return True;
      }
    }
  }
  return False;
}
WSCpulldownMenuPopup* WSCpulldownMenuPopup::_check_child_status_no_mouse(){
  long num = _child_pld_list.getNum();
  long i;
  for(i=0; i <num; i++){
    WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
    if (child_popup->getVisible() != False){
//      short x = _w;
//      short y = _y;
//      WSCushort w = _w;
//      WSCushort h = _h;
      WSCpulldownMenuPopup* ret = child_popup->_check_child_status_no_mouse();
      if (ret != NULL){
        return ret;
      }
      return child_popup;
    }
  }
  return NULL;
}

void WSCpulldownMenuPopup::updateChild(){
  long num = _child_pld_list.getNum();
  long i;
  for(i=0; i <num; i++){
    WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
    if (child_popup->getVisible() != False){
      child_popup->setAbsoluteDraw(True);
      child_popup->draw();
    }
  }
}

long WSCpulldownMenuPopup::getItems(){
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->getItems();
  }
  return 0;
}

long WSCpulldownMenuPopup::setItemSensitive(short no,WSCbool fl){
  long ret = WS_ERR2;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->setSensitive(no,fl);
  }
  return ret;
}

long WSCpulldownMenuPopup::setValueSensitive(short id,WSCbool fl){
  long ret = WS_ERR2;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->setSensitiveWithId(id,fl);
  }

  return ret;
}
void WSCpulldownMenuPopup::onVisibleChange(WSCbool fl){
  if (fl != False){
    _selected_item = WS_NO_SELECTED;
    WSDdev* dev = getowndev();
    if (dev == NULL){
      WSDdev* new_dev = attachdev();
      if (new_dev != NULL){
        char title_bar = WS_NO_TITLE;
        new_dev->setValue(WSDEV_TITLE_BAR, (void*)&title_bar);
	    new_dev->setEnableEventBit(_event_mask);
        new_dev->setVisible(True);
      }
    }else{
      dev->setVisible(True);
    }
  }else{
    long num = _child_pld_list.getNum();
    long i;
    for(i=0; i <num; i++){
      WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
      child_popup->setVisible(False);
    }
    WSCbase::onVisibleChange(fl);
  }
}

WSCbool WSCpulldownMenuPopup::getSelected() {
  return _selected;
}
char* WSCpulldownMenuPopup::getProcName() {
  return _prc_name.getString();
}

WSCbool WSCpulldownMenuPopup::getNextPopup() {
  return _next_popup;
}

void WSCpulldownMenuPopup::setEmboss(WSCbool fl){
  _emboss = fl;
}

WSCbool WSCpulldownMenuPopup::getEmboss(){
  return _emboss;
}

WSCbool* WSCpulldownMenuPopup::getItemSensitive(){
static WSCbool * status_array = NULL;
  if (status_array != NULL){
    delete status_array;
    status_array = NULL;
  }
  WSCpulldownData* data = (WSCpulldownData*)_pld_data;
  if (data != NULL){
    long num = data->getItems();
    long i;
    status_array = new WSCbool[num];
    for(i=0; i<num; i++){
      status_array[i] = data->getSensitive(i);
    }
  }
  return status_array;
}

long WSCpulldownMenuPopup::getValue(){
  return _id_value;
}

void WSCpulldownMenuPopup::setParentMenu(WSCpulldownMenuPopup* parent){
  _parent_pld_menu = parent;
}

WSCpulldownMenuPopup* WSCpulldownMenuPopup::getParentMenu(){
  return _parent_pld_menu;
}

WSCuchar WSCpulldownMenuPopup::getFontNo(){
  return _font;
}

WSCushort WSCpulldownMenuPopup::getItemHeight(){
  return _item_height;
}
void WSCpulldownMenuPopup::onKeyPress(WSDkeyboard* keyboard,WSCbool fl){
  long key = keyboard->getKey();
  WSCpulldownMenuPopup* child = _check_child_status_no_mouse();

  if (child != NULL && child != this){
    child->setUserData("KEY_PROCESSED",(void*)0);
    child->onKeyPress(keyboard,fl);
    if (child->getUserData("KEY_PROCESSED") != (void*)0){
      child->setUserData("KEY_PROCESSED",(void*)0);
      setUserData("KEY_PROCESSED",(void*)1);
    }
    return;
  }
  setUserData("KEY_PROCESSED",(void*)0);
  if (key == WSK_Left){
    _child_popup_waited = 0;
    if ( _parent_pld_menu != NULL){
      setUserData("KEY_PROCESSED",(void*)1);
      setVisible(False);
    }
  }else
  if (key == WSK_Right && _child_popup_waited != False){
    _mouse_no_check = 1;
    setUserData("KEY_PROCESSED",(void*)1);
  }else
  if (key == WSK_Down){
    _child_popup_waited = 0;
    _mouse_no_check = 1;
    _wait_child_popup = 1;
    if ( _selected_item == WS_NO_SELECTED){
      _selected_item = 0;
    }else
    if ( _selected_item == -1){
      _selected_item = 0;
    }else{
      _selected_item++;
    }
    if (_selected_item+1 > _items){
      _selected_item = 0;
    }
    WSCpulldownData* own_pld = (WSCpulldownData*)_pld_data;
    while(1){
      if (_selected_item+1 > _items){
        _selected_item = WS_NO_SELECTED;
        break;
      }
      if (own_pld->getSensitive(_selected_item) == False){
        _selected_item++;
      }else{
        break;
      }
    }
  }else
  if (key == WSK_Up){
    _child_popup_waited = 0;
    _mouse_no_check = 1;
    _wait_child_popup = 1;
    if ( _selected_item == WS_NO_SELECTED){
      _selected_item = -1;
    }else
    if ( _selected_item == 0){
      _selected_item = -1;
    }else{
      _selected_item--;
    }
    if (_selected_item < 0){
      _selected_item = _items -1;
    }
    WSCpulldownData* own_pld = (WSCpulldownData*)_pld_data;
    while(1){
      if (_selected_item < 0){
        _selected_item = WS_NO_SELECTED;
        break;
      }
      if (own_pld->getSensitive(_selected_item) == False){
        _selected_item--;
      }else{
        break;
      }
    }
  }
  setAbsoluteDraw(True);
  draw();
  _mouse_no_check = 0;
  _wait_child_popup = 0;
}
void WSCpulldownMenuPopup::setSelected(WSCbool fl){
  _selected = fl;
}
