//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCRlist.h>
#include <WSCscrForm.h>
#include <WSCbaseList.h>
#include <WSClist.h>

WSMFclassInit(WSCRlist,WSCRscrForm);
WSMFremoteClassInit(WSCRlist,WSClist);

WSCRlist::WSCRlist(){
}

WSCRlist::~WSCRlist(){
}

void WSCRlist::onSort(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->onSort();
	  return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("onSort");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  endRemoteCall();
  return;
}

void WSCRlist::onItemSelected(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->onItemSelected();
	  return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("onItemSelected");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  endRemoteCall();
  return;
}
void WSCRlist::setLabelHeight(WSCushort h){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->setLabelHeight(h);
	  return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setLabelHeight");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRUShort,"h",(void*)&h);
  endRemoteCall();
  return;
}
void WSCRlist::delPos(long pos){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->delPos(pos);
	  return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("delPos");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  endRemoteCall();
  return;
}

void WSCRlist::delAll(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->delAll();
      return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("delAll");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  endRemoteCall();
}

long WSCRlist::getNum(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getNum();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getNum");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
WSCbool WSCRlist::getSelectItemChanged(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getSelectItemChanged();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getSelectItemChanged");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  WSCbool ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
WSCbool WSCRlist::getEnableActivate(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getEnableActivate();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getEnableActivate");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  WSCbool ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
WSCbool WSCRlist::getAbsoluteChangeSelectFlag(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getEnableActivate();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getAbsoluteChangeSelectFlag");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  WSCbool ret;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

long WSCRlist::getTopPos(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getTopPos();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getTopPos");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
long WSCRlist::getBottomPos(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getBottomPos();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getBottomPos");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

long WSCRlist::getSelectedPos(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getSelectedPos();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getSelectedPos");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

WSCstring WSCRlist::getItem(long pos){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getItem(pos);
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getItem");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  _db->save(WS_DcRLong,"pos",(void*)&pos);

  char* ret = NULL;
  _db->loadAlloc(WS_DcRString,"ret",(void**)&ret,NULL);
  endRemoteCall();
  if (ret == NULL){
    WSCstring tmp;
    return tmp;
  }
  WSCstring tmp;
  tmp.setString(ret,WS_EN_UTF8);
  delete ret;
  return tmp;
}
WSCstring WSCRlist::getSelectedItem(){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getSelectedItem();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getSelectedItem");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  char* ret = NULL;
  _db->loadAlloc(WS_DcRString,"ret",(void**)&ret,NULL);
  endRemoteCall();
  if (ret == NULL){
    WSCstring tmp;
    return tmp;
  }
  WSCstring tmp;
  tmp.setString(ret,WS_EN_UTF8);
  delete ret;
  return tmp;
}
long WSCRlist::setSelectPos(long pos){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->setSelectPos(pos);
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setSelectPos");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  _db->save(WS_DcRLong,"pos",(void*)&pos);

  long ret = WS_ERR;
  _db->load(WS_DcRLong,"ret",(void**)&ret);
  endRemoteCall();
  return ret;
}
void WSCRlist::setSelectItemChanged(WSCbool fl){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->setSelectItemChanged(fl);
	  return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setSelectItemChanged");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRlist::setEnableActivate(WSCbool fl){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->setEnableActivate(fl);
	  return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setEnableActivate");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}
void WSCRlist::setAbsoluteChangeSelectFlag(WSCbool fl){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->setAbsoluteChangeSelectFlag(fl);
	  return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setAbsoluteChangeSelectFlag");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}

void WSCRlist::setTopPos(long pos){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->setTopPos(pos);
      return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setTopPos");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  endRemoteCall();
}
long WSCRlist::setItemVisible(long pos,WSCbool fl){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->setItemVisible(pos,fl);
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setTopPos");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  _db->save(WS_DcRChar,"fl",(void*)&fl);

  long ret = WS_ERR;
  _db->load(WS_DcRLong,"ret",(void**)&ret);
  endRemoteCall();
  return ret;
}
long WSCRlist::setItemValue(long pos,long kind,long val){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->setItemValue(pos,kind,val);
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setItemValue");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  _db->save(WS_DcRLong,"kind",(void*)&kind);
  _db->save(WS_DcRLong,"val",(void*)&val);

  long ret = WS_ERR;
  _db->load(WS_DcRLong,"ret",(void**)&ret);
  endRemoteCall();
  return ret;
}
long WSCRlist::getItemValue(long pos,long kind,long* val){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      return target->getItemValue(pos,kind,val);
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("getItemValue");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  _db->save(WS_DcRLong,"kind",(void*)&kind);

  _db->load(WS_DcRLong,"val",(void**)val);
  long ret = WS_ERR;
  _db->load(WS_DcRLong,"ret",(void**)&ret);
  endRemoteCall();
  return ret;
}


void WSCRlist::setBottomPos(long pos){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->setBottomPos(pos);
      return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("setBottomPos");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  endRemoteCall();
}

void WSCRlist::addItem(char* item,long pos){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->addItem(item,pos);
      return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("addItem");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  WSCstring tmp;
  tmp = item;
  
  _db->save(WS_DcRString,"item",(void*)(tmp.getString(WS_EN_UTF8)));
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  endRemoteCall();
}
void WSCRlist::replaceItem(char* item,long pos){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->replaceItem(item,pos);
      return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("replaceItem");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  WSCstring tmp;
  tmp = item;
  
  _db->save(WS_DcRString,"item",(void*)(tmp.getString(WS_EN_UTF8)));
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  endRemoteCall();
}
void WSCRlist::replaceItem(char* item,long pos,long column){
  if (_local != NULL){
    WSClist* target = (WSClist*)_local->cast("WSClist");
    if (target != NULL){
      target->replaceItem(item,pos,column);
      return;
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSClist");
  rc.setOperationName("replaceItem2");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  }
  WSCstring tmp;
  tmp = item;
  
  _db->save(WS_DcRString,"item",(void*)(tmp.getString(WS_EN_UTF8)));
  _db->save(WS_DcRLong,"pos",(void*)&pos);
  _db->save(WS_DcRLong,"col",(void*)&column);
  endRemoteCall();
}


void _WSClist_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getNum")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long ret = 0;
        if (target != NULL){
          ret = target->getNum();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getSelectedPos")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long ret = 0;
        if (target != NULL){
          ret = target->getSelectedPos();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getTopPos")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long ret = 0;
        if (target != NULL){
          ret = target->getTopPos();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getBottomPos")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long ret = 0;
        if (target != NULL){
          ret = target->getBottomPos();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getItem")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long pos = 0;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        WSCstring ret;
        if (target != NULL){
          ret = target->getItem(pos);
        }
        char* ptr = ret.getString(WS_EN_UTF8);
        db->save(WS_DcRString,"ret",(void*)ptr);
      }else{
        char* ptr = "";
        db->save(WS_DcRString,"ret",(void*)ptr);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getSelectItemChanged")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      WSCbool ret;
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          ret = target->getSelectItemChanged();
        }
      }
      db->save(WS_DcRChar,"ret",(void*)&ret);
      return;
    }else
    if (!strcmp(rc->_op,"getAbsoluteChangeSelectFlag")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      WSCbool ret;
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          ret = target->getAbsoluteChangeSelectFlag();
        }
      }
      db->save(WS_DcRChar,"ret",(void*)&ret);
      return;
    }else
    if (!strcmp(rc->_op,"getEnableActivate")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      WSCbool ret;
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          ret = target->getEnableActivate();
        }
      }
      db->save(WS_DcRChar,"ret",(void*)&ret);
      return;
    }else
    if (!strcmp(rc->_op,"getSelectedItem")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        WSCstring ret;
        if (target != NULL){
          ret = target->getSelectedItem();
        }
        char* ptr = ret.getString(WS_EN_UTF8);
        db->save(WS_DcRString,"ret",(void*)ptr);
      }else{
        char* ptr = "";
        db->save(WS_DcRString,"ret",(void*)ptr);
      }
      return;
    }else

    if (!strcmp(rc->_op,"getVisibleWidth")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long ret = 0;
        if (target != NULL){
          ret = target->getVisibleWidth();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getItemValue")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = WS_ERR;
      long val = 0;
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long pos = 0;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        long kind = 0;
        db->load(WS_DcRLong,"kind",(void*)&kind);

        if (target != NULL){
          ret = target->getItemValue(pos,kind,&val);
        }
      }
      db->save(WS_DcRLong,"val",(void*)&val);
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }else

    if (!strcmp(rc->_op,"getVisibleHeight")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long ret = 0;
        if (target != NULL){
          ret = target->getVisibleHeight();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }
  }else
  if ( rc->_op[0] == 'a'){
    if (!strcmp(rc->_op,"addItem")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        char* item;
        db->loadAlloc(WS_DcRString,"item",(void**)&item,NULL);

        long pos = 0;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        WSCstring ret;
        if (target != NULL){
          WSCstring tmp;
          if (item != NULL){
            tmp.setString(item,WS_EN_UTF8);
            delete item;
          }
          target->addItem((char*)tmp,pos);
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 'r'){
    if (!strcmp(rc->_op,"replaceItem")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        char* item;
        db->loadAlloc(WS_DcRString,"item",(void**)&item,NULL);

        long pos = 0;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        WSCstring ret;
        if (target != NULL){
          WSCstring tmp;
          if (item != NULL){
            tmp.setString(item,WS_EN_UTF8);
            delete item;
          }
          target->addItem((char*)tmp,pos);
        }
      }
      return;
    }else
    if (!strcmp(rc->_op,"replaceItem2")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        char* item;
        db->loadAlloc(WS_DcRString,"item",(void**)&item,NULL);

        long pos = 0;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        long col = 0;
        db->load(WS_DcRLong,"col",(void*)&col);
        WSCstring ret;
        if (target != NULL){
          WSCstring tmp;
          if (item != NULL){
            tmp.setString(item,WS_EN_UTF8);
            delete item;
          }
          target->addItem((char*)tmp,pos);
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 'o'){
    if (!strcmp(rc->_op,"onSort")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          target->onSort();
        }
      }
      return;
    }else
    if (!strcmp(rc->_op,"onItemSelected")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          target->onItemSelected();
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 's'){
    if (!strcmp(rc->_op,"setSelectPos")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = WS_ERR;
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long pos = 0;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        if (target != NULL){
          ret = target->setSelectPos(pos);
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }else
    if (!strcmp(rc->_op,"setItemVisible")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = WS_ERR;
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long pos = 0;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        WSCbool fl = False;
        db->load(WS_DcRChar,"fl",(void*)&fl);
        if (target != NULL){
          ret = target->setItemVisible(pos,fl);
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }else
    if (!strcmp(rc->_op,"setItemValue")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = WS_ERR;
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        long pos = 0;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        long kind = 0;
        db->load(WS_DcRLong,"kind",(void*)&kind);
        long val = 0;
        db->load(WS_DcRLong,"val",(void*)&val);
        if (target != NULL){
          ret = target->setItemValue(pos,kind,val);
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }else

    if (!strcmp(rc->_op,"setLabelHeight")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCushort h;
        db->load(WS_DcRUShort,"h",(void*)&h);
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          target->setLabelHeight(h);
        }
      }
      return;
    }else
    if (!strcmp(rc->_op,"setTopPos")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        long pos;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          target->setTopPos(pos);
        }
      }
      return;
    }else
    if (!strcmp(rc->_op,"setSelectItemChanged")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        WSCbool fl = False;
        db->load(WS_DcRChar,"fl",(void*)&fl);
        if (target != NULL){
          target->setSelectItemChanged(fl);
        }
      }
      return;
    }else
    if (!strcmp(rc->_op,"setAbsoluteChangeSelectFlag")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        WSCbool fl = False;
        db->load(WS_DcRChar,"fl",(void*)&fl);
        if (target != NULL){
          target->setAbsoluteChangeSelectFlag(fl);
        }
      }
      return;
    }else
    if (!strcmp(rc->_op,"setEnableActivate")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        WSCbool fl = False;
        db->load(WS_DcRChar,"fl",(void*)&fl);
        if (target != NULL){
          target->setEnableActivate(fl);
        }
      }
      return;
    }else


    if (!strcmp(rc->_op,"setBottomPos")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        long pos;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          target->setBottomPos(pos);
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 'd'){
    if (!strcmp(rc->_op,"delAll")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          target->delAll();
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 'd'){
    if (!strcmp(rc->_op,"delPos")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        long pos;
        db->load(WS_DcRLong,"pos",(void*)&pos);
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          target->setLabelHeight(pos);
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 'u'){
    if (!strcmp(rc->_op,"updateList")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSClist* target = (WSClist*)inst->cast("WSClist");
        if (target != NULL){
          target->updateList();
        }
      }
      return;
    }
  }

extern void _WSCscrForm_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCscrForm_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSClist,_WSClist_remote_call);

