//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCprocedure.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

WSCprocedure::WSCprocedure(char* opname,long trg){
  _function = NULL;
  _func_name = NULL;
  _prc_name = WSGFstrdup(opname);
  _effective_trg_mask = WSGFeventToMaskBit(trg);
  _trg = (char)trg;
  _internal_prc = False;
  _src_file = True;
}
WSCprocedure::~WSCprocedure(){
  if (_func_name != NULL){
    delete _func_name;
  }
  if (_prc_name != NULL){
    delete _prc_name;
  }
}
void WSCprocedure::setUseFile(WSCbool fl){
  _src_file = fl;
}
WSCbool WSCprocedure::getUseFile(){
  return _src_file;
}
long WSCprocedure::setProcName(char* str){
  if (_prc_name != NULL){
    delete _prc_name;
  }
  _prc_name = WSGFstrdup(str);
  return WS_NO_ERR;
}
char* WSCprocedure::getProcName(){
  if (_prc_name == NULL){
    return "";
  }
  return _prc_name;
}
long WSCprocedure::setProc(void* pr){
  _function = pr;
  return WS_NO_ERR;
}

static void* _hd = NULL;
void WSGFsetProcedureHandler(void* hd){
  _hd = hd;
}
void* WSGFgetProcedureHandler(){
  return _hd;
}

void* WSCprocedure::getProc(){
  if (_function == NULL && _func_name != NULL){
    return  WSGIappFunctionList()->getFunctionAddr(_func_name);
  }
  return _function;
}
long WSCprocedure::setTrigger(long ev){
 _trg = (char)ev;
 return WS_NO_ERR;
}
long WSCprocedure::getTrigger(){
  return (long)_trg;
}

long WSCprocedure::setEffectiveTriggerMask(long ev){
 _effective_trg_mask = ev;
 return WS_NO_ERR;
}
long WSCprocedure::getEffectiveTriggerMask(){
  return _effective_trg_mask;
}
long WSCprocedure::setFunction( void(*proc)(WSCbase*),char* fname){
  if (_func_name != NULL){
    delete _func_name;
  }
  _func_name = WSGFstrdup(fname);
  _function = (void*)proc;
  return WS_NO_ERR;
}
char* WSCprocedure::getFunctionName(){
  if (_func_name == NULL){
    return "";
  }
  return _func_name;
}
void WSCprocedure::setInternal(WSCbool fl){
  _internal_prc = fl;
}
WSCbool WSCprocedure::getInternal(){
  return _internal_prc;
}
