//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#if defined (BTRON)  || defined (TE)
#include <basic.h>
#include <btron/clk.h>
#endif

#include <WScom.h>
#include <WSDdev.h>
#include <WSCstring.h>
#include <WSDfont.h>
#include <WSCfontSet.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSDfile.h>
#include <WSDfileSystem.h>
#include <WSDcolor.h>
#include <WSCcolorSet.h>
#include <WSDmouse.h>
#include <WSDdragDrop.h>
#include <WSCimageSet.h>
#include <WSCmessageDialog.h>
#include <WSDmessage.h>
#include <WSCclassInformation.h>
#include <WSDprivateTimer.h>
#include <WSDappDev.h>
#include <WSClocaleSet.h>
#include <WSDmwindowDev.h>

#ifndef MSW
#include <time.h>
#include <sys/time.h>
#else
#include <sys\timeb.h>
#include <time.h>
#endif

#ifdef DS
extern "C" {
  int gettimeofday( struct timeval *, struct timezone*);
};
#endif

extern "C" {
void libws_func();
};
void libws_func(){
}
#ifndef BTRON
FILE* _ws_debug_fp = NULL;
#else
#ifdef TE
#include <btron/bsocket.h>
#endif
FILE* _ws_debug_fp = NULL;
//FILE* _ws_debug_fp = stdout;
#endif
int _dbprintf_init(){
  if (getenv("WSDEBUG") != NULL && _ws_debug_fp == NULL){
#ifndef BTRON
    _ws_debug_fp = fopen("wsdbg.txt","a+");
#else
    _ws_debug_fp = stdout;
#endif
  }
  return 0;
};
int _dbprintf(const char* format,...){
  if (_ws_debug_fp == NULL){
    return -1;
  }
#if 1 //TEST

  int i;
  void* ptr[100];
  for(i=0; i<100;i++){
    ptr[i] = malloc(i*10);
    memset(ptr[i],0,i*10);
  }
  for(i=0; i<100;i++){
    delete ptr[i];
  }
#endif //TEST
  int ret;
  va_list va;
  va_start(va,format);
  ret = vfprintf(_ws_debug_fp,format,va);
  va_end(va);
  fflush(_ws_debug_fp);
  return ret;
}

void WSGFsetGeometry(WSCbase* base,short x,short y,WSCushort w,WSCushort h){
  base->setPropertyV(WSNx,x);
  base->setPropertyV(WSNy,y);
  base->setPropertyV(WSNwidth,w);
  base->setPropertyV(WSNheight,h);
}

void _stretch_timer_proc(void* ptr){
  WSCbase* obj = (WSCbase*)ptr;
  WSCushort val = (WSCushort)((long)obj->getUserData("size"));
  long _stretch_cnt = (long)obj->getUserData("stretch-cnt");
  if (obj->getVisible() == False){
    obj->setPropertyV(WSNheight,(WSCushort)val);
    WSDprivateTimer* stimer = (WSDprivateTimer*)obj->getUserData("stretch-timer");
    stimer->stopTimer();
// may be crashed..
//    obj->setUserData("stretch-timer",(void*)NULL);
//    delete stimer;
    return;
  }
  if (_stretch_cnt == 0){
//    obj->setPropertyV(WSNheight,(WSCushort)(val/64));
    obj->setPropertyV(WSNheight,(WSCushort)(val/2));
  }else if (_stretch_cnt == 1){
//    obj->setPropertyV(WSNheight,(WSCushort)(val/32));
    obj->setPropertyV(WSNheight,(WSCushort)(val*2/3));
  }else if (_stretch_cnt == 2){
//    obj->setPropertyV(WSNheight,(WSCushort)(val/24));
    obj->setPropertyV(WSNheight,(WSCushort)(val*3/4));
  }else if (_stretch_cnt == 3){
//    obj->setPropertyV(WSNheight,(WSCushort)(val/16));
    obj->setPropertyV(WSNheight,(WSCushort)(val*4/5));
  }else if (_stretch_cnt == 4){
//    obj->setPropertyV(WSNheight,(WSCushort)(val/12));
    obj->setPropertyV(WSNheight,(WSCushort)(val*5/6));
  }else if (_stretch_cnt == 5){
//    obj->setPropertyV(WSNheight,(WSCushort)(val/ 8));
    obj->setPropertyV(WSNheight,(WSCushort)(val* 7/8));
  }else if (_stretch_cnt == 6){
//    obj->setPropertyV(WSNheight,(WSCushort)(val/ 4));
    obj->setPropertyV(WSNheight,(WSCushort)(val* 10/11 ));
  }else if (_stretch_cnt == 7){
//    obj->setPropertyV(WSNheight,(WSCushort)(val/ 2));
    obj->setPropertyV(WSNheight,(WSCushort)(val* 14/15));
  }else if (_stretch_cnt == 8){
//    obj->setPropertyV(WSNheight,(WSCushort)(val * 3/4));
    obj->setPropertyV(WSNheight,(WSCushort)(val *19/20));
  }else if (_stretch_cnt == 9){
//    obj->setPropertyV(WSNheight,(WSCushort)(val * 7/8));
    obj->setPropertyV(WSNheight,(WSCushort)(val * 25/26));
  }else if (_stretch_cnt == 10){
//    obj->setPropertyV(WSNheight,(WSCushort)(val * 11/12));
    obj->setPropertyV(WSNheight,(WSCushort)(val * 32/33));
  }else if (_stretch_cnt == 11){
//    obj->setPropertyV(WSNheight,(WSCushort)(val * 15/16));
    obj->setPropertyV(WSNheight,(WSCushort)(val * 40/41));
  }else if (_stretch_cnt == 12){
//    obj->setPropertyV(WSNheight,(WSCushort)(val * 23 /24));
    obj->setPropertyV(WSNheight,(WSCushort)(val * 49 /50));
  }else if (_stretch_cnt == 13){
//    obj->setPropertyV(WSNheight,(WSCushort)(val * 31 /32));
    obj->setPropertyV(WSNheight,(WSCushort)(val * 59/60));
  }else if (_stretch_cnt == 14){
//    obj->setPropertyV(WSNheight,(WSCushort)(val * 63 /64));
    obj->setPropertyV(WSNheight,(WSCushort)(val * 79 /80));
  }else if (_stretch_cnt == 15){
    obj->setPropertyV(WSNheight,(WSCushort)val);
    WSDprivateTimer* stimer = (WSDprivateTimer*)obj->getUserData("stretch-timer");
    stimer->stopTimer();

// may be crashed..
//    obj->setUserData("stretch-timer",(void*)NULL);
//    delete stimer;
  }
  _stretch_cnt++;
  obj->setUserData("stretch-cnt",(void*)_stretch_cnt);
}
void _stretch_timer_proc2(void* ptr){
  WSCbase* obj = (WSCbase*)ptr;
  WSCushort val = (WSCushort)((long)obj->getUserData("size"));
  long _stretch_cnt = (long)obj->getUserData("stretch-cnt2");
  if (obj->getVisible() == False){
    obj->setPropertyV(WSNheight,(WSCushort)val);
    WSDprivateTimer* stimer = (WSDprivateTimer*)obj->getUserData("stretch-timer2");
    stimer->stopTimer();
//may be crashed..
//    obj->setUserData("stretch-timer2",(void*)NULL);
//    delete stimer;
    return;
  }
  if (_stretch_cnt == 0){
    obj->setVisible(False);
    obj->setPropertyV(WSNheight,(WSCushort)val);
    WSDprivateTimer* stimer = (WSDprivateTimer*)obj->getUserData("stretch-timer2");
    stimer->stopTimer();
//may be crashed..
//    obj->setUserData("stretch-timer2",(void*)NULL);
//    delete stimer;
  }else if (_stretch_cnt == 1){
    obj->setPropertyV(WSNheight,(WSCushort)(val/64));
  }else if (_stretch_cnt == 2){
    obj->setPropertyV(WSNheight,(WSCushort)(val/32));
  }else if (_stretch_cnt == 3){
    obj->setPropertyV(WSNheight,(WSCushort)(val/24));
  }else if (_stretch_cnt == 4){
    obj->setPropertyV(WSNheight,(WSCushort)(val/16));
  }else if (_stretch_cnt == 5){
    obj->setPropertyV(WSNheight,(WSCushort)(val/12));
  }else if (_stretch_cnt == 6){
    obj->setPropertyV(WSNheight,(WSCushort)(val /8));
  }else if (_stretch_cnt == 7){
    obj->setPropertyV(WSNheight,(WSCushort)(val /4));
  }else if (_stretch_cnt == 8){
    obj->setPropertyV(WSNheight,(WSCushort)(val /2));
  }else if (_stretch_cnt == 9){
    obj->setPropertyV(WSNheight,(WSCushort)(val * 3 /4));
  }else if (_stretch_cnt == 10){
    obj->setPropertyV(WSNheight,(WSCushort)(val * 7 / 8));
  }else if (_stretch_cnt == 11){
    obj->setPropertyV(WSNheight,(WSCushort)(val * 15 /16));
  }else if (_stretch_cnt == 12){
    obj->setPropertyV(WSNheight,(WSCushort)(val * 23 /24));
  }else if (_stretch_cnt == 13){
    obj->setPropertyV(WSNheight,(WSCushort)(val * 31 /32));
  }else if (_stretch_cnt == 14){
    obj->setPropertyV(WSNheight,(WSCushort)(val * 63 /64));
  }else if (_stretch_cnt == 15){
    obj->setPropertyV(WSNheight,(WSCushort)val);
  }
  _stretch_cnt--;
  obj->setUserData("stretch-cnt2",(void*)_stretch_cnt);
}
void WSGFstretchPopup(WSCbase* obj){
  WSCushort height;
  obj->getPropertyV(WSNheight,&height);
  long val = (long)height;
  obj->setUserData("size",(void*)val);
  obj->setPropertyV(WSNheight,(WSCushort)1);
  obj->setVisible(True);
  WSDprivateTimer* stimer = (WSDprivateTimer*)obj->getUserData("stretch-timer");
  if (stimer == NULL){
    stimer = WSDprivateTimer::getNewInstance();
    stimer->setRate(5);
    stimer->setWorkProc(_stretch_timer_proc,obj);
    obj->setUserData("stretch-timer",(void*)stimer);
  }
  obj->setUserData("stretch-cnt",(void*)0);
  stimer->startTimer();
}
void WSGFstretchPopdown(WSCbase* obj){
  WSDprivateTimer* stimer = (WSDprivateTimer*)obj->getUserData("stretch-timer2");
  if (stimer == NULL){
    stimer = WSDprivateTimer::getNewInstance();
    stimer->setRate(5);
    stimer->setWorkProc(_stretch_timer_proc2,obj);
    obj->setUserData("stretch-timer2",(void*)stimer);
  }
  WSCushort height;
  obj->getPropertyV(WSNheight,&height);
  long val = (long)height;
  obj->setUserData("size",(void*)val);
  obj->setUserData("stretch-cnt2",(void*)14);
  stimer->startTimer();
}
void WSGFcleanupStretchAction(WSCbase* obj){
  WSDprivateTimer* stimer = (WSDprivateTimer*)obj->getUserData("stretch-timer");
  if (stimer != NULL){
    delete stimer;
  }
  WSDprivateTimer* stimer2 = (WSDprivateTimer*)obj->getUserData("stretch-timer");
  if (stimer2 != NULL){
    delete stimer2;
  }

  obj->setUserData("stretch-timer",NULL);
  obj->setUserData("stretch-timer2",NULL);
}
void WSGFgetAllPropertyList(WSCbase* client,WSClistData* out){
  WSCclassInformation* inf = client->getClassInformation();
  WSClistData* property_list1 = inf->getAllPropertyList();
  WSClistData property_list;

  long i;
  long num = property_list1->getNum();
  for(i=0; i<num; i++){
    out->add(property_list1->getData(i));
  }

  if (client->getPropertyInheritChild() != NULL){
    WSClistData prop_list2;
    WSGFgetAllPropertyList( client->getPropertyInheritChild(), &prop_list2);
    WSClistData* property_list2 = &prop_list2;
    num = property_list2->getNum();
    for(i=0; i<num; i++){
      WSCproperty* tmp = (WSCproperty*)(*property_list2)[i];
      WSCproperty* dummy;
      if (inf->getPropObj(tmp->getPropObjName(),&dummy) == False){
        WSClistData* proplist = inf->getPropertyList();
        long pnum = proplist->getNum();
        long j;
        WSCbool fl = False;
        for(j=0; j<pnum;j++){
          WSCproperty* prop = (WSCproperty*)proplist->getData(j);
          if (!strcmp(prop->getPropObjName(),tmp->getPropObjName())){
            if (prop->getNotUse() != False){
              fl = True;
              continue;
            }
          }
        }
        if (fl == False){
          out->add(property_list2->getData(i));
        }
      }
    }
  }
}

//high speed strcmp
inline long WSGFstrcmp(char* x,char* y){
  register WSCuchar* s1 = (WSCuchar*)x;
  register WSCuchar* s2 = (WSCuchar*)y;
  register WSCuchar p1 = 0;
  register WSCuchar p2 = 0;
  do{
      p1 = (WSCuchar)*s1++;
      p2 = (WSCuchar)*s2++;
      if (p1 == 0){
         return p1 -p2;
      }
  } while (p1 == p2);
  return p1 -p2;
}
long WSGFsendMessage(char* message,char* data){
  return WSDmessage::extSendMessage(NULL,message,data);
}
#if 0
#define WS_SEND_LEN 15
long WSGFsendMessage(char* message,char* data){
  if (data == NULL){
    data = "";
  }
  long ptr = 0;
  char buf[WS_SEND_LEN +1];
  long len = strlen(data);
  while(1){
    strncpy(buf,&data[ptr],WS_SEND_LEN);
    buf[WS_SEND_LEN] = 0;
printf("WSGFsendMessage send:#%s#\n",buf);
    WSDmessage::extSendMessage(NULL,message,buf);
    ptr+= WS_SEND_LEN;
    if (ptr+1 > len){
      break;
    }
  }
  return WS_NO_ERR;
}
#endif
static void (*_app_base_chandler)(WSCbase*) = NULL;
void WSGFsetCreateHandler(void (*hd)(WSCbase*) ){
  _app_base_chandler = hd;
}
void WSGFexecCreateHandler(WSCbase* obj){
  if (_app_base_chandler != NULL){
    _app_base_chandler(obj);
  }
}
static void (*_app_base_delete_handler)(WSCbase*) = NULL;
void WSGFsetDeleteHandler(void (*hd)(WSCbase*) ){
  _app_base_delete_handler = hd;
}
void (*        WSGFgetDeleteHandler()
)(WSCbase*){
  return _app_base_delete_handler;
}

static long (*_exist_name_handler)(char*,WSCbase*) = NULL;
// ret = 0                      //no exist
// ret = WS_PROCEDURE_NAME      //hit another procedure name
// ret = WS_OBJECT_NAME         //hit another externed GUI instance name
// ret = WS_OBJECT_ARRAY_NAME   //hit arrayed GUI instance name
// ret = WS_OBJECT_ARRAY_NAME_INVALID  //hit arrayed GUI instance name on another window
long WSGFexistName(char* cname,WSCbase* base){
  if (_exist_name_handler == NULL){
    return 0;
  }
  return _exist_name_handler(cname,base);
}

WSCbase* _get_class_base(WSCbase* base,char* cbase){
  WSClistData children = base->getChildren();
  long num = children.getNum();
  if (num == 0){
    return NULL;
  }
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      if (!WSGFstrcmp(child->getInstanceName(),cbase)){
        return child;
      }
      WSCbase* ret = _get_class_base(child,cbase);
      if (ret != NULL){
        return ret;
      }
    }
  } 
  return NULL;
}

WSCbase* WSGFgetClassBase(WSCbase* base){
  char* cbase = (char*)base->getUserData(WS_WIN_CLASS_BASE);

  base->setUserData("WS-BK-CLASS",(void*)0);

  char* name = (char*)base->getUserData("WS-BK-CLASS-NAME");
  if (name != NULL){
    delete name;
    base->setUserData("WS-BK-CLASS-NAME",(void*)0);
  }

  if (cbase == NULL){
    return base;
  }
  if (!WSGFstrcmp(base->getInstanceName(),cbase)){
    return base;
  }
  WSCbase* ret = _get_class_base(base,cbase);
  if (ret == NULL){
    return base;
  }
  base->setUserData("WS-BK-CLASS",(void*)ret);
  base->setUserData("WS-BK-CLASS-NAME",(void*)WSGFstrdup(ret->getInstanceName()));

//printf("WSGFgetClassBase( base=%s",ret->getInstanceName());
  ret->setInstanceName(base->getInstanceName());
//printf(",cname=%s,icname=%s)\n",ret->getInstanceName(),ret->getClassName());
  ret->setUserData(WS_PROP_LIST,base->getUserData(WS_PROP_LIST));
  ret->setUserData(WS_UTRG_LIST, base->getUserData(WS_UTRG_LIST));
  ret->setUserData(WS_TRG_LIST, base->getUserData(WS_TRG_LIST));
  ret->setUserData(WS_RMETHOD_LIST, base->getUserData(WS_RMETHOD_LIST));
  ret->setUserData(WS_RCLASS_GENERATE, base->getUserData(WS_RCLASS_GENERATE));
  ret->setUserData(WS_RCLASS_NAME, base->getUserData(WS_RCLASS_NAME));
  ret->setUserData(WS_RCLASS_BNAME, base->getUserData(WS_RCLASS_BNAME));

  return ret;
}

void WSGFresetClassBase(WSCbase* base){
  WSCbase* item = (WSCbase*)base->getUserData("WS-BK-CLASS");
  if (item == NULL){
    return;
  }
  
  char* name = (char*)base->getUserData("WS-BK-CLASS-NAME");
  if (name != NULL){
    item->setInstanceName(name);
    delete name;
    base->setUserData("WS-BK-CLASS-NAME",(void*)0);
  }
}

WSCstring* WSGFgetMouseCursorSaveData(){
  long cnt = 0;
  WSCstring* str = new WSCstring();
  while(1){
    long id = WSGIappMouse()->getMouseCursorId(cnt);
    if (id == -1){
      break;
    }
    if (id > 127){
      cnt++;
      continue;
    }
    char* cursor = WSGIappMouse()->getMouseCursorName(id);
    if (cursor == NULL){
      break;
    }
    *str = *str + cursor + "\n";
    cnt++;
  }
  return str; 
}

long WSGFloadMouseCursorData(char** data){
  if (data == NULL){
    return WS_ERR;
  }
//  WSGIappMouse()->resetMouseCursors();
  long cnt = 0;
  while(data[cnt] != NULL){
    char* line = data[cnt];
    if (line == NULL){
      break;
    }
    WSGIappMouse()->setupMouseCursor(line);
    cnt++;
  }
  return WS_NO_ERR;
}

long WSGFloadMouseCursorFile(char* data){
  WSDfile* file = WSDfile::getNewInstance();

  long ret = file->open(WSGIappFileSystem()->adjustFileName(data),"r");
  if (ret == WS_NO_ERR){
    long  len = file->getSize();
    char* buf = new char[len+1];
    long size = file->read(buf,len);
    buf[size] = 0;
    file->close();
    WSCstring str(buf);
    delete buf;
    WSGIappMouse()->resetMouseCursors();
    while(!str.eof()){
      WSCstring line = str.gets();
      WSGIappMouse()->setupMouseCursor(line.getString());
    }
  }
  delete file;
  return ret;
}
static WSCbase* _app_font_editor = NULL;
WSCbase* WSGFgetFontEditor(){
  return _app_font_editor;
}
void WSGFsetFontEditor(WSCbase* feditor){
  _app_font_editor = feditor;
}
void WSGFloadFontFile(char* data){
  WSDfile* file = WSDfile::getNewInstance();
  long ret = file->open(WSGIappFileSystem()->adjustFileName( data ),"r");
  if (ret == WS_NO_ERR){
    long  len = file->getSize();
    char* buf = new char[len+1];
    long size = file->read(buf,len);
    buf[size] = 0;
    file->close();
    WSCstring str(buf);
    delete buf;
    WSGFsetFontData(&str);
  }
  delete file;
}

void WSGFloadFontData(char** data){
  long i= 0;
  WSCstring tmp;
  while( data[i] != NULL ){
    tmp = tmp + data[i] + "\n";
    i++;
  }
  WSGFsetFontData(&tmp);
}

void WSGFsetFontData(WSCstring* data){
  short fno = 0;
  while(!data->eof()){
    WSCstring str = data->gets();
    WSDfont* font = WSGIappFontSet()->getFont(fno);
    if (font == NULL){
WSMFtrace("WScom.cpp:WSGFsetFontData ERROR. fontNo=%d does not exist.\n",fno);
    }else{
      font->setFontName(str.getString());
    }
    fno++;
  }
}

WSCstring* WSGFgetFontSaveData(){
  WSCstring* ret = new WSCstring();
  short fno = 0;
  while(fno < 8){
    WSDfont* font = WSGIappFontSet()->getFont(fno);
    if (font != NULL){
      *ret = *ret + font->getFontName() + "\n";
    }else{
      *ret += "\n";
    }
    fno++;
  }
  return ret;
}

void WSGFsetExistNameHandler(long (*hd)(char*,WSCbase*)){
  _exist_name_handler = hd;
}
void*  WSGFgetExistNameHandler(){
  return (void*)_exist_name_handler;
}

WSCbool WSGFcheckArrayName(char* name,long* arrayno,char* arrayname){
  WSCstring tmp(name);
  long pos1 = tmp.isExist("[");
  if (pos1 == -1 ){
    return False;
  }
  long pos2 = tmp.isExist("]");
  if (pos2 == -1 ){
    return False;
  }

  WSCstring arrayn = tmp.getWord(0,"[");
  if (!WSGFstrcmp(arrayn.getString(),"")){
    return False;
  }
  if (WSGFcheckNameString(arrayn.getString()) == False){
    return False;
  }
  strcpy(arrayname,arrayn.getString());
  WSCstring tmpno = tmp.getWord(1,"[");
  if (!WSGFstrcmp(tmpno.getString(),"")){
    return False;
  }
  WSCstring ano = tmpno.getWord(0,"]");
  if (!WSGFstrcmp(ano.getString(),"")){
    return False;
  }

  ano.delHeadSpace();
  ano.delTailSpace();
  *arrayno = atoi(ano.getString());
  if (*arrayno < 0){
    return False;
  }
  return True;
}
void WSGFdestroyPixmap(char* iname){
  WSGIappImageSet()->destroyImage(iname);
}
void WSGFdestroyPixmap(short no){
  WSGIappImageSet()->destroyImage(no);
}
void WSGFdestroyAllPixmap(){
  WSGIappImageSet()->destroyAllImage();
}
static void _set_char_to_list(WSClistData* dest,char* string){
  long num = dest->getNum();
  long i;
  for(i=0; i<num; i++){
    char* data =(char*)(*dest)[i];
    if (WSGFstrcmp(data,string) > 0){
      dest->add((void*)string,i);
      return;
    }
  }
  dest->add((void*)string);
}
void WSGFsortCharList(WSClistData* src,WSClistData* dest){
  long i;
  long num = src->getNum();
  for(i=0; i< num; i++){
    char* str = (char*)(*src)[i];
    _set_char_to_list(dest,str);
  }
}

long WSGFreplaceTextFile(char* str,char* data,WSCbool same_save){
  return WSGFreplaceFile(str,data,strlen(data),same_save);
}

long WSGFcheckDiffFile(char* str,void* data,long len){
  if (WSGFcheckExistFile(str) != False){
    WSDfile* file = WSDfile::getNewInstance();

    if (file->open(str,"r") == WS_NO_ERR){
      long flen = file->getSize(); 
      char* buf = new char[flen+1];
      long size = file->read(buf,flen);
      buf[size] = 0;
      file->close();
      if (len == size){
        if (memcmp(buf,data,size) == 0){
          delete buf;
          delete file;
          return 0;
        }
      }
      delete buf;
    }
    delete file;
  }
  return 1;
}
long WSGFcheckDiffTextFile(char* str,char* data){
  return WSGFcheckDiffFile(str,data,strlen(data));
}
long WSGFreplaceFile(char* lstr,void* data,long len,WSCbool same_save){
  WSCstring str;
  str = WSGIappFileSystem()->adjustFileName(lstr); 
  if (WSGFcheckExistFile(str) != False){
    if (same_save == False){
      WSDfile* file = WSDfile::getNewInstance();

      if (file->open(str,"r") == WS_NO_ERR){
        long flen = file->getSize(); 
        char* buf = new char[flen+1];
        long size = file->read(buf,flen);
        buf[size] = 0;
        file->close();
        if (len == size){
          if (memcmp(buf,data,size) == 0){
            delete buf;
            delete file;
            return WS_NO_ERR;
          }
        }
        delete buf;
      }
      delete file;
    }
    char bkbuf[1024];
    sprintf(bkbuf,"%s.bak",(char*)str);
    if ( WSGIappFileSystem()->rename(str,bkbuf) == WS_ERR){
#ifdef MSW
printf("ERROR WSGFreplaceFile()  cannot rename filename %s\n",(char*)str);
#else
fprintf(stderr,"ERROR WSGFreplaceFile()  cannot rename filename %s\n",(char*)str);
#endif
      return WS_ERR;
    }
  }

  WSDfile* file = WSDfile::getNewInstance();
  if (file->open(str,"w") == WS_NO_ERR){
    file->write(data,len);
    file->close();
    delete file;
    return WS_NO_ERR; 
  }else{
    delete file;
#ifdef MSW
printf("ERROR WSGFreplaceFile()  cannot open filename %s\n",(char*)str);
#else
fprintf(stderr,"ERROR WSGFreplaceFile()  cannot open filename %s\n",(char*)str);
#endif
    return WS_ERR; 
  }
}

WSCbool WSGFcheckNameString(char* str){ 
  long len = strlen(str);
  if (len == 0){
    return False;
  }
  long i;
  for(i=0; i<len; i++){
    if ( (str[i] >= 'a' && str[i] <= 'z') || 
         (str[i] >= 'A' && str[i] <= 'Z') || 
         (str[i] == '.') || (str[i] == '_') || 
         (i!=0 && str[i] >= '0' && str[i] <= '9') ){
      continue;
    }
    return False;
  }
  return True;
}

WSCbool WSGFcheckPureNameString(char* str){ 
  long len = strlen(str);
  if (len == 0){
    return False;
  }
  long i;
  for(i=0; i<len; i++){
    if ( (str[i] >= 'a' && str[i] <= 'z') || 
         (str[i] >= 'A' && str[i] <= 'Z') || (str[i] == '_') || 
         (i!=0 && str[i] >= '0' && str[i] <= '9') ){
      continue;
    }
    return False;
  }
  return True;
}

WSCbool WSGFcheckDirNameString(char* str){ 
  long len = strlen(str);
  long i;
  for(i=0; i<len; i++){
    if ( (str[i] >= 'a' && str[i] <= 'z') || 
         (str[i] >= 'A' && str[i] <= 'Z') || 
         (str[i] == '/') || (str[i] == ':') || 
         (str[i] == '~') || (str[i] == '-') || 
         (str[i] == '.') || (str[i] == '\\') || 
         (str[i] == '+') || (str[i] == '=') || (str[i] == '_') || 
         (i!=0 && str[i] >= '0' && str[i] <= '9') ){
      continue;
    }
    return False;
  }
  return True;
}

WSCbool WSGFcheckExistFile(char* filename){
  WSDfile* file = WSDfile::getNewInstance();
  long ret = file->open(filename,"r");
  if (ret == WS_NO_ERR){
    file->close();
  }
  delete file;
  if (ret == WS_NO_ERR){
    return True;
  }else{
    return False;
  }
}
long WSGFadjustNumber(long num,long adjust){
  return (num - (num % adjust));
}
void WSGFopCreate(WSCstring* outp,char* fname,char* cname){
    *outp  = "#include <WScom.h>\n";
    *outp << "#include <WSCfunctionList.h>\n";
    *outp << "#include <WSCbase.h>\n";
    *outp << "//----------------------------------------------------------\n";
    *outp << "//Function for the event procedure\n";
    *outp << "//----------------------------------------------------------\n";
    *outp << "void ";
    *outp << fname << "(WSCbase* object){\n";
    *outp << "  //do something...\n";
    *outp << "}\n";
    *outp << "static WSCfunctionRegister  op(\"" << fname; 
    *outp << "\",(void*)" << fname << ");\n";
//    *outp << "void (*_" << fname << ")(WSCbase*) = " << fname << ";\n";
}
void WSGFopCreateRb(WSCstring* outp,char* fname,char* cname){
    *outp =  "#----------------------------------------------------------\n";
    *outp << "#Function for the event procedure\n";
    *outp << "#----------------------------------------------------------\n";
    *outp << "def ";
    *outp << fname << "(object)\n";
    *outp << "#do something...\n\n";
    *outp << "end\n";
}
void WSGFopCreatePy(WSCstring* outp,char* fname,char* cname){
    *outp =  "#----------------------------------------------------------\n";
    *outp << "#Function for the event procedure\n";
    *outp << "#----------------------------------------------------------\n";
    *outp << "import mpfc\n\n";
    *outp << "def ";
    *outp << fname << "(object):\n";
    *outp << "	#do something...\n\n";
    *outp << "	return\n";
    *outp << "mpfc.WSGFfunctionRegister(\""<< fname << "\"," << fname << ")\n";
}
void WSGFopCreatePerl(WSCstring* outp,char* fname,char* cname){
    *outp =  "#----------------------------------------------------------\n";
    *outp << "#Function for the event procedure\n";
    *outp << "#----------------------------------------------------------\n";
    *outp << "use mpfc;\n\n";
    *outp << "sub " << fname << " {\n";
    *outp << "	my ($object) = @_;\n";
    *outp << "	#do something...\n\n";
    *outp << "}\n1;\n";
}



void WSGFclassProcedureCreate(WSCstring* outp,char* fname,char* cname,char* base_class){
    *outp = "#include <WScom.h>\n";
    *outp << "#include <" << base_class << ".h>\n";
    *outp << "#include <WSCbase.h>\n";
    *outp << "//----------------------------------------------------------\n";
    *outp << "//Function for the event procedure\n";
    *outp << "//----------------------------------------------------------\n";
    *outp << "void " << base_class << "::" << fname << "(WSCbase* object){\n";
    *outp << "  " << base_class << "* base = (";
    *outp << base_class << "*)object->getUserData(WS_BASE_CLASS);\n";
//    *outp << WSGFgettext("A:WSSTR  //please edit here...\n");
    *outp << "  //please edit here...\n";
    *outp << "}\n";
}

WSCbool WSGFreadInitString(WSCstring* in,char* sec,WSCstring* out1,WSCstring* out2){
  in->seek(0);
  while(!in->eof()){
    WSCstring str = in->gets();

    if (str.isExist(sec) != -1){
      WSCstring val1 = str.getWord(1,sec);
      out1->setString(val1.getString());
      out1->delHeadSpace();
      out1->delTailSpace();
      out1->delLineFeed();
      val1 = in->gets();
      out2->setString(val1.getString());
      out2->delLineFeed();
      return True;    
    }
  }
  out1->setString("");
  out2->setString("");
  return False;
}

static WSCbool _exist_name_(WSClistData* list,char* str){
  long num = list->getNum();
  long i;
  for(i=0; i<num; i++){
    char* cstr = (char*)(*list)[i];
    if (!WSGFstrcmp(cstr,str)){
      return True;
    }
  }
  return False;
} 

void WSGFgetProcedureList(WSCbase* btarget,WSClistData* list){
  if (list == NULL){
    return;
  }
  WSCbase* parent_win = btarget->getParentWindow();
  WSCbool classP = False;
  if (parent_win != NULL && (long)parent_win->getUserData(WS_WIN_CLASS)){
    classP = True;
  }
  WSClistData* prclist = btarget->getProcedureList();
  long num = prclist->getNum();
  long i;
  for(i=0; i<num; i++){
    WSCprocedure* ac = (WSCprocedure*)(*prclist)[i];
    char* fname = ac->getFunctionName();
    if (ac->getUseFile() == False){
      continue;
    }
    if (ac->getInternal() != False){
      continue;
    }
    WSCstring tmp;
    if (classP == False){
        tmp.setString(fname);
    }else{
        tmp = parent_win->getInstanceName();
        tmp << "_" << fname;
    }
    if (_exist_name_(list,tmp.getString()) == False){
        list->add((void*)WSGFstrdup( tmp.getString() ));
    }
  }

  WSClistData children = btarget->getChildren();
  num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFgetProcedureList(child,list);
    }
  }
}
char* WSGFconvertPropValueString(WSCproperty* prop,char* val){
 return "not_implemented";
}

void WSGFsetEditMode(WSCbase* obj,WSCbool edit){
  obj->setPropertyEditMode(edit);
  WSClistData children = obj->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFsetEditMode(child,edit);
    }
  }
}

static WSCbase*  _get_parent_base(WSCbase* btarget,char* pname){
  if (!WSGFstrcmp(pname,btarget->getInstanceName())){
    return btarget;
  }
  WSClistData children = btarget->getChildren();
  long num = children.getNum();
  if (num == 0){
    return NULL;
  }
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];

    if ( !WSGFstrcmp(pname,child->getInstanceName()) ){
      return child;
    }else{
      WSCbase* ret = _get_parent_base(child,pname);
      if (ret != NULL){
        return ret;
      }
    }
  }
  return NULL;
}

struct prop_data{
  WSCstring name;
  WSCstring vname;
  WSCstring value;
  WSCstring bname;
  long       type;
  WSCbool    use_file;
  char       att;
  WSCstring values;
};
struct utrg_data {
  WSCstring name;
  WSCstring vname;
  long value;
  long type;
};

void _get_2_words(char* src,char* word1,char* word2){
  word1[0] = 0;
  word2[0] = 0;
  long ptr=0;
  while(1){
    if (src[ptr] == 0){
      return;
    }
    if (src[ptr] == ' ' || src[ptr] == '\t'){
      ptr++;
    }else{
      break;
    }
  }

  long i=0;
  while(1){
    if (src[ptr] == 0){
      word1[i] = 0;
      return;
    }
    if (src[ptr] == ' ' || src[ptr] == '\t'){
      word1[i] = 0;
      break;
    }
    word1[i] = src[ptr];
    i++;
    ptr++;
  }

  while(1){
    if (src[ptr] == 0){
      return;
    }
    if (src[ptr] == ' ' || src[ptr] == '\t'){
      ptr++;
    }else{
      break;
    }

  }
  i=0;
  while(1){
    if (src[ptr] == 0){
      word2[i] = 0;
      return;
    }
    if (src[ptr] == ' ' || src[ptr] == '\t'){
      word2[i] = 0;
      return;
    }
    word2[i] = src[ptr];
    i++;
    ptr++;
  }
}
void WSGFmarkChanged(WSCbase* target){
  long fl = 1;
  target->setUserData(WS_PROPERTY_CHANGED,(void*)fl);
}

void WSGFclearMarkChanged(WSCbase* target){
  long fl = (long)target->getUserData(WS_PROPERTY_CHANGED);
  if (fl == 1){
    fl = 0;
    target->setUserData(WS_PROPERTY_CHANGED,(void*)fl);
  }
  WSClistData children = target->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    WSGFclearMarkChanged(child);
  }
}

WSCbool WSGFcheckMarkChanged(WSCbase* target){
  long fl = (long)target->getUserData(WS_PROPERTY_CHANGED);
  if (fl == 1){
    return True;
  }
  WSClistData children = target->getChildren();
  long num = children.getNum();
  if (num == 0){
    return False;
  }
  long i;
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    WSCbool ret = WSGFcheckMarkChanged(child);
    if (ret != False){
      return True;
    }
  }
  return False;
}

static void _append(WSClistData* list,WSCstring* str){
  long num = list->getNum();
  long i;
  if (num > 2){
    WSClistData list1;
    WSClistData list2;
    for(i=0; i<num; i++){
      if (i < num/2){
        list1.add( (*list)[i] );
      }else{
        list2.add( (*list)[i] );
      }
    }
    WSCstring str1;
    WSCstring str2;
    _append(&list1,&str1);
    _append(&list2,&str2);
    *str << str1 << str2;
    return;
  }else{
    if (num == 2){
      WSCstring* str1 = (WSCstring*)(*list)[0];
      WSCstring* str2 = (WSCstring*)(*list)[1];
      *str << *str1 << *str2;
    }else if (num == 1){
      WSCstring* str1 = (WSCstring*)(*list)[0];
      *str << *str1;
    }
    return;
  }
}


long WSGFtypeToValue(char* typen){
  if (!strcmp(typen,"long")){
    return WSTlong;
  }else
  if (!strcmp(typen,"WSCulong")){
    return WSTulong;
  }else
  if (!strcmp(typen,"short")){
    return WSTshort;
  }else
  if (!strcmp(typen,"WSCushort")){
    return WSTushort;
  }else
  if (!strcmp(typen,"char")){
    return WSTchar;
  }else
  if (!strcmp(typen,"WSCuchar")){
    return WSTuchar;
  }else
  if (!strcmp(typen,"float")){
    return WSTfloat;
  }else
  if (!strcmp(typen,"double")){
    return WSTdouble;
  }else
  if (!strcmp(typen,"void*")){
    return WSTvoidptr;
  }else
  if (!strcmp(typen,"char*")){
    return WSTcharptr;
  }else
  if (!strcmp(typen,"void")){
    return WSTvoid;
  }else
  if (!strcmp(typen,"WSCbool")){
    return WSTbool;
  }else
  if (!strcmp(typen,"int")){
    return WSTint;
  }else
  if (!strcmp(typen,"WSCuint")){
    return WSTuint;
  }
  return 0;
}

void _add_default_changed_property(WSCbase* btarget,char* pn,char tp,char* pdata,WSClistData* plist){
  WSCstring pname("WSN");
  pname << pn;
  if (!WSGFstrcmp(pn,"x")){
    return;
  }
  if (!WSGFstrcmp(pn,"y")){
    return;
  }

  WSClistData* prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 2 &&   //default_value_ch
          !WSGFstrcmp(pname.getString(),propdata->name.getString())){
        //Already exists,so update the value...
        propdata->value.setString(pdata);
        return;
      }
    }
  }
  prop_data* propdata = new prop_data;
  propdata->name.setString(pname.getString());
  propdata->value.setString(pdata);
  propdata->type = tp;
  propdata->att = 2; //ѹ //default value change
  plist->add((void*)propdata);
}

WSCstring* WSGFreadTextFile(char* filename,long encoding){
  WSDfile* file = WSDfile::getNewInstance();
  long ret = file->open(WSGIappFileSystem()->adjustFileName(filename),"r");
  if (ret == WS_NO_ERR){
    WSCstring* out = new WSCstring();
    long len = file->getSize();
    char* buf = new char[len+1];
    long size = file->read(buf,len);
    buf[size] = 0;
    file->close();
    out->setString(buf,encoding);
    delete buf;

    delete file;
    return out;
  }else{
    delete file;
    return NULL;
  }
}

char* WSGFultoa(WSCulong val,char* buf){
static char buffer[32];
  long i=31;
  if (val == 0){
    buf[0] = '0';
    buf[1] = 0;
    return buf;
  }
  buffer[31] = 0;
  while(val != 0){
    i--;
    buffer[i] = '0' + val % 10;
    val = val / 10;
  }
  memcpy(buf,&buffer[i],32-i);
  return buf;
}

char* WSGFultoa(WSCulong val){
static char buffer[32];
  long i=31;
  if (val == 0){
    buffer[0] = '0';
    buffer[1] = 0;
    return buffer;
  }
  buffer[31] = 0;
  while(val != 0){
    i--;
    buffer[i] = '0' + val % 10;
     val = val / 10;
  }
  return &buffer[i];
}

char* WSGFltoa(long val,char* buf){
static char buffer[32];
  long i=31;
  WSCbool plus =True;
  if (val < 0){
    val = -val;
    plus = False;

  }else if (val == 0){
    buf[0] = '0';
    buf[1] = 0;
    return buf;
  }
  buffer[31] = 0;
  while(val != 0){
    i--;
    buffer[i] = '0' + val % 10;
     val = val / 10;
  }
  if (plus == False){
    i--;
    buffer[i] = '-';
  }
  memcpy(buf,&buffer[i],32-i);
  return buf;
}

char* WSGFltoa(long val){
static char buffer[32];

  long i=31;
  WSCbool plus =True;
  if (val < 0){
    val = -val;
    plus = False;

  }else if (val == 0){
    buffer[0] = '0';
    buffer[1] = 0;
    return buffer;
  }
  buffer[31] = 0;
  while(val != 0){
    i--;
    buffer[i] = '0' + val % 10;
     val = val / 10;
  }
  if (plus == False){
    i--;
    buffer[i] = '-';
  }
  return &buffer[i];
}

char* WSGFftoa(float val){
static char buffer[64];
  sprintf(buffer,"%10.10lf",val);
  return buffer;
}
char* WSGFlftoa(double val){
static char buffer[64];
  sprintf(buffer,"%10.10lf",val);
  return buffer;
}
//return the hash_value between  0 - MAX_HASH
long WSGFgetHashValue(char* str){
  long val = str[0];
  long len = 0;

  while(str[len] != 0){
    len++;
  }

  if (len != 0){
    val += str[len/2]*2;
    val += str[len-1]*4;
  }

  val = val % WS_MAX_HASH_VALUE;
  if (val < 0){
    return val + WS_MAX_HASH_VALUE;
  }
  return val;
}
WSCushort* WSGFinsertStringUCS2(WSCushort* str,long pos,WSCushort* ins){
  long len1= WSGFstrlenUCS2(str);
  long len2= WSGFstrlenUCS2(ins);
  WSCushort* newstr = new WSCushort[len1+len2+1];
  memcpy(newstr,str,pos*sizeof(WSCushort));
  memcpy(&newstr[pos],ins,len2*sizeof(WSCushort));
  memcpy(&newstr[pos+len2],&str[pos],(len1-pos)*sizeof(WSCushort));
  newstr[len1+len2] = 0;
  return newstr;
}
void WSGFdelStringUCS2(WSCushort* str,long pos,long chars){
  long len = WSGFstrlenUCS2(str);
  if (len < pos){
    return;
  }
  if (len < pos + chars){
    chars = len - pos;
  }
  if (chars < 1){
    return;
  }
  memcpy(&str[pos],&str[pos+chars],(len - pos - chars+1)*sizeof(WSCushort));
}
WSCushort* WSGFgetUCS2(const char* str,long encode){
  if (encode == WS_EN_DEFAULT){
    encode = WSGIappLocaleSet()->getDefaultEncoding();
  }

  int len = WSGIappCodeConvert()->encode(NULL,0,str,-1,encode);
  WSCushort* ret = new WSCushort[len+1];
  WSGIappCodeConvert()->encode(ret,len+1,str,-1,encode);
  return ret;
}
char* WSGFgetString(WSCushort* str,long encode){
  if (encode == WS_EN_DEFAULT){
    encode = WSGIappLocaleSet()->getDefaultEncoding();
  }

  int len = WSGIappCodeConvert()->decode(NULL,0,str,-1,encode);
  char* ret = new char[len+1];
  WSGIappCodeConvert()->decode(ret,len+1,str,-1,encode);
  return ret;
}

long WSGFcalcStringXYPosToPos(WSCushort* istr,long xpos,long ypos,long* pos){
  if (istr[0] == 0){
    *pos=0;
//printf("WSGFcalcStringXYPosToPos out pos=%d\n",*pos);
    return WS_NO_ERR;
  }
  if (ypos < 0){
    long lines = 1;
    long i = 0;
    while(1){
      if (istr[i] == (WSCushort)0){
        break;
      }
      if (istr[i] == (WSCushort)'\n'){
        lines++;
      }
      i++;
    }
    ypos = lines -1;
  }
  long lines = 0;
  long ptr = 0;
  while(1){
    if (lines == ypos){
      break;
    }
    if (istr[ptr] == (WSCushort)0){
      break;
    }
    if (istr[ptr] == (WSCushort)'\n'){
      lines++;
    }
    ptr++;
  }
  long x = 0;
  while(1){
    if (xpos == x){
      *pos = ptr;
//printf("WSGFcalcStringXYPosToPos out1 pos=%d\n",*pos);
      return WS_NO_ERR;
    }
    if (istr[ptr] == (WSCushort)0){
      *pos = ptr;
//printf("WSGFcalcStringXYPosToPos out2 pos=%d\n",*pos);
      return WS_NO_ERR;
    }
    if (istr[ptr] == (WSCushort)'\n'){
      *pos = ptr;
//printf("WSGFcalcStringXYPosToPos out3 pos=%d\n",*pos);
      return WS_NO_ERR;
    }
    ptr++;
    x++;
  }
//printf("WSGFcalcStringXYPosToPos out4 pos=%d\n",*pos);
  return WS_NO_ERR;
}
long WSGFcalcStringXYPos(WSCushort* istr,long pos,long* xpos,long* ypos){
  long i;
  *ypos = 0;
  *xpos = 0;
  for(i=0; i<pos; i++){
    if (istr[i] == (WSCushort)0){
      break;
    }
    if (istr[i] == (WSCushort)'\n'){
      (*ypos)++;
      (*xpos) = 0;
    }else{
      (*xpos)++;
    }
  }
//printf("WSGFcalcStringXYPos out x,y=%d,%d\n",*xpos,*ypos);
  return WS_NO_ERR;
}

long WSGFcalcStringPosFromAddr(WSCushort* istr,WSCrect* area,
            char alignment,WSDfont* font,long x,long y,
            long* pos ,WSCbool intercur){
//printf("WSGFcalcStringPosFromAddr here...\n");
  x -= area->x;
  y -= area->y;
  if (font == NULL){
    *pos = 0;
    return WS_ERR;
  }
  long max = WSGFstrlenUCS2(istr);
  if (max == 0){
    *pos=0;
    return WS_NO_ERR;
  }

  if (intercur == False){
    max--;
  }
  if (max == -1){
    *pos=0;
    return WS_NO_ERR;
  }
//printf("WSGFcalcStringPosFromAddr x=%d y=%d\n",x,y);

//  short fw,fh;
  WSCstring str(" ");
//  fw = font->getStringWidth(&str);
  short fh = font->getStringHeight(&str);
//printf("WSGFcalcStringPosFromAddr fw=%d fh=%d\n",fw,fh);

  long lines = WSGFgetLinesUCS2(istr);
//printf("WSGFcalcStringPosFromAddr lines=%d\n",lines);
  if (alignment == WS_TOP ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_RIGHT_TOP){
    //do nothing
  }else 
  if (alignment == WS_LEFT ||
      alignment == WS_CENTER ||
      alignment == WS_RIGHT){
    long padh = (long)(area->height - fh * lines)/2;
    y -= padh;
  }else 
  if (alignment == WS_BOTTOM ||
      alignment == WS_LEFT_BOTTOM ||
      alignment == WS_RIGHT_BOTTOM ){
    long padh = area->height - fh * lines;
    y -= padh;
  }

  long yline = y / fh;
  
  WSCushort tmp[2];
  tmp[0] = (WSCushort)'\n';
  tmp[1] = 0;
  long ptr = WSGFgetWordCharPosUCS2(istr,yline,tmp);
//printf("WSGFcalcStringPosFromAddr ptr=%d yline=%d y=%d max=%d\n",ptr,yline,y,max);
  if (ptr == -1){
    *pos = max;
    return WS_NO_ERR;
  }
//#if 0//speed up
//#else
//  istr->seek(ptr);
//  WSCstring tstr = istr->gets();
//#endif

  WSCushort* line_str = WSGFgetWordUCS2(istr,yline,tmp);
  long fwidth = font->getStringWidthUCS2(line_str);

  if (alignment == WS_LEFT ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_LEFT_BOTTOM){
    //do nothing.
  }else
  if (alignment == WS_TOP ||
      alignment == WS_CENTER ||
      alignment == WS_BOTTOM){
    x -= (long)(area->width - fwidth)/2;
  }else
  if (alignment == WS_RIGHT ||
      alignment == WS_RIGHT_TOP ||
      alignment == WS_RIGHT_BOTTOM ){
    x -= area->width - fwidth;
  }

  long len = WSGFstrlenUCS2(line_str);
  if (intercur != False){
    len ++;
  }
  *pos = ptr;
  if (x < fwidth){
extern long _calc_rawx_to_pos(WSCushort* str,long x,WSDfont* font);
    long ret = _calc_rawx_to_pos(line_str, x, font);
    delete line_str;
    *pos = ptr+ ret;
    if (*pos < WSGFstrlenUCS2(istr)){
    }else{
      *pos =  WSGFstrlenUCS2(istr);
    }
    return WS_NO_ERR;
  }else{
    delete line_str;
    *pos = ptr+ len -1;
    if (*pos < WSGFstrlenUCS2(istr)){
    }else{
      *pos =  WSGFstrlenUCS2(istr);
    }
    return WS_NO_ERR;
  }
#if 0
  long p;
  for( p=0; p < len; p++){
    long ox = p * fw;

    long tmpdist = (x-ox)*(x-ox);
    if (dist > tmpdist || dist == -1 ){
      dist = tmpdist;
      *pos = p+ ptr;
    }
  }
#endif
  return WS_NO_ERR;
}
long _calc_rawx_to_pos(WSCushort* str,long x,WSDfont* font){
  long len = WSGFstrlenUCS2(str);
  if (len == 1){
    long fwidth = font->getStringWidthUCS2(str);
    if (x < fwidth/2 ){
      return 0;
    }
    return 1;
  }
  if (len == 0){
    return 0;
  }
  WSCushort* str2 = WSGFstrdupUCS2(str);
  str2[len/2] = 0;
  long fwidth2 = font->getStringWidthUCS2(str2);
  if (x < fwidth2){
    long ret = _calc_rawx_to_pos(str2,x,font);
    delete str2;
//printf("_calc_rawx_to_pos ret=%d\n",ret);
    return ret;
  }else{
    delete str2;
    str2 = WSGFstrdupUCS2(str);
    long ret = _calc_rawx_to_pos(&str2[len/2],x-fwidth2,font);
    delete str2;
//printf("_calc_rawx_to_pos ret+len/2=%d\n",ret+len/2);
    return ret+len/2; 
  }
}



long WSGFgetLinesUCS2(WSCushort* str){
  if (str == NULL){
    return 1;
  }
  long lines = 1;
  long i = 0;
  while(1){
    if (str[i] == 0){
      break;
    }
    if (str[i] == (WSCushort)'\n'){
      lines++;
    }
    i++;
  }
  return lines;
}
long WSGFcalcStringLineAddr(WSCushort* istr,WSCrect* area,
            char alignment,WSDfont* font,WSCpoint* pts,long line){
   long n = WSGFgetLinesUCS2(istr);
   if (line > n-1){
     pts->x = 0;
     pts->y = 0;
     return 0;
   }

   long fheight = font->getStringHeightUCS2(istr);
   long py = area->y;
   long by = area->height;
   if (alignment == WS_TOP ||
       alignment == WS_LEFT_TOP ||
       alignment == WS_RIGHT_TOP){
     pts->y = py + fheight*line;
   }else
   if (alignment == WS_LEFT ||
       alignment == WS_CENTER ||
       alignment == WS_RIGHT){
     pts->y = py + by/2  - fheight*(line+1)/2 + fheight*line;
   }else
   if (alignment == WS_BOTTOM ||
       alignment == WS_LEFT_BOTTOM ||
       alignment == WS_RIGHT_BOTTOM ){
     pts->y = py + by + fheight*(line -n) ;
   }

   long px = area->x;
   long pw = area->width;
//   if (!WSGFstrcmp(line_str.getString(),"")){
//     pts->x = px;
//   }else
   if (alignment == WS_LEFT ||
       alignment == WS_LEFT_TOP ||
       alignment == WS_LEFT_BOTTOM){
     pts->x = px;
   }else
   if (alignment == WS_TOP ||
       alignment == WS_CENTER ||
       alignment == WS_BOTTOM){
     WSCushort tmp[2];
     tmp[0] = '\n';
     tmp[1] = 0;
     WSCushort* line_str = WSGFgetWordUCS2(istr,line,tmp);
     long fwidth = font->getStringWidthUCS2(line_str);
     pts->x = px + (long)(pw - fwidth)/2;
     delete line_str;
   }else
   if (alignment == WS_RIGHT ||
       alignment == WS_RIGHT_TOP ||
       alignment == WS_RIGHT_BOTTOM ){
     WSCushort tmp[2];
     tmp[0] = '\n';
     tmp[1] = 0;
     WSCushort* line_str = WSGFgetWordUCS2(istr,line,tmp);
     long fwidth = font->getStringWidthUCS2(line_str);
     pts->x = px + pw - fwidth;
     delete line_str;
   }
   return WS_NO_ERR;
}
long WSGFgetWordPosUCS2(WSCushort* str,long ypos){
  long lines = 1;
  long i = 0;
  while(1){
    if (lines == ypos){
      return i;
    }
    if (str[i] == (WSCushort)0){
      break;
    }
    if (str[i] == (WSCushort)'\n'){
      lines++;
    }
    i++;
  }
  return i;
}

long WSGFcalcStringPosAddr(WSCushort* istr,WSCrect* area,
         char alignment,WSDfont* font,long pos,long* ox,long *oy){
  if (pos < 0){
    return WS_ERR;
  }
#if 0
  long xpos,ypos;
  WSGFcalcStringXYPos(istr,pos,&xpos,&ypos);
  long ptr = WSGFgetWordPosUCS2(istr,ypos);
  WSCushort* lstr = &istr[ptr];
  WSCushort* tmp = new WSCushort[xpos+1];
  memcpy(tmp,lstr,xpos+sizeof(WSCushort));
  tmp[xpos] = 0;
  WSCpoint pt;
  WSGFcalcStringLineAddr(istr,area,alignment,font,&pt,ypos);
  *ox = pt.x + font->getStringWidthUCS2(lstr);
  *oy = pt.y;
#endif

  long xpos = 0;
  long ypos = 0;
  if (istr == NULL){
    *ox = 0;
    *oy = 0;
    return WS_NO_ERR;
  }
  long ptr = 0;
  long i = 0;
  long k = 0;
  long col = 0;
  long line = 0;
  while(1){
    if (col == pos){
       break;
    }
    if (istr[i] == 0){
      ptr = i;
      break;
    }
    if (istr[i] == '\n'){
      k= 0;
      i++;
      line++;
      ptr = i;
      col++;
      continue;
    }
#if 0
    if(str[i] & 0x80){         //not ascii
      if (str[i] == (char)0x8e){       //ȾѲ̾2byte = 1column
        i++;
      }else if (str[i] == (char)0x8f){ //3byte = 2column
        i++;
        col++;
        k++;
        i++;
      }else{         //2byte = 2column
        col++;
        k++;
        i++;
      }
    }
#endif
    col++;
    k++;
    i++;
  }
  xpos = k;
  ypos = line;
//printf("WSGFcalcStringPosAddr %d %d\n",xpos,ypos);
//  istr->seek(ptr);
  WSCushort* lstr = WSGFstrdupUCS2(&istr[ptr]);
  lstr[xpos] = 0;
  WSCpoint pt;

  long n = line;
  i = ptr;
  while(1){
    if (istr[i] == 0){
      break;
    }
    if (istr[i] == '\n'){
      n++;
    }
    i++;
  }

  if (line > n){
    pt.x = 0;
    pt.y = 0;
    return 0;
  }

//   long fheight = font->getStringHeight(istr);
  long fheight = font->getFontHeight();
  long py = area->y;
  long by = area->height;
  if (alignment == WS_TOP ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_RIGHT_TOP){
    pt.y = py + fheight*line;
  }else
  if (alignment == WS_LEFT ||
      alignment == WS_CENTER ||
      alignment == WS_RIGHT){
    pt.y = py + by/2  - fheight*(line+1)/2 + fheight*line;
  }else
  if (alignment == WS_BOTTOM ||
      alignment == WS_LEFT_BOTTOM ||
      alignment == WS_RIGHT_BOTTOM ){
    pt.y = py + by + fheight*(line -n) ;
  }

  long px = area->x;
  long pw = area->width;
  if (alignment == WS_LEFT ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_LEFT_BOTTOM){
    pt.x = px;
  }else
  if (alignment == WS_TOP ||
      alignment == WS_CENTER ||
      alignment == WS_BOTTOM){
    WSCushort tmp[2];
    tmp[0] = (WSCushort)'\n';
    tmp[1] = (WSCushort)0;
    WSCushort* line_str = WSGFgetWordUCS2(istr,line,tmp);
    long fwidth = font->getStringWidthUCS2(line_str);
    pt.x = px + (pw - fwidth)/2;
  }else
  if (alignment == WS_RIGHT ||
      alignment == WS_RIGHT_TOP ||
      alignment == WS_RIGHT_BOTTOM ){
    WSCushort tmp[2];
    tmp[0] = (WSCushort)'\n';
    tmp[1] = (WSCushort)0;
    WSCushort* line_str = WSGFgetWordUCS2(istr,line,tmp);
    long fwidth = font->getStringWidthUCS2(line_str);
    pt.x = px + pw - fwidth;
  }

  *ox = pt.x + font->getStringWidthUCS2(lstr);
  *oy = pt.y;

  return WS_NO_ERR;
}

long WSGFcalcStringAddr(WSCstring* istr,WSCrect* area,
                        char alignment,WSDfont* font,
                        WSCpoint** out,long* num){

//printf("WSGFcalcStringAddr() start:");
//WSGFtimetrace();

  long n = istr->getWords("\n");
  *num = n;
  WSCpoint* pts;
  pts = new WSCpoint[n];
  *out = pts;
//  long fheight = font->getStringHeight(istr);
  long fheight = font->getFontHeight();
  long py = area->y;
  long by = area->height;
  long i;
  if (alignment == WS_TOP ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_RIGHT_TOP){
    for(i=0; i < n; i++){
       pts[i].y = py;
       py += fheight;
    }
  }else
  if (alignment == WS_LEFT ||
      alignment == WS_CENTER ||
      alignment == WS_RIGHT){
    for(i=0; i < n; i++){
      pts[i].y = py + by/2  - (long)fheight*n/2 + fheight*i;
    }
  }else
  if (alignment == WS_BOTTOM ||
      alignment == WS_LEFT_BOTTOM ||
      alignment == WS_RIGHT_BOTTOM ){
    for(i=0; i < n; i++){
       pts[i].y = py + by + fheight*(i -n) ;
    }
  }

  long px = area->x;
  long pw = area->width;
  istr->seek(0);

  if (alignment == WS_LEFT ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_LEFT_BOTTOM){
    for(i=0; i < n; i++){
       pts[i].x = px;
    }
  }else
  if (alignment == WS_TOP ||
      alignment == WS_CENTER ||
      alignment == WS_BOTTOM){
    for(i=0; i < n; i++){
      WSCstring line_str = istr->gets();
      long fwidth = font->getStringWidth(&line_str);
      pts[i].x = px + (long)(pw - fwidth)/2;
    }
  }else
  if (alignment == WS_RIGHT ||
      alignment == WS_RIGHT_TOP ||
      alignment == WS_RIGHT_BOTTOM ){
    for(i=0; i < n; i++){
      WSCstring line_str = istr->gets();
      long fwidth = font->getStringWidth(&line_str);
      pts[i].x = px + pw - fwidth;
    }
  }
  istr->seek(0);
//printf("WSGFcalcStringAddr()   end:");
//WSGFtimetrace();
  return WS_NO_ERR;
}

long WSGFcalcOneLineStringAddr(WSCstring* istr,WSCrect* area,
                        char alignment,WSDfont* font,
                        WSCpoint* out){

//   long fheight = font->getStringHeight(istr);
   long fheight = font->getFontHeight();
   long py = area->y;
   long by = area->height;
   if (alignment == WS_TOP ||
       alignment == WS_LEFT_TOP ||
       alignment == WS_RIGHT_TOP){
     out->y = py;
     py += fheight;
   }else
   if (alignment == WS_LEFT ||
       alignment == WS_CENTER ||
       alignment == WS_RIGHT){
     out->y = py + by/2  - fheight/2;
   }else
   if (alignment == WS_BOTTOM ||
       alignment == WS_LEFT_BOTTOM ||
       alignment == WS_RIGHT_BOTTOM ){
     out->y = py + by - fheight;
   }

   long px = area->x;
   long pw = area->width;

   if (alignment == WS_LEFT ||
       alignment == WS_LEFT_TOP ||
       alignment == WS_LEFT_BOTTOM){
     out->x = px;
   }else
   if (alignment == WS_TOP ||
       alignment == WS_CENTER ||
       alignment == WS_BOTTOM){
     long fwidth = font->getStringWidth(istr);
     out->x = px + (pw - fwidth)/2;
   }else
   if (alignment == WS_RIGHT ||
       alignment == WS_RIGHT_TOP ||
       alignment == WS_RIGHT_BOTTOM ){
     long fwidth = font->getStringWidth(istr);
     out->x = px + pw - fwidth;
   }
   return WS_NO_ERR;
}

static WSCbase* theAppWindowList = NULL;
WSCbase* WSGIappWindowList(){
  return theAppWindowList;
}

long WSGFsetAppWindowList(WSCbase* pl){
  theAppWindowList = pl;
  return WS_NO_ERR;
}

static WSCbase* theAppPropertyEditor = NULL;
WSCbase* WSGIappPropertyEditor(){
  return theAppPropertyEditor;
}

long WSGFsetAppPropertyEditor(WSCbase* editor){
  theAppPropertyEditor = editor;
  return WS_NO_ERR;
}

WSCuchar WSGFblinkRate(long rate){
  return (rate/250);
}

WSCbool WSGFareaInclude(short x1,short y1,WSCushort w1,WSCushort h1,
                        short x2,short y2,WSCushort w2,WSCushort h2){
  if (x1 + w1 < x2){
    return False;
  }else if (y1 + h1 < y2){
    return False;
  }else if (x2 + w2 < x1 ){
    return False;
  }else if (y2 + h2 < y1){
    return False;
  }
  return True;
}

long WSGForArea(long x1,long y1,WSCulong w1,WSCulong h1,
                long x2,long y2,WSCulong w2,WSCulong h2,
                long* x,long* y,WSCulong* w,WSCulong* h){

  *x = x1 < x2 ? x1 : x2;
  *y = y1 < y2 ? y1 : x2;

  *w = x1+w1 > x2+w2 ? x1+w1 - *x : x2+w2 - *x;
  *h = y1+h1 > y2+h2 ? y1+h1 - *y : y2+h2 - *y;

  return WS_NO_ERR;
}
long WSGFandArea(long x1,long y1,WSCulong w1,WSCulong h1,
                 long x2,long y2,WSCulong w2,WSCulong h2,
                 long* x,long* y,WSCulong* w,WSCulong* h){

  *x = x1 > x2 ? x1 : x2;
  *y = y1 > y2 ? y1 : y2;

  short ww = (short)(x1+w1) < (short)(x2+w2) ? x1+w1 - *x : x2+w2 - *x;
  short wh = (short)(y1+h1) < (short)(y2+h2) ? y1+h1 - *y : y2+h2 - *y;
  if (ww > 0){
    *w = ww;
  }else{
    *x = 0;
    *y = 0;
    *w = 0;
    *h = 0;
    return WS_ERR;
  }
  if (wh > 0){
    *h = wh;
  }else{
    *x = 0;
    *y = 0;
    *w = 0;
    *h = 0;
    return WS_ERR;
  }
  return WS_NO_ERR;
}

char* WSGFstrdup(const char* src){
  char* ret;
  int   len = strlen(src) +1;
  ret = new char[len];
  strcpy(ret,src);
  return ret;
}

long WSGFstricmp(char* src1,char* src2){
  char *pt1, *pt2, ch1, ch2;
  long diff = 'a' - 'A';
  for (pt1=src1, pt2=src2; *pt1 != '\0' || *pt2 != '\0'; pt1++, pt2++) {
    ch1 = *pt1;
    ch2 = *pt2;
    if (ch1 >= 'A' && ch1 <= 'Z'){
      ch1 = ch1 + diff;
    }
    if (ch2 >= 'A' && ch2 <= 'Z'){
      ch2 = ch2 + diff;
    }
    if (ch1 != ch2){
      break;
    }
  }
  return ((*pt1)-(*pt2));
}

void WSGFtrimSpace(char* str){
  WSCstring tmp(str);
  tmp.delTailSpace();
  tmp.delLineFeed();
  tmp.delHeadSpace();
  strcpy(str,tmp.getString());
}

long WSGFstrnccmp(char* src1,char* src2,long cnt){
  char *pt1, *pt2, ch1, ch2;
  long i=0;
  for (pt1=src1, pt2=src2; i < cnt && (*pt1 != '\0' || *pt2 != '\0'); pt1++,pt2++,i++){
    ch1 = *pt1;
    ch2 = *pt2;
    if (ch1 >= 'A' && ch1 <= 'Z'){
      ch1 = ch1-'A'+'a';
    }
    if (ch2 >= 'A' && ch2 <= 'Z'){
      ch2 = ch2-'A'+'a';
    }
    if (ch1 != ch2){
      break;
    }
  }
  if (i == cnt){
    return 0;
  }
  return ((*pt1)-(*pt2));
}

//WSDnwDev WSDwindowDev ˤȤƤ

char* WSGFtriggerToName(long ev){
static char fl = 0;
static char* trgtable[WSEV_HASH_MAX_NUM];
  if (fl == 0){
    fl = 1;
    long i;
    for(i=0; i<WSEV_HASH_MAX_NUM; i++){
      trgtable[i] = "WSEV_USER";
    }
    trgtable[WSEV_INITIALIZE] = "WSEV_INITIALIZE";
    trgtable[WSEV_DELETE] = "WSEV_DELETE";
    trgtable[WSEV_ACTIVATE] = "WSEV_ACTIVATE";
    trgtable[WSEV_VALUE_CH] = "WSEV_VALUE_CH";
    trgtable[WSEV_FOCUS_CH] = "WSEV_FOCUS_CH";
    trgtable[WSEV_VISIBLE_CH] = "WSEV_VISIBLE_CH";
    trgtable[WSEV_SENSITIVE_CH] = "WSEV_SENSITIVE_CH";
    trgtable[WSEV_PARENT_VISIBLE_CH] = "WSEV_PARENT_VISIBLE_CH";
    trgtable[WSEV_PARENT_SENSITIVE_CH] = "WSEV_PARENT_SENSITIVE_CH";
    trgtable[WSEV_EXPOSE] = "WSEV_EXPOSE";
    trgtable[WSEV_RESIZE] = "WSEV_RESIZE";
    trgtable[WSEV_MOUSE_IN] = "WSEV_MOUSE_IN";
    trgtable[WSEV_MOUSE_OUT] = "WSEV_MOUSE_OUT";
    trgtable[WSEV_MOUSE_PRESS] = "WSEV_MOUSE_PRESS";
    trgtable[WSEV_MOUSE_RELEASE] = "WSEV_MOUSE_RELEASE";
    trgtable[WSEV_MOUSE_MOVE] = "WSEV_MOUSE_MOVE";
    trgtable[WSEV_KEY_PRESS] = "WSEV_KEY_PRESS";
    trgtable[WSEV_KEY_RELEASE] = "WSEV_KEY_RELEASE";
    trgtable[WSEV_KEY_HOOK] = "WSEV_KEY_HOOK";
    trgtable[WSEV_MOUSE_DOUBLE_CLICK] = "WSEV_MOUSE_DOUBLE_CLICK";
   }
   if (ev < 0 || ev > WSEV_HASH_MAX_NUM -1){
     return "WSEV_NONE";
   }
   return trgtable[ev];
}

char* WSGFeventToName(long ev){
  return WSGFtriggerToName(ev);
}

//WSDnwDev WSDwindowDev ˤȤƤ
WSCulong WSGFeventToMaskBit(long ev){
static char fl = 0;
static long trgtable[WSEV_HASH_MAX_NUM];
  if (fl == 0){
    fl = 1;
    long i;
    for(i=0; i<WSEV_HASH_MAX_NUM; i++){
      trgtable[i] = WSEV_NONE_BIT;
    }
    trgtable[WSEV_INITIALIZE] = WSEV_INITIALIZE_BIT;
    trgtable[WSEV_DELETE] = WSEV_DELETE_BIT;
    trgtable[WSEV_ACTIVATE] = WSEV_ACTIVATE_BIT;
    trgtable[WSEV_VALUE_CH] = WSEV_VALUE_CH_BIT;
    trgtable[WSEV_FOCUS_CH] = WSEV_FOCUS_CH_BIT;
    trgtable[WSEV_VISIBLE_CH] = WSEV_VISIBLE_CH_BIT;
    trgtable[WSEV_SENSITIVE_CH] = WSEV_SENSITIVE_CH_BIT;
    trgtable[WSEV_PARENT_VISIBLE_CH] = WSEV_PARENT_VISIBLE_CH_BIT;
    trgtable[WSEV_PARENT_SENSITIVE_CH] = WSEV_PARENT_SENSITIVE_CH_BIT;
    trgtable[WSEV_EXPOSE] = WSEV_EXPOSE_BIT;
    trgtable[WSEV_RESIZE] = WSEV_RESIZE_BIT;
    trgtable[WSEV_MOUSE_IN] = WSEV_MOUSE_IN_BIT;
    trgtable[WSEV_MOUSE_OUT] = WSEV_MOUSE_OUT_BIT;
    trgtable[WSEV_MOUSE_PRESS] = WSEV_MOUSE_PRESS_BIT;
    trgtable[WSEV_MOUSE_RELEASE] = WSEV_MOUSE_RELEASE_BIT;
    trgtable[WSEV_MOUSE_MOVE] = WSEV_MOUSE_MOVE_BIT;
    trgtable[WSEV_KEY_PRESS] = WSEV_KEY_PRESS_BIT;
    trgtable[WSEV_KEY_RELEASE] = WSEV_KEY_RELEASE_BIT;
    trgtable[WSEV_KEY_HOOK] = WSEV_KEY_HOOK_BIT;
    trgtable[WSEV_MOUSE_DOUBLE_CLICK] = WSEV_MOUSE_PRESS_BIT;
   }
   if (ev < 0 || ev > WSEV_HASH_MAX_NUM -1){
     return WSEV_NONE_BIT;
   }
   return trgtable[ev];
}
long WSGFnameToEvent(char* ev){
  if (!WSGFstrcmp("WSEV_NONE",ev)){
     return  WSEV_NONE;
  }else
  if (!WSGFstrcmp(ev,"WSEV_ACTIVATE")){
     return  WSEV_ACTIVATE;
  }else
  if (!WSGFstrcmp(ev,"WSEV_VALUE_CH")){
     return  WSEV_VALUE_CH;
  }else
  if (!WSGFstrcmp(ev,"WSEV_EXPOSE")){
     return WSEV_EXPOSE;
  }else
  if (!WSGFstrcmp(ev,"WSEV_RESIZE")){
     return WSEV_RESIZE;
  }else
  if (!WSGFstrcmp(ev,"WSEV_FOCUS_CH")){
     return WSEV_FOCUS_CH;
  }else
  if (!WSGFstrcmp(ev,"WSEV_MOUSE_IN")){
     return WSEV_MOUSE_IN;
  }else
  if (!WSGFstrcmp(ev,"WSEV_MOUSE_OUT")){
     return WSEV_MOUSE_OUT;
  }else
  if (!WSGFstrcmp(ev,"WSEV_MOUSE_PRESS")){
     return WSEV_MOUSE_PRESS;
  }else
  if (!WSGFstrcmp(ev,"WSEV_MOUUSE_RELEASE")){
     return WSEV_MOUSE_RELEASE;
  }else
  if (!WSGFstrcmp(ev,"WSEV_MOUSE_MOVE")){
     return WSEV_MOUSE_MOVE;
  }else
  if (!WSGFstrcmp(ev,"WSEV_MOUSE_DOUBLE_CLICK")){
     return WSEV_MOUSE_DOUBLE_CLICK;
  }else
  if (!WSGFstrcmp(ev,"WSEV_INITIALIZE")){
     return WSEV_INITIALIZE;
  }else
  if (!WSGFstrcmp(ev,"WSEV_VISIBLE_CH")){
     return WSEV_VISIBLE_CH;
  }else
  if (!WSGFstrcmp(ev,"WSEV_SENSITIVE_CH")){
     return WSEV_SENSITIVE_CH;
  }else
  if (!WSGFstrcmp(ev,"WSEV_PARENT_VISIBLE_CH")){
     return WSEV_PARENT_VISIBLE_CH;
  }else
  if (!WSGFstrcmp(ev,"WSEV_PARENT_SENSITIVE_CH")){
     return WSEV_PARENT_SENSITIVE_CH;
  }else
  if (!WSGFstrcmp(ev,"WSEV_KEY_PRESS")){
     return WSEV_KEY_PRESS;
  }else
  if (!WSGFstrcmp(ev,"WSEV_KEY_RELEASE")){
     return WSEV_KEY_RELEASE;
  }else
  if (!WSGFstrcmp(ev,"WSEV_KEY_HOOK")){
     return WSEV_KEY_HOOK;
  }
  return WSEV_NONE;
}

void WSGFdrawArrow(WSDdev* dev,WSCbool fill,
                   WSCushort st,short bg_no,
                   short ts_no,short bs_no,char direction,
                   short x,short y,WSCushort w,WSCushort h ){

    WSCpoint pts[6];
    if (direction == WS_LEFT){
      if (fill == False){
        pts[0].setPoint( x,      y+h/2 );
        pts[1].setPoint( x +w,   y  );
        pts[2].setPoint( x +w,   y+h );
        dev->setForeColor(bg_no);
        dev->drawFillPoly(pts,3);

        pts[0].setPoint( x,      y + h/2 );
        pts[1].setPoint( x+st,   y + h/2 );
        pts[2].setPoint( x+w-st/2, y + st*173/200  );
        pts[3].setPoint( x+w,    y       );
        dev->setForeColor(ts_no);
        dev->drawFillPoly(pts,4);

        pts[0].setPoint( x,      y + h/2 );
        pts[1].setPoint( x+st,   y + h/2 );
        pts[2].setPoint( x+w-st/2, y + h -st*173/200 );
        pts[3].setPoint( x+w-st/2, y + st*173/200  );
        pts[4].setPoint( x+w,    y       );
        pts[5].setPoint( x+w,    y + h   );
        dev->setForeColor(bs_no);
        dev->drawFillPoly(pts,6);
      }else{
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          pts[0].setPoint( x,   y +w/2  );
          pts[1].setPoint( x+w, y       );
          pts[2].setPoint( x+w, y + h   );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pts[0].setPoint( x+w/4,   y +w/2  );
          pts[1].setPoint( x+w*3/4, y       );
          pts[2].setPoint( x+w*3/4, y + h   );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }
      }
    }else if (direction == WS_RIGHT){

      if (fill == False){
        pts[0].setPoint( x,      y );
        pts[1].setPoint( x +w,   y+h/2  );
        pts[2].setPoint( x,   y+h );
        dev->setForeColor(bg_no);
        dev->drawFillPoly(pts,3);

        pts[0].setPoint( x,      y + h   );
        pts[1].setPoint( x,      y       );
        pts[2].setPoint( x+w,    y + h/2 );
        pts[3].setPoint( x+w-st, y + h/2 );
        pts[4].setPoint( x+st/2,   y + st*173/200  );
        pts[5].setPoint( x+st/2,   y +h -st*173/200);
        dev->setForeColor(ts_no);
        dev->drawFillPoly(pts,6);

        pts[0].setPoint( x,      y + h   );
        pts[1].setPoint( x+w,    y + h/2 );
        pts[2].setPoint( x+w-st, y + h/2 );
        pts[3].setPoint( x+st/2,   y +h -st*173/200);
        dev->setForeColor(bs_no);
        dev->drawFillPoly(pts,4);
      }else{
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          pts[0].setPoint( x,   y      );
          pts[1].setPoint( x+w, y +h/2 );
          pts[2].setPoint( x,   y + h  );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pts[0].setPoint( x+w/4,   y      );
          pts[1].setPoint( x+w*3/4, y +h/2 );
          pts[2].setPoint( x+w/4,   y + h  );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }
      }
    }else if (direction == WS_UP){

      if (fill == False){
        pts[0].setPoint( x +w/2,      y );
        pts[1].setPoint( x ,   y+h  );
        pts[2].setPoint( x +w,   y+h );
        dev->setForeColor(bg_no);
        dev->drawFillPoly(pts,3);

        pts[0].setPoint( x,      y + h   );
        pts[1].setPoint( x +w/2, y       );
        pts[2].setPoint( x +w/2, y + st  );
        pts[3].setPoint( x + st*173/200, y +h -st/2);
        dev->setForeColor(ts_no);
        dev->drawFillPoly(pts,4);

        pts[0].setPoint( x,      y + h   );
        pts[1].setPoint( x +w, y + h   );
        pts[2].setPoint( x +w/2, y       );
        pts[3].setPoint( x + w/2,  y + st  );
        pts[4].setPoint( x +w-st*173/200,y+h-st/2  );
        pts[5].setPoint( x + st*173/200, y+h-st/2  );
        dev->setForeColor(bs_no);
        dev->drawFillPoly(pts,6);
      }else{

        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          pts[0].setPoint( x +w/2, y     );
          pts[1].setPoint( x+w,    y +h  );
          pts[2].setPoint( x,      y + h );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pts[0].setPoint( x +w/2, y +h/4   );
          pts[1].setPoint( x+w,    y +h*3/4+1  );
          pts[2].setPoint( x,      y +h*3/4+1 );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }
      }
 
    }else if (direction == WS_DOWN){

      if (fill == False){
        pts[0].setPoint( x ,      y );
        pts[1].setPoint( x +w,   y  );
        pts[2].setPoint( x +w/2,   y+h );
        dev->setForeColor(bg_no);
        dev->drawFillPoly(pts,3);

        pts[0].setPoint( x +w/2, y + h   );
        pts[1].setPoint( x,      y       );
        pts[2].setPoint( x + w,  y       );
        pts[3].setPoint( x+w-st*173/200, y+st/2  );
        pts[4].setPoint( x+st*173/200,   y+st/2  );
        pts[5].setPoint( x +w/2, y+h-st  );
        dev->setForeColor(ts_no);
        dev->drawFillPoly(pts,6);

        pts[0].setPoint( x +w/2, y + h   );
        pts[1].setPoint( x + w,  y       );
        pts[2].setPoint( x+w-st*173/200, y+st/2  );
        pts[3].setPoint( x +w/2, y+h-st  );
        dev->setForeColor(bs_no);
        dev->drawFillPoly(pts,4);
      }else{

        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          pts[0].setPoint( x, y  );
          pts[1].setPoint( x + w, y );
          pts[2].setPoint( x + w / 2, y + h );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pts[0].setPoint( x, y +h/4  );
          pts[1].setPoint( x + w, y +h/4 );
          pts[2].setPoint( x + w / 2, y + h*3/4 );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }
      }
    }
}

void WSGFdrawShadow(WSDdev* dev,char shadow_type,WSCushort st,
                    short fg_no,short ts_no,short bs_no,short bg_no,
                    short x,short y,WSCushort w,WSCushort h,WSCbool nodark){
    if (st * 2 > w){
      st = w / 2;
    }
    if (st * 2 > h){
      st = h / 2;
    }
    if (st == 0){
      return;
    }
    dev->setLineDashType(0);
    if (shadow_type == WS_SHADOW_IN || shadow_type == WS_SHADOW_OUT){
      if (st == 1){
        if (shadow_type == WS_SHADOW_OUT){
          dev->setForeColor(bs_no);
        }else{
          dev->setForeColor(ts_no);
        }
        dev->drawFillRect(x + w - st,y,st,h);
        dev->drawFillRect(x,y + h - st,w,st);
  
        if (shadow_type == WS_SHADOW_OUT){
          dev->setForeColor(ts_no);
        }else{
          dev->setForeColor(bs_no);
        }
        dev->drawFillRect(x,y,st,h);
        dev->drawFillRect(x,y,w,st);
        return;
      }else if (st == 2){
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          short dbsc = WSGIappColorSet()->getDefaultColorNo(WS_DF_DARKBOTTOMSHADOWCOLOR);
          if (shadow_type == WS_SHADOW_OUT){
            dev->setForeColor(bg_no);
            dev->drawFillRect(x,y,1,h);
            dev->drawFillRect(x,y,w,1);
            dev->setForeColor(ts_no);
            dev->drawFillRect(x+1,y+1,1,h-1);
            dev->drawFillRect(x+1,y+1,w-1,1);

            dev->setForeColor(bs_no);
            dev->drawFillRect(x + w -2,y +2, 1,h -2);
            dev->drawFillRect(x + 2, y + h -2, w -2, 1);
            if (nodark == False){
              dev->setForeColor(dbsc);
            }
            dev->drawFillRect(x + w -1, y +1, 1, h -1);
            dev->drawFillRect(x +1, y + h -1, w -1,1);
          }else{
            dev->setForeColor(bs_no);
            dev->drawFillRect(x,y,1,h);
            dev->drawFillRect(x,y,w,1);
            if (nodark == False){
              dev->setForeColor(dbsc);
            }
            dev->drawFillRect(x+1,y+1,1,h-1);
            dev->drawFillRect(x,y+1,w-1,1);

            dev->setForeColor(bg_no);
            dev->drawFillRect(x + w -2,y +2, 1,h -2);
            dev->drawFillRect(x +2, y + h -2, w -2, 1);
            dev->setForeColor(ts_no);
            dev->drawFillRect(x + w -1, y +1, 1, h -1);
            dev->drawFillRect(x +1,y + h -1,w -1,1);
          }
  
        }else{
          if (shadow_type == WS_SHADOW_OUT){
            dev->setForeColor(ts_no);
            dev->drawFillRect(x,y,st,h);
            dev->drawFillRect(x,y,w,st);

            dev->setForeColor(bs_no);
            dev->drawFillRect(x + w - st,y + st, st / 2,h - st);
            dev->drawFillRect(x + st, y + h - st, w - st, st / 2);
            dev->drawFillRect(x + w - st / 2, y + st / 2, st / 2, h - st / 2);
            dev->drawFillRect(x + st / 2,y + h - st / 2,w - st / 2,st / 2);
          }else{
            dev->setForeColor(bs_no);
            dev->drawFillRect(x,y,st,h);
            dev->drawFillRect(x,y,w,st);

            dev->setForeColor(ts_no);
            dev->drawFillRect(x + w - st,y + st, st / 2,h - st);
            dev->drawFillRect(x + st, y + h - st, w - st, st / 2);
            dev->drawFillRect(x + w - st / 2, y + st / 2, st / 2, h - st / 2);
            dev->drawFillRect(x + st / 2,y + h - st / 2,w - st / 2,st / 2);
          }
  
        } 
        return;
 
      }

      if (shadow_type == WS_SHADOW_OUT){
        dev->setForeColor(ts_no);
      }else{
        dev->setForeColor(bs_no);
      }

      dev->drawFillRect(x,y,st,h);
      dev->drawFillRect(x,y,w,st);
      short dbsc = 0;
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        dbsc = WSGIappColorSet()->getDefaultColorNo(WS_DF_DARKBOTTOMSHADOWCOLOR);
        if (shadow_type == WS_SHADOW_OUT){
          dev->setForeColor(bg_no);
          dev->drawFillRect(x,y,1,h);
          dev->drawFillRect(x,y,w,1);
        }else{
          if (nodark == False){
            dev->setForeColor(dbsc);
            dev->drawFillRect(x+st-1,y+st-1,1,h-st);
            dev->drawFillRect(x+st-1,y+st-1,w-st,1);
          }
        }
      }
      WSCpoint* pts = new WSCpoint[6];
      pts[0].setPoint( x,  y + h );
      pts[1].setPoint( x + w,y + h);
      pts[2].setPoint( x + w,y);
      pts[3].setPoint( x + w - st, y + st );
      pts[4].setPoint( x + w - st, y + h - st);
      pts[5].setPoint( x +st,y + h - st);

      if (shadow_type == WS_SHADOW_OUT){
        dev->setForeColor(bs_no);
      }else{
        dev->setForeColor(ts_no);
      }
      dev->drawFillPoly(pts,6);
      delete pts;
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        if (shadow_type == WS_SHADOW_OUT){
          if (nodark == False){
            dev->setForeColor(dbsc);
            dev->drawFillRect(x + w-1, y +1, 1, h -1);
            dev->drawFillRect(x +1, y + h-1, w -1,1);
          }
        }else{
          dev->setForeColor(bg_no);
          dev->drawFillRect(x + w -st, y +st, 1, h -st*2+1);
          dev->drawFillRect(x +st, y + h -st, w -st*2+1,1);
        }
      }
    }else if (shadow_type == WS_SHADOW_EIN || shadow_type == WS_SHADOW_EOUT){
      long st2 = st /2;
      if (st2 <1){
        st2 = 1;
      }

      if (st2 == 1){
        if (shadow_type == WS_SHADOW_EOUT){
          dev->setForeColor(ts_no);
        }else{
          dev->setForeColor(bs_no);
        }

        dev->setLineWidth(1);
        dev->drawRect(x,y,w,h);
        dev->drawRect(x,y, w-st2, h-st2);

        if (shadow_type == WS_SHADOW_EOUT){
          dev->setForeColor(bs_no);
        }else{
          dev->setForeColor(ts_no);
        }

        dev->drawRect(x+st2,y+st2,
                      w-st2, h-st2);
        return;
      }

      WSCpoint* pts = new WSCpoint[6];

      if (shadow_type == WS_SHADOW_EOUT){
        dev->setForeColor(ts_no);
      }else{
        dev->setForeColor(bs_no);
      }
      dev->drawFillRect(x,y,st2,h);
      dev->drawFillRect(x,y,w,st2);
      dev->drawFillRect(x + w - st,y,st2,h);
      dev->drawFillRect(x,y + h - st,w,st2);

      if (shadow_type == WS_SHADOW_EOUT){
        dev->setForeColor(bs_no);
      }else{
        dev->setForeColor(ts_no);
      }

      pts[0].setPoint( x + w,y);
      pts[1].setPoint( x + w,y + h);
      pts[2].setPoint( x,y + h );
      pts[3].setPoint( x + st2,y +h - st2);
      pts[4].setPoint( x + w - st2,y + h - st2);
      pts[5].setPoint( x + w - st2,y + st2);
      dev->drawFillPoly(pts,6);

      pts[0].setPoint( x + st2,y + st2);
      pts[1].setPoint( x + w - st2, y + st2);
      pts[2].setPoint( x + w - st,y +st );
      pts[3].setPoint( x + st,y + st );
      pts[4].setPoint( x + st,y + h - st);
      pts[5].setPoint( x + st2,y + h - st2);
      dev->drawFillPoly(pts,6);

      delete pts;
    }else if (shadow_type == WS_SHADOW_BORDER){
      dev->setForeColor(fg_no);
      dev->drawFillRect(x,y,st,h);
      dev->drawFillRect(x,y,w,st);
      dev->drawFillRect(x +w - st,y,st,h);
      dev->drawFillRect(x,y +h - st,w,st);
    }

  return;

}
void WSGFdrawBtnShadow(WSDdev* dev,char shadow_type,WSCushort st,
                    short fg_no,short ts_no,short bs_no,short bg_no,
                    short x,short y,WSCushort w,WSCushort h,WSCbool nodark){
    
    if (st * 2 > w){
      st = w / 2;
    }
    if (st * 2 > h){
      st = h / 2;
    }
    if (st == 0){
      return;
    }

    if (shadow_type == WS_SHADOW_OUT){
      if (st == 1){
        dev->setForeColor(bs_no);
        dev->drawFillRect(x + w - st,y,st,h);
        dev->drawFillRect(x,y + h - st,w,st);
  
        dev->setForeColor(ts_no);
        dev->drawFillRect(x,y,st,h);
        dev->drawFillRect(x,y,w,st);
        return;
      }else if (st == 2){
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          short dbsc = WSGIappColorSet()->getDefaultColorNo(WS_DF_DARKBOTTOMSHADOWCOLOR);
          dev->setForeColor(ts_no);
          dev->drawFillRect(x,y,1,h);
          dev->drawFillRect(x,y,w,1);

          dev->setForeColor(bs_no);
          dev->drawFillRect(x + w -2,y +2, 1,h -2);
          dev->drawFillRect(x + 2, y + h -2, w -2, 1);
          if (nodark == False){
            dev->setForeColor(dbsc);
          }
          dev->drawFillRect(x + w -1, y +1, 1, h -1);
          dev->drawFillRect(x +1, y + h -1, w -1,1);
  
        }else{
          dev->setForeColor(ts_no);
          dev->drawFillRect(x,y,st,h);
          dev->drawFillRect(x,y,w,st);

          dev->setForeColor(bs_no);
          dev->drawFillRect(x + w - st,y + st, st / 2,h - st);
          dev->drawFillRect(x + st, y + h - st, w - st, st / 2);
          dev->drawFillRect(x + w - st / 2, y + st / 2, st / 2, h - st / 2);
          dev->drawFillRect(x + st / 2,y + h - st / 2,w - st / 2,st / 2);
        } 
        return;
 
      }

      dev->setForeColor(ts_no);
      dev->drawFillRect(x,y,st-1,h);
      dev->drawFillRect(x,y,w,st-1);

      short dbsc = 0;
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        dbsc = WSGIappColorSet()->getDefaultColorNo(WS_DF_DARKBOTTOMSHADOWCOLOR);
      }
      WSCpoint* pts = new WSCpoint[6];
      pts[0].setPoint( x,  y + h );
      pts[1].setPoint( x + w,y + h);
      pts[2].setPoint( x + w,y);
      pts[3].setPoint( x + w - st, y + st );
      pts[4].setPoint( x + w - st, y + h - st);
      pts[5].setPoint( x +st,y + h - st);

      dev->setForeColor(bs_no);
      dev->drawFillPoly(pts,6);
      delete pts;
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        if (nodark == False){
          dev->setForeColor(dbsc);
          dev->drawFillRect(x + w -1, y +1, 1, h -1);
          dev->drawFillRect(x +1, y + h -1, w -1,1);
        }
      }
    }else{
      WSGFdrawShadow(dev,shadow_type,st,
                     fg_no, ts_no, bs_no, bg_no,
                     x, y, w, h, nodark);
    }
  return;

}

long WSGFmaskBitToEvent(WSCulong bit){
   switch(bit){
     case   WSEV_NONE_BIT:          return  WSEV_NONE;
     case   WSEV_MOUSE_MOVE_BIT:    return  WSEV_MOUSE_MOVE;
     case   WSEV_MOUSE_IN_BIT:      return  WSEV_MOUSE_IN;
     case   WSEV_MOUSE_OUT_BIT:     return  WSEV_MOUSE_OUT;
     case   WSEV_MOUSE_PRESS_BIT:   return  WSEV_MOUSE_PRESS;
     case   WSEV_MOUSE_RELEASE_BIT: return  WSEV_MOUSE_RELEASE;
     case   WSEV_ACTIVATE_BIT:      return  WSEV_ACTIVATE;
     case   WSEV_VALUE_CH_BIT:      return  WSEV_VALUE_CH;
     case   WSEV_EXPOSE_BIT:        return  WSEV_EXPOSE;
     case   WSEV_RESIZE_BIT:        return  WSEV_RESIZE;
     case   WSEV_FOCUS_CH_BIT:      return  WSEV_FOCUS_CH;
     case   WSEV_INITIALIZE_BIT:    return  WSEV_INITIALIZE;
     case   WSEV_VISIBLE_CH_BIT:    return  WSEV_VISIBLE_CH;
     case   WSEV_KEY_PRESS_BIT:     return  WSEV_KEY_PRESS;
     case   WSEV_KEY_RELEASE_BIT:   return  WSEV_KEY_RELEASE;
     case   WSEV_KEY_HOOK_BIT:      return  WSEV_KEY_HOOK;
   }
   return WSEV_NONE;
}

char* WSGFcreateEucStringFromJisStr(char *buf){
   long i;
   long fl = 0;
static  char output[2048]; 
   i = 0;

   long max = strlen(buf) +1;
   long p =0;
   while(p<max && p < 1000){
     if (*buf == 0){
        output[i] = 0;
        break;
     }
     char jish[4];
     char jist[5];
     char jist2[4];
     jish[0] = 0x1b;
     jish[1] = ')';
     jish[2] = 'I';
     jish[3] = 0;

     jist[0] = 0x1b;
     jist[1] = '$';
     jist[2] = ')';
     jist[3] = 'B';
     jist[4] = 0;

     jist2[0] = 0x1b;
     jist2[1] = '(';
     jist2[2] = 'B';
     jist2[3] = 0;

     if (!strncmp(jish,buf,3)){
         buf = buf +3;;
         output[i] = 0x8e;
         i++;
         output[i] = *buf;
         buf++;
         p++;
         i++;
         fl = 1;//hankaku kana mode
     }else if(!strncmp(jist,buf,4)){
         buf = buf +4;
         output[i] = *buf;
         buf++;
         p++;
         i++;
         output[i] = *buf;
         buf++;
         p++;
         i++;
         fl = 2;//kanji mode
     }else if(!strncmp(jist2,buf,3)){
         buf = buf +3;
         output[i] = *buf;
         buf++;
         p++;
         i++;
         fl = 0;//ascii mode
     }else{
       if (!(*buf & 0x80) && (*buf >= 0x20)){
         output[i] = *buf;
         i++;
         buf++;
         p++;
       }else if (fl == 1){ //hankaku kana mode
         output[i] = 0x8e;
         i++;
         output[i] = *buf;
         i++;
         buf++;
         p++;
       }else if (fl == 2){ //kanji mode
         output[i] = *buf;
         i++;
         buf++;
         p++;
         output[i] = *buf;
         i++;
         buf++;
         p++;
       }else{
         buf++;
         p++;
       }
     }
   }
   output[i] = 0;
   return output;
}


#ifndef MSW

#ifdef DS
extern "C"{
  extern int gettimeofday(struct timeval *tv, struct timezone *tz);
}
#endif

long WSGFclocktime(){
  struct timeval  _tmvl;
  struct timezone _tzp;
  gettimeofday( &_tmvl, &_tzp ) ;
  struct tm* _tm;
  time_t val = _tmvl.tv_sec;
  _tm = localtime( &val ) ;
  _tm->tm_year = _tm->tm_year + 1900;
  _tm->tm_mon = _tm->tm_mon + 1;
  return ( _tm->tm_hour*1000*60*60 + _tm->tm_min*1000*60 +
           _tm->tm_sec*1000 + _tmvl.tv_usec / 1000);
}

void WSGFtimetrace(){
  struct timeval  _tmvl;
  struct timezone _tzp;
  gettimeofday( &_tmvl, &_tzp ) ;
  struct tm* _tm;
  time_t val = _tmvl.tv_sec;
  _tm = localtime( &val ) ;
  _tm->tm_year = _tm->tm_year + 1900;
  _tm->tm_mon = _tm->tm_mon + 1;
WSMFtrace("%2d:%2d:%2d %dmsec\n",_tm->tm_hour,_tm->tm_min,_tm->tm_sec,_tmvl.tv_usec);
}

static  struct timeval  _dr_tmvl;
static  struct timezone _dr_tzp;
void WSGFsetTimePoint(){
  gettimeofday( &_dr_tmvl, &_dr_tzp ) ;
}

long WSGFdiffTimePoint(){
  struct timeval  _tmvl;
  struct timezone _tzp;
  gettimeofday( &_tmvl, &_tzp ) ;
  long diff = (_tmvl.tv_sec - _dr_tmvl.tv_sec) * 1000000;
  if (diff < 0){
     diff += 60000000;
  }

  diff +=  _tmvl.tv_usec - _dr_tmvl.tv_usec;
  return diff;
}
#else

long WSGFclocktime(){
  SYSTEMTIME st;
  GetLocalTime(&st);
//WSMFtrace("WSGFclocktime %d\n", st.wMinute* 1000 * 60 + st.wSecond * 1000 + st.wMilliseconds);
  return ( st.wHour* 1000 * 60 * 60
         + st.wMinute* 1000 * 60
         + st.wSecond * 1000
         + st.wMilliseconds);
}

void WSGFtimetrace(){
  SYSTEMTIME st;
  GetLocalTime(&st);
WSMFtrace("%2d:%2d:%2d %dmsec\n",st.wHour,st.wMinute,st.wSecond,st.wMilliseconds);
  printf(" <do not implement yet.>\n");
}
static SYSTEMTIME _dr_st;
void WSGFsetTimePoint(){
  GetLocalTime(&_dr_st);
}
long WSGFdiffTimePoint(){
  SYSTEMTIME st;
  GetLocalTime(&st);
  long diff = (st.wMinute - _dr_st.wMinute) * 1000000;
  if (diff < 0){
     diff += 60000000;
  }
  diff += st.wMinute * 1000 - _dr_st.wMinute * 1000;
//WSMFtrace("WScom.cpp: WSGFdiffTimePoint\n");
  return diff;
}
#endif

WSCbool IsLeap(long year){
  return ((year) %4 == 0 && ((year) % 100 != 0 || (year) % 400 == 0));
}


long days[] = {31,28,31,30,31,30,31,31,30,31,30,31};
long WSgetwday(long *data){
  long i;
  long year;
  long month;
  long totaldays;
  long wday;

  year = data[0];
  month = data[1] -1;
  totaldays = 0;

  if (year >= 1900){
    year = year - 1900;
  } 

  for(i=0 ; i < year; i++){
    totaldays += (365 + IsLeap(i+1900));
  } 
  for(i=0 ; i < month; i++){
    totaldays += days[i];
    if (i == 1){
      if (IsLeap(year+1900)) totaldays += 1;
    }
  }
  totaldays +=  data[2] -1;
  wday = totaldays%7;
  return wday;  
}

void WSGFgettimeofday(long* tv){
#ifndef MSW
  struct timeval  _tmvl;
  struct timezone _tzp;
  struct tm*      _tm;

  gettimeofday( &_tmvl, &_tzp ) ;
  time_t val = _tmvl.tv_sec;
  _tm = localtime( &val ) ;
  _tm->tm_year = _tm->tm_year + 1900;
  _tm->tm_mon = _tm->tm_mon + 1;

  tv[0] = _tm->tm_year;
  tv[1] = _tm->tm_mon;
  tv[2] = _tm->tm_mday;
  tv[3] = _tm->tm_hour;
  tv[4] = _tm->tm_min;
  tv[5] = _tm->tm_sec;
  tv[6] = _tm->tm_wday;
#else
  SYSTEMTIME st;
  GetLocalTime(&st);
  tv[0] = st.wYear;
  tv[1] = st.wMonth;
  tv[2] = st.wDay;
  tv[3] = st.wHour;
  tv[4] = st.wMinute;
  tv[5] = st.wSecond;
  tv[6] = st.wDayOfWeek;
#endif
#if defined (BTRON)  || defined (TE)
  W tim;
  DATE_TIM tm;
  TIMEZONE tz;
  
  get_tim(&tim,&tz);
  if ( tz.adjust){
    get_tod(&tm,tim,(Bool)1);
  }else{
    get_tod(&tm,tim,(Bool)0);
  }
  tv[0] = tm.d_year + 1900;
  tv[1] = tm.d_month;
  tv[2] = tm.d_day;
  tv[3] = tm.d_hour;
  tv[4] = tm.d_min;
  tv[5] = tm.d_sec;
  tv[6] = tm.d_wday;
#endif /* BTRON */
}

void WSGFsetMargin(WSCbase* obj,WSCushort val){
  obj->setPropertyV(WSNmarginTop,(WSCuchar)val);
  obj->setPropertyV(WSNmarginBottom,(WSCuchar)val);
  obj->setPropertyV(WSNmarginRight,(WSCuchar)val);
  obj->setPropertyV(WSNmarginLeft,(WSCuchar)val);
}

long WSGFstrlenUCS2(WSCushort* str){
  if (str == NULL){
    return 0;
  }
  long i = 0;
  while(str[i]){
    i++;
  } 
  return i;
}
void WSGFcreateVerticalString(WSCstring* str){
  WSCushort* text = WSGFgetUCS2(str->getString(),WS_EN_DEFAULT);
  long len = WSGFstrlenUCS2(text)+1;
  long i;
  WSCushort* tmp = new WSCushort[len*2];
  for(i=0; i<len; i++){
    tmp[i*2] = text[i];
    tmp[i*2+1] = (WSCushort)'\n';
  }
  char* tmp2 = WSGFgetString(tmp,WS_EN_DEFAULT);
  delete tmp;
  str->setString(tmp2);
  delete tmp2;
  return;
}

WSCstring WSGFgetFileName(char* path){
  WSCstring tmp(path);
  tmp.delHeadSpace();
  tmp.delTailSpace();

  char* sep ="/";
#ifdef MSW
  tmp.replaceString("\\","/",0);
#endif
  long num = tmp.getWords(sep);

  if (num == 1){
#ifndef MSW
    return tmp;
#else
    char* sep =":";
    long num = tmp.getWords(sep);
    if (num == 1){
      return tmp;
    }
    WSCstring filename = tmp.getWord(num -1,sep);
    return filename;
#endif
  } 

  WSCstring filename = tmp.getWord(num-1,sep);
  return filename;
}

WSCstring WSGFgetDirName(char* path){
  WSCstring tmp(path);
  tmp.delHeadSpace();
  tmp.delTailSpace();

#ifndef MSW
  char* sep ="/";
#else
  char* sep ="/";
  tmp.replaceString("\\","/",0);
#endif
  long num = tmp.getWords(sep);

  if (num == 1){
    return ".";
  } 

  long pos = tmp.getWordCharPos(num-1,sep);
  if (pos > 0){
    tmp.cutString(pos-1);
  }else{
    tmp.cutString(pos);
  }
  return tmp;
}

long WSGFloadWindow(char* stype,char* fname,WSCbase** btarget,WSCbase* parent){
  WSDserialize* db = WSGIconductor()->beginTransaction(stype,fname);
  if (db == NULL){
    return WS_ERR;
  }
  long ret = WSGIconductor()->loadGUI(db,btarget,parent);
  long ret2 = WSGIconductor()->endTransaction(db);
  if (ret != WS_NO_ERR){
    return ret;
  }
  return ret2;
}

long WSGFsaveWindow(char* stype,char* fname,WSCbase* btarget){
  WSDserialize* db = WSGIconductor()->beginTransaction(stype,fname);
  if (db == NULL){
    return WS_ERR;
  }
  WSGIconductor()->saveGUI(db,btarget->getInstanceName(),btarget);
  return WSGIconductor()->endTransaction(db);
}

long WSGFdestroyWindow(WSCbase* btarget){
  if (btarget == NULL){
    return WS_NO_ERR;
  }
  delete btarget;
  return WS_NO_ERR;
}
long WSGFgetLines(char* str){
  long cnt = 1;
  if (str == NULL){
    return cnt;
  }
  long i;
  long num=strlen(str);
  for(i=0; i< num; i++){
    if (str[i] == '\n'){
      cnt++;
    }
  }
  return cnt;
}
void WSGFdelTailSpaceUCS2(WSCushort* str){
  long len=WSGFstrlenUCS2(str);
  long i;
  for(i=len-1; i > -1; i--){
    if (str[i] == (WSCushort)' '){
      str[i] = 0;
      continue;
    }
    break;
  }
}
WSCushort* WSGFreplaceStringUCS2(WSCushort* str,WSCushort* src,WSCushort* dest,long *num){
  long len = WSGFstrlenUCS2(str);
  long slen = WSGFstrlenUCS2(src);
  long dlen = WSGFstrlenUCS2(dest);
  long i;

  if (*num < 1){
    *num = 65535*32767;
  }
  long cnum = 0;
  WSCbool fl = False;
  for(i=0; i<len; i++){
    if (str[i] == src[0] && !memcmp(&str[i],src,slen*sizeof(WSCushort))){
      cnum++;
      if (cnum <= *num){
        fl = True;
        i += slen -1;
      }
    }
  }
  if (fl == False){
    WSCushort* ret = new WSCushort[len+1];
    memcpy(ret,str,(len+1)*sizeof(WSCushort));
    *num = 0;
    return ret;
  }
  long newlen = len + cnum* (dlen - slen);
  WSCushort* ret = new WSCushort[newlen+1];
  cnum = 0;
  long cnt = 0;
  long count = 0;
  for(i=0; i<len; i++){
    if (str[i] == src[0] && !memcmp(&str[i],src,slen*sizeof(WSCushort))){
      cnum++;
      if (cnum <= *num){
        memcpy(&ret[cnt],dest,dlen*sizeof(WSCushort));
        cnt+=dlen;
        i+= slen -1;
      }
    }else{
      ret[cnt] = str[i];
      cnt++;
    } 
  } 
  ret[cnt] =0;
  *num = count;
  return ret;
}
long WSGFdelLineFeedUCS2(WSCushort* str){
  long len = WSGFstrlenUCS2(str);
  long i;
  long cnt = 0;
  long count = 0;
  for(i=0; i<len; i++){
    if (str[i] == (WSCushort)'\n'){
      count++;
      continue;
    }
    str[cnt] = str[i];
    cnt++;
  }
  str[cnt] =0;
  return count;
}
WSCushort* WSGFstrdupUCS2(WSCushort* str){
  if (str == NULL){
    WSCushort* ret = new WSCushort[1];
    ret[0] =0;
    return ret;
  }
  long len = WSGFstrlenUCS2(str);
  WSCushort* ret = new WSCushort[len+1];
  memcpy(ret,str,(len+1)*sizeof(WSCushort));
  return ret;
}
WSCushort* WSGFaddStringUCS2(WSCushort* str1,WSCushort* str2){
  long len1 = WSGFstrlenUCS2(str1);
  long len2 = WSGFstrlenUCS2(str2);
  WSCushort* ret = new WSCushort[len1+len2+1];
  memcpy(ret,str1,len1*sizeof(WSCushort));
  memcpy(&ret[len1],str2,len2*sizeof(WSCushort));
  ret[len1+len2] = 0;
  return ret;
}
WSCushort* WSGFgetWordUCS2(WSCushort* istr,long pos,WSCushort* sep){
  long len = WSGFstrlenUCS2(istr);
  long seplen = WSGFstrlenUCS2(sep);
  if (seplen < 1){
    WSCushort* ret = new WSCushort[1];
    ret[0] = 0;
    return ret;
  }
  long i;
  long cnt = 0;
  long hit_point=0;
  for(i=0; i< len+1; i++){
    if (istr[i] == sep[0] && !memcmp(&istr[i],sep,(size_t)seplen*sizeof(WSCushort))){
      if (cnt == pos){
        long length = i +1 -hit_point;
        WSCushort* ret = new WSCushort[length];
        memcpy(ret,&istr[hit_point],(size_t)(i-hit_point)*sizeof(WSCushort));
        ret[length-1] =0;
        return ret;
      }
      cnt++;
      hit_point = i + seplen;
      i += seplen -1;
    }
  }
  if (cnt == pos){
    long length = i +1 -hit_point;
    WSCushort* ret = new WSCushort[length];
    memcpy(ret,&istr[hit_point],(size_t)(i-hit_point)*sizeof(WSCushort));
    ret[length-1] =0;
    return ret;
  }
  WSCushort* ret = new WSCushort[1];
  ret[0] = 0;
  return ret;
}
long WSGFgetWordCharPosUCS2(WSCushort* istr,long pos,WSCushort* sep){
  long len = WSGFstrlenUCS2(istr);
  long seplen = WSGFstrlenUCS2(sep);
  if (seplen < 1){
#if 0
    WSCushort* ret = new WSCushort[1];
    ret[0] = 0;
    return ret;
#endif
    return -1;
  }
  if (pos == 0){
    return 0;
  }
  long i;
  long cnt = 1;
//  long hit_point=0;
  for(i=0; i< len+1; i++){
    if (istr[i] == sep[0] && !memcmp(&istr[i],sep,(size_t)seplen*sizeof(WSCushort))){
      if (cnt == pos){
        return i+seplen;
#if 0
        long length = i +1 -hit_point;
        WSCushort* ret = new WSCushort[length];
        memcpy(ret,&istr[hit_point],(size_t)(i-hit_point)*sizeof(WSCushort));
        ret[length-1] =0;
        return ret;
#endif
      }
      cnt++;
//      hit_point = i + seplen;
      i += seplen -1;
    }
  }
  return -1;
#if 0
  if (cnt == pos){
    long length = i +1 -hit_point;
    WSCushort* ret = new WSCushort[length];
    memcpy(ret,&istr[hit_point],(size_t)(i-hit_point)*sizeof(WSCushort));
    ret[length-1] =0;
    return ret;
  }
  WSCushort* ret = new WSCushort[1];
  ret[0] = 0;
  return ret;
#endif
}
long _lang = 0;
void WSGFsetLangVal(long lang){
  _lang = lang;
}
char* WSGFgetLocaleName(long locale){
  switch(locale){
    case WS_EN_DEFAULT:
        return WSGFgetLocaleName(WSGIappCodeConvert()->getSystemLocale());
    case WS_EN_LOCALE:
        return WSN_EN_ISO8859_1;
    case WS_EN_ISO8859_1:
        return WSN_EN_ISO8859_1;
    case WS_EN_ISO8859_2:
        return WSN_EN_ISO8859_2;
    case WS_EN_ISO8859_3:
        return WSN_EN_ISO8859_3;
    case WS_EN_ISO8859_4:
        return WSN_EN_ISO8859_4;
    case WS_EN_ISO8859_5:
        return WSN_EN_ISO8859_5;
    case WS_EN_ISO8859_6:
        return WSN_EN_ISO8859_6;
    case WS_EN_ISO8859_7:
        return WSN_EN_ISO8859_7;
    case WS_EN_ISO8859_8:
        return WSN_EN_ISO8859_8;
    case WS_EN_ISO8859_9:
        return WSN_EN_ISO8859_9;
    case WS_EN_ISO8859_10:
        return WSN_EN_ISO8859_10;
    case WS_EN_ISO8859_11:
        return WSN_EN_ISO8859_11;
    case WS_EN_ISO8859_12:
        return WSN_EN_ISO8859_12;
    case WS_EN_ISO8859_13:
        return WSN_EN_ISO8859_13;
    case WS_EN_ISO8859_14:
        return WSN_EN_ISO8859_14;
    case WS_EN_ISO8859_15:
        return WSN_EN_ISO8859_15;
    case WS_EN_UTF8:
        if (_lang == WS_EN_LANG_JP){
          return WSN_EN_UTF8_JP;
        }
        return WSN_EN_UTF8;
    case WS_EN_KOI8R:
        return WSN_EN_KOI8R;
    case WS_EN_EUCJP:
        return WSN_EN_EUCJP;
    case WS_EN_SJIS:
        return WSN_EN_SJIS;
    case WS_EN_EUCKR:
        return WSN_EN_EUCKR;
    case WS_EN_EUCCN:
        return WSN_EN_EUCCN;
    case WS_EN_BIG5:
        return WSN_EN_BIG5;
    default:
      return WSN_EN_NONE;
  }
}
long WSGFgetLocaleValue(char* lname){
  if (!strcmp(lname,WSN_EN_LOCALE)){
    return WS_EN_LOCALE;
  }else
  if (!strcmp(lname,WSN_EN_DEFAULT)){
    return WS_EN_DEFAULT;
  }else
  if (!strcmp(lname,WSN_EN_NONE)){
    return WS_EN_NONE;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_1)){
    return WS_EN_ISO8859_1;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_2)){
    return WS_EN_ISO8859_2;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_3)){
    return WS_EN_ISO8859_3;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_4)){
    return WS_EN_ISO8859_4;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_5)){
    return WS_EN_ISO8859_5;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_6)){
    return WS_EN_ISO8859_6;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_7)){
    return WS_EN_ISO8859_7;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_8)){
    return WS_EN_ISO8859_8;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_9)){
    return WS_EN_ISO8859_9;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_10)){
    return WS_EN_ISO8859_10;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_11)){
    return WS_EN_ISO8859_11;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_12)){
    return WS_EN_ISO8859_12;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_13)){
    return WS_EN_ISO8859_13;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_14)){
    return WS_EN_ISO8859_14;
  }else
  if (!strcmp(lname,WSN_EN_ISO8859_15)){
    return WS_EN_ISO8859_15;
  }else
  if (!strcmp(lname,WSN_EN_UTF8)){
    return WS_EN_UTF8;
  }else
  if (!strcmp(lname,WSN_EN_UTF8_JP)){
    return WS_EN_UTF8;
  }else
  if (!strcmp(lname,WSN_EN_KOI8R)){
    return WS_EN_KOI8R;
  }else
  if (!strcmp(lname,WSN_EN_EUCJP)){
    return WS_EN_EUCJP;
  }else
  if (!strcmp(lname,WSN_EN_SJIS)){
    return WS_EN_SJIS;
  }else
  if (!strcmp(lname,WSN_EN_EUCKR)){
    return WS_EN_EUCKR;
  }else
  if (!strcmp(lname,WSN_EN_EUCCN)){
    return WS_EN_EUCCN;
  }else
  if (!strcmp(lname,WSN_EN_BIG5)){
    return WS_EN_BIG5;
  }else{
    return WS_EN_NONE;
  }
}
void WSGFgetShadowColor(short in,short* ts,short* bs,short* bg){
  WSDcolor* col = WSGIappColorSet()->getColor(in);
  long r,g,b;
  col->getRGB(&r,&b,&g);
  char cname[32];
  long r1,g1,b1;
  if (r > 4){
    r1 = r-4;
  }else{
    r1 = 0;
  }
  if (g > 4){
    g1 = g-4;
  }else{
    g1 = 0;
  }
  if (b > 4){
    b1 = b-4;
  }else{
    b1 = 0;
  }

  sprintf(cname,"#%02x%02x%02x",r1,g1,b1);
  *bg = WSGIappColorSet()->getColorNo(cname);
  if (r < 252){
    r1 = r+4;
  }else{
    r1 = 255;
  }
  if (g < 252){
    g1 = g+4;
  }else{
    g1 = 255;
  }
  if (b < 252){
    b1 = b+4;
  }else{
    b1 = 255;
  }
  sprintf(cname,"#%02x%02x%02x",r1,g1,b1);
  *ts = WSGIappColorSet()->getColorNo(cname);
  if (r > 8){
    r1 = r-8;
  }else{
    r1 = 0;
  }
  if (g > 8){
    g1 = g-8;
  }else{
    g1 = 0;
  }
  if (b > 8){
    b1 = b-8;
  }else{
    b1 = 0;
  }
  sprintf(cname,"#%02x%02x%02x",r1,g1,b1);
  *bs = WSGIappColorSet()->getColorNo(cname);
}
void WSGFdrawStripes(WSDdev* dev,WSCushort w,WSCushort h,short ts,short bs,short bg){
  long i;
  for(i=0; i<h; i+=6){
    dev->setForeColor(bs);
    dev->drawLine(0,i,w,i);
    dev->setForeColor(bg);
    dev->drawFillRect(0,i+1,w,2);
    dev->setForeColor(ts);
    dev->drawLine(0,i+3,w,i+3);
  }
}

WSDmwindowDev* WSGFgetAquaImage(short col,WSCushort w,WSCushort h,long no){
  WSDcolor* color = WSGIappColorSet()->getColor(col);
  WSDmwindowDev* mdev = WSDmwindowDev::getNewInstance();
  WSDmwindowDev* mdev3 = WSDmwindowDev::getNewInstance();

  mdev->createPixmap(w,h);
  mdev->beginDraw(0,0,w,h);
  if (w < h){
    WSDimage* limage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/alv.xpm");
    WSDimage* rimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/arv.xpm");
    WSDimage* mimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/amv.xpm");
    mdev->drawStretchedImage(0,0,w,h,mimage);
    mdev->drawStretchedImage(0,0,w,w/2,limage);
    mdev->drawStretchedImage(0,h-w/2,w,w/2,rimage);
  }else{
    if (no == 0){
      WSDimage* limage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/al.xpm");
      WSDimage* rimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/ar.xpm");
      WSDimage* mimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/am.xpm");
      mdev->drawStretchedImage(0,0,w,h,mimage);
      mdev->drawStretchedImage(0,0,h/2,h,limage);
      mdev->drawStretchedImage(w-h/2,0,h/2,h,rimage);
    }else{
      WSDimage* limage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/rl.xpm");
      WSDimage* rimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/rr.xpm");
      WSDimage* mimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/rm.xpm");
      mdev->drawStretchedImage(0,0,w,h,mimage);
      mdev->drawStretchedImage(0,0,h/2,h,limage);
      mdev->drawStretchedImage(w-h/2,0,h/2,h,rimage);
    }
  }
  mdev->endDraw();

  mdev3->createPixmap(w,h);
  mdev3->beginDraw(0,0,w,h);
  mdev3->setForeColor(col);
  mdev3->drawFillRect(0,0,w,h);
  mdev3->endDraw();

  mdev->initBuffer();
  mdev3->initBuffer();

  long r1,g1,b1;
  color->getRGB(&r1,&g1,&b1);
  if (r1 == 0){
    r1 = 1;
  }
  if (g1 == 0){
    g1 = 1;
  }
  if (b1 == 0){
    b1 = 1;
  }
  long x,y;
  for(x=0; x<w; x++){
    for(y=0; y<h; y++){
      WSCuchar r,g,b;
      mdev->getBufferRGB(x,y,&r,&g,&b);
      if (r > 247 && g > 247 && b > 247){
        continue;
      }
      r = (WSCushort)(r1*r/255);
      g = (WSCushort)(g1*g/255);
      b = (WSCushort)(b1*b/255);

      WSCuchar r2,g2,b2;
      mdev3->getBufferRGB(x,y,&r2,&g2,&b2);
      r = (WSCushort)(r+r2)/2;
      g = (WSCushort)(g+g2)/2;
      b = (WSCushort)(b+b2)/2;

      mdev3->setBufferRGB(x,y,r,g,b);
    }
  }
  mdev3->putBufferToPixmap();
  delete mdev;
  return mdev3;
}

WSDmwindowDev* WSGFgetAquaMaskImage(WSCushort w,WSCushort h,long no){
  short cno = WSGIappColorSet()->getColorNo("#ffffff");
  WSDmwindowDev* mdev = WSDmwindowDev::getNewInstance();

  mdev->createPixmap(w,h);
  mdev->beginDraw(0,0,w,h);
  mdev->setForeColor(cno);
  mdev->drawFillRect(0,0,w,h);

  if (w < h){
    WSDimage* limage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/mlv.xpm");
    WSDimage* rimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/mrv.xpm");
    mdev->drawStretchedImage(0,0,w,w/2,limage);
    mdev->drawStretchedImage(0,h-w/2,w,w/2,rimage);
  }else{
    if (no == 0){
      WSDimage* limage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/ml.xpm");
      WSDimage* rimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/mr.xpm");
      mdev->drawStretchedImage(0,0,h/2,h,limage);
      mdev->drawStretchedImage(w-h/2,0,h/2,h,rimage);
    }else{
      WSDimage* limage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/mrl.xpm");
      WSDimage* rimage = WSGIappImageSet()->getImage("$(WSDIR)/sys/pixmaps/mrr.xpm");
      mdev->drawStretchedImage(0,0,h/2,h,limage);
      mdev->drawStretchedImage(w-h/2,0,h/2,h,rimage);
    }
  }
  short cno2 = WSGIappColorSet()->getColorNo("#000000");
  mdev->setForeColor(cno2);
  mdev->setLineWidth(1);
  mdev->drawRect(0,0,w,h);

  mdev->endDraw();
  return mdev;
}

void WSGFtrace(WSCstring str){
  if (WSGIappDev()->getTraceMode() != False ){
    WSGFsendMessage("WS-TRACER",str.getString(WS_EN_UTF8));
  }
}
long(*_get_lang_handler)() = NULL;
long WSGFgetLanguage(){
  if (_get_lang_handler == NULL){
    return WS_LANG_CPP;
  }
  return _get_lang_handler();
}
void WSGFsetGetLanguageHandler(long(*hd)()){
  _get_lang_handler = hd;
}

