//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvendbtn.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCimageSet.h>
#include <WSDkeyboard.h>
#include <WSkeysym.h>
#include <WSDfont.h>
#include <WSCfontSet.h>
#include <WSCbaseList.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>

WSMFguiClassInitialize(WSCvendbtn, WSCvbtn);
WSMFversion(WSCvendbtn, WSCvbtn);


WSCvendbtn::WSCvendbtn(WSCbase* base, char* objname):
			WSCvbtn(base, objname) {

  _indicator_size  = 20;
  _exit         = True;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvendbtn);
    WSMFpropertyCreate(WSNindicatorSize,WSCuchar, _indicator_size,WSSindicatorSize);
    WSMFpropertyCreate( WSNexit,  WSCbool, _exit,WSSexit  );
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);

//    WSMFaddTrigger(WSEV_MOUSE_IN   );
      WSMFpropertyDelete(WSNlabelString);
      WSMFpropertyDelete(WSNlabelPixmap);

  WSMFpropertyCreateEnd
}
WSMFproperty(WSCvendbtn, WSNindicatorSize,    WSCuchar,     _indicator_size   ,20      );
WSMFproperty(WSCvendbtn, WSNexit,  WSCbool,  _exit       ,True);

void WSCvendbtn::setWorkWSNindicatorSize(WSCuchar){}
void WSCvendbtn::getWorkWSNindicatorSize(WSCuchar* ){}
void WSCvendbtn::setWorkWSNexit(WSCbool){}
void WSCvendbtn::getWorkWSNexit(WSCbool* ){}

WSCvendbtn::~WSCvendbtn() {
}

long WSCvendbtn::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False) {
    return WS_NO_ERR;
  }
  long ret = WSCvbtn::draw();
  if (ret != WS_NO_ERR){
    return ret;
  }
  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);

  if (_indicator_size > 0){
    WSDimage* pix = WSGIappImageSet()->getImage(WS_EBTN_PIX);
    if (pix != NULL){
      if (_press_state == False){
        dev->drawStretchedImage(w/2 - _indicator_size/2,
                              h/2 - _indicator_size/2,
                              _indicator_size,
                              _indicator_size,pix);
      }else{
        dev->drawStretchedImage(w/2 - _indicator_size/2+1,
                              h/2 - _indicator_size/2+1,
                              _indicator_size,
                              _indicator_size,pix);
      }
    }
  } 

  dev->endDraw();
  return WS_NO_ERR;
}
void WSCvendbtn::onActivate(){
  WSCvbtn::onActivate();
  if (_exit != False && getParent() != NULL){
    getParent()->setVisible(False);
  }
}
