//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCLIST_H
#define WSCLIST_H

#include <WScom.h>
#include <WSCscrForm.h>
#include <WSCsform.h>

#define WSClist_VER 1000
class WSDkeyboard;

class WSClist :public WSCscrForm{

  protected:
     WSCsform*   _btn_area;
     char*       _bar_pos;
     char*       _title_string;
     char*       _data;
     char*       _data_source_name;
     WSCbase*    _input_instance;
     char*       _separator;
     WSClistData _lb_list;
     WSCstring   _lb_class;
     WSCulong    _wy_pos_bak;
     short       _select_color;
     short       _select_fore_color;
     short       _icon_pixmap;
     short       _icon_pixmap_old;
     WSCushort   _w_bk;
     WSCushort   _h_bk;
     WSCushort   _lb_width;
     WSCushort   _work_height_bk;
     short   _pre_select;
     WSCuchar   _lb_height;
     WSCuchar   _lb_height_bk;
     char        _sort_pos;
     unsigned    _font:4;
     unsigned    _disp_type:2;
     unsigned    _data_source_type:2;
     unsigned    _mselect:1;
     unsigned    _select_item_changed:1;
     unsigned    _activate:1;
     unsigned    _reverse_select:1;
     unsigned    _absolute_select_change:1;
     unsigned    _use_icon:1;
     unsigned    _need_update:1;
     unsigned    _enable_input:1;
     unsigned    _need_ds_update:1;
     unsigned    _need_scr_redraw:1;


     WSMFpropertyDef(WSNitemHeight, WSCuchar, _lb_height );
     WSMFpropertyDef(WSNfont,   WSCuchar, _font   );
     WSMFpropertyDef(WSNselectColor, short, _select_color );
     WSMFpropertyDef(WSNselectForeColor, short, _select_fore_color );
     WSMFpropertyDef(WSNtype, WSCuchar, _disp_type );
     WSMFpropertyDef(WSNmultiSelect, WSCbool, _mselect );
     WSMFpropertyDef(WSNreverseSelect, WSCbool, _reverse_select );
     WSMFpropertyDef(WSNtitleHeight,     WSCuchar, _padding  );
     WSMFpropertyDef(WSNtitleString,     char*, _title_string  );
     WSMFpropertyDef(WSNbarValue,        char*, _bar_pos  );
     WSMFpropertyDef(WSNuseIcon,     WSCbool, _use_icon  );
     WSMFpropertyDef(WSNiconPixmap,  short, _icon_pixmap  );
     WSMFpropertyDef(WSNdata,  char*, _data  );
     WSMFpropertyDef(WSNdataSource,  WSCuchar, _data_source_type  );
     WSMFpropertyDef(WSNdataSourceName,  char*, _data_source_name  );
     WSMFpropertyDef(WSNenableInput,  WSCbool, _enable_input  );
     WSMFpropertyDef(WSNseparator,  char*, _separator  );

    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);
    virtual void setWorkWSNworkWidth(WSCushort);
    virtual void setWorkWSNworkHeight(WSCushort);
    virtual void setWorkWSNbackColor(short);
    virtual void setWorkWSNforeColor(short);
    virtual void setWorkWSNtopShadowColor(short);
    virtual void setWorkWSNbottomShadowColor(short);

    virtual void _adjust();
    static void _btn_area_valuech(WSCbase*);
    static void _btn_activate(WSCbase*);
    void _set_data(char*);
    void _clear_ds_instance();
    void _set_ds_instance();
    virtual void _adjust_input(WSCbase* target,long pos,
                               WSCbool vis,short x,short y);

//    static void _mouse_press_work(WSCbase*);
//    static void _mouse_release_work(WSCbase*);

    virtual void onScrMousePress(WSCpoint*);
    virtual void onScrMouseRelease(WSCpoint*);

    void _lb_adjust_work(long&,long,WSCbool,long&);
    virtual void _lb_adjust();
    void _data_from_file(char*);
    static void _input_focus_lose(WSCbase*);
    static void _input_fix_work(WSCbase*);
    virtual void _adjust_no_scroll();
    WSCstring _get_data();

  public:
    WSClist(WSCbase*,char*);
    virtual ~WSClist();

    virtual long draw();
    virtual void update();

    //for data source
    virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT);
    virtual void setData(const WSCvariant&,long code = WS_EN_DEFAULT);

    virtual long getDataSourceType();
    virtual char* getDataSourcePropertyName();

//    virtual void onActivate();
    virtual void onSort();
    virtual void onItemSelected();
    virtual void onItemDoubleClicked();
    virtual void onInputFixed(WSCstring str,long pos,long column);
    virtual void onKey(WSDkeyboard*,WSCbool);
    virtual void onValueChange();
    virtual char* getDefaultProperty();

    void      setLabelHeight(WSCushort h);
    void      delAll();
    WSCbase*  getLabel(long pos);
    long      getNum();
    WSCstring getItem(long pos,long col = -1);
    void      addItem(char* item,long pos = -1);
    void      replaceItem(char* item,long pos);
    void      replaceItem(char* item,long pos,long column);
    void      delPos(long pos);
    long      getPreSelectedPos();
    long      setPreSelectPos(long);
    long      getSelectedPos();
    long      setSelectPos(long );
    WSCstring getSelectedItem();
    void      setTopPos(long);
    void      setBottomPos(long);
    long      getTopPos();
    long      getBottomPos();

    void      updateList();
    void      setLabelProperty(char*,char*);
    void      setLabelClass(char*);
    WSCbool   getSelectItemChanged();
    void      setSelectItemChanged(WSCbool);
    WSClistData* getLabels();
    void      getSelectedLabels(WSClistData&);
    void      setEnableActivate(WSCbool);
    WSCbool   getEnableActivate();
    void      setAbsoluteChangeSelectFlag(WSCbool);
    WSCbool   getAbsoluteChangeSelectFlag();

    long      setItemVisible(long pos,WSCbool fl);
    long      setItemValue(long pos,long kind,long val);
    long      getItemValue(long pos,long kind,long* val);
    long      getSortPos();
    WSCstring getInputString();
    void      cancelInput();
    char*     getSeparator();
    long      getSelectedNextPos(long pos);
    WSCstring getSelectedNextItem(long pos);
    WSCbool   getSelected(long pos);
    WSCbool   setSelected(long pos,WSCbool);


    WSMFguiClassDef(WSClist,WSCscrForm);
};
#endif
