//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <advance/WSCprocessForm.h>
#include <WSCclassInformation.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCvifield.h>
#include <WSDmessage.h>
#include <WSDfileSystem.h>
#include <WSCfontSet.h>
#include <signal.h>
#include <WSCtextField.h>
#include <WSCbaseList.h>
#include <WSDexecute.h>
#include <WSClocaleSet.h>

WSMFguiClassInitialize(WSCprocessForm,WSCtextField);

WSCprocessForm::WSCprocessForm(WSCbase* base,char* objname):
                WSCtextField(base,objname){

//  _label_string = WSGFstrdup("");
  _file_name = WSGFstrdup("");
  _dir_name = WSGFstrdup("");
#if 0
  _pid = 0;
#endif
  _execute = WSDexecute::getNewInstance();
  _execute->setReceiveProc(_receive_proc,this);
  _started = 0;

  WSMFpropertyCreateStart
//    WSMFpropertyCreate(WSNlabelString,char*,_label_string,WSSlabelString);
    WSMFpropertyCreate(WSNfileName,char*,_file_name,WSSfileName);
    WSMFpropertyCreate(WSNdirName,char*,_dir_name,WSSdirName);
  WSMFpropertyCreateEnd
}

//WSMFproperty( WSCprocessForm, WSNlabelString, char*, _label_string, WSGFstrdup(""));
WSMFproperty( WSCprocessForm, WSNfileName, char*, _file_name, WSGFstrdup(""));
WSMFproperty( WSCprocessForm, WSNdirName, char*, _dir_name, WSGFstrdup(""));
#if 0
void WSCprocessForm::setWorkWSNlabelString(char* data){
  if (_textf != NULL){
    _textf->setProperty(WSNlabelString,data);
  }
}
void WSCprocessForm::getWorkWSNlabelString(char** /*data*/){
}
#endif
void WSCprocessForm::setWorkWSNfileName(char* /*data*/){ }
void WSCprocessForm::getWorkWSNfileName(char** /*data*/){ }
void WSCprocessForm::setWorkWSNdirName(char* /*data*/){ }
void WSCprocessForm::getWorkWSNdirName(char** /*data*/){ }

WSCprocessForm::~WSCprocessForm(){
#if 0
  delete _m1;
  delete _m2;
  delete _m3;
  delete _m4;
#endif
  delete _execute;
  delete _file_name;
  delete _dir_name;
}
long WSCprocessForm::initialize(){
#if 0
  _m1 = WSDmessage::getNewInstance();
  _m1->setupMessage("WL-SBYTES",_cb1,(void*)this);
  _m2 = WSDmessage::getNewInstance();
  _m2->setupMessage("WL-LINE",_cb2,(void*)this);
  _m3 = WSDmessage::getNewInstance();
  _m3->setupMessage("WL-LINE-END",_cb3,(void*)this);
  _m4 = WSDmessage::getNewInstance();
  _m4->setupMessage("WL-END",_cb4,(void*)this);
#endif

  WSCtextField::initialize();

  WSCprocedure* op1 = new WSCprocedure("sop4",WSEV_KEY_HOOK);
  op1->setInternal(True);
  op1->setFunction(_textf_work,"_textf_work");
  addProcedure(op1);
//  _textf->addProcedure(op1);

  return WS_NO_ERR;

}
void WSCprocessForm::_textf_work(WSCbase* textf){
  if (WSGIappKeyboard()->isCursorKey() != False){
    return;
  }
  long key = WSGIappKeyboard()->getKey();
  if ((key == WSK_C || key == WSK_c) && WSGIappKeyboard()->withCntl() != False){
    return;
  }
  WSGIappKeyboard()->setKey(0);
}

void WSCprocessForm::_receive_proc(WSDexecute* exec){
  WSCprocessForm* _this = (WSCprocessForm*)exec->getUserData(); 
  char data[2048];
  char* ret = exec->gets(data,sizeof(data));
  WSCstring tmp;
  tmp.setString(data,WSGIappLocaleSet()->getSystemLocaleEncoding());
//printf("WSCprocessForm::_receive_proc #%s#\n",data);

  if (ret > 0){
    WSCstring str(_this->getString());
    str << tmp.getString();
    _this->addString(tmp.getString());
//    delete _this->_label_string;
//    _this->_label_string = WSGFstrdup((char*)str);
    long lines = _this->getLines();
    _this->setBottomLine(lines);
  }else{
    WSCstring str(_this->getProperty(WSNlabelString));
    str << WSGFgettext("B3:WSSTR done.\n");
    _this->getTextFrame()->setPropertyV(WSNlabelString,(char*)str);
    long lines = _this->getLines();
    _this->setBottomLine(lines);

//    delete _this->_label_string;
//    _this->_label_string = WSGFstrdup((char*)str);
    _this->_started = 0;
//    _this->setPropertyV(WSNokString,"OK");
    _this->_execute->killProcess();
    _this->execProcedure(WSEV_ACTIVATE);
  }
}

long WSCprocessForm::start(){
  if (_started != 0){
    return WS_OK;
  }
  if (_execute->getHandle() != NULL){
    stop();
  }
  if (!strcmp(_file_name,"")){
    return WS_ERR;
  }
  setProperty(WSNhbarValue,0);
  setProperty(WSNvbarValue,0);
  _execute->setCurrentDir((char*)_dir_name);
  _execute->execute((char*)_file_name,WS_EXEC_RD);
  _started = 1;
  execProcedure(WSEV_ACTIVATE);
//  setPropertyV(WSNokString,WSGFgettext("C3:WSSTR Break"));
  return WS_OK;
}
long WSCprocessForm::stop(){
  if (_execute->getHandle() != NULL){
    _execute->killProcess();
    WSCstring str(getProperty(WSNlabelString));
    str << WSGFgettext("N3:WSSTR broken.");
    getTextFrame()->setPropertyV(WSNlabelString,(char*)str);
//    delete _label_string;
//    _label_string = WSGFstrdup((char*)str);
  }
  if (_started == 0){
    return WS_OK;
  }
  _started = 0;
  execProcedure(WSEV_ACTIVATE);
//  setPropertyV(WSNokString,"OK");
  return WS_OK;
}
#if 0
void WSCprocessForm::onActivate(){
  if (getStatus() == WS_DIALOG_OK){
    if (_started == 0){
      _popuped = 0;
      setVisible(False);
    }else{
      stop();
    }
  }
}
#endif
void* WSCprocessForm::getHandle(){
  if (_execute == NULL){
    return NULL;
  }
  return _execute->getHandle();
}
WSCbool WSCprocessForm::getExecuteStatus(){
  return _started;
}
