//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCoption.h>
#include <WSCvlabel.h>
#include <WSCvifield.h>
#include <WSCvbtn.h>
#include <WSCimageSet.h>
#include <WSCmessageDialog.h>
#include <WSCfileSelect.h>
#include <WSCvtoggle.h>
#include <WSCvradio.h>
#include <WSDfile.h>
#include <WSCballoonHelp.h>
#include <WSClist.h>
#include <WSCbaseList.h>
#include <advance/WSCwindowEditor.h>
#include <advance/WSCclassPropEditor.h>
#include <advance/WSCclassUTrgEditor.h>
#include <advance/WSCtriggerEditor.h>
#include <advance/WSCclassRMethodEditor.h>

#define WS_WARNING_STR  WSGFgettext("L3:WSSTR Warning")

#define WS_WPS_WIDTH   300
#define WS_WPS_HEIGHT  280

WSMFguiClassInitialize(WSCwindowEditor,WSCscrForm);
WSMFversion(WSCwindowEditor,WSCscrForm);

WSCwindowEditor::WSCwindowEditor(WSCbase* base,char* objname):
                WSCscrForm(base,objname){

  _client = NULL;
  _voidp_client = NULL;


  _tgb1 = NULL;
  _class_icon = NULL;
  _class_cmmt = NULL;
  _class_base = NULL;
  _inst_name = NULL;
  _cpe = NULL;
  _crme = NULL;
  _cute = NULL;
  _cte = NULL;
  _msg = NULL;
  _pstg1 = NULL;
  _pstg2 = NULL;
  _pstg3 = NULL;
  _cname = NULL;
  _bt1 = NULL;
  _editable = 1;
  _vartg = NULL;
  _psbt1 = NULL;


  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNclient, void*,   _voidp_client,WSSclient );
    WSMFaddTrigger(WSEV_ACTIVATE     );
  WSMFpropertyCreateEnd

}

WSMFproperty( WSCwindowEditor, WSNclient, void*,   _voidp_client,   NULL);

void WSCwindowEditor::setWorkWSNwidth(WSCushort data){
  WSCscrForm::setWorkWSNwidth(data);
  _adjust();
}
void WSCwindowEditor::setWorkWSNheight(WSCushort data){
  WSCscrForm::setWorkWSNheight(data);
  _adjust();
}
void WSCwindowEditor::setWorkWSNclient(void* data){
  WSCbase* client = (WSCbase*)data;
  setEditClient(client);
//  WSCbase* old = (WSCbase*)getUserData("PCLIENT");
  setUserData("PCLIENT",client);
}

void WSCwindowEditor::getWorkWSNclient(void** data){
  WSCbase* client = getEditClient();
  *data = (void*)client;
}


WSCwindowEditor::~WSCwindowEditor(){
}
void WSCwindowEditor::_fbtn_work(WSCbase* ptr){
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  if (obj->_client == NULL){
    return;
  }
  WSCfileSelect* fs = WSGIappFileSelect();
  fs->setPropertyV(WSNmaskFileName,"xpm");
  long ret = fs->popup();
  if (ret == WS_DIALOG_OK){
    obj->_class_icon->setPropertyV(WSNlabelString,fs->getFileName());
    obj->_class_icon->execProcedure(WSEV_ACTIVATE);
  }
}
void WSCwindowEditor::_vartg_work(WSCbase* ptr){
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  if (obj->_client == NULL){
    return;
  }
  if ( obj->_vartg->getStatus() == 1){
    obj->_client->setUserData(WS_EXT_VAR,(void*)1);
  }else{
    obj->_client->setUserData(WS_EXT_VAR,(void*)0);
  }
  WSGFmarkChanged(obj->_client);
}
void WSCwindowEditor::_prjtg_work(WSCbase* ptr){
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  if (obj->_client == NULL){
    return;
  }
  if ( obj->_prjtg->getStatus() == 1){
    obj->_client->setUserData(WS_REGISTERED,(void*)1);
  }else{
    obj->_client->setUserData(WS_REGISTERED,(void*)0);
  }
  WSGFmarkChanged(obj->_client);
}
void WSCwindowEditor::_rctg_work(WSCbase* ptr){
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  if (obj->_client == NULL){
    return;
  }
  if ( obj->_rctg->getStatus() == 1){
    obj->_client->setUserData(WS_RCLASS_GENERATE,(void*)1);
    obj->_psbt4->setSensitive(True);
  }else{
    obj->_client->setUserData(WS_RCLASS_GENERATE,(void*)0);
    obj->_psbt4->setSensitive(False);
  }

  WSCbase* win = obj->_client->getParentWindow();
  if (win != NULL){
    if ( !win->getUserData(WS_WIN_CLASS) ){
      obj->_psbt4->setSensitive(False);
      obj->_rctg->setSensitive(False);
    }
  }
  WSGFmarkChanged(obj->_client);

}
void WSCwindowEditor::_stg1_work(WSCbase* ptr){
//printf("here...\n");
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  if ( obj->_pstg1->getGroupValue() == 1 || obj->_editable== False){
    obj->_psbt1->setSensitive(False);
    obj->_psbt2->setSensitive(False);
    obj->_psbt3->setSensitive(False);
    obj->_psbt4->setSensitive(False);
    obj->_rctg->setSensitive(False);
    obj->_class_icon->setSensitive(False);
    obj->_class_icon->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    obj->_class_cmmt->setSensitive(False);
    obj->_class_cmmt->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    obj->_class_base->setSensitive(False);
    obj->_class_base->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    obj->pslb6->setProperty(WSNlabelString,WSGFgettext("D3:WSSTR BaseClass"));
  }else

  if (obj->_pstg1->getGroupValue() == 2){
    obj->_psbt1->setSensitive(True);
    obj->_psbt2->setSensitive(True);
    obj->_psbt3->setSensitive(True);
    obj->_rctg->setSensitive(True);
    if (obj->_rctg->getStatus() != False){
      obj->_psbt4->setSensitive(True);
    }
    obj->_class_icon->setSensitive(True);
    obj->_class_icon->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    obj->_class_cmmt->setSensitive(True);
    obj->_class_cmmt->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    obj->_class_base->setSensitive(True);
    obj->_class_base->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    obj->pslb6->setProperty(WSNlabelString,WSGFgettext("D3:WSSTR BaseClass"));
  }else

  if (obj->_pstg1->getGroupValue() == 3){
    obj->_psbt1->setSensitive(False);
    obj->_psbt2->setSensitive(False);
    obj->_psbt3->setSensitive(False);
    obj->_psbt4->setSensitive(False);
    obj->_rctg->setSensitive(False);
    obj->_class_icon->setSensitive(False);
    obj->_class_icon->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    obj->_class_cmmt->setSensitive(False);
    obj->_class_cmmt->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    obj->_class_base->setSensitive(True);
    obj->_class_base->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    obj->pslb6->setProperty(WSNlabelString,WSGFgettext("E3:WSSTR Base"));
  }

  obj->_psbt1->redraw();
  obj->_psbt2->redraw();
  obj->_psbt3->redraw();
  if (obj->_client == NULL){
    obj->onActivate();
    return;
  }
  WSCbase* win = obj->_client->getParentWindow();
  if (win != NULL){
    long val = obj->_pstg1->getGroupValue();
    long val2 = 1;
    if ( win->getUserData(WS_WIN_CLASS) ){
      val2 = 2;
    }else if ( win->getUserData(WS_WIN_STORE) ){
      val2 = 3;
    }

    obj->_msg->setPropertyV(WSNtitleString,"Message");
    obj->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
    obj->_msg->setPropertyV(WSNwidth,(WSCushort)650);
    obj->_msg->setPropertyV(WSNheight,(WSCushort)150);
    obj->_msg->setPropertyV(WSNno,(WSCbool)True);
    if ( ((val == 1 || val == 3) && val2 == 2)){
      obj->_msg->setPropertyV(WSNlabelString,
        WSGFgettext("F3:WSSTR If you change window definition type,\n"
        "you have to change the type of the event procedure.\n"
        "Do you continue?"));
      long ret =  obj->_msg->popup();
      obj->_msg->setPropertyV(WSNno,(WSCbool)False);
      obj->_msg->setPropertyV(WSNheight,(WSCushort)100);
      if (ret != WS_DIALOG_OK){
        obj->_pstg1->setGroupValue(val2);
        return;
      }
    }else if ( ((val2 == 1 || val2 == 3) && val == 2) ){
      obj->_msg->setPropertyV(WSNlabelString,
        WSGFgettext("G3:WSSTR If it makes the class definition window type into another type,\n"
        "it needs to change the type of the event procedure.\n"
        "Do you continue?"));
      long ret =  obj->_msg->popup();
      obj->_msg->setPropertyV(WSNno,(WSCbool)False);
      obj->_msg->setPropertyV(WSNheight,(WSCushort)100);
      if (ret != WS_DIALOG_OK){
        obj->_pstg1->setGroupValue(val2);
        return;
      }
    }

    if (val == 1){
      win->setUserData(WS_WIN_CLASS,(void*)0);
      win->setUserData(WS_WIN_STORE,(void*)0);
    }else
    if (val == 2){
      win->setUserData(WS_WIN_CLASS,(void*)1);
      win->setUserData(WS_WIN_STORE,(void*)0);
    }else
    if (val == 3){
      win->setUserData(WS_WIN_CLASS,(void*)0);
      win->setUserData(WS_WIN_STORE,(void*)1);
    }
    if (win == obj->_client){
      WSCstring str(obj->_file_name->getProperty(WSNlabelString));
      str.delHeadSpace();
      str.delTailSpace();
      WSCstring str2 = str.getWord(0);
      if (val == 1 || val == 2){
        str2.replaceString(".oof",".win",1);
      }else{
        str2.replaceString(".oof",".win",1);
      }
      obj->_file_name->setPropertyV(WSNlabelString,(char*)str2);
      char* tmp = (char*)win->getUserData(WS_FILENAME);
      if (tmp != NULL){
        delete tmp;
        win->setUserData(WS_FILENAME,NULL);
      }
      if (strcmp((char*)str2,"")){
        win->setUserData(WS_FILENAME,(void*)WSGFstrdup((char*)str2));
      }
    }
    if (val != val2){
      WSGFmarkChanged(win);
    }
  }

  obj->onActivate();
}
void WSCwindowEditor::onActivate(){
//  execEventProc(WSEV_ACTIVATE,NULL);
  execProcedure(WSEV_ACTIVATE);
}
void WSCwindowEditor::onVisibleChange(WSCbool fl){
//printf("WSCwindowEditor::onVisibleChange fl=%d\n",fl);
  WSCscrForm::onVisibleChange(fl);
  if (fl == True){
    setEditClient(_client);
  }
}
void WSCwindowEditor::onParentVisibleChange(WSCbool fl){
//printf("WSCwindowEditor::onParentVisibleChange fl=%d\n",fl);
  WSCscrForm::onParentVisibleChange(fl);
  if (fl == True){
    setEditClient(_client);
  }
}

void WSCwindowEditor::_vifi_work(WSCbase* ptr){
  if (ptr->getFocus() != False){
    return;
  }
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  if (obj->_client == NULL){
    return;
  }
  char* cicon = (char*)obj->_client->getUserData(WS_CLASS_ICON);
  if (cicon != NULL){
    delete cicon;
    obj->_client->setUserData(WS_CLASS_ICON,(void*)0);
  }
  if (strcmp("",obj->_class_icon->getProperty(WSNlabelString))){
    obj->_client->setUserData(WS_CLASS_ICON,(void*)WSGFstrdup(obj->_class_icon->getProperty(WSNlabelString)));
  }

  char* ccom = (char*)obj->_client->getUserData(WS_CLASS_COMMENT);
  if (ccom != NULL){
    delete ccom;
    obj->_client->setUserData(WS_CLASS_COMMENT,(void*)0);
  }
  if (strcmp("",obj->_class_cmmt->getProperty(WSNlabelString))){
    obj->_client->setUserData(WS_CLASS_COMMENT,(void*)WSGFstrdup(obj->_class_cmmt->getProperty(WSNlabelString)));
  }

  char* cbase = (char*)obj->_client->getUserData(WS_WIN_CLASS_BASE);
  if (cbase != NULL){
    delete cbase;
    obj->_client->setUserData(WS_WIN_CLASS_BASE,(void*)0);
  }
  if (strcmp("",obj->_class_base->getProperty(WSNlabelString))){
    WSCbase* child = obj->_client->getChildInstance(
                             obj->_class_base->getProperty(WSNlabelString));
    if (child == NULL){
      obj->_msg->setPropertyV(WSNtitleString,"Message");
      obj->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
      obj->_msg->setPropertyV(WSNwidth,(WSCushort)450);
      obj->_msg->setPropertyV(WSNheight,(WSCushort)130);
      obj->_msg->setPropertyV(WSNno,(WSCbool)False);
      char buffer[1024];
      sprintf(buffer,WSGFgettext("H3:WSSTR inherit base instance: %s Not Found.\nPlease specify the correct instance name."),
              (char*)obj->_class_base->getProperty(WSNlabelString));
      obj->_msg->setPropertyV(WSNlabelString,buffer);
      obj->_msg->popup();
    }else{
      obj->_client->setUserData(WS_WIN_CLASS_BASE,
          (void*)WSGFstrdup(obj->_class_base->getProperty(WSNlabelString)));
    }
  }

  WSCstring pname;
  pname.setString(obj->_inst_name->getProperty(WSNlabelString));
  pname.delHeadSpace();
  pname.delTailSpace();
  WSCstring pname_bk; 
  pname_bk.setString(obj->_client->getInstanceName());
  obj->_client->setInstanceName("--NO NAME--");
  long ano;
  char dummy[2048];

  obj->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
  obj->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  obj->_msg->setPropertyV(WSNwidth,(WSCushort)450);

  if (WSGFcheckNameString(pname.getString()) == True){
    long ret = WSGFexistName(pname.getString(),obj->_client);
    if (ret == 0){
    }else if (ret == WS_PROCEDURE_NAME){
      obj->_msg->setPropertyV(WSNlabelString,
        WSGFgettext("I3:WSSTR Invalid name.\nAlready used by another event procedure."));
      obj->_msg->setVisible(True);
    }else if (ret == WS_OBJECT_NAME){
      obj->_msg->setPropertyV(WSNlabelString,
        WSGFgettext("J3:WSSTR Invalid name.\nAlready used by another instance name."));
      obj->_msg->setVisible(True);
    }else if (ret == WS_OBJECT_ARRAY_NAME || ret == WS_OBJECT_ARRAY_NAME_INVALID){
      obj->_msg->setPropertyV(WSNlabelString,
        WSGFgettext("K3:WSSTR Invalid name.\nAlready used by another instance array name."));
      obj->_msg->setVisible(True);
    }else if (ret == WS_OTHER_NAME){
      obj->_msg->setPropertyV(WSNlabelString,
        WSGFgettext("L3:WSSTR Invalid name.\nAlready used by the project name or the other one."));
      obj->_msg->setVisible(True);
    }
    obj->_client->setInstanceName( pname.getString() );
  }else if (WSGFcheckArrayName(pname.getString(),&ano,dummy) == True){
    pname.delHeadSpace();
    pname.delTailSpace();
    long ret = WSGFexistName(pname.getString(),obj->_client);
    if (obj->_client->getParentWindow() == obj->_client){
      obj->_msg->setPropertyV(WSNlabelString,WSGFgettext("M3:WSSTR Can not specify the array name for window."));
      obj->_msg->setVisible(True);
    }else if ((long)obj->_client->getParentWindow()->getUserData(WS_WIN_CLASS) != 0){
      obj->_msg->setPropertyV(WSNlabelString,WSGFgettext("N3:WSSTR Can not specify the array name for class definition window."));
      obj->_msg->setVisible(True);
    }else if (ret == 0 || ret == WS_OBJECT_ARRAY_NAME){
    }else if (ret == WS_PROCEDURE_NAME){
      obj->_msg->setPropertyV(WSNlabelString,WSGFgettext("O3:WSSTR Invalid name.\nAlready used by another event procedure."));
      obj->_msg->setVisible(True);
    }else if (ret == WS_OBJECT_NAME){
      obj->_msg->setPropertyV(WSNlabelString,WSGFgettext("P3:WSSTR Invalid name.\nAlready used by another external instance."));
      obj->_msg->setVisible(True);
    }else if (ret == WS_OBJECT_ARRAY_NAME_INVALID){
      obj->_msg->setPropertyV(WSNlabelString,
        WSGFgettext("Q3:WSSTR Invalid array name.\nThe Array type differs from another one,or exists also another window."));
      obj->_msg->setVisible(True);
    }else if (ret == WS_OTHER_NAME){
      obj->_msg->setPropertyV(WSNlabelString,
        WSGFgettext("R3:WSSTR Invalid name.\nAlready used by the project name or the other one."));
      obj->_msg->setVisible(True);
    }
    obj->_client->setInstanceName( pname.getString() );
  }else{
    obj->_msg->setPropertyV(WSNlabelString,WSGFgettext("S3:WSSTR Invalid instance name."));
    obj->_msg->setVisible(True);
    obj->_client->setInstanceName( pname_bk.getString() );
  }

  WSCstring fname;
  fname.setString(obj->_file_name->getProperty(WSNlabelString));
  fname.delHeadSpace();
  fname.delTailSpace();
  char* cfname = (char*)obj->_client->getUserData(WS_FILENAME);
  if (cfname != NULL){
    delete cfname;
    obj->_client->setUserData(WS_FILENAME,(void*)0);
  }
  if (strcmp("",(char*)fname)){
    obj->_client->setUserData(WS_FILENAME,(void*)WSGFstrdup((char*)fname));
  }

  WSGFmarkChanged(obj->_client);
  obj->onActivate();
}

void WSCwindowEditor::_psbt4_work(WSCbase* ptr){
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  obj->_crme->setPropertyV(WSNclient,(void*)NULL);
  obj->_crme->setPropertyV(WSNclient,(void*)obj->_client);
  obj->_crme->setVisible(True);
}

void WSCwindowEditor::_psbt3_work(WSCbase* ptr){
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  obj->_cute->setPropertyV(WSNclient,(void*)NULL);
  obj->_cute->setPropertyV(WSNclient,(void*)obj->_client);
  obj->_cute->setVisible(True);
}

void WSCwindowEditor::_psbt2_work(WSCbase* ptr){
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  obj->_cte->setPropertyV(WSNclient,(void*)NULL);
  obj->_cte->setPropertyV(WSNclient,(void*)obj->_client);
  obj->_cte->setVisible(True);
}

void WSCwindowEditor::_psbt1_work(WSCbase* ptr){
  WSCwindowEditor* obj = (WSCwindowEditor*)ptr->getUserData("WINEDIT");
  obj->_cpe->setPropertyV(WSNclient,(void*)NULL);
  obj->_cpe->setPropertyV(WSNclient,(void*)obj->_client);
  obj->_cpe->setVisible(True);
}

static void _set_sp(WSCbase* sp){
  sp->initialize();
  sp->setInternalObject(True);
  sp->setPropertyV(WSNx,(short)0);
  sp->setPropertyV(WSNwidth, (WSCushort)(1280));
  sp->setPropertyV(WSNheight, (WSCushort)2);
  sp->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  sp->setPropertyV(WSNshadowType, (char)WS_SHADOW_IN);
  sp->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
}
static void _set_ifd(WSCbase* ifd){
  ifd->setPropertyV(WSNfillSpace, (WSCbool)False);
  ifd->setPropertyV(WSNinterCur, (WSCbool)True);
  ifd->setPropertyV(WSNcolumns, (WSCushort)0);
  ifd->setPropertyV(WSNmaxLength, (WSCushort)0);
  ifd->setPropertyV(WSNlabelString, "");
  ifd->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ifd->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
}
long WSCwindowEditor::initialize(){
  WSCscrForm::initialize();
  WSGFsetGeometry(this,5,5,100,100);
  setPropertyV(WSNshadowThickness,(WSCuchar)0);
  setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);

  WSCvlabel* pslb0 = new WSCvlabel(this,"pslb0");
  pslb0->initialize();
  pslb0->setInternalObject(True);
  WSGFsetGeometry(pslb0,5,2,90,20);
  pslb0->setPropertyV(WSNlabelString, WSGFgettext("T3:WSSTR ClassName"));
  pslb0->setVisible(True);
  WSGFsetMargin(pslb0,0);

  WSCvlabel* pssp0 = new WSCvlabel(this,"pssp0");
  _set_sp(pssp0);
  pssp0->setPropertyV(WSNy,(short)28);
  pssp0->setVisible(True);

  _cname = new WSCvlabel(this,"pslb0-1");
  _cname->initialize();
  _cname->setInternalObject(True);
  WSGFsetGeometry(_cname,110,2,150,20);
//  _cname->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _cname->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _cname->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _cname->setPropertyV(WSNalignmentH, (WSCuchar)WS_LEFT);
  _cname->setUserData("WINEDIT",(void*)this);
  WSGFsetMargin(_cname,0);
  _cname->setVisible(True);


  WSCvtoggle* tg[3];
  long i;
  for(i=0; i<3; i++){
//    tg[i] = new WSCvtoggle(this,"pstg1");
    tg[i] = new WSCvradio(this,"pstg1");
    tg[i]->initialize();
    tg[i]->setInternalObject(True);
    WSGFsetGeometry(tg[i],100,0,200,19);
    tg[i]->setPropertyV(WSNmarginTop, (WSCuchar)0);
    tg[i]->setPropertyV(WSNmarginBottom, (WSCuchar)0);
    tg[i]->setPropertyV(WSNmarginLeft, (WSCuchar)10);
    tg[i]->setPropertyV(WSNalignmentH, (WSCuchar)WS_LEFT);
//    tg[i]->setPropertyV(WSNindicatorPixmap,WS_TG1_PIX);
//    tg[i]->setPropertyV(WSNselectPixmap,WS_TG2_PIX);
//    tg[i]->setPropertyV(WSNindicatorType,WS_IN);
    tg[i]->setPropertyV(WSNindicatorSize,(WSCuchar)16);
//    tg[i]->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    tg[i]->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    tg[i]->setPropertyV(WSNunique,(WSCbool)True);
    tg[i]->setPropertyV(WSNgroup,"ps-tgl-grp");
    tg[i]->setUserData("WINEDIT",(void*)this);
    tg[i]->setPropertyV(WSNemboss,(WSCbool)True);
  }


  _pstg1 = tg[0];
  _pstg1->setPropertyV(WSNy,(short)32);
  _pstg1->setPropertyV(WSNlabelString, WSGFgettext("U3:WSSTR Normal window"));
  _pstg1->setPropertyV(WSNid,(short)1);
  _pstg1->setVisible(True);

  _pstg2 = tg[1];
  _pstg2->setPropertyV(WSNy,(short)50);
  _pstg2->setPropertyV(WSNlabelString, WSGFgettext("V3:WSSTR Class definition"));
  _pstg2->setPropertyV(WSNid,(short)2);

  WSCprocedure* pschop1 = new WSCprocedure("sop4",WSEV_VALUE_CH);
  pschop1->setFunction(_stg1_work,"_stg1_work");
  _pstg2->addProcedure(pschop1);
  _pstg2->setVisible(True);

  _pstg3 = tg[2];
  _pstg3->initialize();
  _pstg3->setPropertyV(WSNy,(short)68);
  _pstg3->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Use object store"));
  _pstg3->setPropertyV(WSNid,(short)3);
  _pstg3->setVisible(True);

  WSCvlabel* pslb1 = new WSCvlabel(this,"pslb1");
  pslb1->initialize();
  pslb1->setInternalObject(True);
  WSGFsetGeometry(pslb1,5,35,90,20);
  pslb1->setPropertyV(WSNlabelString, WSGFgettext("X3:WSSTR Type"));
  pslb1->setVisible(True);
  WSGFsetMargin(pslb1,0);

  WSCvlabel* pssp1 = new WSCvlabel(this,"pssp1");
  _set_sp(pssp1);
  pssp1->setPropertyV(WSNy,(short)89);
  pssp1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  pssp1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  pssp1->setVisible(True);

  WSCvlabel* pslb2 = new WSCvlabel(this,"pslb2");
  pslb2->initialize();
  pslb2->setInternalObject(True);
  WSGFsetGeometry(pslb2,5,95,90,20);
  pslb2->setPropertyV(WSNlabelString, WSGFgettext("Y3:WSSTR Settings"));
  pslb2->setVisible(True);
  WSGFsetMargin(pslb2,0);

  _psbt1 = new WSCvbtn(this,"psbt1");
  _psbt1->initialize();
  _psbt1->setInternalObject(True);
  WSGFsetGeometry(_psbt1,110,96,150,20);
  _psbt1->setPropertyV(WSNlabelString, WSGFgettext("Z3:WSSTR Properties"));
  _psbt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _psbt1->setPropertyV(WSNemboss,(WSCbool)True);
  _psbt1->setUserData("WINEDIT",(void*)this);
  WSGFsetMargin(_psbt1,0);

  WSCprocedure* psbtop2 = new WSCprocedure("psbtop2",WSEV_ACTIVATE);
  psbtop2->setFunction(_psbt1_work,"_psbt1_work");
  _psbt1->addProcedure(psbtop2);
  _psbt1->setVisible(True);

  _psbt2 = new WSCvbtn(this,"psbt1");
  _psbt2->initialize();
  _psbt2->setInternalObject(True);
  WSGFsetGeometry(_psbt2,110,120,150,20);
  _psbt2->setPropertyV(WSNlabelString, WSGFgettext("a3:WSSTR Triggers"));
  _psbt2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _psbt2->setPropertyV(WSNemboss,(WSCbool)True);
  _psbt2->setUserData("WINEDIT",(void*)this);
  WSGFsetMargin(_psbt2,0);

  WSCprocedure* psbtop3 = new WSCprocedure("psbtop3",WSEV_ACTIVATE);
  psbtop3->setFunction(_psbt2_work,"_psbt2_work");
  _psbt2->addProcedure(psbtop3);
  _psbt2->setVisible(True);

  _psbt3 = new WSCvbtn(this,"psbt1");
  _psbt3->initialize();
  _psbt3->setInternalObject(True);
  WSGFsetGeometry(_psbt3,110,144,150,20);
  _psbt3->setPropertyV(WSNlabelString, WSGFgettext("b3:WSSTR UserTriggers"));
  _psbt3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _psbt3->setPropertyV(WSNemboss,(WSCbool)True);
  _psbt3->setUserData("WINEDIT",(void*)this);
  WSGFsetMargin(_psbt3,0);

  WSCprocedure* psbtop4 = new WSCprocedure("psbtop4",WSEV_ACTIVATE);
  psbtop4->setFunction(_psbt3_work,"_psbt3_work");
  _psbt3->addProcedure(psbtop4);
  _psbt3->setVisible(True);


  _psbt4 = new WSCvbtn(this,"psbt1");
  _psbt4->initialize();
  _psbt4->setInternalObject(True);
  WSGFsetGeometry(_psbt4,110,169,150,20);
  _psbt4->setPropertyV(WSNlabelString, WSGFgettext("b3:WSSTR RemoteMethods"));
  _psbt4->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _psbt4->setPropertyV(WSNemboss,(WSCbool)True);
  _psbt4->setUserData("WINEDIT",(void*)this);
  WSGFsetMargin(_psbt4,0);

  WSCprocedure* psbtop5 = new WSCprocedure("psbtop4",WSEV_ACTIVATE);
  psbtop5->setFunction(_psbt4_work,"_psbt4_work");
  _psbt4->addProcedure(psbtop5);
  _psbt4->setVisible(True);







//XXXXXXXXXXZZZZZZZZZZ

  WSCvlabel* pssp4 = new WSCvlabel(this,"pssp4");
  _set_sp(pssp4);
  pssp4->setPropertyV(WSNy,(short)193);
  pssp4->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  pssp4->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  pssp4->setVisible(True);

  WSCvlabel* pslb4 = new WSCvlabel(this,"pslb4");
  pslb4->initialize();
  pslb4->setInternalObject(True);
  WSGFsetGeometry(pslb4,5,199,90,20);
  pslb4->setPropertyV(WSNlabelString, WSGFgettext("c3:WSSTR Icon"));
  pslb4->setVisible(True);
  WSGFsetMargin(pslb4,0);

  _class_icon = new WSCvifield(this,"psif1");
  _class_icon->initialize();
  _class_icon->setInternalObject(True);
  WSGFsetGeometry(_class_icon,110,199,150,20);
  _set_ifd(_class_icon);
  _class_icon->setUserData("WINEDIT",(void*)this);
  _class_icon->setVisible(True);
  WSCprocedure* psbtop31 = new WSCprocedure("psbtop31",WSEV_ACTIVATE);
  psbtop31->setFunction(_vifi_work,"_vifi_work");
  _class_icon->addProcedure(psbtop31);

  WSCprocedure* psbtop31_2= new WSCprocedure("psbtop35",WSEV_FOCUS_CH);
  psbtop31_2->setFunction(_vifi_work,"_vifi_work");
  _class_icon->addProcedure(psbtop31_2);

  _fbt1 = new WSCvbtn(this,"psbt1");
  _fbt1->initialize();
  _fbt1->setInternalObject(True);
  WSGFsetGeometry(_fbt1,265,199,20,20);
  _fbt1->setPropertyV(WSNlabelString, "..");
  _fbt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _fbt1->setUserData("WINEDIT",(void*)this);
  WSGFsetMargin(_fbt1,0);
  WSCprocedure* fbtop31 = new WSCprocedure("fbtop31",WSEV_ACTIVATE);
  fbtop31->setFunction(_fbtn_work,"_fbtn_work");
  _fbt1->addProcedure(fbtop31);
  _fbt1->setVisible(True);


  WSCvlabel* pslb5 = new WSCvlabel(this,"pslb5");
  pslb5->initialize();
  pslb5->setInternalObject(True);
  WSGFsetGeometry(pslb5,5,224,90,20);
  pslb5->setPropertyV(WSNlabelString, WSGFgettext("d3:WSSTR Comment"));
  pslb5->setVisible(True);
  WSGFsetMargin(pslb5,0);

  _class_cmmt = new WSCvifield(this,"psif1");
  _class_cmmt->initialize();
  _class_cmmt->setInternalObject(True);
  WSGFsetGeometry(_class_cmmt,110,224,150,20);
  _set_ifd(_class_cmmt);
  _class_cmmt->setUserData("WINEDIT",(void*)this);
  _class_cmmt->setVisible(True);
  WSCprocedure* psbtop32 = new WSCprocedure("psbtop32",WSEV_ACTIVATE);
  psbtop32->setFunction(_vifi_work,"_vifi_work");
  _class_cmmt->addProcedure(psbtop32);

  WSCprocedure* psbtop32_2= new WSCprocedure("psbtop35",WSEV_FOCUS_CH);
  psbtop32_2->setFunction(_vifi_work,"_vifi_work");
  _class_cmmt->addProcedure(psbtop32_2);

  pslb6 = new WSCvlabel(this,"pslb6");
  pslb6->initialize();
  pslb6->setInternalObject(True);
  WSGFsetGeometry(pslb6,5,249,90,20);
  pslb6->setPropertyV(WSNlabelString, WSGFgettext("e3:WSSTR Base"));
  pslb6->setVisible(True);
  WSGFsetMargin(pslb6,0);

  _class_base = new WSCvifield(this,"psif3");
  _class_base->initialize();
  _class_base->setInternalObject(True);
  WSGFsetGeometry(_class_base,110,249,150,20);
  _set_ifd(_class_base);
  _class_base->setUserData("WINEDIT",(void*)this);
  _class_base->setVisible(True);
  WSCprocedure* psbtop33 = new WSCprocedure("psbtop33",WSEV_ACTIVATE);
  psbtop33->setFunction(_vifi_work,"_vifi_work");
  _class_base->addProcedure(psbtop33);

  WSCprocedure* psbtop33_2= new WSCprocedure("psbtop35",WSEV_FOCUS_CH);
  psbtop33_2->setFunction(_vifi_work,"_vifi_work");
  _class_base->addProcedure(psbtop33_2);

  WSCvlabel* pslb7 = new WSCvlabel(this,"pslb6");
  pslb7->initialize();
  pslb7->setInternalObject(True);
  WSGFsetGeometry(pslb7,5,274,90,20);
  pslb7->setPropertyV(WSNlabelString, WSGFgettext("f3:WSSTR Name"));
  pslb7->setVisible(True);
  WSGFsetMargin(pslb7,0);

  _inst_name = new WSCvifield(this,"psif4");
  _inst_name->initialize();
  _inst_name->setInternalObject(True);
  WSGFsetGeometry(_inst_name,110,274,150,20);
  _set_ifd(_inst_name);
  _inst_name->setUserData("WINEDIT",(void*)this);
  _inst_name->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
  _inst_name->setVisible(True);
  WSCprocedure* psbtop34 = new WSCprocedure("psbtop34",WSEV_ACTIVATE);
  psbtop34->setFunction(_vifi_work,"_vifi_work");
  _inst_name->addProcedure(psbtop34);

  WSCprocedure* psbtop34_2= new WSCprocedure("psbtop35",WSEV_FOCUS_CH);
  psbtop34_2->setFunction(_vifi_work,"_vifi_work");
  _inst_name->addProcedure(psbtop34_2);


  WSCvlabel* pslb10 = new WSCvlabel(this,"pslb10");
  pslb10->initialize();
  pslb10->setInternalObject(True);
  WSGFsetGeometry(pslb10,5,299,90,20);
  pslb10->setPropertyV(WSNlabelString, WSGFgettext("g3:WSSTR File name"));
  pslb10->setVisible(True);
  WSGFsetMargin(pslb10,0);

  _file_name = new WSCvifield(this,"psif10");
  _file_name->initialize();
  _file_name->setInternalObject(True);
  WSGFsetGeometry(_file_name,110,299,150,20);
  _set_ifd(_file_name);
  _file_name->setUserData("WINEDIT",(void*)this);
  _file_name->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
  _file_name->setVisible(True);
  WSCprocedure* psbtop36 = new WSCprocedure("psbtop34",WSEV_ACTIVATE);
  psbtop36->setFunction(_vifi_work,"_vifi_work");
  _file_name->addProcedure(psbtop36);

  WSCprocedure* psbtop35 = new WSCprocedure("psbtop35",WSEV_FOCUS_CH);
  psbtop35->setFunction(_vifi_work,"_vifi_work");
  _file_name->addProcedure(psbtop35);

  WSCvlabel* pssp5 = new WSCvlabel(this,"pssp4");
  _set_sp(pssp5);
  pssp5->setPropertyV(WSNy,(short)324);
  pssp5->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  pssp5->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  pssp5->setVisible(True);

  WSCvlabel* pslb8 = new WSCvlabel(this,"pslb8");
  pslb8->initialize();
  pslb8->setInternalObject(True);
  WSGFsetGeometry(pslb8,5,330,90,20);
  pslb8->setPropertyV(WSNlabelString, WSGFgettext("h3:WSSTR Access"));
  pslb8->setVisible(True);
  WSGFsetMargin(pslb8,0);

//  _vartg = new WSCvtoggle(this,"pstg1");
  _vartg = new WSCvradio(this,"pstg1");
  _vartg->initialize();
  _vartg->setInternalObject(True);
  WSGFsetGeometry(_vartg,100,330,200,19);
  _vartg->setPropertyV(WSNmarginTop, (WSCuchar)0);
  _vartg->setPropertyV(WSNmarginBottom, (WSCuchar)0);
  _vartg->setPropertyV(WSNmarginLeft, (WSCuchar)10);
  _vartg->setPropertyV(WSNalignmentH, (WSCuchar)WS_LEFT);
//  _vartg->setPropertyV(WSNindicatorPixmap,WS_TG1_PIX);
//  _vartg->setPropertyV(WSNselectPixmap,WS_TG2_PIX);
//  _vartg->setPropertyV(WSNindicatorType,WS_IN);
  _vartg->setPropertyV(WSNindicatorSize,(WSCuchar)16);
//  _vartg->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _vartg->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  _vartg->setPropertyV(WSNunique,(WSCbool)True);
  _vartg->setUserData("WINEDIT",(void*)this);
  _vartg->setPropertyV(WSNemboss,(WSCbool)True);
  _vartg->setPropertyV(WSNlabelString, WSGFgettext("i3:WSSTR Global variable"));
  _vartg->setVisible(True);

  WSCprocedure* pschop2 = new WSCprocedure("pschop2",WSEV_VALUE_CH);
  pschop2->setFunction(_vartg_work,"_vartg_work");
  _vartg->addProcedure(pschop2);
  _vartg->setVisible(True);

  WSCvlabel* pslb9 = new WSCvlabel(this,"pslb9");
  pslb9->initialize();
  pslb9->setInternalObject(True);
  WSGFsetGeometry(pslb9,5,355,90,20);
  pslb9->setPropertyV(WSNlabelString, WSGFgettext("j3:WSSTR Project"));
  pslb9->setVisible(True);
  WSGFsetMargin(pslb9,0);

//  _prjtg = new WSCvtoggle(this,"pstg1");
  _prjtg = new WSCvradio(this,"pstg1");
  _prjtg->initialize();
  _prjtg->setInternalObject(True);
  WSGFsetGeometry(_prjtg,100,355,250,19);
  _prjtg->setPropertyV(WSNmarginTop, (WSCuchar)0);
  _prjtg->setPropertyV(WSNmarginBottom, (WSCuchar)0);
  _prjtg->setPropertyV(WSNmarginLeft, (WSCuchar)10);
  _prjtg->setPropertyV(WSNalignmentH, (WSCuchar)WS_LEFT);
//  _prjtg->setPropertyV(WSNindicatorPixmap,WS_TG1_PIX);
//  _prjtg->setPropertyV(WSNselectPixmap,WS_TG2_PIX);
//  _prjtg->setPropertyV(WSNindicatorType,WS_IN);
  _prjtg->setPropertyV(WSNindicatorSize,(WSCuchar)16);
//  _prjtg->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _prjtg->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  _prjtg->setPropertyV(WSNunique,(WSCbool)True);
  _prjtg->setUserData("WINEDIT",(void*)this);
  _prjtg->setPropertyV(WSNemboss,(WSCbool)True);
  _prjtg->setPropertyV(WSNlabelString, WSGFgettext("k3:WSSTR Belong to this project"));
  _prjtg->setVisible(True);

  WSCprocedure* pschop3 = new WSCprocedure("pschop3",WSEV_VALUE_CH);
  pschop3->setFunction(_prjtg_work,"_prjtg_work");
  _prjtg->addProcedure(pschop3);
  _prjtg->setVisible(True);


  WSCvlabel* pslb11 = new WSCvlabel(this,"pslb11");
  pslb11->initialize();
  pslb11->setInternalObject(True);
  WSGFsetGeometry(pslb11,5,380,90,20);
  pslb11->setPropertyV(WSNlabelString, WSGFgettext("j3:WSSTR RemoteClass"));
  pslb11->setVisible(True);
  WSGFsetMargin(pslb11,0);

//  _rctg = new WSCvtoggle(this,"rctg1");
  _rctg = new WSCvradio(this,"rctg1");
  _rctg->initialize();
  _rctg->setInternalObject(True);
  WSGFsetGeometry(_rctg,100,380,350,19);
  _rctg->setPropertyV(WSNmarginTop, (WSCuchar)0);
  _rctg->setPropertyV(WSNmarginBottom, (WSCuchar)0);
  _rctg->setPropertyV(WSNmarginLeft, (WSCuchar)10);
  _rctg->setPropertyV(WSNalignmentH, (WSCuchar)WS_LEFT);
//  _rctg->setPropertyV(WSNindicatorPixmap,WS_TG1_PIX);
//  _rctg->setPropertyV(WSNselectPixmap,WS_TG2_PIX);
//  _rctg->setPropertyV(WSNindicatorType,WS_IN);
  _rctg->setPropertyV(WSNindicatorSize,(WSCuchar)16);
//  _rctg->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _rctg->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  _rctg->setPropertyV(WSNunique,(WSCbool)True);
  _rctg->setUserData("WINEDIT",(void*)this);
  _rctg->setPropertyV(WSNemboss,(WSCbool)True);
  _rctg->setPropertyV(WSNlabelString, WSGFgettext("k3:WSSTR Generates the virtual remote class"));
  _rctg->setVisible(True);

  WSCprocedure* pschop4 = new WSCprocedure("pschop4",WSEV_VALUE_CH);
  pschop4->setFunction(_rctg_work,"_rctg_work");
  _rctg->addProcedure(pschop4);
  _rctg->setVisible(True);


  _cpe = new WSCclassPropEditor(NULL,(WSCstring)"is-cpe-" + getInstanceName());
  _cpe->setInternalObject(True);
  _cpe->initialize();
  _cpe->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _cpe->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cpe->setUserData("inspector",this);

  _cute = new WSCclassUTrgEditor(NULL,(WSCstring)"is-cute-" + getInstanceName());
  _cute->setInternalObject(True);
  _cute->initialize();
  _cute->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _cute->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cute->setUserData("inspector",this);

  _cte = new WSCtriggerEditor(NULL,(WSCstring)"is-cte-" + getInstanceName());
  _cte->setInternalObject(True);
  _cte->initialize();
  _cte->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _cte->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cte->setUserData("inspector",this);

  _crme = new WSCclassRMethodEditor(NULL,(WSCstring)"is-crme-" + getInstanceName());
  _crme->setInternalObject(True);
  _crme->initialize();
  _crme->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _crme->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _crme->setUserData("inspector",this);


  _msg = new WSCmessageDialog(NULL,"wl-md");
  _msg->initialize();
  WSGFsetGeometry(_msg,300,300,400,120);
  _msg->setPropertyV(WSNtitleString,"Warring");
  _msg->setPropertyV(WSNmodal,(WSCbool)True);
  _msg->setPropertyV(WSNdefaultPosition,(WSCbool)True);

//  WSGIappObjectList()->addEvent(this,WSEV_GUI_POLICY_CH);

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  return WS_NO_ERR;
}

void WSCwindowEditor::setEditClient(WSCbase* client){
  if (_client != client){
     _client = client;
     _cpe->setPropertyV(WSNclient,(void*)_client);
  }
  if (_client == NULL){
    _pstg1->setGroupValue(1);
    _cname->setPropertyV(WSNlabelString,"");
    _class_icon->setPropertyV(WSNlabelString,"");
    _class_cmmt->setPropertyV(WSNlabelString,"");
    _class_base->setPropertyV(WSNlabelString,"");
    _inst_name->setPropertyV(WSNlabelString,"");
    _file_name->setPropertyV(WSNlabelString,"");
    _vartg->setStatus(0);
    _vartg->setStatus(0);
    return;
  }

  _cname->setPropertyV(WSNlabelString,_client->getClassName());

  char* cfname = (char*)_client->getUserData(WS_FILENAME);
  if (cfname != NULL){
    _file_name->setPropertyV(WSNlabelString,cfname);
  }else{
    _file_name->setPropertyV(WSNlabelString,"");
  }


  WSCbase* win = _client->getParentWindow();

  if (_client->getParent()== NULL){ //top window
    _pstg1->setSensitive(True);
    _pstg2->setSensitive(True);
    _pstg3->setSensitive(True);
    _vartg->setSensitive(False);
  }else{
    _pstg1->setSensitive(False);
    _pstg2->setSensitive(False);
    _pstg3->setSensitive(False);
    _vartg->setSensitive(True);
  }

  _vartg->setPropertyV(WSNlabelString,WSGFgettext("i3:WSSTR Global variable"));
  pslb6->setProperty(WSNlabelString,WSGFgettext("e3:WSSTR Base"));
  if (win->getUserData(WS_WIN_CLASS)){
    //classwin
    _vartg->setPropertyV(WSNlabelString,WSGFgettext("l3:WSSTR Member"));
    _pstg1->setGroupValue(2);
    if (_client->getParent()== NULL){ //top window
      _psbt1->setSensitive(True);
      _psbt2->setSensitive(True);
      _psbt3->setSensitive(True);
      _rctg->setSensitive(True);
      if (win->getUserData(WS_RCLASS_GENERATE)){
        _psbt4->setSensitive(True);
      }else{
        _psbt4->setSensitive(False);
      }
      _class_icon->setSensitive(True);
      _class_cmmt->setSensitive(True);
      _class_base->setSensitive(True);
      _class_icon->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
      _class_cmmt->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
      _class_base->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    }else{
      _psbt1->setSensitive(False);
      _psbt2->setSensitive(False);
      _psbt3->setSensitive(False);
      _psbt4->setSensitive(False);
      _rctg->setSensitive(False);
      _class_icon->setSensitive(False);
      _class_cmmt->setSensitive(False);
      _class_base->setSensitive(False);
      _class_icon->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
      _class_cmmt->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
      _class_base->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    }
  }else if (win->getUserData(WS_WIN_STORE)){
    //storewin
    _psbt1->setSensitive(False);
    _psbt2->setSensitive(False);
    _psbt3->setSensitive(False);
    _psbt4->setSensitive(False);
    _vartg->setSensitive(False);
    _rctg->setSensitive(True);
    _pstg1->setGroupValue(3);
    _class_icon->setSensitive(False);
    _class_cmmt->setSensitive(False);
    _class_base->setSensitive(True);
    _class_icon->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _class_cmmt->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _class_base->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
    pslb6->setProperty(WSNlabelString,WSGFgettext("E3:WSSTR Base"));
  }else{
    //win
    _psbt1->setSensitive(False);
    _psbt2->setSensitive(False);
    _psbt3->setSensitive(False);
    _psbt4->setSensitive(False);
    _rctg->setSensitive(False);
    _pstg1->setGroupValue(1);
    _class_icon->setSensitive(False);
    _class_cmmt->setSensitive(False);
    _class_base->setSensitive(False);
    _class_icon->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _class_cmmt->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _class_base->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  }
  _psbt1->redraw();
  _psbt2->redraw();
  _psbt3->redraw();


  if (_client->getUserData(WS_EXT_VAR)){
    _vartg->setStatus(1);
  }else{
    _vartg->setStatus(0);
  }
  if (_client->getUserData(WS_REGISTERED)){
    _prjtg->setStatus(1);
  }else{
    _prjtg->setStatus(0);
  }
  if (_client->getUserData(WS_RCLASS_GENERATE)){
    _rctg->setStatus(1);
  }else{
    _rctg->setStatus(0);
  }

  if (win != _client){
    _prjtg->setSensitive(False);
    _rctg->setSensitive(False);
    _file_name->setSensitive(False);
    _file_name->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  }else{
    _prjtg->setSensitive(True);
    _file_name->setSensitive(True);
    _file_name->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
  }

  char* cicon = (char*)_client->getUserData(WS_CLASS_ICON);
  if (cicon != NULL){
    _class_icon->setPropertyV(WSNlabelString,cicon);
  }else{
    _class_icon->setPropertyV(WSNlabelString,"");
  }

  char* ccom = (char*)_client->getUserData(WS_CLASS_COMMENT);
  if (ccom != NULL){
    _class_cmmt->setPropertyV(WSNlabelString,ccom);
  }else{
    _class_cmmt->setPropertyV(WSNlabelString,"");
  }

  char* cbase = (char*)_client->getUserData(WS_WIN_CLASS_BASE);
  if (cbase != NULL){
    _class_base->setPropertyV(WSNlabelString,cbase);
  }else{
    _class_base->setPropertyV(WSNlabelString,"");
  }

  _inst_name->setPropertyV(WSNlabelString,_client->getInstanceName());
}

WSCbase* WSCwindowEditor::getEditClient(){
  return _client;
}

//long WSCwindowEditor::execEventProc(long ev,void* data){
//  return WSCscrForm::execEventProc(ev,data);
//}

void WSCwindowEditor::_adjust(){
  WSCscrForm::_adjust();
}
WSCbool WSCwindowEditor::getEditable(){
  return _editable;
}
void WSCwindowEditor::setEditable(WSCbool fl){
  if (fl == False){
    _editable = 0;
    _pstg1->setSensitive(False);
    _pstg2->setSensitive(False);
    _pstg3->setSensitive(False);
    _class_icon->setSensitive(False);
    _class_cmmt->setSensitive(False);
    _class_base->setSensitive(False);
    _class_icon->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _class_cmmt->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _class_base->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    _psbt1->setSensitive(False);
    _psbt2->setSensitive(False);
    _psbt3->setSensitive(False);
    _psbt4->setSensitive(False);
    _rctg->setSensitive(False);
  }else{
    _editable = 1;
    setEditClient(_client);
  }
}
void WSCwindowEditor::onGuiPolicyChange(long policy){
  if (_psbt1 != NULL){
WSMFtrace("WSCwindowEditor::onGuiPolicyChange policy=0x%x\n",policy);
    WSCscrForm::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_GRADATION){
      _psbt1->setProperty(WSNgradation,WS_GR_T_B);
      _psbt2->setProperty(WSNgradation,WS_GR_T_B);
      _psbt3->setProperty(WSNgradation,WS_GR_T_B);
      _psbt4->setProperty(WSNgradation,WS_GR_T_B);
    }else{
      _psbt1->setProperty(WSNgradation,WS_GR_NONE);
      _psbt2->setProperty(WSNgradation,WS_GR_NONE);
      _psbt3->setProperty(WSNgradation,WS_GR_NONE);
      _psbt4->setProperty(WSNgradation,WS_GR_NONE);
    }
    if (policy & WS_POLICY_OTHER){
      setProperty(WSNshadowThickness,1);
    }else
    if (policy & WS_POLICY_ORIGINAL){
      setProperty(WSNshadowThickness,1);
    }else{
      setProperty(WSNshadowThickness,2);
    }
  }
}
