//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCconductor.h>
#include <WSCserializeData.h>
#include <WSDsocketSerialize.h>

#define WS_SRL_TYPE "SOCKET"

WSMFclassInit(WSDsocketSerialize,WSDserialize);

class  _sserialize_init {
  public:
  _sserialize_init(){
    WSGIconductor()->addSerialize(new WSDsocketSerialize);
  };
};
static _sserialize_init _sserialize_init_execute;

WSDsocketSerialize::WSDsocketSerialize(){
  _use_socket = True;
  _sock = NULL;
  _sock2 = NULL;
//printf("WSDsocketSerialize::WSDsocketSerialize()...\n");
}
WSDsocketSerialize::~WSDsocketSerialize(){}

void WSDsocketSerialize::setSocket(WSDsocket* sock){
  _sock = sock;
}
void WSDsocketSerialize::setSocket(void* sock){
  _sock2 = sock;
}

long WSDsocketSerialize::beginTransaction(char*){
  return WS_NO_ERR;
}
long WSDsocketSerialize::endTransaction(){
  return WS_NO_ERR;
}
long WSDsocketSerialize::_open(char* name,long mode){
  return WS_NO_ERR;
}
long WSDsocketSerialize::_close(){
  return WS_NO_ERR;
}
long WSDsocketSerialize::_read(void* buf,long len){
  if (len < 1){
    return 0;
  }
  if (_sock != NULL){
    if (_sock2 != NULL){
//printf("WSDsocketSerialize::_read()2 len=%d\n",len);
      return _sock->read(_sock2,(WSCuchar*)buf,len);
    }else{
//printf("WSDsocketSerialize::_read()1 len=%d\n",len);
      return _sock->read((WSCuchar*)buf,len);
    }
  }
  return 0;
}
long WSDsocketSerialize::_write(void* buf,long len){
  if (_sock != NULL){
    if (_sock2 != NULL){
//printf("WSDsocketSerialize::_write()2 len=%d\n",len);
      return _sock->write(_sock2,(WSCuchar*)buf,len);
    }else{
//printf("WSDsocketSerialize::_write()1 len=%d\n",len);
      return _sock->write((WSCuchar*)buf,len);
    }
  }
  return 0;
}
long WSDsocketSerialize::_tell(){
  return 0;
}
long WSDsocketSerialize::_size(){
  return 0;
}
long WSDsocketSerialize::_seek(long addr){
  return WS_NO_ERR;
}
long WSDsocketSerialize::_seek_end(){
  return WS_NO_ERR;
}
long WSDsocketSerialize::_seek_set(){
  return WS_NO_ERR;
}
long WSDsocketSerialize::_eof(){
  return 0;
}
WSCbool WSDsocketSerialize::type(char* tp){
  if ( !strcmp(tp,WS_SRL_TYPE) ){
    return True;
  }else{
    return False;
  }
}
WSDserialize* WSDsocketSerialize::createSerialize(){
  return new WSDsocketSerialize;
}
