//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <basic.h>
#include <btron/WSDbtronMouse.h>
#include <btron/WSDbtronAppDev.h>
#include <btron/WSDbtronFormDev.h>
#include <btron/WSDbtronColor.h>
#include <WSCbase.h>
#include <WSCcolorSet.h>
#include <WSDfileSystem.h>

WSMFclassInit(WSDbtronMouse,WSDmouse);

WSDmouse* _btronMouse_create_handler(){
dbprintf("_btronMouse_create_handler() %s:%d started..\n",__FILE__,__LINE__);
  return new WSDbtronMouse();
}

class _btronMouse_init{
  public: _btronMouse_init(){
dbprintf("_btronMouse_init() %s:%d started..\n",__FILE__,__LINE__);
    WSDmouse::setCreateInstanceHandler(_btronMouse_create_handler);
  };
};

_btronMouse_init _btronMouse_init_run_constructor;


WSDbtronMouse* WSGIbtronAppMouse(){
  WSDmouse* mouse = WSGIappMouse();
  if (mouse == NULL){
    return NULL;
  }
  WSDbtronMouse* btronMouse =(WSDbtronMouse*)mouse->cast("WSDbtronMouse");
  return btronMouse;

}
char* dmnames[]={
"0   PS_SELECT black white",
"195 PS_RSIZ black white",
"197 PS_VRSIZ black white",
"196 PS_RSIZ black white",
"176 PS_HRSIZ black white",
"135 PS_RSIZ black white",
"136 PS_VRSIZ black white",
"134 PS_RSIZ black white",
"163 PS_HRSIZ black white",
"154 PS_RSIZ black white",
"186 PS_VRSIZ black white",
"182 PS_HRSIZ black white",
NULL
};

WSDbtronMouse::WSDbtronMouse(){}
WSDbtronMouse::~WSDbtronMouse(){}

void WSDbtronMouse::resetMouseCursors(){
  long cnt = 0;
  while(1){
    long id = getMouseCursorId(cnt);
    if (id == 0){
      cnt++;
    }else if (id > -1){
      delMouseCursor(cnt);
    }else{
      break;
    }
  }
}

void WSDbtronMouse::setMouseCursor(long mno){}
void WSDbtronMouse::initialize(){
  long num = 0;
  while(dmnames[num] != NULL){
    WSGIbtronAppMouse()->setupMouseCursor(dmnames[num]);
    num++;
  };
}


void WSDbtronMouse::setupMouseCursor(char* data){
  long id;
  char img1[1024];
  char forec[64];
  char backc[64];
  sscanf(data,"%d %s %s %s",&id,img1,forec,backc);
  long img = 0;
  if (!strcmp("PS_SELECT",img1)){
    img = PS_SELECT;
  }else
  if (!strcmp("PS_MODIFY",img1)){
    img = PS_MODIFY;
  }else
  if (!strcmp("PS_MOVE",img1)){
    img = PS_MOVE;
  }else
  if (!strcmp("PS_VMOVE",img1)){
    img = PS_VMOVE;
  }else
  if (!strcmp("PS_HMOVE",img1)){
    img = PS_HMOVE;
  }else
  if (!strcmp("PS_GRIP",img1)){
    img = PS_GRIP;
  }else
  if (!strcmp("PS_VGRIP",img1)){
    img = PS_VGRIP;
  }else
  if (!strcmp("PS_HGRIP",img1)){
    img = PS_HGRIP;
  }else
  if (!strcmp("PS_RSIZ",img1)){
    img = PS_RSIZ;
  }else
  if (!strcmp("PS_VRSIZ",img1)){
    img = PS_VRSIZ;
  }else
  if (!strcmp("PS_HRSIZ",img1)){
    img = PS_HRSIZ;
  }else
  if (!strcmp("PS_PICK",img1)){
    img = PS_PICK;
  }else
  if (!strcmp("PS_VPICK",img1)){
    img = PS_VPICK;
  }else
  if (!strcmp("PS_HPICK",img1)){
    img = PS_HPICK;
  }else
  if (!strcmp("PS_BUSY",img1)){
    img = PS_BUSY;
  }else
  if (!strcmp("PS_MENU",img1)){
    img = PS_MENU;
  }
  WSDcolor* fg = WSGIappColorSet()->getColor(forec);
  WSDcolor* bg = WSGIappColorSet()->getColor(backc);
  _btron_mouse_value* val = new _btron_mouse_value;
  val->_style = img;
  val->_fg = fg->getValue1();
  val->_bg = bg->getValue1();
  addMouseCursor(id,(long)val,data);
}
long WSDbtronMouse::getDefaultMouseCursor(){
static _btron_mouse_value* _default_mouse = NULL;
  if (_default_mouse == NULL){
    WSDcolor* fg = WSGIappColorSet()->getColor("black");
    WSDcolor* bg = WSGIappColorSet()->getColor("white");
    _btron_mouse_value* val = new _btron_mouse_value;
    val->_style = PS_SELECT;
    val->_fg = fg->getValue1();
    val->_bg = bg->getValue1();
    _default_mouse = val;
  }
  return (long)_default_mouse;
}


W WSDbtronMouse::getCurrentMouseWindow(){
  PNT pt;
  PTRSTS sts;
  gget_ptr(&sts,NULL);
  pt = sts.pos;

  W w;
  wfnd_wnd(&pt,NULL,&w);
  return w;
}

WSCbool WSDbtronMouse::getMousePosition(short* ox,short* oy){
  PTRSTS st;
  W ret = gget_ptr(&st,NULL);
  if (ret >= 0){
    *ox = st.pos.x;
    *oy = st.pos.y;
    return True;
  }else{
    *ox = 0;
    *oy = 0;
    return 0;
  }
}


WSCbool WSDbtronMouse::getMousePosition(short* ox,short* oy,WSCbase* client){
  *ox = 0;
  *oy = 0;
  if (client == NULL){
    return False;
  }
  WSDdev* dev = client->getdev();
  if (dev == NULL){
    *ox = 0;
    *oy = 0;
    return False;
  }

  short gx,gy;
  if (!getMousePosition(&gx,&gy)){
    return False;
  }
  WSDbtronFormDev* wdev = (WSDbtronFormDev*)dev->cast("WSDbtronFormDev");
  WSCbool parent = False;
  if (wdev == NULL){
    WSDdev* pdev = dev->getParentDev();
    if (pdev != NULL){
      parent = True;
      wdev = (WSDbtronFormDev*)pdev->cast("WSDbtronFormDev");
    }else{
      return False;
    }
  }
  if (wdev == NULL){
    return False;
  }
  PNT pt;
  pt.x = gx;  
  pt.y = gy;  
  gcnv_rel(wdev->getParentGID(),&pt);
//  short diffx = 0;
//  short diffy = 0;
  short dx,dy;
  wdev->getAbstPos(&dx,&dy);
//  *ox = gx - dx - rect.c.left - diffx;
//  *oy = gy - dy - rect.c.top - diffy;
  if (parent == False){
    *ox = pt.x - dx;
    *oy = pt.y - dy;
  }else{
    short px,py;
    client->getPropertyV(WSNx,&px);
    client->getPropertyV(WSNy,&py);

    *ox = pt.x - dx - px;
    *oy = pt.y - dy - py;
  }
//dbprintf("WSDbtronMouse::getMousePoint() %s %d,%d\n",client->getInstanceName(),*ox,*oy);
  return True;
}

long WSDbtronMouse::getMouseStatus(){
#if 0
   int x,y,dx,dy;
   Window dr,dc;
   WSCuint ds;
   XQueryPointer(WSGIxwinAppDev()->display(),
                 DefaultRootWindow(WSGIxwinAppDev()->display()),
                 &dr,&dc,&dx,&dy,&x,&y,&ds);
   return ds;
#endif
   return getStatus();
}

void WSDbtronMouse::setMousePosition(short x,short y){
#if 0
  XWarpPointer(WSGIxwinAppDev()->display(),None,
       DefaultRootWindow(WSGIxwinAppDev()->display()),0,0,0,0,x,y);
#endif
}


