/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.TreeSet;
import jp.ac.dendai.cdl.mori.wikie.io.XMLInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class WikIE
extends Configured
implements Tool {
    public static final String MAPRED_CONF_FILE_PATH = "mapred.conf";
    public static final String LANG_DAT = "wiki_lang.dat";
    public static final String PROJECT_DAT = "wiki_project.dat";
    public static final String ENTRY = "entry";
    public static final String LEAF = "leaf";
    public static final String NODE = "node";
    public static final String EDGE = "edge";
    public static final String OTHER = "other";
    public static final String TARGET = "target";
    public static final String REDIRECT = "redirect";
    public static final String HYPERNYM = "hypernym";
    public static final String UTF8 = "UTF8";
    public static final String MEDIAWIKI_ELEMENT = "mediawiki";
    public static final String BASE_ELEMENT = "base";
    public static final String NAMESPACES_ELEMENT = "namespaces";
    public static final String NAMESPACE_ELEMENT = "namespace";
    public static final String PAGE_ELEMENT = "page";
    public static final String TITLE_ELEMENT = "title";
    public static final String ID_ELEMENT = "id";
    public static final String REVISION_ELEMENT = "revision";
    public static final String TIMESTAMP_ELEMENT = "timestamp";
    public static final String CONTRIBUTOR_ELEMENT = "contributor";
    public static final String USERNAME_ELEMENT = "username";
    public static final String IP_ELEMENT = "ip";
    public static final String TEXT_ELEMENT = "text";
    public static final String KEY_ATTRIBUTE = "key";
    public static final int LEAF_KIND = 1;
    public static final int NODE_KIND = 2;
    public static final int REDIRECT_KIND = 3;
    public static final int HYPERNYM_KIND = 4;
    public static int ARTICLE_NS_NUM = 0;
    public static int IMAGE_NS_NUM = 6;
    public static int CATEGORY_NS_NUM = 14;
    public static final String PROP_START_TAG = "wikie.io.startTag";
    public static final String PROP_END_TAG = "wikie.io.endTag";
    public static final String PROP_RESOURCE = "wikie.map.resource";
    public static final String PROP_FUNC = "wikie.job.func";
    public static final String PROP_ISBN_HEADER = "wikie.map.isbnheader";
    public static final String PROP_PROJECT = "wikie.project";
    public static final String PROP_LANG = "wikie.lang";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new WikIE(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        JobConf conf = this.createJobConf(args);
        if (conf != null) {
            JobClient.runJob((JobConf)conf);
            return 0;
        }
        return -1;
    }

    public JobConf createJobConf(String[] args) throws IOException, ClassNotFoundException {
        JobConf conf = new JobConf(WikIE.class);
        if (args.length >= 3) {
            conf.set(PROP_FUNC, args[0]);
            conf.setInputFormat(XMLInputFormat.class);
            conf.setOutputFormat(TextOutputFormat.class);
            conf.setOutputKeyClass(Text.class);
            conf.setOutputValueClass(Text.class);
            FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(args[1])});
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(args[2]));
            conf.set(PROP_RESOURCE, args[1]);
            conf.set(PROP_START_TAG, PAGE_ELEMENT);
            conf.set(PROP_END_TAG, PAGE_ELEMENT);
            conf.set(PROP_PROJECT, WikIE.createProjectSet(PROJECT_DAT));
            conf.set(PROP_LANG, WikIE.createProjectSet(LANG_DAT));
            if (args.length >= 4) {
                try {
                    conf.setNumReduceTasks(Integer.parseInt(args[3]));
                }
                catch (NumberFormatException e) {
                    System.out.println("reduce\u30bf\u30b9\u30af\u6570\u306f\u6574\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return null;
                }
            }
            if (!this.setMapRed(conf, MAPRED_CONF_FILE_PATH)) {
                return null;
            }
            return conf;
        }
        this.printFunc(MAPRED_CONF_FILE_PATH);
        return null;
    }

    private boolean setMapRed(JobConf conf, String confFilePathStr) throws IOException, ClassNotFoundException {
        String func = conf.get(PROP_FUNC);
        FileInputStream is = new FileInputStream(new File(confFilePathStr));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, UTF8));
        String line = new String();
        TreeSet<String> funcSet = new TreeSet<String>();
        while ((line = reader.readLine()) != null) {
            String[] column = line.split("\t");
            funcSet.add(column[0]);
            if (!column[0].equals(func)) continue;
            Class<?> mapper = Class.forName(column[1]);
            Class<?> reducer = Class.forName(column[2]);
            conf.setMapperClass(mapper);
            conf.setReducerClass(reducer);
            reader.close();
            return true;
        }
        reader.close();
        this.printFunc(confFilePathStr);
        return false;
    }

    private void printFunc(String confFilePathStr) throws IOException {
        FileInputStream is = new FileInputStream(new File(confFilePathStr));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, UTF8));
        String line = new String();
        System.out.println("\u4ee5\u4e0b\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u5b9f\u884c\u53ef\u80fd\u3067\u3059\u3002");
        while ((line = reader.readLine()) != null) {
            String[] column = line.split("\t");
            System.out.println(column[0]);
        }
        reader.close();
        System.out.println("Wik-IE\u306b\u306f\u6b21\u306e\u3088\u3046\u306b\u5f15\u6570\u3092\u4e0e\u3048\u3066\u304f\u3060\u3055\u3044\uff08Reduce\u30bf\u30b9\u30af\u6570\u306f\u7701\u7565\u53ef\uff09\u3002");
        System.out.println("\u6a5f\u80fd \u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9 \u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30d1\u30b9 Reduce\u30bf\u30b9\u30af\u6570");
    }

    public static String createProjectSet(String projectConfFilePath) throws UnsupportedEncodingException, IOException {
        StringBuffer result = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(projectConfFilePath)), UTF8));
        String line = new String();
        while ((line = reader.readLine()) != null) {
            result.append(String.valueOf(line.trim()) + "\t");
        }
        reader.close();
        return result.toString().trim();
    }

    public static String createlangSet(String langConfFilePath) throws UnsupportedEncodingException, IOException {
        StringBuffer result = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(langConfFilePath)), UTF8));
        String line = new String();
        while ((line = reader.readLine()) != null) {
            result.append(String.valueOf(line.trim()) + "\t");
        }
        reader.close();
        return result.toString().trim();
    }
}

