/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.util;

import info.bliki.wiki.filter.WikipediaParser;
import info.bliki.wiki.model.WikiModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ac.dendai.cdl.mori.wikie.main.WikIE;
import jp.ac.dendai.cdl.mori.wikie.util.WEntry;
import jp.ac.dendai.cdl.mori.wikie.util.WLink;
import jp.ac.dendai.cdl.mori.wikie.util.WNormalizer;
import org.apache.commons.lang.StringUtils;

public class WLinkUtils {
    private WNormalizer normalizer;
    private WikiModel wmodel;

    public WLinkUtils(WNormalizer normalizer) {
        this.normalizer = normalizer;
        this.wmodel = new WikiModel(String.valueOf(normalizer.getBaseURL()) + "${image}", String.valueOf(normalizer.getBaseURL()) + "${title}");
    }

    public List<String> getDoubleBracket(String text) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\[\\[(.+?)\\]\\]");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String entry = matcher.group(1).trim();
            if (!StringUtils.isNotBlank(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    public List<WEntry> getCategory(String text) {
        ArrayList<WEntry> result = new ArrayList<WEntry>();
        for (String link : this.getDoubleBracket(text)) {
            try {
                WEntry linkEntry;
                if (link.charAt(0) == ':' || (linkEntry = this.normalizer.normalize(StringUtils.splitPreserveAllTokens(link, "\\|")[0])).getNsNumber() != WikIE.CATEGORY_NS_NUM || !StringUtils.isNotBlank(linkEntry.toString())) continue;
                result.add(linkEntry);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }

    public List<WLink> getLink(String text) {
        ArrayList<WLink> result = new ArrayList<WLink>();
        Iterator<String> linkItr = this.getDoubleBracket(text).iterator();
        while (linkItr.hasNext()) {
            WEntry entry;
            String[] section;
            WLink wLink = new WLink();
            String[] anchor = linkItr.next().split("\\|");
            if (anchor.length == 2) {
                wLink.setAnchorText(anchor[1].trim());
            }
            if ((section = anchor[0].split("#")).length == 2) {
                wLink.setSection(WNormalizer.decodeSectionLink(section[1].trim()));
            }
            if ((entry = this.normalizer.normalize(section[0].trim())).getNsNumber() != WikIE.ARTICLE_NS_NUM && (entry.getNsNumber() != WikIE.CATEGORY_NS_NUM || section[0].charAt(0) != ':') || !StringUtils.isBlank(entry.getLang()) || !StringUtils.isBlank(entry.getProject())) continue;
            wLink.setEntry(entry);
            result.add(wLink);
        }
        return result;
    }

    public List<WLink> getInterLangLink(String text) {
        ArrayList<WLink> result = new ArrayList<WLink>();
        for (String link : this.getDoubleBracket(text)) {
            WEntry entry;
            if (link.indexOf(":") <= 0 || !StringUtils.isNotBlank((entry = this.normalizer.normalize(link)).getLang())) continue;
            result.add(new WLink(entry, "", ""));
        }
        return result;
    }

    public String getKind(WEntry entry, String text) {
        int ns = entry.getNsNumber();
        String kind = "other";
        if (ns == WikIE.ARTICLE_NS_NUM) {
            WEntry redirect = this.isRedirect(text);
            kind = redirect != null ? "redirect" : "leaf";
        } else if (ns == WikIE.CATEGORY_NS_NUM) {
            kind = "node";
        }
        return kind;
    }

    public WEntry isRedirect(String text) {
        String target = WikipediaParser.parseRedirect(text, this.wmodel);
        if (StringUtils.isNotBlank(target)) {
            return this.normalizer.normalize(target);
        }
        return null;
    }
}

