/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner.util;

import java.io.IOException;
import java.util.List;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHtmlExtractor<T> {
    final T fResultObject;

    public AbstractHtmlExtractor(T resultObject) {
        this.fResultObject = resultObject;
    }

    protected abstract void appendContent(List var1);

    protected abstract boolean isFound(TagNode var1);

    protected T getResultObject() {
        return this.fResultObject;
    }

    protected void visitTokenList(List nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            for (Object item : nodes) {
                if (item == null) continue;
                if (item instanceof List) {
                    this.visitTokenList((List)item);
                    continue;
                }
                if (!(item instanceof BaseToken)) continue;
                this.visitBaseToken((BaseToken)item);
            }
        }
    }

    protected void visitBaseToken(BaseToken node) {
        if (node instanceof TagNode) {
            TagNode tagNode = (TagNode)node;
            if (this.isFound(tagNode)) {
                this.appendContent(tagNode.getChildren());
            } else {
                List children = tagNode.getChildren();
                if (children.size() != 0) {
                    this.visitTokenList(children);
                }
            }
        }
    }

    public void extractContent(String html) {
        HtmlCleaner cleaner = null;
        try {
            cleaner = new HtmlCleaner(html);
            cleaner.clean();
            TagNode body = cleaner.getBodyNode();
            this.visitBaseToken(body);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

