/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.expr.eval;

import info.bliki.wiki.template.expr.Parser;
import info.bliki.wiki.template.expr.SyntaxError;
import info.bliki.wiki.template.expr.ast.ASTNode;
import info.bliki.wiki.template.expr.ast.FunctionNode;
import info.bliki.wiki.template.expr.ast.NumberNode;
import info.bliki.wiki.template.expr.ast.SymbolNode;
import info.bliki.wiki.template.expr.eval.DoubleNode;
import info.bliki.wiki.template.expr.eval.IBooleanBoolean1Function;
import info.bliki.wiki.template.expr.eval.IBooleanBoolean2Function;
import info.bliki.wiki.template.expr.eval.IBooleanDouble2Function;
import info.bliki.wiki.template.expr.eval.IDouble0Function;
import info.bliki.wiki.template.expr.eval.IDouble1Function;
import info.bliki.wiki.template.expr.eval.IDouble2Function;
import info.bliki.wiki.template.expr.eval.IDoubleFunction;
import java.util.HashMap;
import java.util.Map;

public class DoubleEvaluator {
    public static double EPSILON = 1.0E-17;
    public static double EPSILON_ROUND = 1.0E-15;
    Double bd;
    private static Map<String, Double> SYMBOL_DOUBLE_MAP = new HashMap<String, Double>();
    private static Map<String, Object> FUNCTION_DOUBLE_MAP;
    private static Map<String, Object> FUNCTION_BOOLEAN_MAP;
    private ASTNode fNode;

    static {
        FUNCTION_BOOLEAN_MAP = new HashMap<String, Object>();
        SYMBOL_DOUBLE_MAP.put("E", new Double(Math.E));
        SYMBOL_DOUBLE_MAP.put("Pi", new Double(Math.PI));
        FUNCTION_BOOLEAN_MAP.put("And", new IBooleanBoolean2Function(){

            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 && arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Not", new IBooleanBoolean1Function(){

            public boolean evaluate(boolean arg1) {
                return !arg1;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Or", new IBooleanBoolean2Function(){

            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 || arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Equal", new IBooleanDouble2Function(){

            public boolean evaluate(double arg1, double arg2) {
                return Math.abs(arg1 - arg2) < EPSILON;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Greater", new IBooleanDouble2Function(){

            public boolean evaluate(double arg1, double arg2) {
                return arg1 > arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("GreaterEqual", new IBooleanDouble2Function(){

            public boolean evaluate(double arg1, double arg2) {
                return arg1 >= arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Less", new IBooleanDouble2Function(){

            public boolean evaluate(double arg1, double arg2) {
                return arg1 < arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("LessEqual", new IBooleanDouble2Function(){

            public boolean evaluate(double arg1, double arg2) {
                return arg1 <= arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Unequal", new IBooleanDouble2Function(){

            public boolean evaluate(double arg1, double arg2) {
                return !(Math.abs(arg1 - arg2) < EPSILON);
            }
        });
        FUNCTION_DOUBLE_MAP = new HashMap<String, Object>();
        FUNCTION_DOUBLE_MAP.put("Sin", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.sin(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Cos", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.cos(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Tan", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.tan(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("ASin", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.asin(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("ACos", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.acos(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("ATan", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.atan(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Ln", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.log(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Exp", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.exp(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Abs", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.abs(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Ceil", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.ceil(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Floor", new IDouble1Function(){

            public double evaluate(double arg1) {
                return Math.floor(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Trunc", new IDouble1Function(){

            public double evaluate(double arg1) {
                if (arg1 < 0.0) {
                    return Math.ceil(arg1);
                }
                return Math.floor(arg1);
            }
        });
        FUNCTION_DOUBLE_MAP.put("Plus", new PlusFunction());
        FUNCTION_DOUBLE_MAP.put("Subtract", new SubtractFunction());
        FUNCTION_DOUBLE_MAP.put("Times", new TimesFunction());
        FUNCTION_DOUBLE_MAP.put("Divide", new DivideFunction());
        FUNCTION_DOUBLE_MAP.put("Mod", new ModFunction());
        FUNCTION_DOUBLE_MAP.put("Pow", new PowFunction());
        FUNCTION_DOUBLE_MAP.put("Round", new IDouble2Function(){

            public double evaluate(double arg1, double arg2) {
                if (arg1 > 0.0) {
                    return (double)Math.round((arg1 + EPSILON_ROUND) * Math.pow(10.0, arg2)) / Math.pow(10.0, arg2);
                }
                return (double)Math.round((arg1 - EPSILON_ROUND) * Math.pow(10.0, arg2)) / Math.pow(10.0, arg2);
            }
        });
    }

    public DoubleEvaluator() {
        this(null);
    }

    public DoubleEvaluator(ASTNode node) {
        this.fNode = node;
    }

    public ASTNode parse(String expression) {
        Parser p = new Parser();
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.fNode;
    }

    public static ASTNode parseNode(String expression) {
        DoubleEvaluator doubleEvaluator = new DoubleEvaluator();
        return doubleEvaluator.parse(expression);
    }

    public double evaluate(String expression) {
        Parser p = new Parser();
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.evaluateNode(this.fNode);
    }

    public double evaluate() {
        if (this.fNode == null) {
            throw new SyntaxError(0, 0, 0, " ", "No parser input defined", 1);
        }
        return this.evaluateNode(this.fNode);
    }

    public double evaluateNode(ASTNode node) {
        Double dbl;
        if (node instanceof DoubleNode) {
            return ((DoubleNode)node).doubleValue();
        }
        if (node instanceof FunctionNode) {
            return this.evaluateFunction((FunctionNode)node);
        }
        if (node instanceof SymbolNode && (dbl = SYMBOL_DOUBLE_MAP.get(node.toString())) != null) {
            return dbl;
        }
        if (node instanceof NumberNode) {
            return ((NumberNode)node).doubleValue();
        }
        throw new ArithmeticException("EvalDouble#evaluate(ASTNode) not possible for: " + node.toString());
    }

    public double evaluateFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.get(0) instanceof SymbolNode) {
            String symbol = functionNode.get(0).toString();
            if (functionNode.size() == 1) {
                Object obj = FUNCTION_DOUBLE_MAP.get(symbol);
                if (obj instanceof IDouble0Function) {
                    return ((IDouble0Function)obj).evaluate();
                }
            } else {
                if (functionNode.size() == 2) {
                    Object obj = FUNCTION_DOUBLE_MAP.get(symbol);
                    if (obj instanceof IDouble1Function) {
                        return ((IDouble1Function)obj).evaluate(this.evaluateNode(functionNode.get(1)));
                    }
                    return this.evaluateNodeLogical(functionNode) ? 1.0 : 0.0;
                }
                if (functionNode.size() == 3) {
                    Object obj = FUNCTION_DOUBLE_MAP.get(symbol);
                    if (obj instanceof IDouble2Function) {
                        return ((IDouble2Function)obj).evaluate(this.evaluateNode(functionNode.get(1)), this.evaluateNode(functionNode.get(2)));
                    }
                    return this.evaluateNodeLogical(functionNode) ? 1.0 : 0.0;
                }
                Object obj = FUNCTION_DOUBLE_MAP.get(symbol);
                if (obj instanceof IDoubleFunction) {
                    return ((IDoubleFunction)obj).evaluate(this, functionNode);
                }
            }
        }
        throw new ArithmeticException("EvalDouble#evaluateFunction(FunctionNode) not possible for: " + functionNode.toString());
    }

    public boolean evaluateNodeLogical(ASTNode node) {
        if (node instanceof FunctionNode) {
            return this.evaluateFunctionLogical((FunctionNode)node);
        }
        if (node instanceof DoubleNode) {
            double d = ((DoubleNode)node).doubleValue();
            return !(Math.abs(d - 0.0) < EPSILON);
        }
        if (node instanceof NumberNode) {
            double d = ((NumberNode)node).doubleValue();
            return !(Math.abs(d - 0.0) < EPSILON);
        }
        throw new ArithmeticException("EvalDouble#evaluateNodeLogical(ASTNode) not possible for: " + node.toString());
    }

    public boolean evaluateFunctionLogical(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.get(0) instanceof SymbolNode) {
            String symbol = functionNode.get(0).toString();
            if (functionNode.size() == 2) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanBoolean1Function) {
                    return ((IBooleanBoolean1Function)obj).evaluate(this.evaluateNodeLogical(functionNode.get(1)));
                }
            } else if (functionNode.size() == 3) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanDouble2Function) {
                    return ((IBooleanDouble2Function)obj).evaluate(this.evaluateNode(functionNode.get(1)), this.evaluateNode(functionNode.get(2)));
                }
                if (obj instanceof IBooleanBoolean2Function) {
                    return ((IBooleanBoolean2Function)obj).evaluate(this.evaluateNodeLogical(functionNode.get(1)), this.evaluateNodeLogical(functionNode.get(2)));
                }
            }
        }
        throw new ArithmeticException("EvalDouble#evaluateFunctionLogical(FunctionNode) not possible for: " + functionNode.toString());
    }

    public ASTNode optimizeFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0) {
            boolean doubleOnly = true;
            int i = 1;
            while (i < functionNode.size()) {
                ASTNode node = functionNode.get(i);
                if (node instanceof NumberNode) {
                    functionNode.set(i, new DoubleNode(((NumberNode)functionNode.get(i)).doubleValue()));
                } else if (functionNode.get(i) instanceof FunctionNode) {
                    ASTNode optNode = this.optimizeFunction((FunctionNode)functionNode.get(i));
                    if (!(optNode instanceof DoubleNode)) {
                        doubleOnly = false;
                    }
                    functionNode.set(i, optNode);
                } else {
                    doubleOnly = false;
                }
                ++i;
            }
            if (doubleOnly) {
                try {
                    return new DoubleNode(this.evaluateFunction(functionNode));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return functionNode;
    }

    static class DivideFunction
    implements IDouble2Function {
        DivideFunction() {
        }

        public double evaluate(double arg1, double arg2) {
            if (Math.abs(arg2 - 0.0) < EPSILON) {
                throw new ArithmeticException("Division by zero");
            }
            return arg1 / arg2;
        }
    }

    static class ModFunction
    implements IDouble2Function {
        ModFunction() {
        }

        public double evaluate(double arg1, double arg2) {
            if (Math.abs(arg2 - 0.0) < EPSILON) {
                throw new ArithmeticException("Division by zero");
            }
            return arg1 % arg2;
        }
    }

    static class PlusFunction
    implements IDoubleFunction,
    IDouble2Function {
        PlusFunction() {
        }

        public double evaluate(double arg1, double arg2) {
            return arg1 + arg2;
        }

        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = 0.0;
            int i = 1;
            while (i < function.size()) {
                result += engine.evaluateNode(function.get(i));
                ++i;
            }
            return result;
        }
    }

    static class PowFunction
    implements IDouble2Function {
        PowFunction() {
        }

        public double evaluate(double arg1, double arg2) {
            return Math.pow(arg1, arg2);
        }
    }

    static class SubtractFunction
    implements IDoubleFunction,
    IDouble2Function {
        SubtractFunction() {
        }

        public double evaluate(double arg1, double arg2) {
            return arg1 - arg2;
        }

        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = 0.0;
            int i = 1;
            while (i < function.size()) {
                result += engine.evaluateNode(function.get(i));
                ++i;
            }
            return result;
        }
    }

    static class TimesFunction
    implements IDoubleFunction,
    IDouble2Function {
        TimesFunction() {
        }

        public double evaluate(double arg1, double arg2) {
            return arg1 * arg2;
        }

        public double evaluate(DoubleEvaluator engine, FunctionNode function) {
            double result = 1.0;
            int i = 1;
            while (i < function.size()) {
                result *= engine.evaluateNode(function.get(i));
                ++i;
            }
            return result;
        }
    }
}

