/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.dendai.cdl.mori.wikie.mapred;

import info.bliki.wiki.model.WikiModel;
import java.io.IOException;
import java.io.StringReader;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.ac.dendai.cdl.mori.wikie.parser.WPageElementHandler;
import jp.ac.dendai.cdl.mori.wikie.util.WLinkUtils;
import jp.ac.dendai.cdl.mori.wikie.util.WNormalizer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class WMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, Text, Text> {
    protected WNormalizer normalizer;
    protected WLinkUtils linkUtils;
    protected SAXParser parser;
    protected WikiModel model;

    public void configure(JobConf job) {
        super.configure(job);
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
            TreeSet<String> projectSet = new TreeSet<String>();
            String[] stringArray = job.get("wikie.project").split("\t");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                projectSet.add(p);
                ++n2;
            }
            TreeSet<String> langSet = new TreeSet<String>();
            String[] stringArray2 = job.get("wikie.lang").split("\t");
            int n3 = stringArray2.length;
            n = 0;
            while (n < n3) {
                String l = stringArray2[n];
                langSet.add(l);
                ++n;
            }
            this.normalizer = new WNormalizer(job.get("wikie.map.resource"), projectSet, langSet);
            this.linkUtils = new WLinkUtils(this.normalizer);
            this.model = new WikiModel(String.valueOf(this.normalizer.getBaseURL()) + "${image}", String.valueOf(this.normalizer.getBaseURL()) + "${title}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected WPageElementHandler createPageHandler(Text text) throws IOException, SAXException {
        WPageElementHandler page = new WPageElementHandler();
        this.parser.parse(new InputSource(new StringReader(text.toString())), (DefaultHandler)page);
        return page;
    }
}

