package jp.ac.dendai.cdl.mori.wikie.util;

/**
 * Wikipediaのリンクを表現するためのクラス
 * @author Mori
 *
 */
public class WLink {
    /**
     * アンカーテキスト
     */
    private String anchorText;
    /**
     * リンク先エントリ
     */
    private WEntry entry;
    /**
     * セクション指定
     */
    private String section;


    public WLink() {
        anchorText = new String();
        entry = new WEntry();
        section = new String();
    }

    public WLink(WEntry entry, String section, String anchorText) {
        this.anchorText = anchorText;
        this.entry = entry;
        this.section = section;
    }

    /**
     * リンク先エントリを取得する。
     * @return
     */
    public WEntry getEntry() {
        return entry;
    }

    /**
     * セクション指定を取得する。
     * @return
     */
    public String getSection() {
        return section;
    }

    /**
     * アンカーテキストを取得する。
     * @return　アンカーテキスト
     */
    public String getAnchorText() {
        return anchorText;
    }

    /**
     * リンク先エントリを設定する。
     * @param entry
     */
    public void setEntry(WEntry entry) {
        this.entry = entry;
    }

    /**
     * セクション指定を設定する。
     * @param section
     */
    public void setSection(String section) {
        this.section = section;
    }

    /**
     * アンカーテキストを設定する。
     * @param anchorText
     */
    public void setAnchorText(String anchorText) {
        this.anchorText = anchorText;
    }

    @Override
    /**
     * リンクの文字列表現を返す。
     * 文字列表現はWikipediaのリンク記法に従って、<br>
     * エントリ#セクション|アンカーテキスト<br>
     * という構造になる。セクションとアンカーテキストの設定がない場合はその部分は省略される。
     */
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(entry.toString());
        if (section.length() != 0) {
            result.append("#" + section);
        }
        if (anchorText.length() != 0) {
            result.append("|" + anchorText);
        }
        return result.toString();
    }
}