package jp.ac.dendai.cdl.mori.wikie.mapred;

import java.io.*;
import java.util.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;

import org.apache.commons.lang.*;
import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/**
 * pageLink処理用Reducer
 * @author Mori
 *
 */
public class PageLinkReducer extends WReducer {
    @Override
    public void reduce(Text key, Iterator<Text> inputValueItr, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        ArrayList<String> inputValueArrayList = new ArrayList<String>();
        String entryId = null;

        while (inputValueItr.hasNext()) {
            String inputValue = inputValueItr.next().toString();
            String[] status = inputValue.split("\t");
            if (status[0].equals(WikIE.ENTRY)) {
                entryId = status[1];
            }
            else {
                inputValueArrayList.add(inputValue);
            }
        }
        Iterator<String> inputValueIterator = inputValueArrayList.iterator();
        while (inputValueIterator.hasNext()) {
            String inputValue = inputValueIterator.next();
            String[] status = StringUtils.splitPreserveAllTokens(inputValue, "\t");
            output.collect(new Text(status[0]), new Text(entryId + "\t" + status[1] + "\t" + status[2]));
        }

    }

}
