package jp.ac.dendai.cdl.mori.wikie.util;

import org.apache.commons.lang.*;

/**
 * Wikipediaのエントリを表現するクラス。
 * 主にタイトルを扱うために使う。
 * @author Mori
 *
 */
public class WEntry {
    /**
     * プロジェクトプレフィックス
     */
    private String project;
    /**
     * 言語プレフィックス
     */
    private String lang;
    /**
     * 名前空間プレフィックス
     */
    private String ns;
    /**
     * 記事名
     */
    private String name;
    /**
     * 名前空間番号
     */
    private int nsNumber;

    public WEntry() {
        project = new String();
        lang = new String();
        ns = new String();
        name = new String();
        nsNumber = 0;
    }

    public WEntry(String project, String lang, String ns, String name, int nsNumber) {
        super();
        this.project = project;
        this.lang = lang;
        this.ns = ns;
        this.name = name;
        this.nsNumber = nsNumber;
    }

    /**
     * 名前空間プレフィックスを取得する。
     * @return
     */
    public String getProject() {
        return project;
    }

    /**
     * 言語プレフィックスを取得する。
     * @return
     */
    public String getLang() {
        return lang;
    }

    /**
     * 名前空間プレフィックスを取得する。
     * @return
     */
    public String getNs() {
        return ns;
    }

    /**
     * 記事名を取得する。
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * 名前空間プレフィックスを設定する。
     * @param project
     */
    public void setProject(String project) {
        this.project = project;
    }

    /**
     * 言語プレフィックスを設定する。
     * @param lang
     */
    public void setLang(String lang) {
        this.lang = lang;
    }

    /**
     * 名前空間プレフィックスを設定する。
     * @param ns
     */
    public void setNs(String ns) {
        this.ns = ns;
    }

    /**
     * 記事名を設定する。
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 名前空間番号を取得する。
     * @return
     */
    public int getNsNumber() {
        return nsNumber;
    }

    /**
     * 名前空間番号を設定する。
     * @param nsNumber
     */
    public void setNsNumber(int nsNumber) {
        this.nsNumber = nsNumber;
    }

    /**
     * このエントリタイトルを文字列で表現して返す。
     * 存在しない部分のプレフィックスは省略される。
     */
    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        if (StringUtils.isNotBlank(project)) {
            result.append(project + ":");
        }
        if (StringUtils.isNotBlank(lang)) {
            result.append(lang + ":");
        }
        if (StringUtils.isNotBlank(ns)) {
            result.append(ns + ":");
        }
        if (StringUtils.isNotBlank(name)) {
            result.append(name);
        }
        else {
            return "";
        }
        if (StringUtils.isBlank(result.toString())) {
            return "";
        }
        return result.toString();
    }
}
